/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.IntegrationAssociationSummary;
import software.amazon.awssdk.services.connect.model.ListIntegrationAssociationsRequest;
import software.amazon.awssdk.services.connect.model.ListIntegrationAssociationsResponse;

public class ListIntegrationAssociationsPublisher
implements SdkPublisher<ListIntegrationAssociationsResponse> {
    private final ConnectAsyncClient client;
    private final ListIntegrationAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListIntegrationAssociationsPublisher(ConnectAsyncClient client, ListIntegrationAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListIntegrationAssociationsPublisher(ConnectAsyncClient client, ListIntegrationAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListIntegrationAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListIntegrationAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<IntegrationAssociationSummary> integrationAssociationSummaryList() {
        Function<ListIntegrationAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.integrationAssociationSummaryList() != null) {
                return response.integrationAssociationSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListIntegrationAssociationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListIntegrationAssociationsResponseFetcher
    implements AsyncPageFetcher<ListIntegrationAssociationsResponse> {
        private ListIntegrationAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListIntegrationAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListIntegrationAssociationsResponse> nextPage(ListIntegrationAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListIntegrationAssociationsPublisher.this.client.listIntegrationAssociations(ListIntegrationAssociationsPublisher.this.firstRequest);
            }
            return ListIntegrationAssociationsPublisher.this.client.listIntegrationAssociations((ListIntegrationAssociationsRequest)((Object)ListIntegrationAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

