/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchPutContactRequest extends ConnectRequest implements
        ToCopyableBuilder<BatchPutContactRequest.Builder, BatchPutContactRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(BatchPutContactRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(BatchPutContactRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<List<ContactDataRequest>> CONTACT_DATA_REQUEST_LIST_FIELD = SdkField
            .<List<ContactDataRequest>> builder(MarshallingType.LIST)
            .memberName("ContactDataRequestList")
            .getter(getter(BatchPutContactRequest::contactDataRequestList))
            .setter(setter(Builder::contactDataRequestList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactDataRequestList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContactDataRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContactDataRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            INSTANCE_ID_FIELD, CONTACT_DATA_REQUEST_LIST_FIELD));

    private final String clientToken;

    private final String instanceId;

    private final List<ContactDataRequest> contactDataRequestList;

    private BatchPutContactRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.instanceId = builder.instanceId;
        this.contactDataRequestList = builder.contactDataRequestList;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided,
     * the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
     * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with
     * idempotent APIs</a>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
     *         provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see
     *         <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
     *         retries safe with idempotent APIs</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in
     * the Amazon Resource Name (ARN) of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
     *         ID</a> in the Amazon Resource Name (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ContactDataRequestList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasContactDataRequestList() {
        return contactDataRequestList != null && !(contactDataRequestList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of individual contact requests.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContactDataRequestList} method.
     * </p>
     * 
     * @return List of individual contact requests.
     */
    public final List<ContactDataRequest> contactDataRequestList() {
        return contactDataRequestList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasContactDataRequestList() ? contactDataRequestList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPutContactRequest)) {
            return false;
        }
        BatchPutContactRequest other = (BatchPutContactRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(instanceId(), other.instanceId())
                && hasContactDataRequestList() == other.hasContactDataRequestList()
                && Objects.equals(contactDataRequestList(), other.contactDataRequestList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchPutContactRequest").add("ClientToken", clientToken()).add("InstanceId", instanceId())
                .add("ContactDataRequestList", hasContactDataRequestList() ? contactDataRequestList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "ContactDataRequestList":
            return Optional.ofNullable(clazz.cast(contactDataRequestList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchPutContactRequest, T> g) {
        return obj -> g.apply((BatchPutContactRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchPutContactRequest> {
        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         * provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
         * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe
         * with idempotent APIs</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         *        provided, the Amazon Web Services SDK populates this field. For more information about idempotency,
         *        see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
         *        retries safe with idempotent APIs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a>
         * in the Amazon Resource Name (ARN) of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
         *        ID</a> in the Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * List of individual contact requests.
         * </p>
         * 
         * @param contactDataRequestList
         *        List of individual contact requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactDataRequestList(Collection<ContactDataRequest> contactDataRequestList);

        /**
         * <p>
         * List of individual contact requests.
         * </p>
         * 
         * @param contactDataRequestList
         *        List of individual contact requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactDataRequestList(ContactDataRequest... contactDataRequestList);

        /**
         * <p>
         * List of individual contact requests.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.ContactDataRequest.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.connect.model.ContactDataRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.ContactDataRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #contactDataRequestList(List<ContactDataRequest>)}.
         * 
         * @param contactDataRequestList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.ContactDataRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contactDataRequestList(java.util.Collection<ContactDataRequest>)
         */
        Builder contactDataRequestList(Consumer<ContactDataRequest.Builder>... contactDataRequestList);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String instanceId;

        private List<ContactDataRequest> contactDataRequestList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchPutContactRequest model) {
            super(model);
            clientToken(model.clientToken);
            instanceId(model.instanceId);
            contactDataRequestList(model.contactDataRequestList);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final List<ContactDataRequest.Builder> getContactDataRequestList() {
            List<ContactDataRequest.Builder> result = ContactDataRequestListCopier.copyToBuilder(this.contactDataRequestList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContactDataRequestList(Collection<ContactDataRequest.BuilderImpl> contactDataRequestList) {
            this.contactDataRequestList = ContactDataRequestListCopier.copyFromBuilder(contactDataRequestList);
        }

        @Override
        public final Builder contactDataRequestList(Collection<ContactDataRequest> contactDataRequestList) {
            this.contactDataRequestList = ContactDataRequestListCopier.copy(contactDataRequestList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contactDataRequestList(ContactDataRequest... contactDataRequestList) {
            contactDataRequestList(Arrays.asList(contactDataRequestList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contactDataRequestList(Consumer<ContactDataRequest.Builder>... contactDataRequestList) {
            contactDataRequestList(Stream.of(contactDataRequestList)
                    .map(c -> ContactDataRequest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchPutContactRequest build() {
            return new BatchPutContactRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
