/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a single task template field.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TaskTemplateField implements SdkPojo, Serializable,
        ToCopyableBuilder<TaskTemplateField.Builder, TaskTemplateField> {
    private static final SdkField<TaskTemplateFieldIdentifier> ID_FIELD = SdkField
            .<TaskTemplateFieldIdentifier> builder(MarshallingType.SDK_POJO).memberName("Id")
            .getter(getter(TaskTemplateField::id)).setter(setter(Builder::id)).constructor(TaskTemplateFieldIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(TaskTemplateField::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(TaskTemplateField::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<List<String>> SINGLE_SELECT_OPTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SingleSelectOptions")
            .getter(getter(TaskTemplateField::singleSelectOptions))
            .setter(setter(Builder::singleSelectOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleSelectOptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, DESCRIPTION_FIELD,
            TYPE_FIELD, SINGLE_SELECT_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final TaskTemplateFieldIdentifier id;

    private final String description;

    private final String type;

    private final List<String> singleSelectOptions;

    private TaskTemplateField(BuilderImpl builder) {
        this.id = builder.id;
        this.description = builder.description;
        this.type = builder.type;
        this.singleSelectOptions = builder.singleSelectOptions;
    }

    /**
     * <p>
     * The unique identifier for the field.
     * </p>
     * 
     * @return The unique identifier for the field.
     */
    public final TaskTemplateFieldIdentifier id() {
        return id;
    }

    /**
     * <p>
     * The description of the field.
     * </p>
     * 
     * @return The description of the field.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Indicates the type of field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TaskTemplateFieldType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Indicates the type of field.
     * @see TaskTemplateFieldType
     */
    public final TaskTemplateFieldType type() {
        return TaskTemplateFieldType.fromValue(type);
    }

    /**
     * <p>
     * Indicates the type of field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TaskTemplateFieldType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Indicates the type of field.
     * @see TaskTemplateFieldType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * For responses, this returns true if the service returned a value for the SingleSelectOptions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSingleSelectOptions() {
        return singleSelectOptions != null && !(singleSelectOptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of options for a single select field.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSingleSelectOptions} method.
     * </p>
     * 
     * @return A list of options for a single select field.
     */
    public final List<String> singleSelectOptions() {
        return singleSelectOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasSingleSelectOptions() ? singleSelectOptions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskTemplateField)) {
            return false;
        }
        TaskTemplateField other = (TaskTemplateField) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(description(), other.description())
                && Objects.equals(typeAsString(), other.typeAsString())
                && hasSingleSelectOptions() == other.hasSingleSelectOptions()
                && Objects.equals(singleSelectOptions(), other.singleSelectOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TaskTemplateField").add("Id", id()).add("Description", description())
                .add("Type", typeAsString()).add("SingleSelectOptions", hasSingleSelectOptions() ? singleSelectOptions() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "SingleSelectOptions":
            return Optional.ofNullable(clazz.cast(singleSelectOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TaskTemplateField, T> g) {
        return obj -> g.apply((TaskTemplateField) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TaskTemplateField> {
        /**
         * <p>
         * The unique identifier for the field.
         * </p>
         * 
         * @param id
         *        The unique identifier for the field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(TaskTemplateFieldIdentifier id);

        /**
         * <p>
         * The unique identifier for the field.
         * </p>
         * This is a convenience method that creates an instance of the {@link TaskTemplateFieldIdentifier.Builder}
         * avoiding the need to create one manually via {@link TaskTemplateFieldIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TaskTemplateFieldIdentifier.Builder#build()} is called
         * immediately and its result is passed to {@link #id(TaskTemplateFieldIdentifier)}.
         * 
         * @param id
         *        a consumer that will call methods on {@link TaskTemplateFieldIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #id(TaskTemplateFieldIdentifier)
         */
        default Builder id(Consumer<TaskTemplateFieldIdentifier.Builder> id) {
            return id(TaskTemplateFieldIdentifier.builder().applyMutation(id).build());
        }

        /**
         * <p>
         * The description of the field.
         * </p>
         * 
         * @param description
         *        The description of the field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Indicates the type of field.
         * </p>
         * 
         * @param type
         *        Indicates the type of field.
         * @see TaskTemplateFieldType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskTemplateFieldType
         */
        Builder type(String type);

        /**
         * <p>
         * Indicates the type of field.
         * </p>
         * 
         * @param type
         *        Indicates the type of field.
         * @see TaskTemplateFieldType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskTemplateFieldType
         */
        Builder type(TaskTemplateFieldType type);

        /**
         * <p>
         * A list of options for a single select field.
         * </p>
         * 
         * @param singleSelectOptions
         *        A list of options for a single select field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder singleSelectOptions(Collection<String> singleSelectOptions);

        /**
         * <p>
         * A list of options for a single select field.
         * </p>
         * 
         * @param singleSelectOptions
         *        A list of options for a single select field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder singleSelectOptions(String... singleSelectOptions);
    }

    static final class BuilderImpl implements Builder {
        private TaskTemplateFieldIdentifier id;

        private String description;

        private String type;

        private List<String> singleSelectOptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TaskTemplateField model) {
            id(model.id);
            description(model.description);
            type(model.type);
            singleSelectOptions(model.singleSelectOptions);
        }

        public final TaskTemplateFieldIdentifier.Builder getId() {
            return id != null ? id.toBuilder() : null;
        }

        public final void setId(TaskTemplateFieldIdentifier.BuilderImpl id) {
            this.id = id != null ? id.build() : null;
        }

        @Override
        public final Builder id(TaskTemplateFieldIdentifier id) {
            this.id = id;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TaskTemplateFieldType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Collection<String> getSingleSelectOptions() {
            if (singleSelectOptions instanceof SdkAutoConstructList) {
                return null;
            }
            return singleSelectOptions;
        }

        public final void setSingleSelectOptions(Collection<String> singleSelectOptions) {
            this.singleSelectOptions = SingleSelectOptionsCopier.copy(singleSelectOptions);
        }

        @Override
        public final Builder singleSelectOptions(Collection<String> singleSelectOptions) {
            this.singleSelectOptions = SingleSelectOptionsCopier.copy(singleSelectOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder singleSelectOptions(String... singleSelectOptions) {
            singleSelectOptions(Arrays.asList(singleSelectOptions));
            return this;
        }

        @Override
        public TaskTemplateField build() {
            return new TaskTemplateField(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
