/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about phone numbers that have been claimed to your Amazon Connect instance or traffic distribution group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPhoneNumbersSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ListPhoneNumbersSummary.Builder, ListPhoneNumbersSummary> {
    private static final SdkField<String> PHONE_NUMBER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhoneNumberId").getter(getter(ListPhoneNumbersSummary::phoneNumberId))
            .setter(setter(Builder::phoneNumberId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberId").build()).build();

    private static final SdkField<String> PHONE_NUMBER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhoneNumberArn").getter(getter(ListPhoneNumbersSummary::phoneNumberArn))
            .setter(setter(Builder::phoneNumberArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberArn").build()).build();

    private static final SdkField<String> PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhoneNumber").getter(getter(ListPhoneNumbersSummary::phoneNumber)).setter(setter(Builder::phoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumber").build()).build();

    private static final SdkField<String> PHONE_NUMBER_COUNTRY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhoneNumberCountryCode").getter(getter(ListPhoneNumbersSummary::phoneNumberCountryCodeAsString))
            .setter(setter(Builder::phoneNumberCountryCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberCountryCode").build())
            .build();

    private static final SdkField<String> PHONE_NUMBER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhoneNumberType").getter(getter(ListPhoneNumbersSummary::phoneNumberTypeAsString))
            .setter(setter(Builder::phoneNumberType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberType").build()).build();

    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetArn").getter(getter(ListPhoneNumbersSummary::targetArn)).setter(setter(Builder::targetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetArn").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(ListPhoneNumbersSummary::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> PHONE_NUMBER_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhoneNumberDescription").getter(getter(ListPhoneNumbersSummary::phoneNumberDescription))
            .setter(setter(Builder::phoneNumberDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberDescription").build())
            .build();

    private static final SdkField<String> SOURCE_PHONE_NUMBER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourcePhoneNumberArn").getter(getter(ListPhoneNumbersSummary::sourcePhoneNumberArn))
            .setter(setter(Builder::sourcePhoneNumberArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePhoneNumberArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONE_NUMBER_ID_FIELD,
            PHONE_NUMBER_ARN_FIELD, PHONE_NUMBER_FIELD, PHONE_NUMBER_COUNTRY_CODE_FIELD, PHONE_NUMBER_TYPE_FIELD,
            TARGET_ARN_FIELD, INSTANCE_ID_FIELD, PHONE_NUMBER_DESCRIPTION_FIELD, SOURCE_PHONE_NUMBER_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String phoneNumberId;

    private final String phoneNumberArn;

    private final String phoneNumber;

    private final String phoneNumberCountryCode;

    private final String phoneNumberType;

    private final String targetArn;

    private final String instanceId;

    private final String phoneNumberDescription;

    private final String sourcePhoneNumberArn;

    private ListPhoneNumbersSummary(BuilderImpl builder) {
        this.phoneNumberId = builder.phoneNumberId;
        this.phoneNumberArn = builder.phoneNumberArn;
        this.phoneNumber = builder.phoneNumber;
        this.phoneNumberCountryCode = builder.phoneNumberCountryCode;
        this.phoneNumberType = builder.phoneNumberType;
        this.targetArn = builder.targetArn;
        this.instanceId = builder.instanceId;
        this.phoneNumberDescription = builder.phoneNumberDescription;
        this.sourcePhoneNumberArn = builder.sourcePhoneNumberArn;
    }

    /**
     * <p>
     * A unique identifier for the phone number.
     * </p>
     * 
     * @return A unique identifier for the phone number.
     */
    public final String phoneNumberId() {
        return phoneNumberId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the phone number.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the phone number.
     */
    public final String phoneNumberArn() {
        return phoneNumberArn;
    }

    /**
     * <p>
     * The phone number. Phone numbers are formatted
     * <code>[+] [country code] [subscriber number including area code]</code>.
     * </p>
     * 
     * @return The phone number. Phone numbers are formatted
     *         <code>[+] [country code] [subscriber number including area code]</code>.
     */
    public final String phoneNumber() {
        return phoneNumber;
    }

    /**
     * <p>
     * The ISO country code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #phoneNumberCountryCode} will return {@link PhoneNumberCountryCode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #phoneNumberCountryCodeAsString}.
     * </p>
     * 
     * @return The ISO country code.
     * @see PhoneNumberCountryCode
     */
    public final PhoneNumberCountryCode phoneNumberCountryCode() {
        return PhoneNumberCountryCode.fromValue(phoneNumberCountryCode);
    }

    /**
     * <p>
     * The ISO country code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #phoneNumberCountryCode} will return {@link PhoneNumberCountryCode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #phoneNumberCountryCodeAsString}.
     * </p>
     * 
     * @return The ISO country code.
     * @see PhoneNumberCountryCode
     */
    public final String phoneNumberCountryCodeAsString() {
        return phoneNumberCountryCode;
    }

    /**
     * <p>
     * The type of phone number.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #phoneNumberType}
     * will return {@link PhoneNumberType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #phoneNumberTypeAsString}.
     * </p>
     * 
     * @return The type of phone number.
     * @see PhoneNumberType
     */
    public final PhoneNumberType phoneNumberType() {
        return PhoneNumberType.fromValue(phoneNumberType);
    }

    /**
     * <p>
     * The type of phone number.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #phoneNumberType}
     * will return {@link PhoneNumberType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #phoneNumberTypeAsString}.
     * </p>
     * 
     * @return The type of phone number.
     * @see PhoneNumberType
     */
    public final String phoneNumberTypeAsString() {
        return phoneNumberType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for Amazon Connect instances or traffic distribution groups that phone number
     * inbound traffic is routed through.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for Amazon Connect instances or traffic distribution groups that phone
     *         number inbound traffic is routed through.
     */
    public final String targetArn() {
        return targetArn;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance that phone numbers are claimed to. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in
     * the Amazon Resource Name (ARN) of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance that phone numbers are claimed to. You can <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
     *         ID</a> in the Amazon Resource Name (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The description of the phone number.
     * </p>
     * 
     * @return The description of the phone number.
     */
    public final String phoneNumberDescription() {
        return phoneNumberDescription;
    }

    /**
     * <p>
     * The claimed phone number ARN that was previously imported from the external service, such as Amazon Pinpoint. If
     * it is from Amazon Pinpoint, it looks like the ARN of the phone number that was imported from Amazon Pinpoint.
     * </p>
     * 
     * @return The claimed phone number ARN that was previously imported from the external service, such as Amazon
     *         Pinpoint. If it is from Amazon Pinpoint, it looks like the ARN of the phone number that was imported from
     *         Amazon Pinpoint.
     */
    public final String sourcePhoneNumberArn() {
        return sourcePhoneNumberArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumberId());
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumberArn());
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumberCountryCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumberTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumberDescription());
        hashCode = 31 * hashCode + Objects.hashCode(sourcePhoneNumberArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPhoneNumbersSummary)) {
            return false;
        }
        ListPhoneNumbersSummary other = (ListPhoneNumbersSummary) obj;
        return Objects.equals(phoneNumberId(), other.phoneNumberId()) && Objects.equals(phoneNumberArn(), other.phoneNumberArn())
                && Objects.equals(phoneNumber(), other.phoneNumber())
                && Objects.equals(phoneNumberCountryCodeAsString(), other.phoneNumberCountryCodeAsString())
                && Objects.equals(phoneNumberTypeAsString(), other.phoneNumberTypeAsString())
                && Objects.equals(targetArn(), other.targetArn()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(phoneNumberDescription(), other.phoneNumberDescription())
                && Objects.equals(sourcePhoneNumberArn(), other.sourcePhoneNumberArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPhoneNumbersSummary").add("PhoneNumberId", phoneNumberId())
                .add("PhoneNumberArn", phoneNumberArn()).add("PhoneNumber", phoneNumber())
                .add("PhoneNumberCountryCode", phoneNumberCountryCodeAsString())
                .add("PhoneNumberType", phoneNumberTypeAsString()).add("TargetArn", targetArn()).add("InstanceId", instanceId())
                .add("PhoneNumberDescription", phoneNumberDescription()).add("SourcePhoneNumberArn", sourcePhoneNumberArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PhoneNumberId":
            return Optional.ofNullable(clazz.cast(phoneNumberId()));
        case "PhoneNumberArn":
            return Optional.ofNullable(clazz.cast(phoneNumberArn()));
        case "PhoneNumber":
            return Optional.ofNullable(clazz.cast(phoneNumber()));
        case "PhoneNumberCountryCode":
            return Optional.ofNullable(clazz.cast(phoneNumberCountryCodeAsString()));
        case "PhoneNumberType":
            return Optional.ofNullable(clazz.cast(phoneNumberTypeAsString()));
        case "TargetArn":
            return Optional.ofNullable(clazz.cast(targetArn()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "PhoneNumberDescription":
            return Optional.ofNullable(clazz.cast(phoneNumberDescription()));
        case "SourcePhoneNumberArn":
            return Optional.ofNullable(clazz.cast(sourcePhoneNumberArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPhoneNumbersSummary, T> g) {
        return obj -> g.apply((ListPhoneNumbersSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListPhoneNumbersSummary> {
        /**
         * <p>
         * A unique identifier for the phone number.
         * </p>
         * 
         * @param phoneNumberId
         *        A unique identifier for the phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumberId(String phoneNumberId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the phone number.
         * </p>
         * 
         * @param phoneNumberArn
         *        The Amazon Resource Name (ARN) of the phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumberArn(String phoneNumberArn);

        /**
         * <p>
         * The phone number. Phone numbers are formatted
         * <code>[+] [country code] [subscriber number including area code]</code>.
         * </p>
         * 
         * @param phoneNumber
         *        The phone number. Phone numbers are formatted
         *        <code>[+] [country code] [subscriber number including area code]</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumber(String phoneNumber);

        /**
         * <p>
         * The ISO country code.
         * </p>
         * 
         * @param phoneNumberCountryCode
         *        The ISO country code.
         * @see PhoneNumberCountryCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneNumberCountryCode
         */
        Builder phoneNumberCountryCode(String phoneNumberCountryCode);

        /**
         * <p>
         * The ISO country code.
         * </p>
         * 
         * @param phoneNumberCountryCode
         *        The ISO country code.
         * @see PhoneNumberCountryCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneNumberCountryCode
         */
        Builder phoneNumberCountryCode(PhoneNumberCountryCode phoneNumberCountryCode);

        /**
         * <p>
         * The type of phone number.
         * </p>
         * 
         * @param phoneNumberType
         *        The type of phone number.
         * @see PhoneNumberType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneNumberType
         */
        Builder phoneNumberType(String phoneNumberType);

        /**
         * <p>
         * The type of phone number.
         * </p>
         * 
         * @param phoneNumberType
         *        The type of phone number.
         * @see PhoneNumberType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneNumberType
         */
        Builder phoneNumberType(PhoneNumberType phoneNumberType);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for Amazon Connect instances or traffic distribution groups that phone number
         * inbound traffic is routed through.
         * </p>
         * 
         * @param targetArn
         *        The Amazon Resource Name (ARN) for Amazon Connect instances or traffic distribution groups that phone
         *        number inbound traffic is routed through.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetArn(String targetArn);

        /**
         * <p>
         * The identifier of the Amazon Connect instance that phone numbers are claimed to. You can <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a>
         * in the Amazon Resource Name (ARN) of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance that phone numbers are claimed to. You can <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
         *        ID</a> in the Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The description of the phone number.
         * </p>
         * 
         * @param phoneNumberDescription
         *        The description of the phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumberDescription(String phoneNumberDescription);

        /**
         * <p>
         * The claimed phone number ARN that was previously imported from the external service, such as Amazon Pinpoint.
         * If it is from Amazon Pinpoint, it looks like the ARN of the phone number that was imported from Amazon
         * Pinpoint.
         * </p>
         * 
         * @param sourcePhoneNumberArn
         *        The claimed phone number ARN that was previously imported from the external service, such as Amazon
         *        Pinpoint. If it is from Amazon Pinpoint, it looks like the ARN of the phone number that was imported
         *        from Amazon Pinpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourcePhoneNumberArn(String sourcePhoneNumberArn);
    }

    static final class BuilderImpl implements Builder {
        private String phoneNumberId;

        private String phoneNumberArn;

        private String phoneNumber;

        private String phoneNumberCountryCode;

        private String phoneNumberType;

        private String targetArn;

        private String instanceId;

        private String phoneNumberDescription;

        private String sourcePhoneNumberArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPhoneNumbersSummary model) {
            phoneNumberId(model.phoneNumberId);
            phoneNumberArn(model.phoneNumberArn);
            phoneNumber(model.phoneNumber);
            phoneNumberCountryCode(model.phoneNumberCountryCode);
            phoneNumberType(model.phoneNumberType);
            targetArn(model.targetArn);
            instanceId(model.instanceId);
            phoneNumberDescription(model.phoneNumberDescription);
            sourcePhoneNumberArn(model.sourcePhoneNumberArn);
        }

        public final String getPhoneNumberId() {
            return phoneNumberId;
        }

        public final void setPhoneNumberId(String phoneNumberId) {
            this.phoneNumberId = phoneNumberId;
        }

        @Override
        public final Builder phoneNumberId(String phoneNumberId) {
            this.phoneNumberId = phoneNumberId;
            return this;
        }

        public final String getPhoneNumberArn() {
            return phoneNumberArn;
        }

        public final void setPhoneNumberArn(String phoneNumberArn) {
            this.phoneNumberArn = phoneNumberArn;
        }

        @Override
        public final Builder phoneNumberArn(String phoneNumberArn) {
            this.phoneNumberArn = phoneNumberArn;
            return this;
        }

        public final String getPhoneNumber() {
            return phoneNumber;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final String getPhoneNumberCountryCode() {
            return phoneNumberCountryCode;
        }

        public final void setPhoneNumberCountryCode(String phoneNumberCountryCode) {
            this.phoneNumberCountryCode = phoneNumberCountryCode;
        }

        @Override
        public final Builder phoneNumberCountryCode(String phoneNumberCountryCode) {
            this.phoneNumberCountryCode = phoneNumberCountryCode;
            return this;
        }

        @Override
        public final Builder phoneNumberCountryCode(PhoneNumberCountryCode phoneNumberCountryCode) {
            this.phoneNumberCountryCode(phoneNumberCountryCode == null ? null : phoneNumberCountryCode.toString());
            return this;
        }

        public final String getPhoneNumberType() {
            return phoneNumberType;
        }

        public final void setPhoneNumberType(String phoneNumberType) {
            this.phoneNumberType = phoneNumberType;
        }

        @Override
        public final Builder phoneNumberType(String phoneNumberType) {
            this.phoneNumberType = phoneNumberType;
            return this;
        }

        @Override
        public final Builder phoneNumberType(PhoneNumberType phoneNumberType) {
            this.phoneNumberType(phoneNumberType == null ? null : phoneNumberType.toString());
            return this;
        }

        public final String getTargetArn() {
            return targetArn;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getPhoneNumberDescription() {
            return phoneNumberDescription;
        }

        public final void setPhoneNumberDescription(String phoneNumberDescription) {
            this.phoneNumberDescription = phoneNumberDescription;
        }

        @Override
        public final Builder phoneNumberDescription(String phoneNumberDescription) {
            this.phoneNumberDescription = phoneNumberDescription;
            return this;
        }

        public final String getSourcePhoneNumberArn() {
            return sourcePhoneNumberArn;
        }

        public final void setSourcePhoneNumberArn(String sourcePhoneNumberArn) {
            this.sourcePhoneNumberArn = sourcePhoneNumberArn;
        }

        @Override
        public final Builder sourcePhoneNumberArn(String sourcePhoneNumberArn) {
            this.sourcePhoneNumberArn = sourcePhoneNumberArn;
            return this;
        }

        @Override
        public ListPhoneNumbersSummary build() {
            return new ListPhoneNumbersSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
