/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A meeting created using the Amazon Chime SDK.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Meeting implements SdkPojo, Serializable, ToCopyableBuilder<Meeting.Builder, Meeting> {
    private static final SdkField<String> MEDIA_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MediaRegion").getter(getter(Meeting::mediaRegion)).setter(setter(Builder::mediaRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaRegion").build()).build();

    private static final SdkField<MediaPlacement> MEDIA_PLACEMENT_FIELD = SdkField
            .<MediaPlacement> builder(MarshallingType.SDK_POJO).memberName("MediaPlacement")
            .getter(getter(Meeting::mediaPlacement)).setter(setter(Builder::mediaPlacement)).constructor(MediaPlacement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaPlacement").build()).build();

    private static final SdkField<MeetingFeaturesConfiguration> MEETING_FEATURES_FIELD = SdkField
            .<MeetingFeaturesConfiguration> builder(MarshallingType.SDK_POJO).memberName("MeetingFeatures")
            .getter(getter(Meeting::meetingFeatures)).setter(setter(Builder::meetingFeatures))
            .constructor(MeetingFeaturesConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeetingFeatures").build()).build();

    private static final SdkField<String> MEETING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MeetingId").getter(getter(Meeting::meetingId)).setter(setter(Builder::meetingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeetingId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDIA_REGION_FIELD,
            MEDIA_PLACEMENT_FIELD, MEETING_FEATURES_FIELD, MEETING_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String mediaRegion;

    private final MediaPlacement mediaPlacement;

    private final MeetingFeaturesConfiguration meetingFeatures;

    private final String meetingId;

    private Meeting(BuilderImpl builder) {
        this.mediaRegion = builder.mediaRegion;
        this.mediaPlacement = builder.mediaPlacement;
        this.meetingFeatures = builder.meetingFeatures;
        this.meetingId = builder.meetingId;
    }

    /**
     * <p>
     * The Amazon Web Services Region in which you create the meeting.
     * </p>
     * 
     * @return The Amazon Web Services Region in which you create the meeting.
     */
    public final String mediaRegion() {
        return mediaRegion;
    }

    /**
     * <p>
     * The media placement for the meeting.
     * </p>
     * 
     * @return The media placement for the meeting.
     */
    public final MediaPlacement mediaPlacement() {
        return mediaPlacement;
    }

    /**
     * <p>
     * The configuration settings of the features available to a meeting.
     * </p>
     * 
     * @return The configuration settings of the features available to a meeting.
     */
    public final MeetingFeaturesConfiguration meetingFeatures() {
        return meetingFeatures;
    }

    /**
     * <p>
     * The Amazon Chime SDK meeting ID.
     * </p>
     * 
     * @return The Amazon Chime SDK meeting ID.
     */
    public final String meetingId() {
        return meetingId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mediaRegion());
        hashCode = 31 * hashCode + Objects.hashCode(mediaPlacement());
        hashCode = 31 * hashCode + Objects.hashCode(meetingFeatures());
        hashCode = 31 * hashCode + Objects.hashCode(meetingId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Meeting)) {
            return false;
        }
        Meeting other = (Meeting) obj;
        return Objects.equals(mediaRegion(), other.mediaRegion()) && Objects.equals(mediaPlacement(), other.mediaPlacement())
                && Objects.equals(meetingFeatures(), other.meetingFeatures()) && Objects.equals(meetingId(), other.meetingId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Meeting").add("MediaRegion", mediaRegion()).add("MediaPlacement", mediaPlacement())
                .add("MeetingFeatures", meetingFeatures()).add("MeetingId", meetingId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MediaRegion":
            return Optional.ofNullable(clazz.cast(mediaRegion()));
        case "MediaPlacement":
            return Optional.ofNullable(clazz.cast(mediaPlacement()));
        case "MeetingFeatures":
            return Optional.ofNullable(clazz.cast(meetingFeatures()));
        case "MeetingId":
            return Optional.ofNullable(clazz.cast(meetingId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Meeting, T> g) {
        return obj -> g.apply((Meeting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Meeting> {
        /**
         * <p>
         * The Amazon Web Services Region in which you create the meeting.
         * </p>
         * 
         * @param mediaRegion
         *        The Amazon Web Services Region in which you create the meeting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaRegion(String mediaRegion);

        /**
         * <p>
         * The media placement for the meeting.
         * </p>
         * 
         * @param mediaPlacement
         *        The media placement for the meeting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaPlacement(MediaPlacement mediaPlacement);

        /**
         * <p>
         * The media placement for the meeting.
         * </p>
         * This is a convenience method that creates an instance of the {@link MediaPlacement.Builder} avoiding the need
         * to create one manually via {@link MediaPlacement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MediaPlacement.Builder#build()} is called immediately and its
         * result is passed to {@link #mediaPlacement(MediaPlacement)}.
         * 
         * @param mediaPlacement
         *        a consumer that will call methods on {@link MediaPlacement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mediaPlacement(MediaPlacement)
         */
        default Builder mediaPlacement(Consumer<MediaPlacement.Builder> mediaPlacement) {
            return mediaPlacement(MediaPlacement.builder().applyMutation(mediaPlacement).build());
        }

        /**
         * <p>
         * The configuration settings of the features available to a meeting.
         * </p>
         * 
         * @param meetingFeatures
         *        The configuration settings of the features available to a meeting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meetingFeatures(MeetingFeaturesConfiguration meetingFeatures);

        /**
         * <p>
         * The configuration settings of the features available to a meeting.
         * </p>
         * This is a convenience method that creates an instance of the {@link MeetingFeaturesConfiguration.Builder}
         * avoiding the need to create one manually via {@link MeetingFeaturesConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MeetingFeaturesConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #meetingFeatures(MeetingFeaturesConfiguration)}.
         * 
         * @param meetingFeatures
         *        a consumer that will call methods on {@link MeetingFeaturesConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #meetingFeatures(MeetingFeaturesConfiguration)
         */
        default Builder meetingFeatures(Consumer<MeetingFeaturesConfiguration.Builder> meetingFeatures) {
            return meetingFeatures(MeetingFeaturesConfiguration.builder().applyMutation(meetingFeatures).build());
        }

        /**
         * <p>
         * The Amazon Chime SDK meeting ID.
         * </p>
         * 
         * @param meetingId
         *        The Amazon Chime SDK meeting ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meetingId(String meetingId);
    }

    static final class BuilderImpl implements Builder {
        private String mediaRegion;

        private MediaPlacement mediaPlacement;

        private MeetingFeaturesConfiguration meetingFeatures;

        private String meetingId;

        private BuilderImpl() {
        }

        private BuilderImpl(Meeting model) {
            mediaRegion(model.mediaRegion);
            mediaPlacement(model.mediaPlacement);
            meetingFeatures(model.meetingFeatures);
            meetingId(model.meetingId);
        }

        public final String getMediaRegion() {
            return mediaRegion;
        }

        public final void setMediaRegion(String mediaRegion) {
            this.mediaRegion = mediaRegion;
        }

        @Override
        public final Builder mediaRegion(String mediaRegion) {
            this.mediaRegion = mediaRegion;
            return this;
        }

        public final MediaPlacement.Builder getMediaPlacement() {
            return mediaPlacement != null ? mediaPlacement.toBuilder() : null;
        }

        public final void setMediaPlacement(MediaPlacement.BuilderImpl mediaPlacement) {
            this.mediaPlacement = mediaPlacement != null ? mediaPlacement.build() : null;
        }

        @Override
        public final Builder mediaPlacement(MediaPlacement mediaPlacement) {
            this.mediaPlacement = mediaPlacement;
            return this;
        }

        public final MeetingFeaturesConfiguration.Builder getMeetingFeatures() {
            return meetingFeatures != null ? meetingFeatures.toBuilder() : null;
        }

        public final void setMeetingFeatures(MeetingFeaturesConfiguration.BuilderImpl meetingFeatures) {
            this.meetingFeatures = meetingFeatures != null ? meetingFeatures.build() : null;
        }

        @Override
        public final Builder meetingFeatures(MeetingFeaturesConfiguration meetingFeatures) {
            this.meetingFeatures = meetingFeatures;
            return this;
        }

        public final String getMeetingId() {
            return meetingId;
        }

        public final void setMeetingId(String meetingId) {
            this.meetingId = meetingId;
        }

        @Override
        public final Builder meetingId(String meetingId) {
            this.meetingId = meetingId;
            return this;
        }

        @Override
        public Meeting build() {
            return new Meeting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
