/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the phone configuration settings for a user.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserPhoneConfig implements SdkPojo, Serializable, ToCopyableBuilder<UserPhoneConfig.Builder, UserPhoneConfig> {
    private static final SdkField<String> PHONE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhoneType").getter(getter(UserPhoneConfig::phoneTypeAsString)).setter(setter(Builder::phoneType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneType").build()).build();

    private static final SdkField<Boolean> AUTO_ACCEPT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoAccept").getter(getter(UserPhoneConfig::autoAccept)).setter(setter(Builder::autoAccept))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoAccept").build()).build();

    private static final SdkField<Integer> AFTER_CONTACT_WORK_TIME_LIMIT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("AfterContactWorkTimeLimit")
            .getter(getter(UserPhoneConfig::afterContactWorkTimeLimit)).setter(setter(Builder::afterContactWorkTimeLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AfterContactWorkTimeLimit").build())
            .build();

    private static final SdkField<String> DESK_PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeskPhoneNumber").getter(getter(UserPhoneConfig::deskPhoneNumber))
            .setter(setter(Builder::deskPhoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeskPhoneNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONE_TYPE_FIELD,
            AUTO_ACCEPT_FIELD, AFTER_CONTACT_WORK_TIME_LIMIT_FIELD, DESK_PHONE_NUMBER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String phoneType;

    private final Boolean autoAccept;

    private final Integer afterContactWorkTimeLimit;

    private final String deskPhoneNumber;

    private UserPhoneConfig(BuilderImpl builder) {
        this.phoneType = builder.phoneType;
        this.autoAccept = builder.autoAccept;
        this.afterContactWorkTimeLimit = builder.afterContactWorkTimeLimit;
        this.deskPhoneNumber = builder.deskPhoneNumber;
    }

    /**
     * <p>
     * The phone type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #phoneType} will
     * return {@link PhoneType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #phoneTypeAsString}.
     * </p>
     * 
     * @return The phone type.
     * @see PhoneType
     */
    public final PhoneType phoneType() {
        return PhoneType.fromValue(phoneType);
    }

    /**
     * <p>
     * The phone type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #phoneType} will
     * return {@link PhoneType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #phoneTypeAsString}.
     * </p>
     * 
     * @return The phone type.
     * @see PhoneType
     */
    public final String phoneTypeAsString() {
        return phoneType;
    }

    /**
     * <p>
     * The Auto accept setting.
     * </p>
     * 
     * @return The Auto accept setting.
     */
    public final Boolean autoAccept() {
        return autoAccept;
    }

    /**
     * <p>
     * The After Call Work (ACW) timeout setting, in seconds. This parameter has a minimum value of 0 and a maximum
     * value of 2,000,000 seconds (24 days). Enter 0 if you don't want to allocate a specific amount of ACW time. It
     * essentially means an indefinite amount of time. When the conversation ends, ACW starts; the agent must choose
     * Close contact to end ACW.
     * </p>
     * <note>
     * <p>
     * When returned by a <code>SearchUsers</code> call, <code>AfterContactWorkTimeLimit</code> is returned in
     * milliseconds.
     * </p>
     * </note>
     * 
     * @return The After Call Work (ACW) timeout setting, in seconds. This parameter has a minimum value of 0 and a
     *         maximum value of 2,000,000 seconds (24 days). Enter 0 if you don't want to allocate a specific amount of
     *         ACW time. It essentially means an indefinite amount of time. When the conversation ends, ACW starts; the
     *         agent must choose Close contact to end ACW. </p> <note>
     *         <p>
     *         When returned by a <code>SearchUsers</code> call, <code>AfterContactWorkTimeLimit</code> is returned in
     *         milliseconds.
     *         </p>
     */
    public final Integer afterContactWorkTimeLimit() {
        return afterContactWorkTimeLimit;
    }

    /**
     * <p>
     * The phone number for the user's desk phone.
     * </p>
     * 
     * @return The phone number for the user's desk phone.
     */
    public final String deskPhoneNumber() {
        return deskPhoneNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(phoneTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(autoAccept());
        hashCode = 31 * hashCode + Objects.hashCode(afterContactWorkTimeLimit());
        hashCode = 31 * hashCode + Objects.hashCode(deskPhoneNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserPhoneConfig)) {
            return false;
        }
        UserPhoneConfig other = (UserPhoneConfig) obj;
        return Objects.equals(phoneTypeAsString(), other.phoneTypeAsString()) && Objects.equals(autoAccept(), other.autoAccept())
                && Objects.equals(afterContactWorkTimeLimit(), other.afterContactWorkTimeLimit())
                && Objects.equals(deskPhoneNumber(), other.deskPhoneNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserPhoneConfig").add("PhoneType", phoneTypeAsString()).add("AutoAccept", autoAccept())
                .add("AfterContactWorkTimeLimit", afterContactWorkTimeLimit()).add("DeskPhoneNumber", deskPhoneNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PhoneType":
            return Optional.ofNullable(clazz.cast(phoneTypeAsString()));
        case "AutoAccept":
            return Optional.ofNullable(clazz.cast(autoAccept()));
        case "AfterContactWorkTimeLimit":
            return Optional.ofNullable(clazz.cast(afterContactWorkTimeLimit()));
        case "DeskPhoneNumber":
            return Optional.ofNullable(clazz.cast(deskPhoneNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserPhoneConfig, T> g) {
        return obj -> g.apply((UserPhoneConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserPhoneConfig> {
        /**
         * <p>
         * The phone type.
         * </p>
         * 
         * @param phoneType
         *        The phone type.
         * @see PhoneType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneType
         */
        Builder phoneType(String phoneType);

        /**
         * <p>
         * The phone type.
         * </p>
         * 
         * @param phoneType
         *        The phone type.
         * @see PhoneType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneType
         */
        Builder phoneType(PhoneType phoneType);

        /**
         * <p>
         * The Auto accept setting.
         * </p>
         * 
         * @param autoAccept
         *        The Auto accept setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoAccept(Boolean autoAccept);

        /**
         * <p>
         * The After Call Work (ACW) timeout setting, in seconds. This parameter has a minimum value of 0 and a maximum
         * value of 2,000,000 seconds (24 days). Enter 0 if you don't want to allocate a specific amount of ACW time. It
         * essentially means an indefinite amount of time. When the conversation ends, ACW starts; the agent must choose
         * Close contact to end ACW.
         * </p>
         * <note>
         * <p>
         * When returned by a <code>SearchUsers</code> call, <code>AfterContactWorkTimeLimit</code> is returned in
         * milliseconds.
         * </p>
         * </note>
         * 
         * @param afterContactWorkTimeLimit
         *        The After Call Work (ACW) timeout setting, in seconds. This parameter has a minimum value of 0 and a
         *        maximum value of 2,000,000 seconds (24 days). Enter 0 if you don't want to allocate a specific amount
         *        of ACW time. It essentially means an indefinite amount of time. When the conversation ends, ACW
         *        starts; the agent must choose Close contact to end ACW. </p> <note>
         *        <p>
         *        When returned by a <code>SearchUsers</code> call, <code>AfterContactWorkTimeLimit</code> is returned
         *        in milliseconds.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder afterContactWorkTimeLimit(Integer afterContactWorkTimeLimit);

        /**
         * <p>
         * The phone number for the user's desk phone.
         * </p>
         * 
         * @param deskPhoneNumber
         *        The phone number for the user's desk phone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deskPhoneNumber(String deskPhoneNumber);
    }

    static final class BuilderImpl implements Builder {
        private String phoneType;

        private Boolean autoAccept;

        private Integer afterContactWorkTimeLimit;

        private String deskPhoneNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(UserPhoneConfig model) {
            phoneType(model.phoneType);
            autoAccept(model.autoAccept);
            afterContactWorkTimeLimit(model.afterContactWorkTimeLimit);
            deskPhoneNumber(model.deskPhoneNumber);
        }

        public final String getPhoneType() {
            return phoneType;
        }

        public final void setPhoneType(String phoneType) {
            this.phoneType = phoneType;
        }

        @Override
        public final Builder phoneType(String phoneType) {
            this.phoneType = phoneType;
            return this;
        }

        @Override
        public final Builder phoneType(PhoneType phoneType) {
            this.phoneType(phoneType == null ? null : phoneType.toString());
            return this;
        }

        public final Boolean getAutoAccept() {
            return autoAccept;
        }

        public final void setAutoAccept(Boolean autoAccept) {
            this.autoAccept = autoAccept;
        }

        @Override
        public final Builder autoAccept(Boolean autoAccept) {
            this.autoAccept = autoAccept;
            return this;
        }

        public final Integer getAfterContactWorkTimeLimit() {
            return afterContactWorkTimeLimit;
        }

        public final void setAfterContactWorkTimeLimit(Integer afterContactWorkTimeLimit) {
            this.afterContactWorkTimeLimit = afterContactWorkTimeLimit;
        }

        @Override
        public final Builder afterContactWorkTimeLimit(Integer afterContactWorkTimeLimit) {
            this.afterContactWorkTimeLimit = afterContactWorkTimeLimit;
            return this;
        }

        public final String getDeskPhoneNumber() {
            return deskPhoneNumber;
        }

        public final void setDeskPhoneNumber(String deskPhoneNumber) {
            this.deskPhoneNumber = deskPhoneNumber;
        }

        @Override
        public final Builder deskPhoneNumber(String deskPhoneNumber) {
            this.deskPhoneNumber = deskPhoneNumber;
            return this;
        }

        @Override
        public UserPhoneConfig build() {
            return new UserPhoneConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
