/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendChatIntegrationEventResponse extends ConnectResponse implements
        ToCopyableBuilder<SendChatIntegrationEventResponse.Builder, SendChatIntegrationEventResponse> {
    private static final SdkField<String> INITIAL_CONTACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InitialContactId").getter(getter(SendChatIntegrationEventResponse::initialContactId))
            .setter(setter(Builder::initialContactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitialContactId").build()).build();

    private static final SdkField<Boolean> NEW_CHAT_CREATED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("NewChatCreated").getter(getter(SendChatIntegrationEventResponse::newChatCreated))
            .setter(setter(Builder::newChatCreated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewChatCreated").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INITIAL_CONTACT_ID_FIELD,
            NEW_CHAT_CREATED_FIELD));

    private final String initialContactId;

    private final Boolean newChatCreated;

    private SendChatIntegrationEventResponse(BuilderImpl builder) {
        super(builder);
        this.initialContactId = builder.initialContactId;
        this.newChatCreated = builder.newChatCreated;
    }

    /**
     * <p>
     * Identifier of chat contact used to handle integration event. This may be null if the integration event is not
     * valid without an already existing chat contact.
     * </p>
     * 
     * @return Identifier of chat contact used to handle integration event. This may be null if the integration event is
     *         not valid without an already existing chat contact.
     */
    public final String initialContactId() {
        return initialContactId;
    }

    /**
     * <p>
     * Whether handling the integration event resulted in creating a new chat or acting on existing chat.
     * </p>
     * 
     * @return Whether handling the integration event resulted in creating a new chat or acting on existing chat.
     */
    public final Boolean newChatCreated() {
        return newChatCreated;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(initialContactId());
        hashCode = 31 * hashCode + Objects.hashCode(newChatCreated());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendChatIntegrationEventResponse)) {
            return false;
        }
        SendChatIntegrationEventResponse other = (SendChatIntegrationEventResponse) obj;
        return Objects.equals(initialContactId(), other.initialContactId())
                && Objects.equals(newChatCreated(), other.newChatCreated());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SendChatIntegrationEventResponse").add("InitialContactId", initialContactId())
                .add("NewChatCreated", newChatCreated()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InitialContactId":
            return Optional.ofNullable(clazz.cast(initialContactId()));
        case "NewChatCreated":
            return Optional.ofNullable(clazz.cast(newChatCreated()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendChatIntegrationEventResponse, T> g) {
        return obj -> g.apply((SendChatIntegrationEventResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, SendChatIntegrationEventResponse> {
        /**
         * <p>
         * Identifier of chat contact used to handle integration event. This may be null if the integration event is not
         * valid without an already existing chat contact.
         * </p>
         * 
         * @param initialContactId
         *        Identifier of chat contact used to handle integration event. This may be null if the integration event
         *        is not valid without an already existing chat contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initialContactId(String initialContactId);

        /**
         * <p>
         * Whether handling the integration event resulted in creating a new chat or acting on existing chat.
         * </p>
         * 
         * @param newChatCreated
         *        Whether handling the integration event resulted in creating a new chat or acting on existing chat.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newChatCreated(Boolean newChatCreated);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private String initialContactId;

        private Boolean newChatCreated;

        private BuilderImpl() {
        }

        private BuilderImpl(SendChatIntegrationEventResponse model) {
            super(model);
            initialContactId(model.initialContactId);
            newChatCreated(model.newChatCreated);
        }

        public final String getInitialContactId() {
            return initialContactId;
        }

        public final void setInitialContactId(String initialContactId) {
            this.initialContactId = initialContactId;
        }

        @Override
        public final Builder initialContactId(String initialContactId) {
            this.initialContactId = initialContactId;
            return this;
        }

        public final Boolean getNewChatCreated() {
            return newChatCreated;
        }

        public final void setNewChatCreated(Boolean newChatCreated) {
            this.newChatCreated = newChatCreated;
        }

        @Override
        public final Builder newChatCreated(Boolean newChatCreated) {
            this.newChatCreated = newChatCreated;
            return this;
        }

        @Override
        public SendChatIntegrationEventResponse build() {
            return new SendChatIntegrationEventResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
