/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The user's first name and last name.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserIdentityInfoLite implements SdkPojo, Serializable,
        ToCopyableBuilder<UserIdentityInfoLite.Builder, UserIdentityInfoLite> {
    private static final SdkField<String> FIRST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirstName").getter(getter(UserIdentityInfoLite::firstName)).setter(setter(Builder::firstName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstName").build()).build();

    private static final SdkField<String> LAST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastName").getter(getter(UserIdentityInfoLite::lastName)).setter(setter(Builder::lastName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIRST_NAME_FIELD,
            LAST_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String firstName;

    private final String lastName;

    private UserIdentityInfoLite(BuilderImpl builder) {
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
    }

    /**
     * <p>
     * The user's first name.
     * </p>
     * 
     * @return The user's first name.
     */
    public final String firstName() {
        return firstName;
    }

    /**
     * <p>
     * The user's last name.
     * </p>
     * 
     * @return The user's last name.
     */
    public final String lastName() {
        return lastName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(firstName());
        hashCode = 31 * hashCode + Objects.hashCode(lastName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserIdentityInfoLite)) {
            return false;
        }
        UserIdentityInfoLite other = (UserIdentityInfoLite) obj;
        return Objects.equals(firstName(), other.firstName()) && Objects.equals(lastName(), other.lastName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserIdentityInfoLite")
                .add("FirstName", firstName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("LastName", lastName() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FirstName":
            return Optional.ofNullable(clazz.cast(firstName()));
        case "LastName":
            return Optional.ofNullable(clazz.cast(lastName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserIdentityInfoLite, T> g) {
        return obj -> g.apply((UserIdentityInfoLite) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserIdentityInfoLite> {
        /**
         * <p>
         * The user's first name.
         * </p>
         * 
         * @param firstName
         *        The user's first name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstName(String firstName);

        /**
         * <p>
         * The user's last name.
         * </p>
         * 
         * @param lastName
         *        The user's last name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastName(String lastName);
    }

    static final class BuilderImpl implements Builder {
        private String firstName;

        private String lastName;

        private BuilderImpl() {
        }

        private BuilderImpl(UserIdentityInfoLite model) {
            firstName(model.firstName);
            lastName(model.lastName);
        }

        public final String getFirstName() {
            return firstName;
        }

        public final void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        @Override
        public final Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public final String getLastName() {
            return lastName;
        }

        public final void setLastName(String lastName) {
            this.lastName = lastName;
        }

        @Override
        public final Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        @Override
        public UserIdentityInfoLite build() {
            return new UserIdentityInfoLite(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
