/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ArtifactStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RealTimeContactAnalysisAttachment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RealTimeContactAnalysisAttachment> {
    private static final SdkField<String> ATTACHMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttachmentName").getter(RealTimeContactAnalysisAttachment.getter(RealTimeContactAnalysisAttachment::attachmentName)).setter(RealTimeContactAnalysisAttachment.setter(Builder::attachmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentName").build()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentType").getter(RealTimeContactAnalysisAttachment.getter(RealTimeContactAnalysisAttachment::contentType)).setter(RealTimeContactAnalysisAttachment.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentType").build()}).build();
    private static final SdkField<String> ATTACHMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttachmentId").getter(RealTimeContactAnalysisAttachment.getter(RealTimeContactAnalysisAttachment::attachmentId)).setter(RealTimeContactAnalysisAttachment.setter(Builder::attachmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(RealTimeContactAnalysisAttachment.getter(RealTimeContactAnalysisAttachment::statusAsString)).setter(RealTimeContactAnalysisAttachment.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_NAME_FIELD, CONTENT_TYPE_FIELD, ATTACHMENT_ID_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String attachmentName;
    private final String contentType;
    private final String attachmentId;
    private final String status;

    private RealTimeContactAnalysisAttachment(BuilderImpl builder) {
        this.attachmentName = builder.attachmentName;
        this.contentType = builder.contentType;
        this.attachmentId = builder.attachmentId;
        this.status = builder.status;
    }

    public final String attachmentName() {
        return this.attachmentName;
    }

    public final String contentType() {
        return this.contentType;
    }

    public final String attachmentId() {
        return this.attachmentId;
    }

    public final ArtifactStatus status() {
        return ArtifactStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RealTimeContactAnalysisAttachment)) {
            return false;
        }
        RealTimeContactAnalysisAttachment other = (RealTimeContactAnalysisAttachment)obj;
        return Objects.equals(this.attachmentName(), other.attachmentName()) && Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.attachmentId(), other.attachmentId()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RealTimeContactAnalysisAttachment").add("AttachmentName", (Object)this.attachmentName()).add("ContentType", (Object)this.contentType()).add("AttachmentId", (Object)this.attachmentId()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttachmentName": {
                return Optional.ofNullable(clazz.cast(this.attachmentName()));
            }
            case "ContentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "AttachmentId": {
                return Optional.ofNullable(clazz.cast(this.attachmentId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RealTimeContactAnalysisAttachment, T> g) {
        return obj -> g.apply((RealTimeContactAnalysisAttachment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String attachmentName;
        private String contentType;
        private String attachmentId;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(RealTimeContactAnalysisAttachment model) {
            this.attachmentName(model.attachmentName);
            this.contentType(model.contentType);
            this.attachmentId(model.attachmentId);
            this.status(model.status);
        }

        public final String getAttachmentName() {
            return this.attachmentName;
        }

        public final void setAttachmentName(String attachmentName) {
            this.attachmentName = attachmentName;
        }

        @Override
        public final Builder attachmentName(String attachmentName) {
            this.attachmentName = attachmentName;
            return this;
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final String getAttachmentId() {
            return this.attachmentId;
        }

        public final void setAttachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
        }

        @Override
        public final Builder attachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ArtifactStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public RealTimeContactAnalysisAttachment build() {
            return new RealTimeContactAnalysisAttachment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RealTimeContactAnalysisAttachment> {
        public Builder attachmentName(String var1);

        public Builder contentType(String var1);

        public Builder attachmentId(String var1);

        public Builder status(String var1);

        public Builder status(ArtifactStatus var1);
    }
}

