/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.connect.model.AccessDeniedException;
import software.amazon.awssdk.services.connect.model.ActivateEvaluationFormRequest;
import software.amazon.awssdk.services.connect.model.ActivateEvaluationFormResponse;
import software.amazon.awssdk.services.connect.model.AssociateAnalyticsDataSetRequest;
import software.amazon.awssdk.services.connect.model.AssociateAnalyticsDataSetResponse;
import software.amazon.awssdk.services.connect.model.AssociateApprovedOriginRequest;
import software.amazon.awssdk.services.connect.model.AssociateApprovedOriginResponse;
import software.amazon.awssdk.services.connect.model.AssociateBotRequest;
import software.amazon.awssdk.services.connect.model.AssociateBotResponse;
import software.amazon.awssdk.services.connect.model.AssociateDefaultVocabularyRequest;
import software.amazon.awssdk.services.connect.model.AssociateDefaultVocabularyResponse;
import software.amazon.awssdk.services.connect.model.AssociateFlowRequest;
import software.amazon.awssdk.services.connect.model.AssociateFlowResponse;
import software.amazon.awssdk.services.connect.model.AssociateInstanceStorageConfigRequest;
import software.amazon.awssdk.services.connect.model.AssociateInstanceStorageConfigResponse;
import software.amazon.awssdk.services.connect.model.AssociateLambdaFunctionRequest;
import software.amazon.awssdk.services.connect.model.AssociateLambdaFunctionResponse;
import software.amazon.awssdk.services.connect.model.AssociateLexBotRequest;
import software.amazon.awssdk.services.connect.model.AssociateLexBotResponse;
import software.amazon.awssdk.services.connect.model.AssociatePhoneNumberContactFlowRequest;
import software.amazon.awssdk.services.connect.model.AssociatePhoneNumberContactFlowResponse;
import software.amazon.awssdk.services.connect.model.AssociateQueueQuickConnectsRequest;
import software.amazon.awssdk.services.connect.model.AssociateQueueQuickConnectsResponse;
import software.amazon.awssdk.services.connect.model.AssociateRoutingProfileQueuesRequest;
import software.amazon.awssdk.services.connect.model.AssociateRoutingProfileQueuesResponse;
import software.amazon.awssdk.services.connect.model.AssociateSecurityKeyRequest;
import software.amazon.awssdk.services.connect.model.AssociateSecurityKeyResponse;
import software.amazon.awssdk.services.connect.model.AssociateTrafficDistributionGroupUserRequest;
import software.amazon.awssdk.services.connect.model.AssociateTrafficDistributionGroupUserResponse;
import software.amazon.awssdk.services.connect.model.AssociateUserProficienciesRequest;
import software.amazon.awssdk.services.connect.model.AssociateUserProficienciesResponse;
import software.amazon.awssdk.services.connect.model.BatchAssociateAnalyticsDataSetRequest;
import software.amazon.awssdk.services.connect.model.BatchAssociateAnalyticsDataSetResponse;
import software.amazon.awssdk.services.connect.model.BatchDisassociateAnalyticsDataSetRequest;
import software.amazon.awssdk.services.connect.model.BatchDisassociateAnalyticsDataSetResponse;
import software.amazon.awssdk.services.connect.model.BatchGetAttachedFileMetadataRequest;
import software.amazon.awssdk.services.connect.model.BatchGetAttachedFileMetadataResponse;
import software.amazon.awssdk.services.connect.model.BatchGetFlowAssociationRequest;
import software.amazon.awssdk.services.connect.model.BatchGetFlowAssociationResponse;
import software.amazon.awssdk.services.connect.model.BatchPutContactRequest;
import software.amazon.awssdk.services.connect.model.BatchPutContactResponse;
import software.amazon.awssdk.services.connect.model.ClaimPhoneNumberRequest;
import software.amazon.awssdk.services.connect.model.ClaimPhoneNumberResponse;
import software.amazon.awssdk.services.connect.model.CompleteAttachedFileUploadRequest;
import software.amazon.awssdk.services.connect.model.CompleteAttachedFileUploadResponse;
import software.amazon.awssdk.services.connect.model.ConflictException;
import software.amazon.awssdk.services.connect.model.ConnectException;
import software.amazon.awssdk.services.connect.model.ContactFlowNotPublishedException;
import software.amazon.awssdk.services.connect.model.ContactNotFoundException;
import software.amazon.awssdk.services.connect.model.CreateAgentStatusRequest;
import software.amazon.awssdk.services.connect.model.CreateAgentStatusResponse;
import software.amazon.awssdk.services.connect.model.CreateContactFlowModuleRequest;
import software.amazon.awssdk.services.connect.model.CreateContactFlowModuleResponse;
import software.amazon.awssdk.services.connect.model.CreateContactFlowRequest;
import software.amazon.awssdk.services.connect.model.CreateContactFlowResponse;
import software.amazon.awssdk.services.connect.model.CreateEvaluationFormRequest;
import software.amazon.awssdk.services.connect.model.CreateEvaluationFormResponse;
import software.amazon.awssdk.services.connect.model.CreateHoursOfOperationRequest;
import software.amazon.awssdk.services.connect.model.CreateHoursOfOperationResponse;
import software.amazon.awssdk.services.connect.model.CreateInstanceRequest;
import software.amazon.awssdk.services.connect.model.CreateInstanceResponse;
import software.amazon.awssdk.services.connect.model.CreateIntegrationAssociationRequest;
import software.amazon.awssdk.services.connect.model.CreateIntegrationAssociationResponse;
import software.amazon.awssdk.services.connect.model.CreateParticipantRequest;
import software.amazon.awssdk.services.connect.model.CreateParticipantResponse;
import software.amazon.awssdk.services.connect.model.CreatePersistentContactAssociationRequest;
import software.amazon.awssdk.services.connect.model.CreatePersistentContactAssociationResponse;
import software.amazon.awssdk.services.connect.model.CreatePredefinedAttributeRequest;
import software.amazon.awssdk.services.connect.model.CreatePredefinedAttributeResponse;
import software.amazon.awssdk.services.connect.model.CreatePromptRequest;
import software.amazon.awssdk.services.connect.model.CreatePromptResponse;
import software.amazon.awssdk.services.connect.model.CreateQueueRequest;
import software.amazon.awssdk.services.connect.model.CreateQueueResponse;
import software.amazon.awssdk.services.connect.model.CreateQuickConnectRequest;
import software.amazon.awssdk.services.connect.model.CreateQuickConnectResponse;
import software.amazon.awssdk.services.connect.model.CreateRoutingProfileRequest;
import software.amazon.awssdk.services.connect.model.CreateRoutingProfileResponse;
import software.amazon.awssdk.services.connect.model.CreateRuleRequest;
import software.amazon.awssdk.services.connect.model.CreateRuleResponse;
import software.amazon.awssdk.services.connect.model.CreateSecurityProfileRequest;
import software.amazon.awssdk.services.connect.model.CreateSecurityProfileResponse;
import software.amazon.awssdk.services.connect.model.CreateTaskTemplateRequest;
import software.amazon.awssdk.services.connect.model.CreateTaskTemplateResponse;
import software.amazon.awssdk.services.connect.model.CreateTrafficDistributionGroupRequest;
import software.amazon.awssdk.services.connect.model.CreateTrafficDistributionGroupResponse;
import software.amazon.awssdk.services.connect.model.CreateUseCaseRequest;
import software.amazon.awssdk.services.connect.model.CreateUseCaseResponse;
import software.amazon.awssdk.services.connect.model.CreateUserHierarchyGroupRequest;
import software.amazon.awssdk.services.connect.model.CreateUserHierarchyGroupResponse;
import software.amazon.awssdk.services.connect.model.CreateUserRequest;
import software.amazon.awssdk.services.connect.model.CreateUserResponse;
import software.amazon.awssdk.services.connect.model.CreateViewRequest;
import software.amazon.awssdk.services.connect.model.CreateViewResponse;
import software.amazon.awssdk.services.connect.model.CreateViewVersionRequest;
import software.amazon.awssdk.services.connect.model.CreateViewVersionResponse;
import software.amazon.awssdk.services.connect.model.CreateVocabularyRequest;
import software.amazon.awssdk.services.connect.model.CreateVocabularyResponse;
import software.amazon.awssdk.services.connect.model.DeactivateEvaluationFormRequest;
import software.amazon.awssdk.services.connect.model.DeactivateEvaluationFormResponse;
import software.amazon.awssdk.services.connect.model.DeleteAttachedFileRequest;
import software.amazon.awssdk.services.connect.model.DeleteAttachedFileResponse;
import software.amazon.awssdk.services.connect.model.DeleteContactEvaluationRequest;
import software.amazon.awssdk.services.connect.model.DeleteContactEvaluationResponse;
import software.amazon.awssdk.services.connect.model.DeleteContactFlowModuleRequest;
import software.amazon.awssdk.services.connect.model.DeleteContactFlowModuleResponse;
import software.amazon.awssdk.services.connect.model.DeleteContactFlowRequest;
import software.amazon.awssdk.services.connect.model.DeleteContactFlowResponse;
import software.amazon.awssdk.services.connect.model.DeleteEvaluationFormRequest;
import software.amazon.awssdk.services.connect.model.DeleteEvaluationFormResponse;
import software.amazon.awssdk.services.connect.model.DeleteHoursOfOperationRequest;
import software.amazon.awssdk.services.connect.model.DeleteHoursOfOperationResponse;
import software.amazon.awssdk.services.connect.model.DeleteInstanceRequest;
import software.amazon.awssdk.services.connect.model.DeleteInstanceResponse;
import software.amazon.awssdk.services.connect.model.DeleteIntegrationAssociationRequest;
import software.amazon.awssdk.services.connect.model.DeleteIntegrationAssociationResponse;
import software.amazon.awssdk.services.connect.model.DeletePredefinedAttributeRequest;
import software.amazon.awssdk.services.connect.model.DeletePredefinedAttributeResponse;
import software.amazon.awssdk.services.connect.model.DeletePromptRequest;
import software.amazon.awssdk.services.connect.model.DeletePromptResponse;
import software.amazon.awssdk.services.connect.model.DeleteQueueRequest;
import software.amazon.awssdk.services.connect.model.DeleteQueueResponse;
import software.amazon.awssdk.services.connect.model.DeleteQuickConnectRequest;
import software.amazon.awssdk.services.connect.model.DeleteQuickConnectResponse;
import software.amazon.awssdk.services.connect.model.DeleteRoutingProfileRequest;
import software.amazon.awssdk.services.connect.model.DeleteRoutingProfileResponse;
import software.amazon.awssdk.services.connect.model.DeleteRuleRequest;
import software.amazon.awssdk.services.connect.model.DeleteRuleResponse;
import software.amazon.awssdk.services.connect.model.DeleteSecurityProfileRequest;
import software.amazon.awssdk.services.connect.model.DeleteSecurityProfileResponse;
import software.amazon.awssdk.services.connect.model.DeleteTaskTemplateRequest;
import software.amazon.awssdk.services.connect.model.DeleteTaskTemplateResponse;
import software.amazon.awssdk.services.connect.model.DeleteTrafficDistributionGroupRequest;
import software.amazon.awssdk.services.connect.model.DeleteTrafficDistributionGroupResponse;
import software.amazon.awssdk.services.connect.model.DeleteUseCaseRequest;
import software.amazon.awssdk.services.connect.model.DeleteUseCaseResponse;
import software.amazon.awssdk.services.connect.model.DeleteUserHierarchyGroupRequest;
import software.amazon.awssdk.services.connect.model.DeleteUserHierarchyGroupResponse;
import software.amazon.awssdk.services.connect.model.DeleteUserRequest;
import software.amazon.awssdk.services.connect.model.DeleteUserResponse;
import software.amazon.awssdk.services.connect.model.DeleteViewRequest;
import software.amazon.awssdk.services.connect.model.DeleteViewResponse;
import software.amazon.awssdk.services.connect.model.DeleteViewVersionRequest;
import software.amazon.awssdk.services.connect.model.DeleteViewVersionResponse;
import software.amazon.awssdk.services.connect.model.DeleteVocabularyRequest;
import software.amazon.awssdk.services.connect.model.DeleteVocabularyResponse;
import software.amazon.awssdk.services.connect.model.DescribeAgentStatusRequest;
import software.amazon.awssdk.services.connect.model.DescribeAgentStatusResponse;
import software.amazon.awssdk.services.connect.model.DescribeContactEvaluationRequest;
import software.amazon.awssdk.services.connect.model.DescribeContactEvaluationResponse;
import software.amazon.awssdk.services.connect.model.DescribeContactFlowModuleRequest;
import software.amazon.awssdk.services.connect.model.DescribeContactFlowModuleResponse;
import software.amazon.awssdk.services.connect.model.DescribeContactFlowRequest;
import software.amazon.awssdk.services.connect.model.DescribeContactFlowResponse;
import software.amazon.awssdk.services.connect.model.DescribeContactRequest;
import software.amazon.awssdk.services.connect.model.DescribeContactResponse;
import software.amazon.awssdk.services.connect.model.DescribeEvaluationFormRequest;
import software.amazon.awssdk.services.connect.model.DescribeEvaluationFormResponse;
import software.amazon.awssdk.services.connect.model.DescribeHoursOfOperationRequest;
import software.amazon.awssdk.services.connect.model.DescribeHoursOfOperationResponse;
import software.amazon.awssdk.services.connect.model.DescribeInstanceAttributeRequest;
import software.amazon.awssdk.services.connect.model.DescribeInstanceAttributeResponse;
import software.amazon.awssdk.services.connect.model.DescribeInstanceRequest;
import software.amazon.awssdk.services.connect.model.DescribeInstanceResponse;
import software.amazon.awssdk.services.connect.model.DescribeInstanceStorageConfigRequest;
import software.amazon.awssdk.services.connect.model.DescribeInstanceStorageConfigResponse;
import software.amazon.awssdk.services.connect.model.DescribePhoneNumberRequest;
import software.amazon.awssdk.services.connect.model.DescribePhoneNumberResponse;
import software.amazon.awssdk.services.connect.model.DescribePredefinedAttributeRequest;
import software.amazon.awssdk.services.connect.model.DescribePredefinedAttributeResponse;
import software.amazon.awssdk.services.connect.model.DescribePromptRequest;
import software.amazon.awssdk.services.connect.model.DescribePromptResponse;
import software.amazon.awssdk.services.connect.model.DescribeQueueRequest;
import software.amazon.awssdk.services.connect.model.DescribeQueueResponse;
import software.amazon.awssdk.services.connect.model.DescribeQuickConnectRequest;
import software.amazon.awssdk.services.connect.model.DescribeQuickConnectResponse;
import software.amazon.awssdk.services.connect.model.DescribeRoutingProfileRequest;
import software.amazon.awssdk.services.connect.model.DescribeRoutingProfileResponse;
import software.amazon.awssdk.services.connect.model.DescribeRuleRequest;
import software.amazon.awssdk.services.connect.model.DescribeRuleResponse;
import software.amazon.awssdk.services.connect.model.DescribeSecurityProfileRequest;
import software.amazon.awssdk.services.connect.model.DescribeSecurityProfileResponse;
import software.amazon.awssdk.services.connect.model.DescribeTrafficDistributionGroupRequest;
import software.amazon.awssdk.services.connect.model.DescribeTrafficDistributionGroupResponse;
import software.amazon.awssdk.services.connect.model.DescribeUserHierarchyGroupRequest;
import software.amazon.awssdk.services.connect.model.DescribeUserHierarchyGroupResponse;
import software.amazon.awssdk.services.connect.model.DescribeUserHierarchyStructureRequest;
import software.amazon.awssdk.services.connect.model.DescribeUserHierarchyStructureResponse;
import software.amazon.awssdk.services.connect.model.DescribeUserRequest;
import software.amazon.awssdk.services.connect.model.DescribeUserResponse;
import software.amazon.awssdk.services.connect.model.DescribeViewRequest;
import software.amazon.awssdk.services.connect.model.DescribeViewResponse;
import software.amazon.awssdk.services.connect.model.DescribeVocabularyRequest;
import software.amazon.awssdk.services.connect.model.DescribeVocabularyResponse;
import software.amazon.awssdk.services.connect.model.DestinationNotAllowedException;
import software.amazon.awssdk.services.connect.model.DisassociateAnalyticsDataSetRequest;
import software.amazon.awssdk.services.connect.model.DisassociateAnalyticsDataSetResponse;
import software.amazon.awssdk.services.connect.model.DisassociateApprovedOriginRequest;
import software.amazon.awssdk.services.connect.model.DisassociateApprovedOriginResponse;
import software.amazon.awssdk.services.connect.model.DisassociateBotRequest;
import software.amazon.awssdk.services.connect.model.DisassociateBotResponse;
import software.amazon.awssdk.services.connect.model.DisassociateFlowRequest;
import software.amazon.awssdk.services.connect.model.DisassociateFlowResponse;
import software.amazon.awssdk.services.connect.model.DisassociateInstanceStorageConfigRequest;
import software.amazon.awssdk.services.connect.model.DisassociateInstanceStorageConfigResponse;
import software.amazon.awssdk.services.connect.model.DisassociateLambdaFunctionRequest;
import software.amazon.awssdk.services.connect.model.DisassociateLambdaFunctionResponse;
import software.amazon.awssdk.services.connect.model.DisassociateLexBotRequest;
import software.amazon.awssdk.services.connect.model.DisassociateLexBotResponse;
import software.amazon.awssdk.services.connect.model.DisassociatePhoneNumberContactFlowRequest;
import software.amazon.awssdk.services.connect.model.DisassociatePhoneNumberContactFlowResponse;
import software.amazon.awssdk.services.connect.model.DisassociateQueueQuickConnectsRequest;
import software.amazon.awssdk.services.connect.model.DisassociateQueueQuickConnectsResponse;
import software.amazon.awssdk.services.connect.model.DisassociateRoutingProfileQueuesRequest;
import software.amazon.awssdk.services.connect.model.DisassociateRoutingProfileQueuesResponse;
import software.amazon.awssdk.services.connect.model.DisassociateSecurityKeyRequest;
import software.amazon.awssdk.services.connect.model.DisassociateSecurityKeyResponse;
import software.amazon.awssdk.services.connect.model.DisassociateTrafficDistributionGroupUserRequest;
import software.amazon.awssdk.services.connect.model.DisassociateTrafficDistributionGroupUserResponse;
import software.amazon.awssdk.services.connect.model.DisassociateUserProficienciesRequest;
import software.amazon.awssdk.services.connect.model.DisassociateUserProficienciesResponse;
import software.amazon.awssdk.services.connect.model.DismissUserContactRequest;
import software.amazon.awssdk.services.connect.model.DismissUserContactResponse;
import software.amazon.awssdk.services.connect.model.DuplicateResourceException;
import software.amazon.awssdk.services.connect.model.GetAttachedFileRequest;
import software.amazon.awssdk.services.connect.model.GetAttachedFileResponse;
import software.amazon.awssdk.services.connect.model.GetContactAttributesRequest;
import software.amazon.awssdk.services.connect.model.GetContactAttributesResponse;
import software.amazon.awssdk.services.connect.model.GetCurrentMetricDataRequest;
import software.amazon.awssdk.services.connect.model.GetCurrentMetricDataResponse;
import software.amazon.awssdk.services.connect.model.GetCurrentUserDataRequest;
import software.amazon.awssdk.services.connect.model.GetCurrentUserDataResponse;
import software.amazon.awssdk.services.connect.model.GetFederationTokenRequest;
import software.amazon.awssdk.services.connect.model.GetFederationTokenResponse;
import software.amazon.awssdk.services.connect.model.GetFlowAssociationRequest;
import software.amazon.awssdk.services.connect.model.GetFlowAssociationResponse;
import software.amazon.awssdk.services.connect.model.GetMetricDataRequest;
import software.amazon.awssdk.services.connect.model.GetMetricDataResponse;
import software.amazon.awssdk.services.connect.model.GetMetricDataV2Request;
import software.amazon.awssdk.services.connect.model.GetMetricDataV2Response;
import software.amazon.awssdk.services.connect.model.GetPromptFileRequest;
import software.amazon.awssdk.services.connect.model.GetPromptFileResponse;
import software.amazon.awssdk.services.connect.model.GetTaskTemplateRequest;
import software.amazon.awssdk.services.connect.model.GetTaskTemplateResponse;
import software.amazon.awssdk.services.connect.model.GetTrafficDistributionRequest;
import software.amazon.awssdk.services.connect.model.GetTrafficDistributionResponse;
import software.amazon.awssdk.services.connect.model.IdempotencyException;
import software.amazon.awssdk.services.connect.model.ImportPhoneNumberRequest;
import software.amazon.awssdk.services.connect.model.ImportPhoneNumberResponse;
import software.amazon.awssdk.services.connect.model.InternalServiceException;
import software.amazon.awssdk.services.connect.model.InvalidContactFlowException;
import software.amazon.awssdk.services.connect.model.InvalidContactFlowModuleException;
import software.amazon.awssdk.services.connect.model.InvalidParameterException;
import software.amazon.awssdk.services.connect.model.InvalidRequestException;
import software.amazon.awssdk.services.connect.model.LimitExceededException;
import software.amazon.awssdk.services.connect.model.ListAgentStatusesRequest;
import software.amazon.awssdk.services.connect.model.ListAgentStatusesResponse;
import software.amazon.awssdk.services.connect.model.ListAnalyticsDataAssociationsRequest;
import software.amazon.awssdk.services.connect.model.ListAnalyticsDataAssociationsResponse;
import software.amazon.awssdk.services.connect.model.ListApprovedOriginsRequest;
import software.amazon.awssdk.services.connect.model.ListApprovedOriginsResponse;
import software.amazon.awssdk.services.connect.model.ListBotsRequest;
import software.amazon.awssdk.services.connect.model.ListBotsResponse;
import software.amazon.awssdk.services.connect.model.ListContactEvaluationsRequest;
import software.amazon.awssdk.services.connect.model.ListContactEvaluationsResponse;
import software.amazon.awssdk.services.connect.model.ListContactFlowModulesRequest;
import software.amazon.awssdk.services.connect.model.ListContactFlowModulesResponse;
import software.amazon.awssdk.services.connect.model.ListContactFlowsRequest;
import software.amazon.awssdk.services.connect.model.ListContactFlowsResponse;
import software.amazon.awssdk.services.connect.model.ListContactReferencesRequest;
import software.amazon.awssdk.services.connect.model.ListContactReferencesResponse;
import software.amazon.awssdk.services.connect.model.ListDefaultVocabulariesRequest;
import software.amazon.awssdk.services.connect.model.ListDefaultVocabulariesResponse;
import software.amazon.awssdk.services.connect.model.ListEvaluationFormVersionsRequest;
import software.amazon.awssdk.services.connect.model.ListEvaluationFormVersionsResponse;
import software.amazon.awssdk.services.connect.model.ListEvaluationFormsRequest;
import software.amazon.awssdk.services.connect.model.ListEvaluationFormsResponse;
import software.amazon.awssdk.services.connect.model.ListFlowAssociationsRequest;
import software.amazon.awssdk.services.connect.model.ListFlowAssociationsResponse;
import software.amazon.awssdk.services.connect.model.ListHoursOfOperationsRequest;
import software.amazon.awssdk.services.connect.model.ListHoursOfOperationsResponse;
import software.amazon.awssdk.services.connect.model.ListInstanceAttributesRequest;
import software.amazon.awssdk.services.connect.model.ListInstanceAttributesResponse;
import software.amazon.awssdk.services.connect.model.ListInstanceStorageConfigsRequest;
import software.amazon.awssdk.services.connect.model.ListInstanceStorageConfigsResponse;
import software.amazon.awssdk.services.connect.model.ListInstancesRequest;
import software.amazon.awssdk.services.connect.model.ListInstancesResponse;
import software.amazon.awssdk.services.connect.model.ListIntegrationAssociationsRequest;
import software.amazon.awssdk.services.connect.model.ListIntegrationAssociationsResponse;
import software.amazon.awssdk.services.connect.model.ListLambdaFunctionsRequest;
import software.amazon.awssdk.services.connect.model.ListLambdaFunctionsResponse;
import software.amazon.awssdk.services.connect.model.ListLexBotsRequest;
import software.amazon.awssdk.services.connect.model.ListLexBotsResponse;
import software.amazon.awssdk.services.connect.model.ListPhoneNumbersRequest;
import software.amazon.awssdk.services.connect.model.ListPhoneNumbersResponse;
import software.amazon.awssdk.services.connect.model.ListPhoneNumbersV2Request;
import software.amazon.awssdk.services.connect.model.ListPhoneNumbersV2Response;
import software.amazon.awssdk.services.connect.model.ListPredefinedAttributesRequest;
import software.amazon.awssdk.services.connect.model.ListPredefinedAttributesResponse;
import software.amazon.awssdk.services.connect.model.ListPromptsRequest;
import software.amazon.awssdk.services.connect.model.ListPromptsResponse;
import software.amazon.awssdk.services.connect.model.ListQueueQuickConnectsRequest;
import software.amazon.awssdk.services.connect.model.ListQueueQuickConnectsResponse;
import software.amazon.awssdk.services.connect.model.ListQueuesRequest;
import software.amazon.awssdk.services.connect.model.ListQueuesResponse;
import software.amazon.awssdk.services.connect.model.ListQuickConnectsRequest;
import software.amazon.awssdk.services.connect.model.ListQuickConnectsResponse;
import software.amazon.awssdk.services.connect.model.ListRealtimeContactAnalysisSegmentsV2Request;
import software.amazon.awssdk.services.connect.model.ListRealtimeContactAnalysisSegmentsV2Response;
import software.amazon.awssdk.services.connect.model.ListRoutingProfileQueuesRequest;
import software.amazon.awssdk.services.connect.model.ListRoutingProfileQueuesResponse;
import software.amazon.awssdk.services.connect.model.ListRoutingProfilesRequest;
import software.amazon.awssdk.services.connect.model.ListRoutingProfilesResponse;
import software.amazon.awssdk.services.connect.model.ListRulesRequest;
import software.amazon.awssdk.services.connect.model.ListRulesResponse;
import software.amazon.awssdk.services.connect.model.ListSecurityKeysRequest;
import software.amazon.awssdk.services.connect.model.ListSecurityKeysResponse;
import software.amazon.awssdk.services.connect.model.ListSecurityProfileApplicationsRequest;
import software.amazon.awssdk.services.connect.model.ListSecurityProfileApplicationsResponse;
import software.amazon.awssdk.services.connect.model.ListSecurityProfilePermissionsRequest;
import software.amazon.awssdk.services.connect.model.ListSecurityProfilePermissionsResponse;
import software.amazon.awssdk.services.connect.model.ListSecurityProfilesRequest;
import software.amazon.awssdk.services.connect.model.ListSecurityProfilesResponse;
import software.amazon.awssdk.services.connect.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.connect.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.connect.model.ListTaskTemplatesRequest;
import software.amazon.awssdk.services.connect.model.ListTaskTemplatesResponse;
import software.amazon.awssdk.services.connect.model.ListTrafficDistributionGroupUsersRequest;
import software.amazon.awssdk.services.connect.model.ListTrafficDistributionGroupUsersResponse;
import software.amazon.awssdk.services.connect.model.ListTrafficDistributionGroupsRequest;
import software.amazon.awssdk.services.connect.model.ListTrafficDistributionGroupsResponse;
import software.amazon.awssdk.services.connect.model.ListUseCasesRequest;
import software.amazon.awssdk.services.connect.model.ListUseCasesResponse;
import software.amazon.awssdk.services.connect.model.ListUserHierarchyGroupsRequest;
import software.amazon.awssdk.services.connect.model.ListUserHierarchyGroupsResponse;
import software.amazon.awssdk.services.connect.model.ListUserProficienciesRequest;
import software.amazon.awssdk.services.connect.model.ListUserProficienciesResponse;
import software.amazon.awssdk.services.connect.model.ListUsersRequest;
import software.amazon.awssdk.services.connect.model.ListUsersResponse;
import software.amazon.awssdk.services.connect.model.ListViewVersionsRequest;
import software.amazon.awssdk.services.connect.model.ListViewVersionsResponse;
import software.amazon.awssdk.services.connect.model.ListViewsRequest;
import software.amazon.awssdk.services.connect.model.ListViewsResponse;
import software.amazon.awssdk.services.connect.model.MaximumResultReturnedException;
import software.amazon.awssdk.services.connect.model.MonitorContactRequest;
import software.amazon.awssdk.services.connect.model.MonitorContactResponse;
import software.amazon.awssdk.services.connect.model.OutboundContactNotPermittedException;
import software.amazon.awssdk.services.connect.model.OutputTypeNotFoundException;
import software.amazon.awssdk.services.connect.model.PauseContactRequest;
import software.amazon.awssdk.services.connect.model.PauseContactResponse;
import software.amazon.awssdk.services.connect.model.PropertyValidationException;
import software.amazon.awssdk.services.connect.model.PutUserStatusRequest;
import software.amazon.awssdk.services.connect.model.PutUserStatusResponse;
import software.amazon.awssdk.services.connect.model.ReleasePhoneNumberRequest;
import software.amazon.awssdk.services.connect.model.ReleasePhoneNumberResponse;
import software.amazon.awssdk.services.connect.model.ReplicateInstanceRequest;
import software.amazon.awssdk.services.connect.model.ReplicateInstanceResponse;
import software.amazon.awssdk.services.connect.model.ResourceConflictException;
import software.amazon.awssdk.services.connect.model.ResourceInUseException;
import software.amazon.awssdk.services.connect.model.ResourceNotFoundException;
import software.amazon.awssdk.services.connect.model.ResourceNotReadyException;
import software.amazon.awssdk.services.connect.model.ResumeContactRecordingRequest;
import software.amazon.awssdk.services.connect.model.ResumeContactRecordingResponse;
import software.amazon.awssdk.services.connect.model.ResumeContactRequest;
import software.amazon.awssdk.services.connect.model.ResumeContactResponse;
import software.amazon.awssdk.services.connect.model.SearchAvailablePhoneNumbersRequest;
import software.amazon.awssdk.services.connect.model.SearchAvailablePhoneNumbersResponse;
import software.amazon.awssdk.services.connect.model.SearchContactFlowModulesRequest;
import software.amazon.awssdk.services.connect.model.SearchContactFlowModulesResponse;
import software.amazon.awssdk.services.connect.model.SearchContactFlowsRequest;
import software.amazon.awssdk.services.connect.model.SearchContactFlowsResponse;
import software.amazon.awssdk.services.connect.model.SearchContactsRequest;
import software.amazon.awssdk.services.connect.model.SearchContactsResponse;
import software.amazon.awssdk.services.connect.model.SearchHoursOfOperationsRequest;
import software.amazon.awssdk.services.connect.model.SearchHoursOfOperationsResponse;
import software.amazon.awssdk.services.connect.model.SearchPredefinedAttributesRequest;
import software.amazon.awssdk.services.connect.model.SearchPredefinedAttributesResponse;
import software.amazon.awssdk.services.connect.model.SearchPromptsRequest;
import software.amazon.awssdk.services.connect.model.SearchPromptsResponse;
import software.amazon.awssdk.services.connect.model.SearchQueuesRequest;
import software.amazon.awssdk.services.connect.model.SearchQueuesResponse;
import software.amazon.awssdk.services.connect.model.SearchQuickConnectsRequest;
import software.amazon.awssdk.services.connect.model.SearchQuickConnectsResponse;
import software.amazon.awssdk.services.connect.model.SearchResourceTagsRequest;
import software.amazon.awssdk.services.connect.model.SearchResourceTagsResponse;
import software.amazon.awssdk.services.connect.model.SearchRoutingProfilesRequest;
import software.amazon.awssdk.services.connect.model.SearchRoutingProfilesResponse;
import software.amazon.awssdk.services.connect.model.SearchSecurityProfilesRequest;
import software.amazon.awssdk.services.connect.model.SearchSecurityProfilesResponse;
import software.amazon.awssdk.services.connect.model.SearchUsersRequest;
import software.amazon.awssdk.services.connect.model.SearchUsersResponse;
import software.amazon.awssdk.services.connect.model.SearchVocabulariesRequest;
import software.amazon.awssdk.services.connect.model.SearchVocabulariesResponse;
import software.amazon.awssdk.services.connect.model.SendChatIntegrationEventRequest;
import software.amazon.awssdk.services.connect.model.SendChatIntegrationEventResponse;
import software.amazon.awssdk.services.connect.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.connect.model.StartAttachedFileUploadRequest;
import software.amazon.awssdk.services.connect.model.StartAttachedFileUploadResponse;
import software.amazon.awssdk.services.connect.model.StartChatContactRequest;
import software.amazon.awssdk.services.connect.model.StartChatContactResponse;
import software.amazon.awssdk.services.connect.model.StartContactEvaluationRequest;
import software.amazon.awssdk.services.connect.model.StartContactEvaluationResponse;
import software.amazon.awssdk.services.connect.model.StartContactRecordingRequest;
import software.amazon.awssdk.services.connect.model.StartContactRecordingResponse;
import software.amazon.awssdk.services.connect.model.StartContactStreamingRequest;
import software.amazon.awssdk.services.connect.model.StartContactStreamingResponse;
import software.amazon.awssdk.services.connect.model.StartOutboundVoiceContactRequest;
import software.amazon.awssdk.services.connect.model.StartOutboundVoiceContactResponse;
import software.amazon.awssdk.services.connect.model.StartTaskContactRequest;
import software.amazon.awssdk.services.connect.model.StartTaskContactResponse;
import software.amazon.awssdk.services.connect.model.StartWebRtcContactRequest;
import software.amazon.awssdk.services.connect.model.StartWebRtcContactResponse;
import software.amazon.awssdk.services.connect.model.StopContactRecordingRequest;
import software.amazon.awssdk.services.connect.model.StopContactRecordingResponse;
import software.amazon.awssdk.services.connect.model.StopContactRequest;
import software.amazon.awssdk.services.connect.model.StopContactResponse;
import software.amazon.awssdk.services.connect.model.StopContactStreamingRequest;
import software.amazon.awssdk.services.connect.model.StopContactStreamingResponse;
import software.amazon.awssdk.services.connect.model.SubmitContactEvaluationRequest;
import software.amazon.awssdk.services.connect.model.SubmitContactEvaluationResponse;
import software.amazon.awssdk.services.connect.model.SuspendContactRecordingRequest;
import software.amazon.awssdk.services.connect.model.SuspendContactRecordingResponse;
import software.amazon.awssdk.services.connect.model.TagContactRequest;
import software.amazon.awssdk.services.connect.model.TagContactResponse;
import software.amazon.awssdk.services.connect.model.TagResourceRequest;
import software.amazon.awssdk.services.connect.model.TagResourceResponse;
import software.amazon.awssdk.services.connect.model.ThrottlingException;
import software.amazon.awssdk.services.connect.model.TooManyRequestsException;
import software.amazon.awssdk.services.connect.model.TransferContactRequest;
import software.amazon.awssdk.services.connect.model.TransferContactResponse;
import software.amazon.awssdk.services.connect.model.UntagContactRequest;
import software.amazon.awssdk.services.connect.model.UntagContactResponse;
import software.amazon.awssdk.services.connect.model.UntagResourceRequest;
import software.amazon.awssdk.services.connect.model.UntagResourceResponse;
import software.amazon.awssdk.services.connect.model.UpdateAgentStatusRequest;
import software.amazon.awssdk.services.connect.model.UpdateAgentStatusResponse;
import software.amazon.awssdk.services.connect.model.UpdateContactAttributesRequest;
import software.amazon.awssdk.services.connect.model.UpdateContactAttributesResponse;
import software.amazon.awssdk.services.connect.model.UpdateContactEvaluationRequest;
import software.amazon.awssdk.services.connect.model.UpdateContactEvaluationResponse;
import software.amazon.awssdk.services.connect.model.UpdateContactFlowContentRequest;
import software.amazon.awssdk.services.connect.model.UpdateContactFlowContentResponse;
import software.amazon.awssdk.services.connect.model.UpdateContactFlowMetadataRequest;
import software.amazon.awssdk.services.connect.model.UpdateContactFlowMetadataResponse;
import software.amazon.awssdk.services.connect.model.UpdateContactFlowModuleContentRequest;
import software.amazon.awssdk.services.connect.model.UpdateContactFlowModuleContentResponse;
import software.amazon.awssdk.services.connect.model.UpdateContactFlowModuleMetadataRequest;
import software.amazon.awssdk.services.connect.model.UpdateContactFlowModuleMetadataResponse;
import software.amazon.awssdk.services.connect.model.UpdateContactFlowNameRequest;
import software.amazon.awssdk.services.connect.model.UpdateContactFlowNameResponse;
import software.amazon.awssdk.services.connect.model.UpdateContactRequest;
import software.amazon.awssdk.services.connect.model.UpdateContactResponse;
import software.amazon.awssdk.services.connect.model.UpdateContactRoutingDataRequest;
import software.amazon.awssdk.services.connect.model.UpdateContactRoutingDataResponse;
import software.amazon.awssdk.services.connect.model.UpdateContactScheduleRequest;
import software.amazon.awssdk.services.connect.model.UpdateContactScheduleResponse;
import software.amazon.awssdk.services.connect.model.UpdateEvaluationFormRequest;
import software.amazon.awssdk.services.connect.model.UpdateEvaluationFormResponse;
import software.amazon.awssdk.services.connect.model.UpdateHoursOfOperationRequest;
import software.amazon.awssdk.services.connect.model.UpdateHoursOfOperationResponse;
import software.amazon.awssdk.services.connect.model.UpdateInstanceAttributeRequest;
import software.amazon.awssdk.services.connect.model.UpdateInstanceAttributeResponse;
import software.amazon.awssdk.services.connect.model.UpdateInstanceStorageConfigRequest;
import software.amazon.awssdk.services.connect.model.UpdateInstanceStorageConfigResponse;
import software.amazon.awssdk.services.connect.model.UpdateParticipantRoleConfigRequest;
import software.amazon.awssdk.services.connect.model.UpdateParticipantRoleConfigResponse;
import software.amazon.awssdk.services.connect.model.UpdatePhoneNumberMetadataRequest;
import software.amazon.awssdk.services.connect.model.UpdatePhoneNumberMetadataResponse;
import software.amazon.awssdk.services.connect.model.UpdatePhoneNumberRequest;
import software.amazon.awssdk.services.connect.model.UpdatePhoneNumberResponse;
import software.amazon.awssdk.services.connect.model.UpdatePredefinedAttributeRequest;
import software.amazon.awssdk.services.connect.model.UpdatePredefinedAttributeResponse;
import software.amazon.awssdk.services.connect.model.UpdatePromptRequest;
import software.amazon.awssdk.services.connect.model.UpdatePromptResponse;
import software.amazon.awssdk.services.connect.model.UpdateQueueHoursOfOperationRequest;
import software.amazon.awssdk.services.connect.model.UpdateQueueHoursOfOperationResponse;
import software.amazon.awssdk.services.connect.model.UpdateQueueMaxContactsRequest;
import software.amazon.awssdk.services.connect.model.UpdateQueueMaxContactsResponse;
import software.amazon.awssdk.services.connect.model.UpdateQueueNameRequest;
import software.amazon.awssdk.services.connect.model.UpdateQueueNameResponse;
import software.amazon.awssdk.services.connect.model.UpdateQueueOutboundCallerConfigRequest;
import software.amazon.awssdk.services.connect.model.UpdateQueueOutboundCallerConfigResponse;
import software.amazon.awssdk.services.connect.model.UpdateQueueStatusRequest;
import software.amazon.awssdk.services.connect.model.UpdateQueueStatusResponse;
import software.amazon.awssdk.services.connect.model.UpdateQuickConnectConfigRequest;
import software.amazon.awssdk.services.connect.model.UpdateQuickConnectConfigResponse;
import software.amazon.awssdk.services.connect.model.UpdateQuickConnectNameRequest;
import software.amazon.awssdk.services.connect.model.UpdateQuickConnectNameResponse;
import software.amazon.awssdk.services.connect.model.UpdateRoutingProfileAgentAvailabilityTimerRequest;
import software.amazon.awssdk.services.connect.model.UpdateRoutingProfileAgentAvailabilityTimerResponse;
import software.amazon.awssdk.services.connect.model.UpdateRoutingProfileConcurrencyRequest;
import software.amazon.awssdk.services.connect.model.UpdateRoutingProfileConcurrencyResponse;
import software.amazon.awssdk.services.connect.model.UpdateRoutingProfileDefaultOutboundQueueRequest;
import software.amazon.awssdk.services.connect.model.UpdateRoutingProfileDefaultOutboundQueueResponse;
import software.amazon.awssdk.services.connect.model.UpdateRoutingProfileNameRequest;
import software.amazon.awssdk.services.connect.model.UpdateRoutingProfileNameResponse;
import software.amazon.awssdk.services.connect.model.UpdateRoutingProfileQueuesRequest;
import software.amazon.awssdk.services.connect.model.UpdateRoutingProfileQueuesResponse;
import software.amazon.awssdk.services.connect.model.UpdateRuleRequest;
import software.amazon.awssdk.services.connect.model.UpdateRuleResponse;
import software.amazon.awssdk.services.connect.model.UpdateSecurityProfileRequest;
import software.amazon.awssdk.services.connect.model.UpdateSecurityProfileResponse;
import software.amazon.awssdk.services.connect.model.UpdateTaskTemplateRequest;
import software.amazon.awssdk.services.connect.model.UpdateTaskTemplateResponse;
import software.amazon.awssdk.services.connect.model.UpdateTrafficDistributionRequest;
import software.amazon.awssdk.services.connect.model.UpdateTrafficDistributionResponse;
import software.amazon.awssdk.services.connect.model.UpdateUserHierarchyGroupNameRequest;
import software.amazon.awssdk.services.connect.model.UpdateUserHierarchyGroupNameResponse;
import software.amazon.awssdk.services.connect.model.UpdateUserHierarchyRequest;
import software.amazon.awssdk.services.connect.model.UpdateUserHierarchyResponse;
import software.amazon.awssdk.services.connect.model.UpdateUserHierarchyStructureRequest;
import software.amazon.awssdk.services.connect.model.UpdateUserHierarchyStructureResponse;
import software.amazon.awssdk.services.connect.model.UpdateUserIdentityInfoRequest;
import software.amazon.awssdk.services.connect.model.UpdateUserIdentityInfoResponse;
import software.amazon.awssdk.services.connect.model.UpdateUserPhoneConfigRequest;
import software.amazon.awssdk.services.connect.model.UpdateUserPhoneConfigResponse;
import software.amazon.awssdk.services.connect.model.UpdateUserProficienciesRequest;
import software.amazon.awssdk.services.connect.model.UpdateUserProficienciesResponse;
import software.amazon.awssdk.services.connect.model.UpdateUserRoutingProfileRequest;
import software.amazon.awssdk.services.connect.model.UpdateUserRoutingProfileResponse;
import software.amazon.awssdk.services.connect.model.UpdateUserSecurityProfilesRequest;
import software.amazon.awssdk.services.connect.model.UpdateUserSecurityProfilesResponse;
import software.amazon.awssdk.services.connect.model.UpdateViewContentRequest;
import software.amazon.awssdk.services.connect.model.UpdateViewContentResponse;
import software.amazon.awssdk.services.connect.model.UpdateViewMetadataRequest;
import software.amazon.awssdk.services.connect.model.UpdateViewMetadataResponse;
import software.amazon.awssdk.services.connect.model.UserNotFoundException;
import software.amazon.awssdk.services.connect.paginators.GetCurrentMetricDataIterable;
import software.amazon.awssdk.services.connect.paginators.GetCurrentUserDataIterable;
import software.amazon.awssdk.services.connect.paginators.GetMetricDataIterable;
import software.amazon.awssdk.services.connect.paginators.GetMetricDataV2Iterable;
import software.amazon.awssdk.services.connect.paginators.ListAgentStatusesIterable;
import software.amazon.awssdk.services.connect.paginators.ListApprovedOriginsIterable;
import software.amazon.awssdk.services.connect.paginators.ListBotsIterable;
import software.amazon.awssdk.services.connect.paginators.ListContactEvaluationsIterable;
import software.amazon.awssdk.services.connect.paginators.ListContactFlowModulesIterable;
import software.amazon.awssdk.services.connect.paginators.ListContactFlowsIterable;
import software.amazon.awssdk.services.connect.paginators.ListContactReferencesIterable;
import software.amazon.awssdk.services.connect.paginators.ListDefaultVocabulariesIterable;
import software.amazon.awssdk.services.connect.paginators.ListEvaluationFormVersionsIterable;
import software.amazon.awssdk.services.connect.paginators.ListEvaluationFormsIterable;
import software.amazon.awssdk.services.connect.paginators.ListFlowAssociationsIterable;
import software.amazon.awssdk.services.connect.paginators.ListHoursOfOperationsIterable;
import software.amazon.awssdk.services.connect.paginators.ListInstanceAttributesIterable;
import software.amazon.awssdk.services.connect.paginators.ListInstanceStorageConfigsIterable;
import software.amazon.awssdk.services.connect.paginators.ListInstancesIterable;
import software.amazon.awssdk.services.connect.paginators.ListIntegrationAssociationsIterable;
import software.amazon.awssdk.services.connect.paginators.ListLambdaFunctionsIterable;
import software.amazon.awssdk.services.connect.paginators.ListLexBotsIterable;
import software.amazon.awssdk.services.connect.paginators.ListPhoneNumbersIterable;
import software.amazon.awssdk.services.connect.paginators.ListPhoneNumbersV2Iterable;
import software.amazon.awssdk.services.connect.paginators.ListPredefinedAttributesIterable;
import software.amazon.awssdk.services.connect.paginators.ListPromptsIterable;
import software.amazon.awssdk.services.connect.paginators.ListQueueQuickConnectsIterable;
import software.amazon.awssdk.services.connect.paginators.ListQueuesIterable;
import software.amazon.awssdk.services.connect.paginators.ListQuickConnectsIterable;
import software.amazon.awssdk.services.connect.paginators.ListRealtimeContactAnalysisSegmentsV2Iterable;
import software.amazon.awssdk.services.connect.paginators.ListRoutingProfileQueuesIterable;
import software.amazon.awssdk.services.connect.paginators.ListRoutingProfilesIterable;
import software.amazon.awssdk.services.connect.paginators.ListRulesIterable;
import software.amazon.awssdk.services.connect.paginators.ListSecurityKeysIterable;
import software.amazon.awssdk.services.connect.paginators.ListSecurityProfileApplicationsIterable;
import software.amazon.awssdk.services.connect.paginators.ListSecurityProfilePermissionsIterable;
import software.amazon.awssdk.services.connect.paginators.ListSecurityProfilesIterable;
import software.amazon.awssdk.services.connect.paginators.ListTaskTemplatesIterable;
import software.amazon.awssdk.services.connect.paginators.ListTrafficDistributionGroupUsersIterable;
import software.amazon.awssdk.services.connect.paginators.ListTrafficDistributionGroupsIterable;
import software.amazon.awssdk.services.connect.paginators.ListUseCasesIterable;
import software.amazon.awssdk.services.connect.paginators.ListUserHierarchyGroupsIterable;
import software.amazon.awssdk.services.connect.paginators.ListUserProficienciesIterable;
import software.amazon.awssdk.services.connect.paginators.ListUsersIterable;
import software.amazon.awssdk.services.connect.paginators.ListViewVersionsIterable;
import software.amazon.awssdk.services.connect.paginators.ListViewsIterable;
import software.amazon.awssdk.services.connect.paginators.SearchAvailablePhoneNumbersIterable;
import software.amazon.awssdk.services.connect.paginators.SearchContactFlowModulesIterable;
import software.amazon.awssdk.services.connect.paginators.SearchContactFlowsIterable;
import software.amazon.awssdk.services.connect.paginators.SearchContactsIterable;
import software.amazon.awssdk.services.connect.paginators.SearchHoursOfOperationsIterable;
import software.amazon.awssdk.services.connect.paginators.SearchPredefinedAttributesIterable;
import software.amazon.awssdk.services.connect.paginators.SearchPromptsIterable;
import software.amazon.awssdk.services.connect.paginators.SearchQueuesIterable;
import software.amazon.awssdk.services.connect.paginators.SearchQuickConnectsIterable;
import software.amazon.awssdk.services.connect.paginators.SearchResourceTagsIterable;
import software.amazon.awssdk.services.connect.paginators.SearchRoutingProfilesIterable;
import software.amazon.awssdk.services.connect.paginators.SearchSecurityProfilesIterable;
import software.amazon.awssdk.services.connect.paginators.SearchUsersIterable;
import software.amazon.awssdk.services.connect.paginators.SearchVocabulariesIterable;

/**
 * Service client for accessing Amazon Connect. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon Connect is a cloud-based contact center solution that you use to set up and manage a customer contact center
 * and provide reliable customer engagement at any scale.
 * </p>
 * <p>
 * Amazon Connect provides metrics and real-time reporting that enable you to optimize contact routing. You can also
 * resolve customer issues more efficiently by getting customers in touch with the appropriate agents.
 * </p>
 * <p>
 * There are limits to the number of Amazon Connect resources that you can create. There are also limits to the number
 * of requests that you can make per second. For more information, see <a
 * href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html">Amazon Connect
 * Service Quotas</a> in the <i>Amazon Connect Administrator Guide</i>.
 * </p>
 * <p>
 * You can connect programmatically to an Amazon Web Services service by using an endpoint. For a list of Amazon Connect
 * endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/connect_region.html">Amazon Connect
 * Endpoints</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ConnectClient extends AwsClient {
    String SERVICE_NAME = "connect";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "connect";

    /**
     * <p>
     * Activates an evaluation form in the specified Amazon Connect instance. After the evaluation form is activated, it
     * is available to start new evaluations based on the form.
     * </p>
     *
     * @param activateEvaluationFormRequest
     * @return Result of the ActivateEvaluationForm operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ActivateEvaluationForm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ActivateEvaluationForm"
     *      target="_top">AWS API Documentation</a>
     */
    default ActivateEvaluationFormResponse activateEvaluationForm(ActivateEvaluationFormRequest activateEvaluationFormRequest)
            throws InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            ResourceConflictException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Activates an evaluation form in the specified Amazon Connect instance. After the evaluation form is activated, it
     * is available to start new evaluations based on the form.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ActivateEvaluationFormRequest.Builder} avoiding the
     * need to create one manually via {@link ActivateEvaluationFormRequest#builder()}
     * </p>
     *
     * @param activateEvaluationFormRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ActivateEvaluationFormRequest.Builder} to create a
     *        request.
     * @return Result of the ActivateEvaluationForm operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ActivateEvaluationForm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ActivateEvaluationForm"
     *      target="_top">AWS API Documentation</a>
     */
    default ActivateEvaluationFormResponse activateEvaluationForm(
            Consumer<ActivateEvaluationFormRequest.Builder> activateEvaluationFormRequest) throws InvalidParameterException,
            ResourceNotFoundException, ThrottlingException, InternalServiceException, ResourceConflictException,
            AwsServiceException, SdkClientException, ConnectException {
        return activateEvaluationForm(ActivateEvaluationFormRequest.builder().applyMutation(activateEvaluationFormRequest)
                .build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Associates the specified dataset for a Amazon Connect instance with the target account. You can associate only
     * one dataset in a single call.
     * </p>
     *
     * @param associateAnalyticsDataSetRequest
     * @return Result of the AssociateAnalyticsDataSet operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateAnalyticsDataSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateAnalyticsDataSet"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateAnalyticsDataSetResponse associateAnalyticsDataSet(
            AssociateAnalyticsDataSetRequest associateAnalyticsDataSetRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Associates the specified dataset for a Amazon Connect instance with the target account. You can associate only
     * one dataset in a single call.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateAnalyticsDataSetRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateAnalyticsDataSetRequest#builder()}
     * </p>
     *
     * @param associateAnalyticsDataSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.AssociateAnalyticsDataSetRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateAnalyticsDataSet operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateAnalyticsDataSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateAnalyticsDataSet"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateAnalyticsDataSetResponse associateAnalyticsDataSet(
            Consumer<AssociateAnalyticsDataSetRequest.Builder> associateAnalyticsDataSetRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return associateAnalyticsDataSet(AssociateAnalyticsDataSetRequest.builder()
                .applyMutation(associateAnalyticsDataSetRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Associates an approved origin to an Amazon Connect instance.
     * </p>
     *
     * @param associateApprovedOriginRequest
     * @return Result of the AssociateApprovedOrigin operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateApprovedOrigin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateApprovedOrigin"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateApprovedOriginResponse associateApprovedOrigin(AssociateApprovedOriginRequest associateApprovedOriginRequest)
            throws ResourceNotFoundException, ResourceConflictException, InternalServiceException, InvalidRequestException,
            InvalidParameterException, ServiceQuotaExceededException, ThrottlingException, AwsServiceException,
            SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Associates an approved origin to an Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateApprovedOriginRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateApprovedOriginRequest#builder()}
     * </p>
     *
     * @param associateApprovedOriginRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.AssociateApprovedOriginRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateApprovedOrigin operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateApprovedOrigin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateApprovedOrigin"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateApprovedOriginResponse associateApprovedOrigin(
            Consumer<AssociateApprovedOriginRequest.Builder> associateApprovedOriginRequest) throws ResourceNotFoundException,
            ResourceConflictException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return associateApprovedOrigin(AssociateApprovedOriginRequest.builder().applyMutation(associateApprovedOriginRequest)
                .build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Allows the specified Amazon Connect instance to access the specified Amazon Lex or Amazon Lex V2 bot.
     * </p>
     *
     * @param associateBotRequest
     * @return Result of the AssociateBot operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateBot" target="_top">AWS API
     *      Documentation</a>
     */
    default AssociateBotResponse associateBot(AssociateBotRequest associateBotRequest) throws ResourceNotFoundException,
            ResourceConflictException, InternalServiceException, InvalidRequestException, LimitExceededException,
            ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Allows the specified Amazon Connect instance to access the specified Amazon Lex or Amazon Lex V2 bot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateBotRequest.Builder} avoiding the need to
     * create one manually via {@link AssociateBotRequest#builder()}
     * </p>
     *
     * @param associateBotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.AssociateBotRequest.Builder} to create a request.
     * @return Result of the AssociateBot operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateBot" target="_top">AWS API
     *      Documentation</a>
     */
    default AssociateBotResponse associateBot(Consumer<AssociateBotRequest.Builder> associateBotRequest)
            throws ResourceNotFoundException, ResourceConflictException, InternalServiceException, InvalidRequestException,
            LimitExceededException, ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException,
            ConnectException {
        return associateBot(AssociateBotRequest.builder().applyMutation(associateBotRequest).build());
    }

    /**
     * <p>
     * Associates an existing vocabulary as the default. Contact Lens for Amazon Connect uses the vocabulary in
     * post-call and real-time analysis sessions for the given language.
     * </p>
     *
     * @param associateDefaultVocabularyRequest
     * @return Result of the AssociateDefaultVocabulary operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateDefaultVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateDefaultVocabulary"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateDefaultVocabularyResponse associateDefaultVocabulary(
            AssociateDefaultVocabularyRequest associateDefaultVocabularyRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalServiceException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates an existing vocabulary as the default. Contact Lens for Amazon Connect uses the vocabulary in
     * post-call and real-time analysis sessions for the given language.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateDefaultVocabularyRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateDefaultVocabularyRequest#builder()}
     * </p>
     *
     * @param associateDefaultVocabularyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.AssociateDefaultVocabularyRequest.Builder} to create
     *        a request.
     * @return Result of the AssociateDefaultVocabulary operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateDefaultVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateDefaultVocabulary"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateDefaultVocabularyResponse associateDefaultVocabulary(
            Consumer<AssociateDefaultVocabularyRequest.Builder> associateDefaultVocabularyRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalServiceException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, ConnectException {
        return associateDefaultVocabulary(AssociateDefaultVocabularyRequest.builder()
                .applyMutation(associateDefaultVocabularyRequest).build());
    }

    /**
     * <p>
     * Associates a connect resource to a flow.
     * </p>
     *
     * @param associateFlowRequest
     * @return Result of the AssociateFlow operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default AssociateFlowResponse associateFlow(AssociateFlowRequest associateFlowRequest) throws AccessDeniedException,
            ResourceNotFoundException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a connect resource to a flow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateFlowRequest.Builder} avoiding the need to
     * create one manually via {@link AssociateFlowRequest#builder()}
     * </p>
     *
     * @param associateFlowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.AssociateFlowRequest.Builder} to create a request.
     * @return Result of the AssociateFlow operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default AssociateFlowResponse associateFlow(Consumer<AssociateFlowRequest.Builder> associateFlowRequest)
            throws AccessDeniedException, ResourceNotFoundException, InternalServiceException, InvalidRequestException,
            InvalidParameterException, ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return associateFlow(AssociateFlowRequest.builder().applyMutation(associateFlowRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Associates a storage resource type for the first time. You can only associate one type of storage configuration
     * in a single call. This means, for example, that you can't define an instance with multiple S3 buckets for storing
     * chat transcripts.
     * </p>
     * <p>
     * This API does not create a resource that doesn't exist. It only associates it to the instance. Ensure that the
     * resource being specified in the storage configuration, like an S3 bucket, exists when being used for association.
     * </p>
     *
     * @param associateInstanceStorageConfigRequest
     * @return Result of the AssociateInstanceStorageConfig operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateInstanceStorageConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateInstanceStorageConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateInstanceStorageConfigResponse associateInstanceStorageConfig(
            AssociateInstanceStorageConfigRequest associateInstanceStorageConfigRequest) throws ResourceNotFoundException,
            ResourceConflictException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Associates a storage resource type for the first time. You can only associate one type of storage configuration
     * in a single call. This means, for example, that you can't define an instance with multiple S3 buckets for storing
     * chat transcripts.
     * </p>
     * <p>
     * This API does not create a resource that doesn't exist. It only associates it to the instance. Ensure that the
     * resource being specified in the storage configuration, like an S3 bucket, exists when being used for association.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateInstanceStorageConfigRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateInstanceStorageConfigRequest#builder()}
     * </p>
     *
     * @param associateInstanceStorageConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.AssociateInstanceStorageConfigRequest.Builder} to
     *        create a request.
     * @return Result of the AssociateInstanceStorageConfig operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateInstanceStorageConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateInstanceStorageConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateInstanceStorageConfigResponse associateInstanceStorageConfig(
            Consumer<AssociateInstanceStorageConfigRequest.Builder> associateInstanceStorageConfigRequest)
            throws ResourceNotFoundException, ResourceConflictException, InternalServiceException, InvalidRequestException,
            InvalidParameterException, ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return associateInstanceStorageConfig(AssociateInstanceStorageConfigRequest.builder()
                .applyMutation(associateInstanceStorageConfigRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Allows the specified Amazon Connect instance to access the specified Lambda function.
     * </p>
     *
     * @param associateLambdaFunctionRequest
     * @return Result of the AssociateLambdaFunction operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateLambdaFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateLambdaFunction"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateLambdaFunctionResponse associateLambdaFunction(AssociateLambdaFunctionRequest associateLambdaFunctionRequest)
            throws ResourceNotFoundException, ResourceConflictException, InternalServiceException, InvalidRequestException,
            InvalidParameterException, ServiceQuotaExceededException, ThrottlingException, AwsServiceException,
            SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Allows the specified Amazon Connect instance to access the specified Lambda function.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateLambdaFunctionRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateLambdaFunctionRequest#builder()}
     * </p>
     *
     * @param associateLambdaFunctionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.AssociateLambdaFunctionRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateLambdaFunction operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateLambdaFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateLambdaFunction"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateLambdaFunctionResponse associateLambdaFunction(
            Consumer<AssociateLambdaFunctionRequest.Builder> associateLambdaFunctionRequest) throws ResourceNotFoundException,
            ResourceConflictException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return associateLambdaFunction(AssociateLambdaFunctionRequest.builder().applyMutation(associateLambdaFunctionRequest)
                .build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Allows the specified Amazon Connect instance to access the specified Amazon Lex V1 bot. This API only supports
     * the association of Amazon Lex V1 bots.
     * </p>
     *
     * @param associateLexBotRequest
     * @return Result of the AssociateLexBot operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateLexBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateLexBot" target="_top">AWS API
     *      Documentation</a>
     */
    default AssociateLexBotResponse associateLexBot(AssociateLexBotRequest associateLexBotRequest)
            throws ResourceNotFoundException, ResourceConflictException, InternalServiceException, InvalidRequestException,
            InvalidParameterException, ServiceQuotaExceededException, ThrottlingException, AwsServiceException,
            SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Allows the specified Amazon Connect instance to access the specified Amazon Lex V1 bot. This API only supports
     * the association of Amazon Lex V1 bots.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateLexBotRequest.Builder} avoiding the need
     * to create one manually via {@link AssociateLexBotRequest#builder()}
     * </p>
     *
     * @param associateLexBotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.AssociateLexBotRequest.Builder} to create a request.
     * @return Result of the AssociateLexBot operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateLexBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateLexBot" target="_top">AWS API
     *      Documentation</a>
     */
    default AssociateLexBotResponse associateLexBot(Consumer<AssociateLexBotRequest.Builder> associateLexBotRequest)
            throws ResourceNotFoundException, ResourceConflictException, InternalServiceException, InvalidRequestException,
            InvalidParameterException, ServiceQuotaExceededException, ThrottlingException, AwsServiceException,
            SdkClientException, ConnectException {
        return associateLexBot(AssociateLexBotRequest.builder().applyMutation(associateLexBotRequest).build());
    }

    /**
     * <p>
     * Associates a flow with a phone number claimed to your Amazon Connect instance.
     * </p>
     * <important>
     * <p>
     * If the number is claimed to a traffic distribution group, and you are calling this API using an instance in the
     * Amazon Web Services Region where the traffic distribution group was created, you can use either a full phone
     * number ARN or UUID value for the <code>PhoneNumberId</code> URI request parameter. However, if the number is
     * claimed to a traffic distribution group and you are calling this API using an instance in the alternate Amazon
     * Web Services Region associated with the traffic distribution group, you must provide a full phone number ARN. If
     * a UUID is provided in this scenario, you will receive a <code>ResourceNotFoundException</code>.
     * </p>
     * </important>
     *
     * @param associatePhoneNumberContactFlowRequest
     * @return Result of the AssociatePhoneNumberContactFlow operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociatePhoneNumberContactFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociatePhoneNumberContactFlow"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociatePhoneNumberContactFlowResponse associatePhoneNumberContactFlow(
            AssociatePhoneNumberContactFlowRequest associatePhoneNumberContactFlowRequest) throws InvalidParameterException,
            ResourceNotFoundException, ThrottlingException, InternalServiceException, AccessDeniedException, AwsServiceException,
            SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a flow with a phone number claimed to your Amazon Connect instance.
     * </p>
     * <important>
     * <p>
     * If the number is claimed to a traffic distribution group, and you are calling this API using an instance in the
     * Amazon Web Services Region where the traffic distribution group was created, you can use either a full phone
     * number ARN or UUID value for the <code>PhoneNumberId</code> URI request parameter. However, if the number is
     * claimed to a traffic distribution group and you are calling this API using an instance in the alternate Amazon
     * Web Services Region associated with the traffic distribution group, you must provide a full phone number ARN. If
     * a UUID is provided in this scenario, you will receive a <code>ResourceNotFoundException</code>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociatePhoneNumberContactFlowRequest.Builder}
     * avoiding the need to create one manually via {@link AssociatePhoneNumberContactFlowRequest#builder()}
     * </p>
     *
     * @param associatePhoneNumberContactFlowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.AssociatePhoneNumberContactFlowRequest.Builder} to
     *        create a request.
     * @return Result of the AssociatePhoneNumberContactFlow operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociatePhoneNumberContactFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociatePhoneNumberContactFlow"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociatePhoneNumberContactFlowResponse associatePhoneNumberContactFlow(
            Consumer<AssociatePhoneNumberContactFlowRequest.Builder> associatePhoneNumberContactFlowRequest)
            throws InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AccessDeniedException, AwsServiceException, SdkClientException, ConnectException {
        return associatePhoneNumberContactFlow(AssociatePhoneNumberContactFlowRequest.builder()
                .applyMutation(associatePhoneNumberContactFlowRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Associates a set of quick connects with a queue.
     * </p>
     *
     * @param associateQueueQuickConnectsRequest
     * @return Result of the AssociateQueueQuickConnects operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateQueueQuickConnects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateQueueQuickConnects"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateQueueQuickConnectsResponse associateQueueQuickConnects(
            AssociateQueueQuickConnectsRequest associateQueueQuickConnectsRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, LimitExceededException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Associates a set of quick connects with a queue.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateQueueQuickConnectsRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateQueueQuickConnectsRequest#builder()}
     * </p>
     *
     * @param associateQueueQuickConnectsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.AssociateQueueQuickConnectsRequest.Builder} to create
     *        a request.
     * @return Result of the AssociateQueueQuickConnects operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateQueueQuickConnects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateQueueQuickConnects"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateQueueQuickConnectsResponse associateQueueQuickConnects(
            Consumer<AssociateQueueQuickConnectsRequest.Builder> associateQueueQuickConnectsRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, LimitExceededException,
            ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return associateQueueQuickConnects(AssociateQueueQuickConnectsRequest.builder()
                .applyMutation(associateQueueQuickConnectsRequest).build());
    }

    /**
     * <p>
     * Associates a set of queues with a routing profile.
     * </p>
     *
     * @param associateRoutingProfileQueuesRequest
     * @return Result of the AssociateRoutingProfileQueues operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateRoutingProfileQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateRoutingProfileQueues"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateRoutingProfileQueuesResponse associateRoutingProfileQueues(
            AssociateRoutingProfileQueuesRequest associateRoutingProfileQueuesRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a set of queues with a routing profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateRoutingProfileQueuesRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateRoutingProfileQueuesRequest#builder()}
     * </p>
     *
     * @param associateRoutingProfileQueuesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.AssociateRoutingProfileQueuesRequest.Builder} to
     *        create a request.
     * @return Result of the AssociateRoutingProfileQueues operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateRoutingProfileQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateRoutingProfileQueues"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateRoutingProfileQueuesResponse associateRoutingProfileQueues(
            Consumer<AssociateRoutingProfileQueuesRequest.Builder> associateRoutingProfileQueuesRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return associateRoutingProfileQueues(AssociateRoutingProfileQueuesRequest.builder()
                .applyMutation(associateRoutingProfileQueuesRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Associates a security key to the instance.
     * </p>
     *
     * @param associateSecurityKeyRequest
     * @return Result of the AssociateSecurityKey operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateSecurityKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateSecurityKey" target="_top">AWS
     *      API Documentation</a>
     */
    default AssociateSecurityKeyResponse associateSecurityKey(AssociateSecurityKeyRequest associateSecurityKeyRequest)
            throws ResourceNotFoundException, ResourceConflictException, InternalServiceException, InvalidRequestException,
            InvalidParameterException, ServiceQuotaExceededException, ThrottlingException, AwsServiceException,
            SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Associates a security key to the instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateSecurityKeyRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateSecurityKeyRequest#builder()}
     * </p>
     *
     * @param associateSecurityKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.AssociateSecurityKeyRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateSecurityKey operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateSecurityKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateSecurityKey" target="_top">AWS
     *      API Documentation</a>
     */
    default AssociateSecurityKeyResponse associateSecurityKey(
            Consumer<AssociateSecurityKeyRequest.Builder> associateSecurityKeyRequest) throws ResourceNotFoundException,
            ResourceConflictException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return associateSecurityKey(AssociateSecurityKeyRequest.builder().applyMutation(associateSecurityKeyRequest).build());
    }

    /**
     * <p>
     * Associates an agent with a traffic distribution group.
     * </p>
     *
     * @param associateTrafficDistributionGroupUserRequest
     * @return Result of the AssociateTrafficDistributionGroupUser operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateTrafficDistributionGroupUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateTrafficDistributionGroupUser"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateTrafficDistributionGroupUserResponse associateTrafficDistributionGroupUser(
            AssociateTrafficDistributionGroupUserRequest associateTrafficDistributionGroupUserRequest)
            throws InvalidRequestException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            ResourceConflictException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates an agent with a traffic distribution group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AssociateTrafficDistributionGroupUserRequest.Builder} avoiding the need to create one manually via
     * {@link AssociateTrafficDistributionGroupUserRequest#builder()}
     * </p>
     *
     * @param associateTrafficDistributionGroupUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.AssociateTrafficDistributionGroupUserRequest.Builder}
     *        to create a request.
     * @return Result of the AssociateTrafficDistributionGroupUser operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateTrafficDistributionGroupUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateTrafficDistributionGroupUser"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateTrafficDistributionGroupUserResponse associateTrafficDistributionGroupUser(
            Consumer<AssociateTrafficDistributionGroupUserRequest.Builder> associateTrafficDistributionGroupUserRequest)
            throws InvalidRequestException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            ResourceConflictException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return associateTrafficDistributionGroupUser(AssociateTrafficDistributionGroupUserRequest.builder()
                .applyMutation(associateTrafficDistributionGroupUserRequest).build());
    }

    /**
     * <p>
     * &gt;Associates a set of proficiencies with a user.
     * </p>
     *
     * @param associateUserProficienciesRequest
     * @return Result of the AssociateUserProficiencies operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateUserProficiencies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateUserProficiencies"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateUserProficienciesResponse associateUserProficiencies(
            AssociateUserProficienciesRequest associateUserProficienciesRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * &gt;Associates a set of proficiencies with a user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateUserProficienciesRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateUserProficienciesRequest#builder()}
     * </p>
     *
     * @param associateUserProficienciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.AssociateUserProficienciesRequest.Builder} to create
     *        a request.
     * @return Result of the AssociateUserProficiencies operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateUserProficiencies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateUserProficiencies"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateUserProficienciesResponse associateUserProficiencies(
            Consumer<AssociateUserProficienciesRequest.Builder> associateUserProficienciesRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return associateUserProficiencies(AssociateUserProficienciesRequest.builder()
                .applyMutation(associateUserProficienciesRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Associates a list of analytics datasets for a given Amazon Connect instance to a target account. You can
     * associate multiple datasets in a single call.
     * </p>
     *
     * @param batchAssociateAnalyticsDataSetRequest
     * @return Result of the BatchAssociateAnalyticsDataSet operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.BatchAssociateAnalyticsDataSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/BatchAssociateAnalyticsDataSet"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchAssociateAnalyticsDataSetResponse batchAssociateAnalyticsDataSet(
            BatchAssociateAnalyticsDataSetRequest batchAssociateAnalyticsDataSetRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Associates a list of analytics datasets for a given Amazon Connect instance to a target account. You can
     * associate multiple datasets in a single call.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchAssociateAnalyticsDataSetRequest.Builder}
     * avoiding the need to create one manually via {@link BatchAssociateAnalyticsDataSetRequest#builder()}
     * </p>
     *
     * @param batchAssociateAnalyticsDataSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.BatchAssociateAnalyticsDataSetRequest.Builder} to
     *        create a request.
     * @return Result of the BatchAssociateAnalyticsDataSet operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.BatchAssociateAnalyticsDataSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/BatchAssociateAnalyticsDataSet"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchAssociateAnalyticsDataSetResponse batchAssociateAnalyticsDataSet(
            Consumer<BatchAssociateAnalyticsDataSetRequest.Builder> batchAssociateAnalyticsDataSetRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return batchAssociateAnalyticsDataSet(BatchAssociateAnalyticsDataSetRequest.builder()
                .applyMutation(batchAssociateAnalyticsDataSetRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Removes a list of analytics datasets associated with a given Amazon Connect instance. You can disassociate
     * multiple datasets in a single call.
     * </p>
     *
     * @param batchDisassociateAnalyticsDataSetRequest
     * @return Result of the BatchDisassociateAnalyticsDataSet operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.BatchDisassociateAnalyticsDataSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/BatchDisassociateAnalyticsDataSet"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDisassociateAnalyticsDataSetResponse batchDisassociateAnalyticsDataSet(
            BatchDisassociateAnalyticsDataSetRequest batchDisassociateAnalyticsDataSetRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Removes a list of analytics datasets associated with a given Amazon Connect instance. You can disassociate
     * multiple datasets in a single call.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDisassociateAnalyticsDataSetRequest.Builder}
     * avoiding the need to create one manually via {@link BatchDisassociateAnalyticsDataSetRequest#builder()}
     * </p>
     *
     * @param batchDisassociateAnalyticsDataSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.BatchDisassociateAnalyticsDataSetRequest.Builder} to
     *        create a request.
     * @return Result of the BatchDisassociateAnalyticsDataSet operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.BatchDisassociateAnalyticsDataSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/BatchDisassociateAnalyticsDataSet"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDisassociateAnalyticsDataSetResponse batchDisassociateAnalyticsDataSet(
            Consumer<BatchDisassociateAnalyticsDataSetRequest.Builder> batchDisassociateAnalyticsDataSetRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return batchDisassociateAnalyticsDataSet(BatchDisassociateAnalyticsDataSetRequest.builder()
                .applyMutation(batchDisassociateAnalyticsDataSetRequest).build());
    }

    /**
     * <p>
     * Allows you to retrieve metadata about multiple attached files on an associated resource. Each attached file
     * provided in the input list must be associated with the input AssociatedResourceArn.
     * </p>
     *
     * @param batchGetAttachedFileMetadataRequest
     * @return Result of the BatchGetAttachedFileMetadata operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.BatchGetAttachedFileMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/BatchGetAttachedFileMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetAttachedFileMetadataResponse batchGetAttachedFileMetadata(
            BatchGetAttachedFileMetadataRequest batchGetAttachedFileMetadataRequest) throws AccessDeniedException,
            InvalidRequestException, InternalServiceException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows you to retrieve metadata about multiple attached files on an associated resource. Each attached file
     * provided in the input list must be associated with the input AssociatedResourceArn.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetAttachedFileMetadataRequest.Builder}
     * avoiding the need to create one manually via {@link BatchGetAttachedFileMetadataRequest#builder()}
     * </p>
     *
     * @param batchGetAttachedFileMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.BatchGetAttachedFileMetadataRequest.Builder} to
     *        create a request.
     * @return Result of the BatchGetAttachedFileMetadata operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.BatchGetAttachedFileMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/BatchGetAttachedFileMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetAttachedFileMetadataResponse batchGetAttachedFileMetadata(
            Consumer<BatchGetAttachedFileMetadataRequest.Builder> batchGetAttachedFileMetadataRequest)
            throws AccessDeniedException, InvalidRequestException, InternalServiceException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return batchGetAttachedFileMetadata(BatchGetAttachedFileMetadataRequest.builder()
                .applyMutation(batchGetAttachedFileMetadataRequest).build());
    }

    /**
     * <p>
     * Retrieve the flow associations for the given resources.
     * </p>
     *
     * @param batchGetFlowAssociationRequest
     * @return Result of the BatchGetFlowAssociation operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.BatchGetFlowAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/BatchGetFlowAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetFlowAssociationResponse batchGetFlowAssociation(BatchGetFlowAssociationRequest batchGetFlowAssociationRequest)
            throws AccessDeniedException, ResourceNotFoundException, InternalServiceException, InvalidRequestException,
            InvalidParameterException, ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve the flow associations for the given resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetFlowAssociationRequest.Builder} avoiding
     * the need to create one manually via {@link BatchGetFlowAssociationRequest#builder()}
     * </p>
     *
     * @param batchGetFlowAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.BatchGetFlowAssociationRequest.Builder} to create a
     *        request.
     * @return Result of the BatchGetFlowAssociation operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.BatchGetFlowAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/BatchGetFlowAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetFlowAssociationResponse batchGetFlowAssociation(
            Consumer<BatchGetFlowAssociationRequest.Builder> batchGetFlowAssociationRequest) throws AccessDeniedException,
            ResourceNotFoundException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return batchGetFlowAssociation(BatchGetFlowAssociationRequest.builder().applyMutation(batchGetFlowAssociationRequest)
                .build());
    }

    /**
     * <note>
     * <p>
     * Only the Amazon Connect outbound campaigns service principal is allowed to assume a role in your account and call
     * this API.
     * </p>
     * </note>
     * <p>
     * Allows you to create a batch of contacts in Amazon Connect. The outbound campaigns capability ingests dial
     * requests via the <a
     * href="https://docs.aws.amazon.com/connect-outbound/latest/APIReference/API_PutDialRequestBatch.html"
     * >PutDialRequestBatch</a> API. It then uses BatchPutContact to create contacts corresponding to those dial
     * requests. If agents are available, the dial requests are dialed out, which results in a voice call. The resulting
     * voice call uses the same contactId that was created by BatchPutContact.
     * </p>
     *
     * @param batchPutContactRequest
     * @return Result of the BatchPutContact operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws IdempotencyException
     *         An entity with the same name already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.BatchPutContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/BatchPutContact" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchPutContactResponse batchPutContact(BatchPutContactRequest batchPutContactRequest) throws AccessDeniedException,
            InternalServiceException, InvalidRequestException, ResourceNotFoundException, LimitExceededException,
            IdempotencyException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * Only the Amazon Connect outbound campaigns service principal is allowed to assume a role in your account and call
     * this API.
     * </p>
     * </note>
     * <p>
     * Allows you to create a batch of contacts in Amazon Connect. The outbound campaigns capability ingests dial
     * requests via the <a
     * href="https://docs.aws.amazon.com/connect-outbound/latest/APIReference/API_PutDialRequestBatch.html"
     * >PutDialRequestBatch</a> API. It then uses BatchPutContact to create contacts corresponding to those dial
     * requests. If agents are available, the dial requests are dialed out, which results in a voice call. The resulting
     * voice call uses the same contactId that was created by BatchPutContact.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchPutContactRequest.Builder} avoiding the need
     * to create one manually via {@link BatchPutContactRequest#builder()}
     * </p>
     *
     * @param batchPutContactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.BatchPutContactRequest.Builder} to create a request.
     * @return Result of the BatchPutContact operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws IdempotencyException
     *         An entity with the same name already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.BatchPutContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/BatchPutContact" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchPutContactResponse batchPutContact(Consumer<BatchPutContactRequest.Builder> batchPutContactRequest)
            throws AccessDeniedException, InternalServiceException, InvalidRequestException, ResourceNotFoundException,
            LimitExceededException, IdempotencyException, AwsServiceException, SdkClientException, ConnectException {
        return batchPutContact(BatchPutContactRequest.builder().applyMutation(batchPutContactRequest).build());
    }

    /**
     * <p>
     * Claims an available phone number to your Amazon Connect instance or traffic distribution group. You can call this
     * API only in the same Amazon Web Services Region where the Amazon Connect instance or traffic distribution group
     * was created.
     * </p>
     * <p>
     * For more information about how to use this operation, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/claim-phone-number.html">Claim a phone number in your
     * country</a> and <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/claim-phone-numbers-traffic-distribution-groups.html"
     * >Claim phone numbers to traffic distribution groups</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <important>
     * <p>
     * You can call the <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_SearchAvailablePhoneNumbers.html"
     * >SearchAvailablePhoneNumbers</a> API for available phone numbers that you can claim. Call the <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribePhoneNumber.html"
     * >DescribePhoneNumber</a> API to verify the status of a previous <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_ClaimPhoneNumber.html">ClaimPhoneNumber</a>
     * operation.
     * </p>
     * </important>
     * <p>
     * If you plan to claim and release numbers frequently, contact us for a service quota exception. Otherwise, it is
     * possible you will be blocked from claiming and releasing any more numbers until up to 180 days past the oldest
     * number released has expired.
     * </p>
     * <p>
     * By default you can claim and release up to 200% of your maximum number of active phone numbers. If you claim and
     * release phone numbers using the UI or API during a rolling 180 day cycle that exceeds 200% of your phone number
     * service level quota, you will be blocked from claiming any more numbers until 180 days past the oldest number
     * released has expired.
     * </p>
     * <p>
     * For example, if you already have 99 claimed numbers and a service level quota of 99 phone numbers, and in any 180
     * day period you release 99, claim 99, and then release 99, you will have exceeded the 200% limit. At that point
     * you are blocked from claiming any more numbers until you open an Amazon Web Services support ticket.
     * </p>
     *
     * @param claimPhoneNumberRequest
     * @return Result of the ClaimPhoneNumber operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws IdempotencyException
     *         An entity with the same name already exists.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ClaimPhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ClaimPhoneNumber" target="_top">AWS API
     *      Documentation</a>
     */
    default ClaimPhoneNumberResponse claimPhoneNumber(ClaimPhoneNumberRequest claimPhoneNumberRequest)
            throws InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            IdempotencyException, AccessDeniedException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Claims an available phone number to your Amazon Connect instance or traffic distribution group. You can call this
     * API only in the same Amazon Web Services Region where the Amazon Connect instance or traffic distribution group
     * was created.
     * </p>
     * <p>
     * For more information about how to use this operation, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/claim-phone-number.html">Claim a phone number in your
     * country</a> and <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/claim-phone-numbers-traffic-distribution-groups.html"
     * >Claim phone numbers to traffic distribution groups</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <important>
     * <p>
     * You can call the <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_SearchAvailablePhoneNumbers.html"
     * >SearchAvailablePhoneNumbers</a> API for available phone numbers that you can claim. Call the <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribePhoneNumber.html"
     * >DescribePhoneNumber</a> API to verify the status of a previous <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_ClaimPhoneNumber.html">ClaimPhoneNumber</a>
     * operation.
     * </p>
     * </important>
     * <p>
     * If you plan to claim and release numbers frequently, contact us for a service quota exception. Otherwise, it is
     * possible you will be blocked from claiming and releasing any more numbers until up to 180 days past the oldest
     * number released has expired.
     * </p>
     * <p>
     * By default you can claim and release up to 200% of your maximum number of active phone numbers. If you claim and
     * release phone numbers using the UI or API during a rolling 180 day cycle that exceeds 200% of your phone number
     * service level quota, you will be blocked from claiming any more numbers until 180 days past the oldest number
     * released has expired.
     * </p>
     * <p>
     * For example, if you already have 99 claimed numbers and a service level quota of 99 phone numbers, and in any 180
     * day period you release 99, claim 99, and then release 99, you will have exceeded the 200% limit. At that point
     * you are blocked from claiming any more numbers until you open an Amazon Web Services support ticket.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ClaimPhoneNumberRequest.Builder} avoiding the need
     * to create one manually via {@link ClaimPhoneNumberRequest#builder()}
     * </p>
     *
     * @param claimPhoneNumberRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ClaimPhoneNumberRequest.Builder} to create a request.
     * @return Result of the ClaimPhoneNumber operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws IdempotencyException
     *         An entity with the same name already exists.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ClaimPhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ClaimPhoneNumber" target="_top">AWS API
     *      Documentation</a>
     */
    default ClaimPhoneNumberResponse claimPhoneNumber(Consumer<ClaimPhoneNumberRequest.Builder> claimPhoneNumberRequest)
            throws InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            IdempotencyException, AccessDeniedException, AwsServiceException, SdkClientException, ConnectException {
        return claimPhoneNumber(ClaimPhoneNumberRequest.builder().applyMutation(claimPhoneNumberRequest).build());
    }

    /**
     * <p>
     * Allows you to confirm that the attached file has been uploaded using the pre-signed URL provided in the
     * StartAttachedFileUpload API.
     * </p>
     *
     * @param completeAttachedFileUploadRequest
     *        Request to CompleteAttachedFileUpload API
     * @return Result of the CompleteAttachedFileUpload operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CompleteAttachedFileUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CompleteAttachedFileUpload"
     *      target="_top">AWS API Documentation</a>
     */
    default CompleteAttachedFileUploadResponse completeAttachedFileUpload(
            CompleteAttachedFileUploadRequest completeAttachedFileUploadRequest) throws AccessDeniedException,
            InvalidRequestException, InternalServiceException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows you to confirm that the attached file has been uploaded using the pre-signed URL provided in the
     * StartAttachedFileUpload API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CompleteAttachedFileUploadRequest.Builder} avoiding
     * the need to create one manually via {@link CompleteAttachedFileUploadRequest#builder()}
     * </p>
     *
     * @param completeAttachedFileUploadRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CompleteAttachedFileUploadRequest.Builder} to create
     *        a request. Request to CompleteAttachedFileUpload API
     * @return Result of the CompleteAttachedFileUpload operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CompleteAttachedFileUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CompleteAttachedFileUpload"
     *      target="_top">AWS API Documentation</a>
     */
    default CompleteAttachedFileUploadResponse completeAttachedFileUpload(
            Consumer<CompleteAttachedFileUploadRequest.Builder> completeAttachedFileUploadRequest) throws AccessDeniedException,
            InvalidRequestException, InternalServiceException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        return completeAttachedFileUpload(CompleteAttachedFileUploadRequest.builder()
                .applyMutation(completeAttachedFileUploadRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Creates an agent status for the specified Amazon Connect instance.
     * </p>
     *
     * @param createAgentStatusRequest
     * @return Result of the CreateAgentStatus operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateAgentStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateAgentStatus" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAgentStatusResponse createAgentStatus(CreateAgentStatusRequest createAgentStatusRequest)
            throws InvalidRequestException, InvalidParameterException, DuplicateResourceException, ResourceNotFoundException,
            LimitExceededException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException,
            ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Creates an agent status for the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAgentStatusRequest.Builder} avoiding the need
     * to create one manually via {@link CreateAgentStatusRequest#builder()}
     * </p>
     *
     * @param createAgentStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreateAgentStatusRequest.Builder} to create a
     *        request.
     * @return Result of the CreateAgentStatus operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateAgentStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateAgentStatus" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAgentStatusResponse createAgentStatus(Consumer<CreateAgentStatusRequest.Builder> createAgentStatusRequest)
            throws InvalidRequestException, InvalidParameterException, DuplicateResourceException, ResourceNotFoundException,
            LimitExceededException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException,
            ConnectException {
        return createAgentStatus(CreateAgentStatusRequest.builder().applyMutation(createAgentStatusRequest).build());
    }

    /**
     * <p>
     * Creates a flow for the specified Amazon Connect instance.
     * </p>
     * <p>
     * You can also create and update flows using the <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/flow-language.html">Amazon Connect Flow
     * language</a>.
     * </p>
     *
     * @param createContactFlowRequest
     * @return Result of the CreateContactFlow operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidContactFlowException
     *         The flow is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateContactFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateContactFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateContactFlowResponse createContactFlow(CreateContactFlowRequest createContactFlowRequest)
            throws InvalidRequestException, InvalidContactFlowException, InvalidParameterException, DuplicateResourceException,
            LimitExceededException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a flow for the specified Amazon Connect instance.
     * </p>
     * <p>
     * You can also create and update flows using the <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/flow-language.html">Amazon Connect Flow
     * language</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateContactFlowRequest.Builder} avoiding the need
     * to create one manually via {@link CreateContactFlowRequest#builder()}
     * </p>
     *
     * @param createContactFlowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreateContactFlowRequest.Builder} to create a
     *        request.
     * @return Result of the CreateContactFlow operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidContactFlowException
     *         The flow is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateContactFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateContactFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateContactFlowResponse createContactFlow(Consumer<CreateContactFlowRequest.Builder> createContactFlowRequest)
            throws InvalidRequestException, InvalidContactFlowException, InvalidParameterException, DuplicateResourceException,
            LimitExceededException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return createContactFlow(CreateContactFlowRequest.builder().applyMutation(createContactFlowRequest).build());
    }

    /**
     * <p>
     * Creates a flow module for the specified Amazon Connect instance.
     * </p>
     *
     * @param createContactFlowModuleRequest
     * @return Result of the CreateContactFlowModule operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidContactFlowModuleException
     *         The problems with the module. Please fix before trying again.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws IdempotencyException
     *         An entity with the same name already exists.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateContactFlowModule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateContactFlowModule"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateContactFlowModuleResponse createContactFlowModule(CreateContactFlowModuleRequest createContactFlowModuleRequest)
            throws AccessDeniedException, InvalidRequestException, InvalidContactFlowModuleException, InvalidParameterException,
            DuplicateResourceException, LimitExceededException, ResourceNotFoundException, ThrottlingException,
            IdempotencyException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a flow module for the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateContactFlowModuleRequest.Builder} avoiding
     * the need to create one manually via {@link CreateContactFlowModuleRequest#builder()}
     * </p>
     *
     * @param createContactFlowModuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreateContactFlowModuleRequest.Builder} to create a
     *        request.
     * @return Result of the CreateContactFlowModule operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidContactFlowModuleException
     *         The problems with the module. Please fix before trying again.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws IdempotencyException
     *         An entity with the same name already exists.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateContactFlowModule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateContactFlowModule"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateContactFlowModuleResponse createContactFlowModule(
            Consumer<CreateContactFlowModuleRequest.Builder> createContactFlowModuleRequest) throws AccessDeniedException,
            InvalidRequestException, InvalidContactFlowModuleException, InvalidParameterException, DuplicateResourceException,
            LimitExceededException, ResourceNotFoundException, ThrottlingException, IdempotencyException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return createContactFlowModule(CreateContactFlowModuleRequest.builder().applyMutation(createContactFlowModuleRequest)
                .build());
    }

    /**
     * <p>
     * Creates an evaluation form in the specified Amazon Connect instance. The form can be used to define questions
     * related to agent performance, and create sections to organize such questions. Question and section identifiers
     * cannot be duplicated within the same evaluation form.
     * </p>
     *
     * @param createEvaluationFormRequest
     * @return Result of the CreateEvaluationForm operation returned by the service.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateEvaluationForm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateEvaluationForm" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateEvaluationFormResponse createEvaluationForm(CreateEvaluationFormRequest createEvaluationFormRequest)
            throws InternalServiceException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            ServiceQuotaExceededException, ResourceConflictException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an evaluation form in the specified Amazon Connect instance. The form can be used to define questions
     * related to agent performance, and create sections to organize such questions. Question and section identifiers
     * cannot be duplicated within the same evaluation form.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEvaluationFormRequest.Builder} avoiding the
     * need to create one manually via {@link CreateEvaluationFormRequest#builder()}
     * </p>
     *
     * @param createEvaluationFormRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreateEvaluationFormRequest.Builder} to create a
     *        request.
     * @return Result of the CreateEvaluationForm operation returned by the service.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateEvaluationForm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateEvaluationForm" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateEvaluationFormResponse createEvaluationForm(
            Consumer<CreateEvaluationFormRequest.Builder> createEvaluationFormRequest) throws InternalServiceException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, ServiceQuotaExceededException,
            ResourceConflictException, AwsServiceException, SdkClientException, ConnectException {
        return createEvaluationForm(CreateEvaluationFormRequest.builder().applyMutation(createEvaluationFormRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Creates hours of operation.
     * </p>
     *
     * @param createHoursOfOperationRequest
     * @return Result of the CreateHoursOfOperation operation returned by the service.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateHoursOfOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateHoursOfOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateHoursOfOperationResponse createHoursOfOperation(CreateHoursOfOperationRequest createHoursOfOperationRequest)
            throws DuplicateResourceException, InvalidRequestException, InvalidParameterException, ResourceNotFoundException,
            LimitExceededException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException,
            ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Creates hours of operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateHoursOfOperationRequest.Builder} avoiding the
     * need to create one manually via {@link CreateHoursOfOperationRequest#builder()}
     * </p>
     *
     * @param createHoursOfOperationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreateHoursOfOperationRequest.Builder} to create a
     *        request.
     * @return Result of the CreateHoursOfOperation operation returned by the service.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateHoursOfOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateHoursOfOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateHoursOfOperationResponse createHoursOfOperation(
            Consumer<CreateHoursOfOperationRequest.Builder> createHoursOfOperationRequest) throws DuplicateResourceException,
            InvalidRequestException, InvalidParameterException, ResourceNotFoundException, LimitExceededException,
            ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return createHoursOfOperation(CreateHoursOfOperationRequest.builder().applyMutation(createHoursOfOperationRequest)
                .build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Initiates an Amazon Connect instance with all the supported channels enabled. It does not attach any storage,
     * such as Amazon Simple Storage Service (Amazon S3) or Amazon Kinesis. It also does not allow for any
     * configurations on features, such as Contact Lens for Amazon Connect.
     * </p>
     * <p>
     * Amazon Connect enforces a limit on the total number of instances that you can create or delete in 30 days. If you
     * exceed this limit, you will get an error message indicating there has been an excessive number of attempts at
     * creating or deleting instances. You must wait 30 days before you can restart creating and deleting instances in
     * your account.
     * </p>
     *
     * @param createInstanceRequest
     * @return Result of the CreateInstance operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateInstanceResponse createInstance(CreateInstanceRequest createInstanceRequest) throws InvalidRequestException,
            ServiceQuotaExceededException, ThrottlingException, ResourceNotFoundException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Initiates an Amazon Connect instance with all the supported channels enabled. It does not attach any storage,
     * such as Amazon Simple Storage Service (Amazon S3) or Amazon Kinesis. It also does not allow for any
     * configurations on features, such as Contact Lens for Amazon Connect.
     * </p>
     * <p>
     * Amazon Connect enforces a limit on the total number of instances that you can create or delete in 30 days. If you
     * exceed this limit, you will get an error message indicating there has been an excessive number of attempts at
     * creating or deleting instances. You must wait 30 days before you can restart creating and deleting instances in
     * your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInstanceRequest.Builder} avoiding the need to
     * create one manually via {@link CreateInstanceRequest#builder()}
     * </p>
     *
     * @param createInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreateInstanceRequest.Builder} to create a request.
     * @return Result of the CreateInstance operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateInstanceResponse createInstance(Consumer<CreateInstanceRequest.Builder> createInstanceRequest)
            throws InvalidRequestException, ServiceQuotaExceededException, ThrottlingException, ResourceNotFoundException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return createInstance(CreateInstanceRequest.builder().applyMutation(createInstanceRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Web Services resource association with an Amazon Connect instance.
     * </p>
     *
     * @param createIntegrationAssociationRequest
     * @return Result of the CreateIntegrationAssociation operation returned by the service.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateIntegrationAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateIntegrationAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateIntegrationAssociationResponse createIntegrationAssociation(
            CreateIntegrationAssociationRequest createIntegrationAssociationRequest) throws DuplicateResourceException,
            ResourceNotFoundException, InternalServiceException, InvalidRequestException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Web Services resource association with an Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIntegrationAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateIntegrationAssociationRequest#builder()}
     * </p>
     *
     * @param createIntegrationAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreateIntegrationAssociationRequest.Builder} to
     *        create a request.
     * @return Result of the CreateIntegrationAssociation operation returned by the service.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateIntegrationAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateIntegrationAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateIntegrationAssociationResponse createIntegrationAssociation(
            Consumer<CreateIntegrationAssociationRequest.Builder> createIntegrationAssociationRequest)
            throws DuplicateResourceException, ResourceNotFoundException, InternalServiceException, InvalidRequestException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return createIntegrationAssociation(CreateIntegrationAssociationRequest.builder()
                .applyMutation(createIntegrationAssociationRequest).build());
    }

    /**
     * <p>
     * Adds a new participant into an on-going chat contact. For more information, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/chat-customize-flow.html">Customize chat flow
     * experiences by integrating custom participants</a>.
     * </p>
     *
     * @param createParticipantRequest
     * @return Result of the CreateParticipant operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateParticipant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateParticipant" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateParticipantResponse createParticipant(CreateParticipantRequest createParticipantRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalServiceException, ServiceQuotaExceededException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a new participant into an on-going chat contact. For more information, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/chat-customize-flow.html">Customize chat flow
     * experiences by integrating custom participants</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateParticipantRequest.Builder} avoiding the need
     * to create one manually via {@link CreateParticipantRequest#builder()}
     * </p>
     *
     * @param createParticipantRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreateParticipantRequest.Builder} to create a
     *        request.
     * @return Result of the CreateParticipant operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateParticipant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateParticipant" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateParticipantResponse createParticipant(Consumer<CreateParticipantRequest.Builder> createParticipantRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalServiceException, ServiceQuotaExceededException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return createParticipant(CreateParticipantRequest.builder().applyMutation(createParticipantRequest).build());
    }

    /**
     * <p>
     * Enables rehydration of chats for the lifespan of a contact. For more information about chat rehydration, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/chat-persistence.html">Enable persistent chat</a> in
     * the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     *
     * @param createPersistentContactAssociationRequest
     * @return Result of the CreatePersistentContactAssociation operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreatePersistentContactAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreatePersistentContactAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreatePersistentContactAssociationResponse createPersistentContactAssociation(
            CreatePersistentContactAssociationRequest createPersistentContactAssociationRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables rehydration of chats for the lifespan of a contact. For more information about chat rehydration, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/chat-persistence.html">Enable persistent chat</a> in
     * the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePersistentContactAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link CreatePersistentContactAssociationRequest#builder()}
     * </p>
     *
     * @param createPersistentContactAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreatePersistentContactAssociationRequest.Builder} to
     *        create a request.
     * @return Result of the CreatePersistentContactAssociation operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreatePersistentContactAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreatePersistentContactAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreatePersistentContactAssociationResponse createPersistentContactAssociation(
            Consumer<CreatePersistentContactAssociationRequest.Builder> createPersistentContactAssociationRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, AccessDeniedException,
            ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return createPersistentContactAssociation(CreatePersistentContactAssociationRequest.builder()
                .applyMutation(createPersistentContactAssociationRequest).build());
    }

    /**
     * <p>
     * Creates a new predefined attribute for the specified Amazon Connect instance.
     * </p>
     *
     * @param createPredefinedAttributeRequest
     * @return Result of the CreatePredefinedAttribute operation returned by the service.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreatePredefinedAttribute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreatePredefinedAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    default CreatePredefinedAttributeResponse createPredefinedAttribute(
            CreatePredefinedAttributeRequest createPredefinedAttributeRequest) throws DuplicateResourceException,
            InvalidRequestException, InvalidParameterException, LimitExceededException, ResourceNotFoundException,
            ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new predefined attribute for the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePredefinedAttributeRequest.Builder} avoiding
     * the need to create one manually via {@link CreatePredefinedAttributeRequest#builder()}
     * </p>
     *
     * @param createPredefinedAttributeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreatePredefinedAttributeRequest.Builder} to create a
     *        request.
     * @return Result of the CreatePredefinedAttribute operation returned by the service.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreatePredefinedAttribute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreatePredefinedAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    default CreatePredefinedAttributeResponse createPredefinedAttribute(
            Consumer<CreatePredefinedAttributeRequest.Builder> createPredefinedAttributeRequest)
            throws DuplicateResourceException, InvalidRequestException, InvalidParameterException, LimitExceededException,
            ResourceNotFoundException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException,
            ConnectException {
        return createPredefinedAttribute(CreatePredefinedAttributeRequest.builder()
                .applyMutation(createPredefinedAttributeRequest).build());
    }

    /**
     * <p>
     * Creates a prompt. For more information about prompts, such as supported file types and maximum length, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/prompts.html">Create prompts</a> in the <i>Amazon
     * Connect Administrator Guide</i>.
     * </p>
     *
     * @param createPromptRequest
     * @return Result of the CreatePrompt operation returned by the service.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreatePrompt
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreatePrompt" target="_top">AWS API
     *      Documentation</a>
     */
    default CreatePromptResponse createPrompt(CreatePromptRequest createPromptRequest) throws DuplicateResourceException,
            InvalidRequestException, InvalidParameterException, LimitExceededException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a prompt. For more information about prompts, such as supported file types and maximum length, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/prompts.html">Create prompts</a> in the <i>Amazon
     * Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePromptRequest.Builder} avoiding the need to
     * create one manually via {@link CreatePromptRequest#builder()}
     * </p>
     *
     * @param createPromptRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreatePromptRequest.Builder} to create a request.
     * @return Result of the CreatePrompt operation returned by the service.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreatePrompt
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreatePrompt" target="_top">AWS API
     *      Documentation</a>
     */
    default CreatePromptResponse createPrompt(Consumer<CreatePromptRequest.Builder> createPromptRequest)
            throws DuplicateResourceException, InvalidRequestException, InvalidParameterException, LimitExceededException,
            ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return createPrompt(CreatePromptRequest.builder().applyMutation(createPromptRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Creates a new queue for the specified Amazon Connect instance.
     * </p>
     * <important>
     * <ul>
     * <li>
     * <p>
     * If the phone number is claimed to a traffic distribution group that was created in the same Region as the Amazon
     * Connect instance where you are calling this API, then you can use a full phone number ARN or a UUID for
     * <code>OutboundCallerIdNumberId</code>. However, if the phone number is claimed to a traffic distribution group
     * that is in one Region, and you are calling this API from an instance in another Amazon Web Services Region that
     * is associated with the traffic distribution group, you must provide a full phone number ARN. If a UUID is
     * provided in this scenario, you will receive a <code>ResourceNotFoundException</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Only use the phone number ARN format that doesn't contain <code>instance</code> in the path, for example,
     * <code>arn:aws:connect:us-east-1:1234567890:phone-number/uuid</code>. This is the same ARN format that is returned
     * when you call the <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_ListPhoneNumbersV2.html">ListPhoneNumbersV2</a>
     * API.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you plan to use IAM policies to allow/deny access to this API for phone number resources claimed to a traffic
     * distribution group, see <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/security_iam_resource-level-policy-examples.html#allow-deny-queue-actions-replica-region"
     * >Allow or Deny queue API actions for phone numbers in a replica Region</a>.
     * </p>
     * </li>
     * </ul>
     * </important>
     *
     * @param createQueueRequest
     * @return Result of the CreateQueue operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateQueueResponse createQueue(CreateQueueRequest createQueueRequest) throws InvalidRequestException,
            InvalidParameterException, DuplicateResourceException, ResourceNotFoundException, LimitExceededException,
            ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Creates a new queue for the specified Amazon Connect instance.
     * </p>
     * <important>
     * <ul>
     * <li>
     * <p>
     * If the phone number is claimed to a traffic distribution group that was created in the same Region as the Amazon
     * Connect instance where you are calling this API, then you can use a full phone number ARN or a UUID for
     * <code>OutboundCallerIdNumberId</code>. However, if the phone number is claimed to a traffic distribution group
     * that is in one Region, and you are calling this API from an instance in another Amazon Web Services Region that
     * is associated with the traffic distribution group, you must provide a full phone number ARN. If a UUID is
     * provided in this scenario, you will receive a <code>ResourceNotFoundException</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Only use the phone number ARN format that doesn't contain <code>instance</code> in the path, for example,
     * <code>arn:aws:connect:us-east-1:1234567890:phone-number/uuid</code>. This is the same ARN format that is returned
     * when you call the <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_ListPhoneNumbersV2.html">ListPhoneNumbersV2</a>
     * API.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you plan to use IAM policies to allow/deny access to this API for phone number resources claimed to a traffic
     * distribution group, see <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/security_iam_resource-level-policy-examples.html#allow-deny-queue-actions-replica-region"
     * >Allow or Deny queue API actions for phone numbers in a replica Region</a>.
     * </p>
     * </li>
     * </ul>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateQueueRequest.Builder} avoiding the need to
     * create one manually via {@link CreateQueueRequest#builder()}
     * </p>
     *
     * @param createQueueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreateQueueRequest.Builder} to create a request.
     * @return Result of the CreateQueue operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateQueueResponse createQueue(Consumer<CreateQueueRequest.Builder> createQueueRequest)
            throws InvalidRequestException, InvalidParameterException, DuplicateResourceException, ResourceNotFoundException,
            LimitExceededException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException,
            ConnectException {
        return createQueue(CreateQueueRequest.builder().applyMutation(createQueueRequest).build());
    }

    /**
     * <p>
     * Creates a quick connect for the specified Amazon Connect instance.
     * </p>
     *
     * @param createQuickConnectRequest
     * @return Result of the CreateQuickConnect operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateQuickConnect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateQuickConnect" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateQuickConnectResponse createQuickConnect(CreateQuickConnectRequest createQuickConnectRequest)
            throws InvalidRequestException, InvalidParameterException, DuplicateResourceException, ResourceNotFoundException,
            LimitExceededException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException,
            ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a quick connect for the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateQuickConnectRequest.Builder} avoiding the
     * need to create one manually via {@link CreateQuickConnectRequest#builder()}
     * </p>
     *
     * @param createQuickConnectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreateQuickConnectRequest.Builder} to create a
     *        request.
     * @return Result of the CreateQuickConnect operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateQuickConnect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateQuickConnect" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateQuickConnectResponse createQuickConnect(Consumer<CreateQuickConnectRequest.Builder> createQuickConnectRequest)
            throws InvalidRequestException, InvalidParameterException, DuplicateResourceException, ResourceNotFoundException,
            LimitExceededException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException,
            ConnectException {
        return createQuickConnect(CreateQuickConnectRequest.builder().applyMutation(createQuickConnectRequest).build());
    }

    /**
     * <p>
     * Creates a new routing profile.
     * </p>
     *
     * @param createRoutingProfileRequest
     * @return Result of the CreateRoutingProfile operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateRoutingProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateRoutingProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateRoutingProfileResponse createRoutingProfile(CreateRoutingProfileRequest createRoutingProfileRequest)
            throws InvalidRequestException, InvalidParameterException, DuplicateResourceException, ResourceNotFoundException,
            LimitExceededException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException,
            ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new routing profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRoutingProfileRequest.Builder} avoiding the
     * need to create one manually via {@link CreateRoutingProfileRequest#builder()}
     * </p>
     *
     * @param createRoutingProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreateRoutingProfileRequest.Builder} to create a
     *        request.
     * @return Result of the CreateRoutingProfile operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateRoutingProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateRoutingProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateRoutingProfileResponse createRoutingProfile(
            Consumer<CreateRoutingProfileRequest.Builder> createRoutingProfileRequest) throws InvalidRequestException,
            InvalidParameterException, DuplicateResourceException, ResourceNotFoundException, LimitExceededException,
            ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return createRoutingProfile(CreateRoutingProfileRequest.builder().applyMutation(createRoutingProfileRequest).build());
    }

    /**
     * <p>
     * Creates a rule for the specified Amazon Connect instance.
     * </p>
     * <p>
     * Use the <a href="https://docs.aws.amazon.com/connect/latest/APIReference/connect-rules-language.html">Rules
     * Function language</a> to code conditions for the rule.
     * </p>
     *
     * @param createRuleRequest
     * @return Result of the CreateRule operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateRuleResponse createRule(CreateRuleRequest createRuleRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalServiceException, ThrottlingException, AccessDeniedException,
            ResourceConflictException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a rule for the specified Amazon Connect instance.
     * </p>
     * <p>
     * Use the <a href="https://docs.aws.amazon.com/connect/latest/APIReference/connect-rules-language.html">Rules
     * Function language</a> to code conditions for the rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRuleRequest.Builder} avoiding the need to
     * create one manually via {@link CreateRuleRequest#builder()}
     * </p>
     *
     * @param createRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreateRuleRequest.Builder} to create a request.
     * @return Result of the CreateRule operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateRuleResponse createRule(Consumer<CreateRuleRequest.Builder> createRuleRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalServiceException, ThrottlingException, AccessDeniedException,
            ResourceConflictException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, ConnectException {
        return createRule(CreateRuleRequest.builder().applyMutation(createRuleRequest).build());
    }

    /**
     * <p>
     * Creates a security profile.
     * </p>
     *
     * @param createSecurityProfileRequest
     * @return Result of the CreateSecurityProfile operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateSecurityProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateSecurityProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateSecurityProfileResponse createSecurityProfile(CreateSecurityProfileRequest createSecurityProfileRequest)
            throws InvalidRequestException, InvalidParameterException, LimitExceededException, DuplicateResourceException,
            ResourceNotFoundException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException,
            ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a security profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSecurityProfileRequest.Builder} avoiding the
     * need to create one manually via {@link CreateSecurityProfileRequest#builder()}
     * </p>
     *
     * @param createSecurityProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreateSecurityProfileRequest.Builder} to create a
     *        request.
     * @return Result of the CreateSecurityProfile operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateSecurityProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateSecurityProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateSecurityProfileResponse createSecurityProfile(
            Consumer<CreateSecurityProfileRequest.Builder> createSecurityProfileRequest) throws InvalidRequestException,
            InvalidParameterException, LimitExceededException, DuplicateResourceException, ResourceNotFoundException,
            ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return createSecurityProfile(CreateSecurityProfileRequest.builder().applyMutation(createSecurityProfileRequest).build());
    }

    /**
     * <p>
     * Creates a new task template in the specified Amazon Connect instance.
     * </p>
     *
     * @param createTaskTemplateRequest
     * @return Result of the CreateTaskTemplate operation returned by the service.
     * @throws PropertyValidationException
     *         The property is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateTaskTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateTaskTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateTaskTemplateResponse createTaskTemplate(CreateTaskTemplateRequest createTaskTemplateRequest)
            throws PropertyValidationException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            ServiceQuotaExceededException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new task template in the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTaskTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link CreateTaskTemplateRequest#builder()}
     * </p>
     *
     * @param createTaskTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreateTaskTemplateRequest.Builder} to create a
     *        request.
     * @return Result of the CreateTaskTemplate operation returned by the service.
     * @throws PropertyValidationException
     *         The property is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateTaskTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateTaskTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateTaskTemplateResponse createTaskTemplate(Consumer<CreateTaskTemplateRequest.Builder> createTaskTemplateRequest)
            throws PropertyValidationException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            ServiceQuotaExceededException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return createTaskTemplate(CreateTaskTemplateRequest.builder().applyMutation(createTaskTemplateRequest).build());
    }

    /**
     * <p>
     * Creates a traffic distribution group given an Amazon Connect instance that has been replicated.
     * </p>
     * <note>
     * <p>
     * The <code>SignInConfig</code> distribution is available only on a default <code>TrafficDistributionGroup</code>
     * (see the <code>IsDefault</code> parameter in the <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_TrafficDistributionGroup.html"
     * >TrafficDistributionGroup</a> data type). If you call <code>UpdateTrafficDistribution</code> with a modified
     * <code>SignInConfig</code> and a non-default <code>TrafficDistributionGroup</code>, an
     * <code>InvalidRequestException</code> is returned.
     * </p>
     * </note>
     * <p>
     * For more information about creating traffic distribution groups, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/setup-traffic-distribution-groups.html">Set up
     * traffic distribution groups</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     *
     * @param createTrafficDistributionGroupRequest
     * @return Result of the CreateTrafficDistributionGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws ResourceNotReadyException
     *         The resource is not ready.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateTrafficDistributionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateTrafficDistributionGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTrafficDistributionGroupResponse createTrafficDistributionGroup(
            CreateTrafficDistributionGroupRequest createTrafficDistributionGroupRequest) throws InvalidRequestException,
            AccessDeniedException, ServiceQuotaExceededException, ThrottlingException, ResourceNotFoundException,
            InternalServiceException, ResourceConflictException, ResourceNotReadyException, AwsServiceException,
            SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a traffic distribution group given an Amazon Connect instance that has been replicated.
     * </p>
     * <note>
     * <p>
     * The <code>SignInConfig</code> distribution is available only on a default <code>TrafficDistributionGroup</code>
     * (see the <code>IsDefault</code> parameter in the <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_TrafficDistributionGroup.html"
     * >TrafficDistributionGroup</a> data type). If you call <code>UpdateTrafficDistribution</code> with a modified
     * <code>SignInConfig</code> and a non-default <code>TrafficDistributionGroup</code>, an
     * <code>InvalidRequestException</code> is returned.
     * </p>
     * </note>
     * <p>
     * For more information about creating traffic distribution groups, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/setup-traffic-distribution-groups.html">Set up
     * traffic distribution groups</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTrafficDistributionGroupRequest.Builder}
     * avoiding the need to create one manually via {@link CreateTrafficDistributionGroupRequest#builder()}
     * </p>
     *
     * @param createTrafficDistributionGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreateTrafficDistributionGroupRequest.Builder} to
     *        create a request.
     * @return Result of the CreateTrafficDistributionGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws ResourceNotReadyException
     *         The resource is not ready.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateTrafficDistributionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateTrafficDistributionGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTrafficDistributionGroupResponse createTrafficDistributionGroup(
            Consumer<CreateTrafficDistributionGroupRequest.Builder> createTrafficDistributionGroupRequest)
            throws InvalidRequestException, AccessDeniedException, ServiceQuotaExceededException, ThrottlingException,
            ResourceNotFoundException, InternalServiceException, ResourceConflictException, ResourceNotReadyException,
            AwsServiceException, SdkClientException, ConnectException {
        return createTrafficDistributionGroup(CreateTrafficDistributionGroupRequest.builder()
                .applyMutation(createTrafficDistributionGroupRequest).build());
    }

    /**
     * <p>
     * Creates a use case for an integration association.
     * </p>
     *
     * @param createUseCaseRequest
     * @return Result of the CreateUseCase operation returned by the service.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateUseCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateUseCase" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateUseCaseResponse createUseCase(CreateUseCaseRequest createUseCaseRequest) throws DuplicateResourceException,
            ResourceNotFoundException, InternalServiceException, InvalidRequestException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a use case for an integration association.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUseCaseRequest.Builder} avoiding the need to
     * create one manually via {@link CreateUseCaseRequest#builder()}
     * </p>
     *
     * @param createUseCaseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreateUseCaseRequest.Builder} to create a request.
     * @return Result of the CreateUseCase operation returned by the service.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateUseCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateUseCase" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateUseCaseResponse createUseCase(Consumer<CreateUseCaseRequest.Builder> createUseCaseRequest)
            throws DuplicateResourceException, ResourceNotFoundException, InternalServiceException, InvalidRequestException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return createUseCase(CreateUseCaseRequest.builder().applyMutation(createUseCaseRequest).build());
    }

    /**
     * <p>
     * Creates a user account for the specified Amazon Connect instance.
     * </p>
     * <important>
     * <p>
     * Certain <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_UserIdentityInfo.html">UserIdentityInfo</a>
     * parameters are required in some situations. For example, <code>Email</code> is required if you are using SAML for
     * identity management. <code>FirstName</code> and <code>LastName</code> are required if you are using Amazon
     * Connect or SAML for identity management.
     * </p>
     * </important>
     * <p>
     * For information about how to create users using the Amazon Connect admin website, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/user-management.html">Add Users</a> in the <i>Amazon
     * Connect Administrator Guide</i>.
     * </p>
     *
     * @param createUserRequest
     * @return Result of the CreateUser operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateUserResponse createUser(CreateUserRequest createUserRequest) throws InvalidRequestException,
            InvalidParameterException, LimitExceededException, DuplicateResourceException, ResourceNotFoundException,
            ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a user account for the specified Amazon Connect instance.
     * </p>
     * <important>
     * <p>
     * Certain <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_UserIdentityInfo.html">UserIdentityInfo</a>
     * parameters are required in some situations. For example, <code>Email</code> is required if you are using SAML for
     * identity management. <code>FirstName</code> and <code>LastName</code> are required if you are using Amazon
     * Connect or SAML for identity management.
     * </p>
     * </important>
     * <p>
     * For information about how to create users using the Amazon Connect admin website, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/user-management.html">Add Users</a> in the <i>Amazon
     * Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUserRequest.Builder} avoiding the need to
     * create one manually via {@link CreateUserRequest#builder()}
     * </p>
     *
     * @param createUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreateUserRequest.Builder} to create a request.
     * @return Result of the CreateUser operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateUserResponse createUser(Consumer<CreateUserRequest.Builder> createUserRequest) throws InvalidRequestException,
            InvalidParameterException, LimitExceededException, DuplicateResourceException, ResourceNotFoundException,
            ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return createUser(CreateUserRequest.builder().applyMutation(createUserRequest).build());
    }

    /**
     * <p>
     * Creates a new user hierarchy group.
     * </p>
     *
     * @param createUserHierarchyGroupRequest
     * @return Result of the CreateUserHierarchyGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateUserHierarchyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateUserHierarchyGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateUserHierarchyGroupResponse createUserHierarchyGroup(
            CreateUserHierarchyGroupRequest createUserHierarchyGroupRequest) throws InvalidRequestException,
            InvalidParameterException, DuplicateResourceException, LimitExceededException, ResourceNotFoundException,
            ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new user hierarchy group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUserHierarchyGroupRequest.Builder} avoiding
     * the need to create one manually via {@link CreateUserHierarchyGroupRequest#builder()}
     * </p>
     *
     * @param createUserHierarchyGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreateUserHierarchyGroupRequest.Builder} to create a
     *        request.
     * @return Result of the CreateUserHierarchyGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateUserHierarchyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateUserHierarchyGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateUserHierarchyGroupResponse createUserHierarchyGroup(
            Consumer<CreateUserHierarchyGroupRequest.Builder> createUserHierarchyGroupRequest) throws InvalidRequestException,
            InvalidParameterException, DuplicateResourceException, LimitExceededException, ResourceNotFoundException,
            ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return createUserHierarchyGroup(CreateUserHierarchyGroupRequest.builder().applyMutation(createUserHierarchyGroupRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new view with the possible status of <code>SAVED</code> or <code>PUBLISHED</code>.
     * </p>
     * <p>
     * The views will have a unique name for each connect instance.
     * </p>
     * <p>
     * It performs basic content validation if the status is <code>SAVED</code> or full content validation if the status
     * is set to <code>PUBLISHED</code>. An error is returned if validation fails. It associates either the
     * <code>&#36SAVED</code> qualifier or both of the <code>&#36SAVED</code> and <code>&#36LATEST</code> qualifiers
     * with the provided view content based on the status. The view is idempotent if ClientToken is provided.
     * </p>
     *
     * @param createViewRequest
     * @return Result of the CreateView operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws TooManyRequestsException
     *         Displayed when rate-related API limits are exceeded.
     * @throws ResourceInUseException
     *         That resource is already in use. Please try another.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateView" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateViewResponse createView(CreateViewRequest createViewRequest) throws AccessDeniedException,
            InvalidRequestException, InvalidParameterException, ResourceNotFoundException, InternalServiceException,
            DuplicateResourceException, ServiceQuotaExceededException, TooManyRequestsException, ResourceInUseException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new view with the possible status of <code>SAVED</code> or <code>PUBLISHED</code>.
     * </p>
     * <p>
     * The views will have a unique name for each connect instance.
     * </p>
     * <p>
     * It performs basic content validation if the status is <code>SAVED</code> or full content validation if the status
     * is set to <code>PUBLISHED</code>. An error is returned if validation fails. It associates either the
     * <code>&#36SAVED</code> qualifier or both of the <code>&#36SAVED</code> and <code>&#36LATEST</code> qualifiers
     * with the provided view content based on the status. The view is idempotent if ClientToken is provided.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateViewRequest.Builder} avoiding the need to
     * create one manually via {@link CreateViewRequest#builder()}
     * </p>
     *
     * @param createViewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreateViewRequest.Builder} to create a request.
     * @return Result of the CreateView operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws TooManyRequestsException
     *         Displayed when rate-related API limits are exceeded.
     * @throws ResourceInUseException
     *         That resource is already in use. Please try another.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateView" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateViewResponse createView(Consumer<CreateViewRequest.Builder> createViewRequest) throws AccessDeniedException,
            InvalidRequestException, InvalidParameterException, ResourceNotFoundException, InternalServiceException,
            DuplicateResourceException, ServiceQuotaExceededException, TooManyRequestsException, ResourceInUseException,
            AwsServiceException, SdkClientException, ConnectException {
        return createView(CreateViewRequest.builder().applyMutation(createViewRequest).build());
    }

    /**
     * <p>
     * Publishes a new version of the view identifier.
     * </p>
     * <p>
     * Versions are immutable and monotonically increasing.
     * </p>
     * <p>
     * It returns the highest version if there is no change in content compared to that version. An error is displayed
     * if the supplied ViewContentSha256 is different from the ViewContentSha256 of the <code>&#36LATEST</code> alias.
     * </p>
     *
     * @param createViewVersionRequest
     * @return Result of the CreateViewVersion operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws TooManyRequestsException
     *         Displayed when rate-related API limits are exceeded.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ResourceInUseException
     *         That resource is already in use. Please try another.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateViewVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateViewVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateViewVersionResponse createViewVersion(CreateViewVersionRequest createViewVersionRequest)
            throws AccessDeniedException, InvalidRequestException, InvalidParameterException, ResourceNotFoundException,
            InternalServiceException, TooManyRequestsException, ServiceQuotaExceededException, ResourceInUseException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Publishes a new version of the view identifier.
     * </p>
     * <p>
     * Versions are immutable and monotonically increasing.
     * </p>
     * <p>
     * It returns the highest version if there is no change in content compared to that version. An error is displayed
     * if the supplied ViewContentSha256 is different from the ViewContentSha256 of the <code>&#36LATEST</code> alias.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateViewVersionRequest.Builder} avoiding the need
     * to create one manually via {@link CreateViewVersionRequest#builder()}
     * </p>
     *
     * @param createViewVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreateViewVersionRequest.Builder} to create a
     *        request.
     * @return Result of the CreateViewVersion operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws TooManyRequestsException
     *         Displayed when rate-related API limits are exceeded.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ResourceInUseException
     *         That resource is already in use. Please try another.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateViewVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateViewVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateViewVersionResponse createViewVersion(Consumer<CreateViewVersionRequest.Builder> createViewVersionRequest)
            throws AccessDeniedException, InvalidRequestException, InvalidParameterException, ResourceNotFoundException,
            InternalServiceException, TooManyRequestsException, ServiceQuotaExceededException, ResourceInUseException,
            AwsServiceException, SdkClientException, ConnectException {
        return createViewVersion(CreateViewVersionRequest.builder().applyMutation(createViewVersionRequest).build());
    }

    /**
     * <p>
     * Creates a custom vocabulary associated with your Amazon Connect instance. You can set a custom vocabulary to be
     * your default vocabulary for a given language. Contact Lens for Amazon Connect uses the default vocabulary in
     * post-call and real-time contact analysis sessions for that language.
     * </p>
     *
     * @param createVocabularyRequest
     * @return Result of the CreateVocabulary operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateVocabulary" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateVocabularyResponse createVocabulary(CreateVocabularyRequest createVocabularyRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalServiceException, ThrottlingException,
            AccessDeniedException, ResourceConflictException, ServiceQuotaExceededException, AwsServiceException,
            SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a custom vocabulary associated with your Amazon Connect instance. You can set a custom vocabulary to be
     * your default vocabulary for a given language. Contact Lens for Amazon Connect uses the default vocabulary in
     * post-call and real-time contact analysis sessions for that language.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVocabularyRequest.Builder} avoiding the need
     * to create one manually via {@link CreateVocabularyRequest#builder()}
     * </p>
     *
     * @param createVocabularyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.CreateVocabularyRequest.Builder} to create a request.
     * @return Result of the CreateVocabulary operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateVocabulary" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateVocabularyResponse createVocabulary(Consumer<CreateVocabularyRequest.Builder> createVocabularyRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalServiceException, ThrottlingException,
            AccessDeniedException, ResourceConflictException, ServiceQuotaExceededException, AwsServiceException,
            SdkClientException, ConnectException {
        return createVocabulary(CreateVocabularyRequest.builder().applyMutation(createVocabularyRequest).build());
    }

    /**
     * <p>
     * Deactivates an evaluation form in the specified Amazon Connect instance. After a form is deactivated, it is no
     * longer available for users to start new evaluations based on the form.
     * </p>
     *
     * @param deactivateEvaluationFormRequest
     * @return Result of the DeactivateEvaluationForm operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeactivateEvaluationForm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeactivateEvaluationForm"
     *      target="_top">AWS API Documentation</a>
     */
    default DeactivateEvaluationFormResponse deactivateEvaluationForm(
            DeactivateEvaluationFormRequest deactivateEvaluationFormRequest) throws InvalidParameterException,
            ResourceNotFoundException, ThrottlingException, InternalServiceException, ResourceConflictException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deactivates an evaluation form in the specified Amazon Connect instance. After a form is deactivated, it is no
     * longer available for users to start new evaluations based on the form.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeactivateEvaluationFormRequest.Builder} avoiding
     * the need to create one manually via {@link DeactivateEvaluationFormRequest#builder()}
     * </p>
     *
     * @param deactivateEvaluationFormRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeactivateEvaluationFormRequest.Builder} to create a
     *        request.
     * @return Result of the DeactivateEvaluationForm operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeactivateEvaluationForm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeactivateEvaluationForm"
     *      target="_top">AWS API Documentation</a>
     */
    default DeactivateEvaluationFormResponse deactivateEvaluationForm(
            Consumer<DeactivateEvaluationFormRequest.Builder> deactivateEvaluationFormRequest) throws InvalidParameterException,
            ResourceNotFoundException, ThrottlingException, InternalServiceException, ResourceConflictException,
            AwsServiceException, SdkClientException, ConnectException {
        return deactivateEvaluationForm(DeactivateEvaluationFormRequest.builder().applyMutation(deactivateEvaluationFormRequest)
                .build());
    }

    /**
     * <p>
     * Deletes an attached file along with the underlying S3 Object.
     * </p>
     * <important>
     * <p>
     * The attached file is <b>permanently deleted</b> if S3 bucket versioning is not enabled.
     * </p>
     * </important>
     *
     * @param deleteAttachedFileRequest
     *        Request to DeleteAttachedFile API
     * @return Result of the DeleteAttachedFile operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteAttachedFile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteAttachedFile" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteAttachedFileResponse deleteAttachedFile(DeleteAttachedFileRequest deleteAttachedFileRequest)
            throws AccessDeniedException, InvalidRequestException, InternalServiceException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an attached file along with the underlying S3 Object.
     * </p>
     * <important>
     * <p>
     * The attached file is <b>permanently deleted</b> if S3 bucket versioning is not enabled.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAttachedFileRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAttachedFileRequest#builder()}
     * </p>
     *
     * @param deleteAttachedFileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeleteAttachedFileRequest.Builder} to create a
     *        request. Request to DeleteAttachedFile API
     * @return Result of the DeleteAttachedFile operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteAttachedFile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteAttachedFile" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteAttachedFileResponse deleteAttachedFile(Consumer<DeleteAttachedFileRequest.Builder> deleteAttachedFileRequest)
            throws AccessDeniedException, InvalidRequestException, InternalServiceException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return deleteAttachedFile(DeleteAttachedFileRequest.builder().applyMutation(deleteAttachedFileRequest).build());
    }

    /**
     * <p>
     * Deletes a contact evaluation in the specified Amazon Connect instance.
     * </p>
     *
     * @param deleteContactEvaluationRequest
     * @return Result of the DeleteContactEvaluation operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteContactEvaluation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteContactEvaluation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteContactEvaluationResponse deleteContactEvaluation(DeleteContactEvaluationRequest deleteContactEvaluationRequest)
            throws InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            ResourceConflictException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a contact evaluation in the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteContactEvaluationRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteContactEvaluationRequest#builder()}
     * </p>
     *
     * @param deleteContactEvaluationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeleteContactEvaluationRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteContactEvaluation operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteContactEvaluation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteContactEvaluation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteContactEvaluationResponse deleteContactEvaluation(
            Consumer<DeleteContactEvaluationRequest.Builder> deleteContactEvaluationRequest) throws InvalidParameterException,
            ResourceNotFoundException, ThrottlingException, InternalServiceException, ResourceConflictException,
            AwsServiceException, SdkClientException, ConnectException {
        return deleteContactEvaluation(DeleteContactEvaluationRequest.builder().applyMutation(deleteContactEvaluationRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a flow for the specified Amazon Connect instance.
     * </p>
     *
     * @param deleteContactFlowRequest
     * @return Result of the DeleteContactFlow operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteContactFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteContactFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteContactFlowResponse deleteContactFlow(DeleteContactFlowRequest deleteContactFlowRequest)
            throws AccessDeniedException, InvalidRequestException, InvalidParameterException, ResourceNotFoundException,
            InternalServiceException, ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a flow for the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteContactFlowRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteContactFlowRequest#builder()}
     * </p>
     *
     * @param deleteContactFlowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeleteContactFlowRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteContactFlow operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteContactFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteContactFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteContactFlowResponse deleteContactFlow(Consumer<DeleteContactFlowRequest.Builder> deleteContactFlowRequest)
            throws AccessDeniedException, InvalidRequestException, InvalidParameterException, ResourceNotFoundException,
            InternalServiceException, ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return deleteContactFlow(DeleteContactFlowRequest.builder().applyMutation(deleteContactFlowRequest).build());
    }

    /**
     * <p>
     * Deletes the specified flow module.
     * </p>
     *
     * @param deleteContactFlowModuleRequest
     * @return Result of the DeleteContactFlowModule operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteContactFlowModule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteContactFlowModule"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteContactFlowModuleResponse deleteContactFlowModule(DeleteContactFlowModuleRequest deleteContactFlowModuleRequest)
            throws AccessDeniedException, InvalidRequestException, InvalidParameterException, ResourceNotFoundException,
            ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified flow module.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteContactFlowModuleRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteContactFlowModuleRequest#builder()}
     * </p>
     *
     * @param deleteContactFlowModuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeleteContactFlowModuleRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteContactFlowModule operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteContactFlowModule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteContactFlowModule"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteContactFlowModuleResponse deleteContactFlowModule(
            Consumer<DeleteContactFlowModuleRequest.Builder> deleteContactFlowModuleRequest) throws AccessDeniedException,
            InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return deleteContactFlowModule(DeleteContactFlowModuleRequest.builder().applyMutation(deleteContactFlowModuleRequest)
                .build());
    }

    /**
     * <p>
     * Deletes an evaluation form in the specified Amazon Connect instance.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the version property is provided, only the specified version of the evaluation form is deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * If no version is provided, then the full form (all versions) is deleted.
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteEvaluationFormRequest
     * @return Result of the DeleteEvaluationForm operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteEvaluationForm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteEvaluationForm" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteEvaluationFormResponse deleteEvaluationForm(DeleteEvaluationFormRequest deleteEvaluationFormRequest)
            throws InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            ResourceConflictException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an evaluation form in the specified Amazon Connect instance.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the version property is provided, only the specified version of the evaluation form is deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * If no version is provided, then the full form (all versions) is deleted.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEvaluationFormRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteEvaluationFormRequest#builder()}
     * </p>
     *
     * @param deleteEvaluationFormRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeleteEvaluationFormRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteEvaluationForm operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteEvaluationForm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteEvaluationForm" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteEvaluationFormResponse deleteEvaluationForm(
            Consumer<DeleteEvaluationFormRequest.Builder> deleteEvaluationFormRequest) throws InvalidParameterException,
            ResourceNotFoundException, ThrottlingException, InternalServiceException, ResourceConflictException,
            AwsServiceException, SdkClientException, ConnectException {
        return deleteEvaluationForm(DeleteEvaluationFormRequest.builder().applyMutation(deleteEvaluationFormRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Deletes an hours of operation.
     * </p>
     *
     * @param deleteHoursOfOperationRequest
     * @return Result of the DeleteHoursOfOperation operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteHoursOfOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteHoursOfOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteHoursOfOperationResponse deleteHoursOfOperation(DeleteHoursOfOperationRequest deleteHoursOfOperationRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Deletes an hours of operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteHoursOfOperationRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteHoursOfOperationRequest#builder()}
     * </p>
     *
     * @param deleteHoursOfOperationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeleteHoursOfOperationRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteHoursOfOperation operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteHoursOfOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteHoursOfOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteHoursOfOperationResponse deleteHoursOfOperation(
            Consumer<DeleteHoursOfOperationRequest.Builder> deleteHoursOfOperationRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return deleteHoursOfOperation(DeleteHoursOfOperationRequest.builder().applyMutation(deleteHoursOfOperationRequest)
                .build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Deletes the Amazon Connect instance.
     * </p>
     * <p>
     * Amazon Connect enforces a limit on the total number of instances that you can create or delete in 30 days. If you
     * exceed this limit, you will get an error message indicating there has been an excessive number of attempts at
     * creating or deleting instances. You must wait 30 days before you can restart creating and deleting instances in
     * your account.
     * </p>
     *
     * @param deleteInstanceRequest
     * @return Result of the DeleteInstance operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteInstanceResponse deleteInstance(DeleteInstanceRequest deleteInstanceRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Deletes the Amazon Connect instance.
     * </p>
     * <p>
     * Amazon Connect enforces a limit on the total number of instances that you can create or delete in 30 days. If you
     * exceed this limit, you will get an error message indicating there has been an excessive number of attempts at
     * creating or deleting instances. You must wait 30 days before you can restart creating and deleting instances in
     * your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInstanceRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteInstanceRequest#builder()}
     * </p>
     *
     * @param deleteInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeleteInstanceRequest.Builder} to create a request.
     * @return Result of the DeleteInstance operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteInstanceResponse deleteInstance(Consumer<DeleteInstanceRequest.Builder> deleteInstanceRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, AwsServiceException,
            SdkClientException, ConnectException {
        return deleteInstance(DeleteInstanceRequest.builder().applyMutation(deleteInstanceRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon Web Services resource association from an Amazon Connect instance. The association must not
     * have any use cases associated with it.
     * </p>
     *
     * @param deleteIntegrationAssociationRequest
     * @return Result of the DeleteIntegrationAssociation operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteIntegrationAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteIntegrationAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteIntegrationAssociationResponse deleteIntegrationAssociation(
            DeleteIntegrationAssociationRequest deleteIntegrationAssociationRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, ThrottlingException, AwsServiceException, SdkClientException,
            ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon Web Services resource association from an Amazon Connect instance. The association must not
     * have any use cases associated with it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIntegrationAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteIntegrationAssociationRequest#builder()}
     * </p>
     *
     * @param deleteIntegrationAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeleteIntegrationAssociationRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteIntegrationAssociation operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteIntegrationAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteIntegrationAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteIntegrationAssociationResponse deleteIntegrationAssociation(
            Consumer<DeleteIntegrationAssociationRequest.Builder> deleteIntegrationAssociationRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        return deleteIntegrationAssociation(DeleteIntegrationAssociationRequest.builder()
                .applyMutation(deleteIntegrationAssociationRequest).build());
    }

    /**
     * <p>
     * Deletes a predefined attribute from the specified Amazon Connect instance.
     * </p>
     *
     * @param deletePredefinedAttributeRequest
     * @return Result of the DeletePredefinedAttribute operation returned by the service.
     * @throws ResourceInUseException
     *         That resource is already in use. Please try another.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeletePredefinedAttribute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeletePredefinedAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    default DeletePredefinedAttributeResponse deletePredefinedAttribute(
            DeletePredefinedAttributeRequest deletePredefinedAttributeRequest) throws ResourceInUseException,
            InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a predefined attribute from the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePredefinedAttributeRequest.Builder} avoiding
     * the need to create one manually via {@link DeletePredefinedAttributeRequest#builder()}
     * </p>
     *
     * @param deletePredefinedAttributeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeletePredefinedAttributeRequest.Builder} to create a
     *        request.
     * @return Result of the DeletePredefinedAttribute operation returned by the service.
     * @throws ResourceInUseException
     *         That resource is already in use. Please try another.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeletePredefinedAttribute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeletePredefinedAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    default DeletePredefinedAttributeResponse deletePredefinedAttribute(
            Consumer<DeletePredefinedAttributeRequest.Builder> deletePredefinedAttributeRequest) throws ResourceInUseException,
            InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return deletePredefinedAttribute(DeletePredefinedAttributeRequest.builder()
                .applyMutation(deletePredefinedAttributeRequest).build());
    }

    /**
     * <p>
     * Deletes a prompt.
     * </p>
     *
     * @param deletePromptRequest
     * @return Result of the DeletePrompt operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeletePrompt
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeletePrompt" target="_top">AWS API
     *      Documentation</a>
     */
    default DeletePromptResponse deletePrompt(DeletePromptRequest deletePromptRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a prompt.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePromptRequest.Builder} avoiding the need to
     * create one manually via {@link DeletePromptRequest#builder()}
     * </p>
     *
     * @param deletePromptRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeletePromptRequest.Builder} to create a request.
     * @return Result of the DeletePrompt operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeletePrompt
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeletePrompt" target="_top">AWS API
     *      Documentation</a>
     */
    default DeletePromptResponse deletePrompt(Consumer<DeletePromptRequest.Builder> deletePromptRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return deletePrompt(DeletePromptRequest.builder().applyMutation(deletePromptRequest).build());
    }

    /**
     * <p>
     * Deletes a queue.
     * </p>
     *
     * @param deleteQueueRequest
     * @return Result of the DeleteQueue operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceInUseException
     *         That resource is already in use. Please try another.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteQueueResponse deleteQueue(DeleteQueueRequest deleteQueueRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ResourceInUseException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a queue.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteQueueRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteQueueRequest#builder()}
     * </p>
     *
     * @param deleteQueueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeleteQueueRequest.Builder} to create a request.
     * @return Result of the DeleteQueue operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceInUseException
     *         That resource is already in use. Please try another.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteQueueResponse deleteQueue(Consumer<DeleteQueueRequest.Builder> deleteQueueRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ResourceInUseException,
            ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return deleteQueue(DeleteQueueRequest.builder().applyMutation(deleteQueueRequest).build());
    }

    /**
     * <p>
     * Deletes a quick connect.
     * </p>
     * <important>
     * <p>
     * After calling <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteUser.html">DeleteUser</a>, it's important
     * to call <code>DeleteQuickConnect</code> to delete any records related to the deleted users. This will help you:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Avoid dangling resources that impact your service quotas.
     * </p>
     * </li>
     * <li>
     * <p>
     * Remove deleted users so they don't appear to agents as transfer options.
     * </p>
     * </li>
     * <li>
     * <p>
     * Avoid the disruption of other Amazon Connect processes, such as instance replication and syncing if you're using
     * <a href="https://docs.aws.amazon.com/connect/latest/adminguide/setup-connect-global-resiliency.html">Amazon
     * Connect Global Resiliency</a>.
     * </p>
     * </li>
     * </ul>
     * </important>
     *
     * @param deleteQuickConnectRequest
     * @return Result of the DeleteQuickConnect operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteQuickConnect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteQuickConnect" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteQuickConnectResponse deleteQuickConnect(DeleteQuickConnectRequest deleteQuickConnectRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a quick connect.
     * </p>
     * <important>
     * <p>
     * After calling <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteUser.html">DeleteUser</a>, it's important
     * to call <code>DeleteQuickConnect</code> to delete any records related to the deleted users. This will help you:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Avoid dangling resources that impact your service quotas.
     * </p>
     * </li>
     * <li>
     * <p>
     * Remove deleted users so they don't appear to agents as transfer options.
     * </p>
     * </li>
     * <li>
     * <p>
     * Avoid the disruption of other Amazon Connect processes, such as instance replication and syncing if you're using
     * <a href="https://docs.aws.amazon.com/connect/latest/adminguide/setup-connect-global-resiliency.html">Amazon
     * Connect Global Resiliency</a>.
     * </p>
     * </li>
     * </ul>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteQuickConnectRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteQuickConnectRequest#builder()}
     * </p>
     *
     * @param deleteQuickConnectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeleteQuickConnectRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteQuickConnect operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteQuickConnect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteQuickConnect" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteQuickConnectResponse deleteQuickConnect(Consumer<DeleteQuickConnectRequest.Builder> deleteQuickConnectRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return deleteQuickConnect(DeleteQuickConnectRequest.builder().applyMutation(deleteQuickConnectRequest).build());
    }

    /**
     * <p>
     * Deletes a routing profile.
     * </p>
     *
     * @param deleteRoutingProfileRequest
     * @return Result of the DeleteRoutingProfile operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceInUseException
     *         That resource is already in use. Please try another.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteRoutingProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteRoutingProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteRoutingProfileResponse deleteRoutingProfile(DeleteRoutingProfileRequest deleteRoutingProfileRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ResourceInUseException,
            ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a routing profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRoutingProfileRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteRoutingProfileRequest#builder()}
     * </p>
     *
     * @param deleteRoutingProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeleteRoutingProfileRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteRoutingProfile operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceInUseException
     *         That resource is already in use. Please try another.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteRoutingProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteRoutingProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteRoutingProfileResponse deleteRoutingProfile(
            Consumer<DeleteRoutingProfileRequest.Builder> deleteRoutingProfileRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ResourceInUseException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return deleteRoutingProfile(DeleteRoutingProfileRequest.builder().applyMutation(deleteRoutingProfileRequest).build());
    }

    /**
     * <p>
     * Deletes a rule for the specified Amazon Connect instance.
     * </p>
     *
     * @param deleteRuleRequest
     * @return Result of the DeleteRule operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteRule" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteRuleResponse deleteRule(DeleteRuleRequest deleteRuleRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalServiceException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a rule for the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRuleRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteRuleRequest#builder()}
     * </p>
     *
     * @param deleteRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeleteRuleRequest.Builder} to create a request.
     * @return Result of the DeleteRule operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteRule" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteRuleResponse deleteRule(Consumer<DeleteRuleRequest.Builder> deleteRuleRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalServiceException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, ConnectException {
        return deleteRule(DeleteRuleRequest.builder().applyMutation(deleteRuleRequest).build());
    }

    /**
     * <p>
     * Deletes a security profile.
     * </p>
     *
     * @param deleteSecurityProfileRequest
     * @return Result of the DeleteSecurityProfile operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ResourceInUseException
     *         That resource is already in use. Please try another.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteSecurityProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteSecurityProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteSecurityProfileResponse deleteSecurityProfile(DeleteSecurityProfileRequest deleteSecurityProfileRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AccessDeniedException, ResourceInUseException, AwsServiceException, SdkClientException,
            ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a security profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSecurityProfileRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteSecurityProfileRequest#builder()}
     * </p>
     *
     * @param deleteSecurityProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeleteSecurityProfileRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteSecurityProfile operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ResourceInUseException
     *         That resource is already in use. Please try another.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteSecurityProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteSecurityProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteSecurityProfileResponse deleteSecurityProfile(
            Consumer<DeleteSecurityProfileRequest.Builder> deleteSecurityProfileRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AccessDeniedException, ResourceInUseException, AwsServiceException, SdkClientException, ConnectException {
        return deleteSecurityProfile(DeleteSecurityProfileRequest.builder().applyMutation(deleteSecurityProfileRequest).build());
    }

    /**
     * <p>
     * Deletes the task template.
     * </p>
     *
     * @param deleteTaskTemplateRequest
     * @return Result of the DeleteTaskTemplate operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteTaskTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteTaskTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteTaskTemplateResponse deleteTaskTemplate(DeleteTaskTemplateRequest deleteTaskTemplateRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the task template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTaskTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteTaskTemplateRequest#builder()}
     * </p>
     *
     * @param deleteTaskTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeleteTaskTemplateRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteTaskTemplate operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteTaskTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteTaskTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteTaskTemplateResponse deleteTaskTemplate(Consumer<DeleteTaskTemplateRequest.Builder> deleteTaskTemplateRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return deleteTaskTemplate(DeleteTaskTemplateRequest.builder().applyMutation(deleteTaskTemplateRequest).build());
    }

    /**
     * <p>
     * Deletes a traffic distribution group. This API can be called only in the Region where the traffic distribution
     * group is created.
     * </p>
     * <p>
     * For more information about deleting traffic distribution groups, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/delete-traffic-distribution-groups.html">Delete
     * traffic distribution groups</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     *
     * @param deleteTrafficDistributionGroupRequest
     * @return Result of the DeleteTrafficDistributionGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ResourceInUseException
     *         That resource is already in use. Please try another.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteTrafficDistributionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteTrafficDistributionGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTrafficDistributionGroupResponse deleteTrafficDistributionGroup(
            DeleteTrafficDistributionGroupRequest deleteTrafficDistributionGroupRequest) throws InvalidRequestException,
            AccessDeniedException, ResourceInUseException, ThrottlingException, InternalServiceException, AwsServiceException,
            SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a traffic distribution group. This API can be called only in the Region where the traffic distribution
     * group is created.
     * </p>
     * <p>
     * For more information about deleting traffic distribution groups, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/delete-traffic-distribution-groups.html">Delete
     * traffic distribution groups</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTrafficDistributionGroupRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteTrafficDistributionGroupRequest#builder()}
     * </p>
     *
     * @param deleteTrafficDistributionGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeleteTrafficDistributionGroupRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteTrafficDistributionGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ResourceInUseException
     *         That resource is already in use. Please try another.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteTrafficDistributionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteTrafficDistributionGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTrafficDistributionGroupResponse deleteTrafficDistributionGroup(
            Consumer<DeleteTrafficDistributionGroupRequest.Builder> deleteTrafficDistributionGroupRequest)
            throws InvalidRequestException, AccessDeniedException, ResourceInUseException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return deleteTrafficDistributionGroup(DeleteTrafficDistributionGroupRequest.builder()
                .applyMutation(deleteTrafficDistributionGroupRequest).build());
    }

    /**
     * <p>
     * Deletes a use case from an integration association.
     * </p>
     *
     * @param deleteUseCaseRequest
     * @return Result of the DeleteUseCase operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteUseCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteUseCase" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteUseCaseResponse deleteUseCase(DeleteUseCaseRequest deleteUseCaseRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, ThrottlingException, AwsServiceException, SdkClientException,
            ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a use case from an integration association.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUseCaseRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteUseCaseRequest#builder()}
     * </p>
     *
     * @param deleteUseCaseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeleteUseCaseRequest.Builder} to create a request.
     * @return Result of the DeleteUseCase operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteUseCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteUseCase" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteUseCaseResponse deleteUseCase(Consumer<DeleteUseCaseRequest.Builder> deleteUseCaseRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        return deleteUseCase(DeleteUseCaseRequest.builder().applyMutation(deleteUseCaseRequest).build());
    }

    /**
     * <p>
     * Deletes a user account from the specified Amazon Connect instance.
     * </p>
     * <p>
     * For information about what happens to a user's data when their account is deleted, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/delete-users.html">Delete Users from Your Amazon
     * Connect Instance</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <important>
     * <p>
     * After calling DeleteUser, call <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteQuickConnect.html">DeleteQuickConnect</a>
     * to delete any records related to the deleted users. This will help you:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Avoid dangling resources that impact your service quotas.
     * </p>
     * </li>
     * <li>
     * <p>
     * Remove deleted users so they don't appear to agents as transfer options.
     * </p>
     * </li>
     * <li>
     * <p>
     * Avoid the disruption of other Amazon Connect processes, such as instance replication and syncing if you're using
     * <a href="https://docs.aws.amazon.com/connect/latest/adminguide/setup-connect-global-resiliency.html">Amazon
     * Connect Global Resiliency</a>.
     * </p>
     * </li>
     * </ul>
     * </important>
     *
     * @param deleteUserRequest
     * @return Result of the DeleteUser operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteUserResponse deleteUser(DeleteUserRequest deleteUserRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a user account from the specified Amazon Connect instance.
     * </p>
     * <p>
     * For information about what happens to a user's data when their account is deleted, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/delete-users.html">Delete Users from Your Amazon
     * Connect Instance</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <important>
     * <p>
     * After calling DeleteUser, call <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteQuickConnect.html">DeleteQuickConnect</a>
     * to delete any records related to the deleted users. This will help you:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Avoid dangling resources that impact your service quotas.
     * </p>
     * </li>
     * <li>
     * <p>
     * Remove deleted users so they don't appear to agents as transfer options.
     * </p>
     * </li>
     * <li>
     * <p>
     * Avoid the disruption of other Amazon Connect processes, such as instance replication and syncing if you're using
     * <a href="https://docs.aws.amazon.com/connect/latest/adminguide/setup-connect-global-resiliency.html">Amazon
     * Connect Global Resiliency</a>.
     * </p>
     * </li>
     * </ul>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteUserRequest#builder()}
     * </p>
     *
     * @param deleteUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeleteUserRequest.Builder} to create a request.
     * @return Result of the DeleteUser operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteUserResponse deleteUser(Consumer<DeleteUserRequest.Builder> deleteUserRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return deleteUser(DeleteUserRequest.builder().applyMutation(deleteUserRequest).build());
    }

    /**
     * <p>
     * Deletes an existing user hierarchy group. It must not be associated with any agents or have any active child
     * groups.
     * </p>
     *
     * @param deleteUserHierarchyGroupRequest
     * @return Result of the DeleteUserHierarchyGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceInUseException
     *         That resource is already in use. Please try another.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteUserHierarchyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteUserHierarchyGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteUserHierarchyGroupResponse deleteUserHierarchyGroup(
            DeleteUserHierarchyGroupRequest deleteUserHierarchyGroupRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ResourceInUseException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing user hierarchy group. It must not be associated with any agents or have any active child
     * groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserHierarchyGroupRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteUserHierarchyGroupRequest#builder()}
     * </p>
     *
     * @param deleteUserHierarchyGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeleteUserHierarchyGroupRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteUserHierarchyGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceInUseException
     *         That resource is already in use. Please try another.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteUserHierarchyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteUserHierarchyGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteUserHierarchyGroupResponse deleteUserHierarchyGroup(
            Consumer<DeleteUserHierarchyGroupRequest.Builder> deleteUserHierarchyGroupRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ResourceInUseException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return deleteUserHierarchyGroup(DeleteUserHierarchyGroupRequest.builder().applyMutation(deleteUserHierarchyGroupRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the view entirely. It deletes the view and all associated qualifiers (versions and aliases).
     * </p>
     *
     * @param deleteViewRequest
     * @return Result of the DeleteView operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws TooManyRequestsException
     *         Displayed when rate-related API limits are exceeded.
     * @throws ResourceInUseException
     *         That resource is already in use. Please try another.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteView" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteViewResponse deleteView(DeleteViewRequest deleteViewRequest) throws AccessDeniedException,
            InvalidRequestException, InvalidParameterException, ResourceNotFoundException, InternalServiceException,
            TooManyRequestsException, ResourceInUseException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the view entirely. It deletes the view and all associated qualifiers (versions and aliases).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteViewRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteViewRequest#builder()}
     * </p>
     *
     * @param deleteViewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeleteViewRequest.Builder} to create a request.
     * @return Result of the DeleteView operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws TooManyRequestsException
     *         Displayed when rate-related API limits are exceeded.
     * @throws ResourceInUseException
     *         That resource is already in use. Please try another.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteView" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteViewResponse deleteView(Consumer<DeleteViewRequest.Builder> deleteViewRequest) throws AccessDeniedException,
            InvalidRequestException, InvalidParameterException, ResourceNotFoundException, InternalServiceException,
            TooManyRequestsException, ResourceInUseException, AwsServiceException, SdkClientException, ConnectException {
        return deleteView(DeleteViewRequest.builder().applyMutation(deleteViewRequest).build());
    }

    /**
     * <p>
     * Deletes the particular version specified in <code>ViewVersion</code> identifier.
     * </p>
     *
     * @param deleteViewVersionRequest
     * @return Result of the DeleteViewVersion operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws TooManyRequestsException
     *         Displayed when rate-related API limits are exceeded.
     * @throws ResourceInUseException
     *         That resource is already in use. Please try another.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteViewVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteViewVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteViewVersionResponse deleteViewVersion(DeleteViewVersionRequest deleteViewVersionRequest)
            throws AccessDeniedException, InvalidRequestException, InvalidParameterException, ResourceNotFoundException,
            InternalServiceException, TooManyRequestsException, ResourceInUseException, AwsServiceException, SdkClientException,
            ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the particular version specified in <code>ViewVersion</code> identifier.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteViewVersionRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteViewVersionRequest#builder()}
     * </p>
     *
     * @param deleteViewVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeleteViewVersionRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteViewVersion operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws TooManyRequestsException
     *         Displayed when rate-related API limits are exceeded.
     * @throws ResourceInUseException
     *         That resource is already in use. Please try another.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteViewVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteViewVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteViewVersionResponse deleteViewVersion(Consumer<DeleteViewVersionRequest.Builder> deleteViewVersionRequest)
            throws AccessDeniedException, InvalidRequestException, InvalidParameterException, ResourceNotFoundException,
            InternalServiceException, TooManyRequestsException, ResourceInUseException, AwsServiceException, SdkClientException,
            ConnectException {
        return deleteViewVersion(DeleteViewVersionRequest.builder().applyMutation(deleteViewVersionRequest).build());
    }

    /**
     * <p>
     * Deletes the vocabulary that has the given identifier.
     * </p>
     *
     * @param deleteVocabularyRequest
     * @return Result of the DeleteVocabulary operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ResourceInUseException
     *         That resource is already in use. Please try another.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteVocabulary" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteVocabularyResponse deleteVocabulary(DeleteVocabularyRequest deleteVocabularyRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalServiceException, ThrottlingException,
            AccessDeniedException, ResourceInUseException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the vocabulary that has the given identifier.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVocabularyRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteVocabularyRequest#builder()}
     * </p>
     *
     * @param deleteVocabularyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DeleteVocabularyRequest.Builder} to create a request.
     * @return Result of the DeleteVocabulary operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ResourceInUseException
     *         That resource is already in use. Please try another.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteVocabulary" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteVocabularyResponse deleteVocabulary(Consumer<DeleteVocabularyRequest.Builder> deleteVocabularyRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalServiceException, ThrottlingException,
            AccessDeniedException, ResourceInUseException, AwsServiceException, SdkClientException, ConnectException {
        return deleteVocabulary(DeleteVocabularyRequest.builder().applyMutation(deleteVocabularyRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Describes an agent status.
     * </p>
     *
     * @param describeAgentStatusRequest
     * @return Result of the DescribeAgentStatus operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeAgentStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeAgentStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAgentStatusResponse describeAgentStatus(DescribeAgentStatusRequest describeAgentStatusRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Describes an agent status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAgentStatusRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeAgentStatusRequest#builder()}
     * </p>
     *
     * @param describeAgentStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribeAgentStatusRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeAgentStatus operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeAgentStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeAgentStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAgentStatusResponse describeAgentStatus(
            Consumer<DescribeAgentStatusRequest.Builder> describeAgentStatusRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return describeAgentStatus(DescribeAgentStatusRequest.builder().applyMutation(describeAgentStatusRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Describes the specified contact.
     * </p>
     * <important>
     * <p>
     * Contact information remains available in Amazon Connect for 24 months, and then it is deleted.
     * </p>
     * <p>
     * Only data from November 12, 2021, and later is returned by this API.
     * </p>
     * </important>
     *
     * @param describeContactRequest
     * @return Result of the DescribeContact operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeContact" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeContactResponse describeContact(DescribeContactRequest describeContactRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, InternalServiceException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Describes the specified contact.
     * </p>
     * <important>
     * <p>
     * Contact information remains available in Amazon Connect for 24 months, and then it is deleted.
     * </p>
     * <p>
     * Only data from November 12, 2021, and later is returned by this API.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeContactRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeContactRequest#builder()}
     * </p>
     *
     * @param describeContactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribeContactRequest.Builder} to create a request.
     * @return Result of the DescribeContact operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeContact" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeContactResponse describeContact(Consumer<DescribeContactRequest.Builder> describeContactRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, InternalServiceException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return describeContact(DescribeContactRequest.builder().applyMutation(describeContactRequest).build());
    }

    /**
     * <p>
     * Describes a contact evaluation in the specified Amazon Connect instance.
     * </p>
     *
     * @param describeContactEvaluationRequest
     * @return Result of the DescribeContactEvaluation operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeContactEvaluation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeContactEvaluation"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeContactEvaluationResponse describeContactEvaluation(
            DescribeContactEvaluationRequest describeContactEvaluationRequest) throws InvalidParameterException,
            ResourceNotFoundException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException,
            ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a contact evaluation in the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeContactEvaluationRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeContactEvaluationRequest#builder()}
     * </p>
     *
     * @param describeContactEvaluationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribeContactEvaluationRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeContactEvaluation operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeContactEvaluation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeContactEvaluation"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeContactEvaluationResponse describeContactEvaluation(
            Consumer<DescribeContactEvaluationRequest.Builder> describeContactEvaluationRequest)
            throws InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return describeContactEvaluation(DescribeContactEvaluationRequest.builder()
                .applyMutation(describeContactEvaluationRequest).build());
    }

    /**
     * <p>
     * Describes the specified flow.
     * </p>
     * <p>
     * You can also create and update flows using the <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/flow-language.html">Amazon Connect Flow
     * language</a>.
     * </p>
     * <p>
     * Use the <code>&#36SAVED</code> alias in the request to describe the <code>SAVED</code> content of a Flow. For
     * example, <code>arn:aws:.../contact-flow/{id}:&#36SAVED</code>. Once a contact flow is published,
     * <code>&#36SAVED</code> needs to be supplied to view saved content that has not been published.
     * </p>
     * <p>
     * In the response, <b>Status</b> indicates the flow status as either <code>SAVED</code> or <code>PUBLISHED</code>.
     * The <code>PUBLISHED</code> status will initiate validation on the content. <code>SAVED</code> does not initiate
     * validation of the content. <code>SAVED</code> | <code>PUBLISHED</code>
     * </p>
     *
     * @param describeContactFlowRequest
     * @return Result of the DescribeContactFlow operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ContactFlowNotPublishedException
     *         The flow has not been published.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeContactFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeContactFlow" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeContactFlowResponse describeContactFlow(DescribeContactFlowRequest describeContactFlowRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException,
            ContactFlowNotPublishedException, ThrottlingException, InternalServiceException, AwsServiceException,
            SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified flow.
     * </p>
     * <p>
     * You can also create and update flows using the <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/flow-language.html">Amazon Connect Flow
     * language</a>.
     * </p>
     * <p>
     * Use the <code>&#36SAVED</code> alias in the request to describe the <code>SAVED</code> content of a Flow. For
     * example, <code>arn:aws:.../contact-flow/{id}:&#36SAVED</code>. Once a contact flow is published,
     * <code>&#36SAVED</code> needs to be supplied to view saved content that has not been published.
     * </p>
     * <p>
     * In the response, <b>Status</b> indicates the flow status as either <code>SAVED</code> or <code>PUBLISHED</code>.
     * The <code>PUBLISHED</code> status will initiate validation on the content. <code>SAVED</code> does not initiate
     * validation of the content. <code>SAVED</code> | <code>PUBLISHED</code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeContactFlowRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeContactFlowRequest#builder()}
     * </p>
     *
     * @param describeContactFlowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribeContactFlowRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeContactFlow operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ContactFlowNotPublishedException
     *         The flow has not been published.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeContactFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeContactFlow" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeContactFlowResponse describeContactFlow(
            Consumer<DescribeContactFlowRequest.Builder> describeContactFlowRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ContactFlowNotPublishedException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return describeContactFlow(DescribeContactFlowRequest.builder().applyMutation(describeContactFlowRequest).build());
    }

    /**
     * <p>
     * Describes the specified flow module.
     * </p>
     * <p>
     * Use the <code>&#36SAVED</code> alias in the request to describe the <code>SAVED</code> content of a Flow. For
     * example, <code>arn:aws:.../contact-flow/{id}:&#36SAVED</code>. Once a contact flow is published,
     * <code>&#36SAVED</code> needs to be supplied to view saved content that has not been published.
     * </p>
     *
     * @param describeContactFlowModuleRequest
     * @return Result of the DescribeContactFlowModule operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeContactFlowModule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeContactFlowModule"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeContactFlowModuleResponse describeContactFlowModule(
            DescribeContactFlowModuleRequest describeContactFlowModuleRequest) throws AccessDeniedException,
            InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified flow module.
     * </p>
     * <p>
     * Use the <code>&#36SAVED</code> alias in the request to describe the <code>SAVED</code> content of a Flow. For
     * example, <code>arn:aws:.../contact-flow/{id}:&#36SAVED</code>. Once a contact flow is published,
     * <code>&#36SAVED</code> needs to be supplied to view saved content that has not been published.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeContactFlowModuleRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeContactFlowModuleRequest#builder()}
     * </p>
     *
     * @param describeContactFlowModuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribeContactFlowModuleRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeContactFlowModule operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeContactFlowModule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeContactFlowModule"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeContactFlowModuleResponse describeContactFlowModule(
            Consumer<DescribeContactFlowModuleRequest.Builder> describeContactFlowModuleRequest) throws AccessDeniedException,
            InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return describeContactFlowModule(DescribeContactFlowModuleRequest.builder()
                .applyMutation(describeContactFlowModuleRequest).build());
    }

    /**
     * <p>
     * Describes an evaluation form in the specified Amazon Connect instance. If the version property is not provided,
     * the latest version of the evaluation form is described.
     * </p>
     *
     * @param describeEvaluationFormRequest
     * @return Result of the DescribeEvaluationForm operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeEvaluationForm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeEvaluationForm"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEvaluationFormResponse describeEvaluationForm(DescribeEvaluationFormRequest describeEvaluationFormRequest)
            throws InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an evaluation form in the specified Amazon Connect instance. If the version property is not provided,
     * the latest version of the evaluation form is described.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEvaluationFormRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeEvaluationFormRequest#builder()}
     * </p>
     *
     * @param describeEvaluationFormRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribeEvaluationFormRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeEvaluationForm operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeEvaluationForm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeEvaluationForm"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEvaluationFormResponse describeEvaluationForm(
            Consumer<DescribeEvaluationFormRequest.Builder> describeEvaluationFormRequest) throws InvalidParameterException,
            ResourceNotFoundException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException,
            ConnectException {
        return describeEvaluationForm(DescribeEvaluationFormRequest.builder().applyMutation(describeEvaluationFormRequest)
                .build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Describes the hours of operation.
     * </p>
     *
     * @param describeHoursOfOperationRequest
     * @return Result of the DescribeHoursOfOperation operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeHoursOfOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeHoursOfOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeHoursOfOperationResponse describeHoursOfOperation(
            DescribeHoursOfOperationRequest describeHoursOfOperationRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Describes the hours of operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeHoursOfOperationRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeHoursOfOperationRequest#builder()}
     * </p>
     *
     * @param describeHoursOfOperationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribeHoursOfOperationRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeHoursOfOperation operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeHoursOfOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeHoursOfOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeHoursOfOperationResponse describeHoursOfOperation(
            Consumer<DescribeHoursOfOperationRequest.Builder> describeHoursOfOperationRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return describeHoursOfOperation(DescribeHoursOfOperationRequest.builder().applyMutation(describeHoursOfOperationRequest)
                .build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Returns the current state of the specified instance identifier. It tracks the instance while it is being created
     * and returns an error status, if applicable.
     * </p>
     * <p>
     * If an instance is not created successfully, the instance status reason field returns details relevant to the
     * reason. The instance in a failed state is returned only for 24 hours after the CreateInstance API was invoked.
     * </p>
     *
     * @param describeInstanceRequest
     * @return Result of the DescribeInstance operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeInstanceResponse describeInstance(DescribeInstanceRequest describeInstanceRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalServiceException, AwsServiceException,
            SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Returns the current state of the specified instance identifier. It tracks the instance while it is being created
     * and returns an error status, if applicable.
     * </p>
     * <p>
     * If an instance is not created successfully, the instance status reason field returns details relevant to the
     * reason. The instance in a failed state is returned only for 24 hours after the CreateInstance API was invoked.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInstanceRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeInstanceRequest#builder()}
     * </p>
     *
     * @param describeInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribeInstanceRequest.Builder} to create a request.
     * @return Result of the DescribeInstance operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeInstanceResponse describeInstance(Consumer<DescribeInstanceRequest.Builder> describeInstanceRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalServiceException, AwsServiceException,
            SdkClientException, ConnectException {
        return describeInstance(DescribeInstanceRequest.builder().applyMutation(describeInstanceRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Describes the specified instance attribute.
     * </p>
     *
     * @param describeInstanceAttributeRequest
     * @return Result of the DescribeInstanceAttribute operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeInstanceAttribute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeInstanceAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInstanceAttributeResponse describeInstanceAttribute(
            DescribeInstanceAttributeRequest describeInstanceAttributeRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, InvalidParameterException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Describes the specified instance attribute.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInstanceAttributeRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeInstanceAttributeRequest#builder()}
     * </p>
     *
     * @param describeInstanceAttributeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribeInstanceAttributeRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeInstanceAttribute operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeInstanceAttribute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeInstanceAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInstanceAttributeResponse describeInstanceAttribute(
            Consumer<DescribeInstanceAttributeRequest.Builder> describeInstanceAttributeRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return describeInstanceAttribute(DescribeInstanceAttributeRequest.builder()
                .applyMutation(describeInstanceAttributeRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Retrieves the current storage configurations for the specified resource type, association ID, and instance ID.
     * </p>
     *
     * @param describeInstanceStorageConfigRequest
     * @return Result of the DescribeInstanceStorageConfig operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeInstanceStorageConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeInstanceStorageConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInstanceStorageConfigResponse describeInstanceStorageConfig(
            DescribeInstanceStorageConfigRequest describeInstanceStorageConfigRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, InvalidParameterException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Retrieves the current storage configurations for the specified resource type, association ID, and instance ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInstanceStorageConfigRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeInstanceStorageConfigRequest#builder()}
     * </p>
     *
     * @param describeInstanceStorageConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribeInstanceStorageConfigRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeInstanceStorageConfig operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeInstanceStorageConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeInstanceStorageConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInstanceStorageConfigResponse describeInstanceStorageConfig(
            Consumer<DescribeInstanceStorageConfigRequest.Builder> describeInstanceStorageConfigRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return describeInstanceStorageConfig(DescribeInstanceStorageConfigRequest.builder()
                .applyMutation(describeInstanceStorageConfigRequest).build());
    }

    /**
     * <p>
     * Gets details and status of a phone number that’s claimed to your Amazon Connect instance or traffic distribution
     * group.
     * </p>
     * <important>
     * <p>
     * If the number is claimed to a traffic distribution group, and you are calling in the Amazon Web Services Region
     * where the traffic distribution group was created, you can use either a phone number ARN or UUID value for the
     * <code>PhoneNumberId</code> URI request parameter. However, if the number is claimed to a traffic distribution
     * group and you are calling this API in the alternate Amazon Web Services Region associated with the traffic
     * distribution group, you must provide a full phone number ARN. If a UUID is provided in this scenario, you will
     * receive a <code>ResourceNotFoundException</code>.
     * </p>
     * </important>
     *
     * @param describePhoneNumberRequest
     * @return Result of the DescribePhoneNumber operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribePhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribePhoneNumber" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribePhoneNumberResponse describePhoneNumber(DescribePhoneNumberRequest describePhoneNumberRequest)
            throws InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AccessDeniedException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details and status of a phone number that’s claimed to your Amazon Connect instance or traffic distribution
     * group.
     * </p>
     * <important>
     * <p>
     * If the number is claimed to a traffic distribution group, and you are calling in the Amazon Web Services Region
     * where the traffic distribution group was created, you can use either a phone number ARN or UUID value for the
     * <code>PhoneNumberId</code> URI request parameter. However, if the number is claimed to a traffic distribution
     * group and you are calling this API in the alternate Amazon Web Services Region associated with the traffic
     * distribution group, you must provide a full phone number ARN. If a UUID is provided in this scenario, you will
     * receive a <code>ResourceNotFoundException</code>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePhoneNumberRequest.Builder} avoiding the
     * need to create one manually via {@link DescribePhoneNumberRequest#builder()}
     * </p>
     *
     * @param describePhoneNumberRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribePhoneNumberRequest.Builder} to create a
     *        request.
     * @return Result of the DescribePhoneNumber operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribePhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribePhoneNumber" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribePhoneNumberResponse describePhoneNumber(
            Consumer<DescribePhoneNumberRequest.Builder> describePhoneNumberRequest) throws InvalidParameterException,
            ResourceNotFoundException, ThrottlingException, InternalServiceException, AccessDeniedException, AwsServiceException,
            SdkClientException, ConnectException {
        return describePhoneNumber(DescribePhoneNumberRequest.builder().applyMutation(describePhoneNumberRequest).build());
    }

    /**
     * <p>
     * Describes a predefined attribute for the specified Amazon Connect instance.
     * </p>
     *
     * @param describePredefinedAttributeRequest
     * @return Result of the DescribePredefinedAttribute operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribePredefinedAttribute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribePredefinedAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePredefinedAttributeResponse describePredefinedAttribute(
            DescribePredefinedAttributeRequest describePredefinedAttributeRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a predefined attribute for the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePredefinedAttributeRequest.Builder}
     * avoiding the need to create one manually via {@link DescribePredefinedAttributeRequest#builder()}
     * </p>
     *
     * @param describePredefinedAttributeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribePredefinedAttributeRequest.Builder} to create
     *        a request.
     * @return Result of the DescribePredefinedAttribute operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribePredefinedAttribute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribePredefinedAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePredefinedAttributeResponse describePredefinedAttribute(
            Consumer<DescribePredefinedAttributeRequest.Builder> describePredefinedAttributeRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return describePredefinedAttribute(DescribePredefinedAttributeRequest.builder()
                .applyMutation(describePredefinedAttributeRequest).build());
    }

    /**
     * <p>
     * Describes the prompt.
     * </p>
     *
     * @param describePromptRequest
     * @return Result of the DescribePrompt operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribePrompt
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribePrompt" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribePromptResponse describePrompt(DescribePromptRequest describePromptRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the prompt.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePromptRequest.Builder} avoiding the need to
     * create one manually via {@link DescribePromptRequest#builder()}
     * </p>
     *
     * @param describePromptRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribePromptRequest.Builder} to create a request.
     * @return Result of the DescribePrompt operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribePrompt
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribePrompt" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribePromptResponse describePrompt(Consumer<DescribePromptRequest.Builder> describePromptRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return describePrompt(DescribePromptRequest.builder().applyMutation(describePromptRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Describes the specified queue.
     * </p>
     *
     * @param describeQueueRequest
     * @return Result of the DescribeQueue operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeQueueResponse describeQueue(DescribeQueueRequest describeQueueRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Describes the specified queue.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeQueueRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeQueueRequest#builder()}
     * </p>
     *
     * @param describeQueueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribeQueueRequest.Builder} to create a request.
     * @return Result of the DescribeQueue operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeQueueResponse describeQueue(Consumer<DescribeQueueRequest.Builder> describeQueueRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return describeQueue(DescribeQueueRequest.builder().applyMutation(describeQueueRequest).build());
    }

    /**
     * <p>
     * Describes the quick connect.
     * </p>
     *
     * @param describeQuickConnectRequest
     * @return Result of the DescribeQuickConnect operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeQuickConnect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeQuickConnect" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeQuickConnectResponse describeQuickConnect(DescribeQuickConnectRequest describeQuickConnectRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the quick connect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeQuickConnectRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeQuickConnectRequest#builder()}
     * </p>
     *
     * @param describeQuickConnectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribeQuickConnectRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeQuickConnect operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeQuickConnect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeQuickConnect" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeQuickConnectResponse describeQuickConnect(
            Consumer<DescribeQuickConnectRequest.Builder> describeQuickConnectRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return describeQuickConnect(DescribeQuickConnectRequest.builder().applyMutation(describeQuickConnectRequest).build());
    }

    /**
     * <p>
     * Describes the specified routing profile.
     * </p>
     *
     * @param describeRoutingProfileRequest
     * @return Result of the DescribeRoutingProfile operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeRoutingProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeRoutingProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRoutingProfileResponse describeRoutingProfile(DescribeRoutingProfileRequest describeRoutingProfileRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified routing profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRoutingProfileRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeRoutingProfileRequest#builder()}
     * </p>
     *
     * @param describeRoutingProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribeRoutingProfileRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeRoutingProfile operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeRoutingProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeRoutingProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRoutingProfileResponse describeRoutingProfile(
            Consumer<DescribeRoutingProfileRequest.Builder> describeRoutingProfileRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return describeRoutingProfile(DescribeRoutingProfileRequest.builder().applyMutation(describeRoutingProfileRequest)
                .build());
    }

    /**
     * <p>
     * Describes a rule for the specified Amazon Connect instance.
     * </p>
     *
     * @param describeRuleRequest
     * @return Result of the DescribeRule operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeRule" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeRuleResponse describeRule(DescribeRuleRequest describeRuleRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalServiceException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a rule for the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRuleRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeRuleRequest#builder()}
     * </p>
     *
     * @param describeRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribeRuleRequest.Builder} to create a request.
     * @return Result of the DescribeRule operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeRule" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeRuleResponse describeRule(Consumer<DescribeRuleRequest.Builder> describeRuleRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalServiceException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, ConnectException {
        return describeRule(DescribeRuleRequest.builder().applyMutation(describeRuleRequest).build());
    }

    /**
     * <p>
     * Gets basic information about the security profle.
     * </p>
     *
     * @param describeSecurityProfileRequest
     * @return Result of the DescribeSecurityProfile operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeSecurityProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeSecurityProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSecurityProfileResponse describeSecurityProfile(DescribeSecurityProfileRequest describeSecurityProfileRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets basic information about the security profle.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSecurityProfileRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeSecurityProfileRequest#builder()}
     * </p>
     *
     * @param describeSecurityProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribeSecurityProfileRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeSecurityProfile operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeSecurityProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeSecurityProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSecurityProfileResponse describeSecurityProfile(
            Consumer<DescribeSecurityProfileRequest.Builder> describeSecurityProfileRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return describeSecurityProfile(DescribeSecurityProfileRequest.builder().applyMutation(describeSecurityProfileRequest)
                .build());
    }

    /**
     * <p>
     * Gets details and status of a traffic distribution group.
     * </p>
     *
     * @param describeTrafficDistributionGroupRequest
     * @return Result of the DescribeTrafficDistributionGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeTrafficDistributionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeTrafficDistributionGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTrafficDistributionGroupResponse describeTrafficDistributionGroup(
            DescribeTrafficDistributionGroupRequest describeTrafficDistributionGroupRequest) throws InvalidRequestException,
            AccessDeniedException, ResourceNotFoundException, InternalServiceException, ThrottlingException, AwsServiceException,
            SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details and status of a traffic distribution group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTrafficDistributionGroupRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeTrafficDistributionGroupRequest#builder()}
     * </p>
     *
     * @param describeTrafficDistributionGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribeTrafficDistributionGroupRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeTrafficDistributionGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeTrafficDistributionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeTrafficDistributionGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTrafficDistributionGroupResponse describeTrafficDistributionGroup(
            Consumer<DescribeTrafficDistributionGroupRequest.Builder> describeTrafficDistributionGroupRequest)
            throws InvalidRequestException, AccessDeniedException, ResourceNotFoundException, InternalServiceException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return describeTrafficDistributionGroup(DescribeTrafficDistributionGroupRequest.builder()
                .applyMutation(describeTrafficDistributionGroupRequest).build());
    }

    /**
     * <p>
     * Describes the specified user. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID in the
     * Amazon Connect console</a> (it’s the final part of the ARN). The console does not display the user IDs. Instead,
     * list the users and note the IDs provided in the output.
     * </p>
     *
     * @param describeUserRequest
     * @return Result of the DescribeUser operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeUser" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeUserResponse describeUser(DescribeUserRequest describeUserRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified user. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID in the
     * Amazon Connect console</a> (it’s the final part of the ARN). The console does not display the user IDs. Instead,
     * list the users and note the IDs provided in the output.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUserRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeUserRequest#builder()}
     * </p>
     *
     * @param describeUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribeUserRequest.Builder} to create a request.
     * @return Result of the DescribeUser operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeUser" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeUserResponse describeUser(Consumer<DescribeUserRequest.Builder> describeUserRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return describeUser(DescribeUserRequest.builder().applyMutation(describeUserRequest).build());
    }

    /**
     * <p>
     * Describes the specified hierarchy group.
     * </p>
     *
     * @param describeUserHierarchyGroupRequest
     * @return Result of the DescribeUserHierarchyGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeUserHierarchyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeUserHierarchyGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeUserHierarchyGroupResponse describeUserHierarchyGroup(
            DescribeUserHierarchyGroupRequest describeUserHierarchyGroupRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified hierarchy group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUserHierarchyGroupRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeUserHierarchyGroupRequest#builder()}
     * </p>
     *
     * @param describeUserHierarchyGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribeUserHierarchyGroupRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeUserHierarchyGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeUserHierarchyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeUserHierarchyGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeUserHierarchyGroupResponse describeUserHierarchyGroup(
            Consumer<DescribeUserHierarchyGroupRequest.Builder> describeUserHierarchyGroupRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return describeUserHierarchyGroup(DescribeUserHierarchyGroupRequest.builder()
                .applyMutation(describeUserHierarchyGroupRequest).build());
    }

    /**
     * <p>
     * Describes the hierarchy structure of the specified Amazon Connect instance.
     * </p>
     *
     * @param describeUserHierarchyStructureRequest
     * @return Result of the DescribeUserHierarchyStructure operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeUserHierarchyStructure
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeUserHierarchyStructure"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeUserHierarchyStructureResponse describeUserHierarchyStructure(
            DescribeUserHierarchyStructureRequest describeUserHierarchyStructureRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the hierarchy structure of the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUserHierarchyStructureRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeUserHierarchyStructureRequest#builder()}
     * </p>
     *
     * @param describeUserHierarchyStructureRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribeUserHierarchyStructureRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeUserHierarchyStructure operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeUserHierarchyStructure
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeUserHierarchyStructure"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeUserHierarchyStructureResponse describeUserHierarchyStructure(
            Consumer<DescribeUserHierarchyStructureRequest.Builder> describeUserHierarchyStructureRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return describeUserHierarchyStructure(DescribeUserHierarchyStructureRequest.builder()
                .applyMutation(describeUserHierarchyStructureRequest).build());
    }

    /**
     * <p>
     * Retrieves the view for the specified Amazon Connect instance and view identifier.
     * </p>
     * <p>
     * The view identifier can be supplied as a ViewId or ARN.
     * </p>
     * <p>
     * <code>&#36SAVED</code> needs to be supplied if a view is unpublished.
     * </p>
     * <p>
     * The view identifier can contain an optional qualifier, for example, <code>&lt;view-id&gt;:&#36SAVED</code>, which
     * is either an actual version number or an Amazon Connect managed qualifier <code>&#36SAVED | &#36LATEST</code>. If
     * it is not supplied, then <code>&#36LATEST</code> is assumed for customer managed views and an error is returned
     * if there is no published content available. Version 1 is assumed for Amazon Web Services managed views.
     * </p>
     *
     * @param describeViewRequest
     * @return Result of the DescribeView operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws TooManyRequestsException
     *         Displayed when rate-related API limits are exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeView" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeViewResponse describeView(DescribeViewRequest describeViewRequest) throws AccessDeniedException,
            InvalidRequestException, InvalidParameterException, ResourceNotFoundException, InternalServiceException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the view for the specified Amazon Connect instance and view identifier.
     * </p>
     * <p>
     * The view identifier can be supplied as a ViewId or ARN.
     * </p>
     * <p>
     * <code>&#36SAVED</code> needs to be supplied if a view is unpublished.
     * </p>
     * <p>
     * The view identifier can contain an optional qualifier, for example, <code>&lt;view-id&gt;:&#36SAVED</code>, which
     * is either an actual version number or an Amazon Connect managed qualifier <code>&#36SAVED | &#36LATEST</code>. If
     * it is not supplied, then <code>&#36LATEST</code> is assumed for customer managed views and an error is returned
     * if there is no published content available. Version 1 is assumed for Amazon Web Services managed views.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeViewRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeViewRequest#builder()}
     * </p>
     *
     * @param describeViewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribeViewRequest.Builder} to create a request.
     * @return Result of the DescribeView operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws TooManyRequestsException
     *         Displayed when rate-related API limits are exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeView" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeViewResponse describeView(Consumer<DescribeViewRequest.Builder> describeViewRequest)
            throws AccessDeniedException, InvalidRequestException, InvalidParameterException, ResourceNotFoundException,
            InternalServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, ConnectException {
        return describeView(DescribeViewRequest.builder().applyMutation(describeViewRequest).build());
    }

    /**
     * <p>
     * Describes the specified vocabulary.
     * </p>
     *
     * @param describeVocabularyRequest
     * @return Result of the DescribeVocabulary operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeVocabulary" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeVocabularyResponse describeVocabulary(DescribeVocabularyRequest describeVocabularyRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalServiceException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified vocabulary.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeVocabularyRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeVocabularyRequest#builder()}
     * </p>
     *
     * @param describeVocabularyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DescribeVocabularyRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeVocabulary operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DescribeVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeVocabulary" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeVocabularyResponse describeVocabulary(Consumer<DescribeVocabularyRequest.Builder> describeVocabularyRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalServiceException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, ConnectException {
        return describeVocabulary(DescribeVocabularyRequest.builder().applyMutation(describeVocabularyRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Removes the dataset ID associated with a given Amazon Connect instance.
     * </p>
     *
     * @param disassociateAnalyticsDataSetRequest
     * @return Result of the DisassociateAnalyticsDataSet operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DisassociateAnalyticsDataSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateAnalyticsDataSet"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateAnalyticsDataSetResponse disassociateAnalyticsDataSet(
            DisassociateAnalyticsDataSetRequest disassociateAnalyticsDataSetRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Removes the dataset ID associated with a given Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateAnalyticsDataSetRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateAnalyticsDataSetRequest#builder()}
     * </p>
     *
     * @param disassociateAnalyticsDataSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DisassociateAnalyticsDataSetRequest.Builder} to
     *        create a request.
     * @return Result of the DisassociateAnalyticsDataSet operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DisassociateAnalyticsDataSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateAnalyticsDataSet"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateAnalyticsDataSetResponse disassociateAnalyticsDataSet(
            Consumer<DisassociateAnalyticsDataSetRequest.Builder> disassociateAnalyticsDataSetRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return disassociateAnalyticsDataSet(DisassociateAnalyticsDataSetRequest.builder()
                .applyMutation(disassociateAnalyticsDataSetRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Revokes access to integrated applications from Amazon Connect.
     * </p>
     *
     * @param disassociateApprovedOriginRequest
     * @return Result of the DisassociateApprovedOrigin operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DisassociateApprovedOrigin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateApprovedOrigin"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateApprovedOriginResponse disassociateApprovedOrigin(
            DisassociateApprovedOriginRequest disassociateApprovedOriginRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, InvalidParameterException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Revokes access to integrated applications from Amazon Connect.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateApprovedOriginRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateApprovedOriginRequest#builder()}
     * </p>
     *
     * @param disassociateApprovedOriginRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DisassociateApprovedOriginRequest.Builder} to create
     *        a request.
     * @return Result of the DisassociateApprovedOrigin operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DisassociateApprovedOrigin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateApprovedOrigin"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateApprovedOriginResponse disassociateApprovedOrigin(
            Consumer<DisassociateApprovedOriginRequest.Builder> disassociateApprovedOriginRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return disassociateApprovedOrigin(DisassociateApprovedOriginRequest.builder()
                .applyMutation(disassociateApprovedOriginRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Revokes authorization from the specified instance to access the specified Amazon Lex or Amazon Lex V2 bot.
     * </p>
     *
     * @param disassociateBotRequest
     * @return Result of the DisassociateBot operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DisassociateBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateBot" target="_top">AWS API
     *      Documentation</a>
     */
    default DisassociateBotResponse disassociateBot(DisassociateBotRequest disassociateBotRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Revokes authorization from the specified instance to access the specified Amazon Lex or Amazon Lex V2 bot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateBotRequest.Builder} avoiding the need
     * to create one manually via {@link DisassociateBotRequest#builder()}
     * </p>
     *
     * @param disassociateBotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DisassociateBotRequest.Builder} to create a request.
     * @return Result of the DisassociateBot operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DisassociateBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateBot" target="_top">AWS API
     *      Documentation</a>
     */
    default DisassociateBotResponse disassociateBot(Consumer<DisassociateBotRequest.Builder> disassociateBotRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        return disassociateBot(DisassociateBotRequest.builder().applyMutation(disassociateBotRequest).build());
    }

    /**
     * <p>
     * Disassociates a connect resource from a flow.
     * </p>
     *
     * @param disassociateFlowRequest
     * @return Result of the DisassociateFlow operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DisassociateFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default DisassociateFlowResponse disassociateFlow(DisassociateFlowRequest disassociateFlowRequest)
            throws AccessDeniedException, ResourceNotFoundException, InternalServiceException, InvalidRequestException,
            InvalidParameterException, ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a connect resource from a flow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateFlowRequest.Builder} avoiding the need
     * to create one manually via {@link DisassociateFlowRequest#builder()}
     * </p>
     *
     * @param disassociateFlowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DisassociateFlowRequest.Builder} to create a request.
     * @return Result of the DisassociateFlow operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DisassociateFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateFlow" target="_top">AWS API
     *      Documentation</a>
     */
    default DisassociateFlowResponse disassociateFlow(Consumer<DisassociateFlowRequest.Builder> disassociateFlowRequest)
            throws AccessDeniedException, ResourceNotFoundException, InternalServiceException, InvalidRequestException,
            InvalidParameterException, ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return disassociateFlow(DisassociateFlowRequest.builder().applyMutation(disassociateFlowRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Removes the storage type configurations for the specified resource type and association ID.
     * </p>
     *
     * @param disassociateInstanceStorageConfigRequest
     * @return Result of the DisassociateInstanceStorageConfig operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DisassociateInstanceStorageConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateInstanceStorageConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateInstanceStorageConfigResponse disassociateInstanceStorageConfig(
            DisassociateInstanceStorageConfigRequest disassociateInstanceStorageConfigRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, InvalidParameterException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Removes the storage type configurations for the specified resource type and association ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateInstanceStorageConfigRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateInstanceStorageConfigRequest#builder()}
     * </p>
     *
     * @param disassociateInstanceStorageConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DisassociateInstanceStorageConfigRequest.Builder} to
     *        create a request.
     * @return Result of the DisassociateInstanceStorageConfig operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DisassociateInstanceStorageConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateInstanceStorageConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateInstanceStorageConfigResponse disassociateInstanceStorageConfig(
            Consumer<DisassociateInstanceStorageConfigRequest.Builder> disassociateInstanceStorageConfigRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return disassociateInstanceStorageConfig(DisassociateInstanceStorageConfigRequest.builder()
                .applyMutation(disassociateInstanceStorageConfigRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Remove the Lambda function from the dropdown options available in the relevant flow blocks.
     * </p>
     *
     * @param disassociateLambdaFunctionRequest
     * @return Result of the DisassociateLambdaFunction operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DisassociateLambdaFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateLambdaFunction"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateLambdaFunctionResponse disassociateLambdaFunction(
            DisassociateLambdaFunctionRequest disassociateLambdaFunctionRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, InvalidParameterException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Remove the Lambda function from the dropdown options available in the relevant flow blocks.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateLambdaFunctionRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateLambdaFunctionRequest#builder()}
     * </p>
     *
     * @param disassociateLambdaFunctionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DisassociateLambdaFunctionRequest.Builder} to create
     *        a request.
     * @return Result of the DisassociateLambdaFunction operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DisassociateLambdaFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateLambdaFunction"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateLambdaFunctionResponse disassociateLambdaFunction(
            Consumer<DisassociateLambdaFunctionRequest.Builder> disassociateLambdaFunctionRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return disassociateLambdaFunction(DisassociateLambdaFunctionRequest.builder()
                .applyMutation(disassociateLambdaFunctionRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Revokes authorization from the specified instance to access the specified Amazon Lex bot.
     * </p>
     *
     * @param disassociateLexBotRequest
     * @return Result of the DisassociateLexBot operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DisassociateLexBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateLexBot" target="_top">AWS
     *      API Documentation</a>
     */
    default DisassociateLexBotResponse disassociateLexBot(DisassociateLexBotRequest disassociateLexBotRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Revokes authorization from the specified instance to access the specified Amazon Lex bot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateLexBotRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateLexBotRequest#builder()}
     * </p>
     *
     * @param disassociateLexBotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DisassociateLexBotRequest.Builder} to create a
     *        request.
     * @return Result of the DisassociateLexBot operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DisassociateLexBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateLexBot" target="_top">AWS
     *      API Documentation</a>
     */
    default DisassociateLexBotResponse disassociateLexBot(Consumer<DisassociateLexBotRequest.Builder> disassociateLexBotRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return disassociateLexBot(DisassociateLexBotRequest.builder().applyMutation(disassociateLexBotRequest).build());
    }

    /**
     * <p>
     * Removes the flow association from a phone number claimed to your Amazon Connect instance.
     * </p>
     * <important>
     * <p>
     * If the number is claimed to a traffic distribution group, and you are calling this API using an instance in the
     * Amazon Web Services Region where the traffic distribution group was created, you can use either a full phone
     * number ARN or UUID value for the <code>PhoneNumberId</code> URI request parameter. However, if the number is
     * claimed to a traffic distribution group and you are calling this API using an instance in the alternate Amazon
     * Web Services Region associated with the traffic distribution group, you must provide a full phone number ARN. If
     * a UUID is provided in this scenario, you will receive a <code>ResourceNotFoundException</code>.
     * </p>
     * </important>
     *
     * @param disassociatePhoneNumberContactFlowRequest
     * @return Result of the DisassociatePhoneNumberContactFlow operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DisassociatePhoneNumberContactFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociatePhoneNumberContactFlow"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociatePhoneNumberContactFlowResponse disassociatePhoneNumberContactFlow(
            DisassociatePhoneNumberContactFlowRequest disassociatePhoneNumberContactFlowRequest)
            throws InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AccessDeniedException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the flow association from a phone number claimed to your Amazon Connect instance.
     * </p>
     * <important>
     * <p>
     * If the number is claimed to a traffic distribution group, and you are calling this API using an instance in the
     * Amazon Web Services Region where the traffic distribution group was created, you can use either a full phone
     * number ARN or UUID value for the <code>PhoneNumberId</code> URI request parameter. However, if the number is
     * claimed to a traffic distribution group and you are calling this API using an instance in the alternate Amazon
     * Web Services Region associated with the traffic distribution group, you must provide a full phone number ARN. If
     * a UUID is provided in this scenario, you will receive a <code>ResourceNotFoundException</code>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociatePhoneNumberContactFlowRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociatePhoneNumberContactFlowRequest#builder()}
     * </p>
     *
     * @param disassociatePhoneNumberContactFlowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DisassociatePhoneNumberContactFlowRequest.Builder} to
     *        create a request.
     * @return Result of the DisassociatePhoneNumberContactFlow operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DisassociatePhoneNumberContactFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociatePhoneNumberContactFlow"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociatePhoneNumberContactFlowResponse disassociatePhoneNumberContactFlow(
            Consumer<DisassociatePhoneNumberContactFlowRequest.Builder> disassociatePhoneNumberContactFlowRequest)
            throws InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AccessDeniedException, AwsServiceException, SdkClientException, ConnectException {
        return disassociatePhoneNumberContactFlow(DisassociatePhoneNumberContactFlowRequest.builder()
                .applyMutation(disassociatePhoneNumberContactFlowRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Disassociates a set of quick connects from a queue.
     * </p>
     *
     * @param disassociateQueueQuickConnectsRequest
     * @return Result of the DisassociateQueueQuickConnects operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DisassociateQueueQuickConnects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateQueueQuickConnects"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateQueueQuickConnectsResponse disassociateQueueQuickConnects(
            DisassociateQueueQuickConnectsRequest disassociateQueueQuickConnectsRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Disassociates a set of quick connects from a queue.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateQueueQuickConnectsRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateQueueQuickConnectsRequest#builder()}
     * </p>
     *
     * @param disassociateQueueQuickConnectsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DisassociateQueueQuickConnectsRequest.Builder} to
     *        create a request.
     * @return Result of the DisassociateQueueQuickConnects operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DisassociateQueueQuickConnects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateQueueQuickConnects"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateQueueQuickConnectsResponse disassociateQueueQuickConnects(
            Consumer<DisassociateQueueQuickConnectsRequest.Builder> disassociateQueueQuickConnectsRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return disassociateQueueQuickConnects(DisassociateQueueQuickConnectsRequest.builder()
                .applyMutation(disassociateQueueQuickConnectsRequest).build());
    }

    /**
     * <p>
     * Disassociates a set of queues from a routing profile.
     * </p>
     *
     * @param disassociateRoutingProfileQueuesRequest
     * @return Result of the DisassociateRoutingProfileQueues operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DisassociateRoutingProfileQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateRoutingProfileQueues"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateRoutingProfileQueuesResponse disassociateRoutingProfileQueues(
            DisassociateRoutingProfileQueuesRequest disassociateRoutingProfileQueuesRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a set of queues from a routing profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateRoutingProfileQueuesRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateRoutingProfileQueuesRequest#builder()}
     * </p>
     *
     * @param disassociateRoutingProfileQueuesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DisassociateRoutingProfileQueuesRequest.Builder} to
     *        create a request.
     * @return Result of the DisassociateRoutingProfileQueues operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DisassociateRoutingProfileQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateRoutingProfileQueues"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateRoutingProfileQueuesResponse disassociateRoutingProfileQueues(
            Consumer<DisassociateRoutingProfileQueuesRequest.Builder> disassociateRoutingProfileQueuesRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return disassociateRoutingProfileQueues(DisassociateRoutingProfileQueuesRequest.builder()
                .applyMutation(disassociateRoutingProfileQueuesRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Deletes the specified security key.
     * </p>
     *
     * @param disassociateSecurityKeyRequest
     * @return Result of the DisassociateSecurityKey operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DisassociateSecurityKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateSecurityKey"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateSecurityKeyResponse disassociateSecurityKey(DisassociateSecurityKeyRequest disassociateSecurityKeyRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Deletes the specified security key.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateSecurityKeyRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateSecurityKeyRequest#builder()}
     * </p>
     *
     * @param disassociateSecurityKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DisassociateSecurityKeyRequest.Builder} to create a
     *        request.
     * @return Result of the DisassociateSecurityKey operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DisassociateSecurityKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateSecurityKey"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateSecurityKeyResponse disassociateSecurityKey(
            Consumer<DisassociateSecurityKeyRequest.Builder> disassociateSecurityKeyRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, InvalidParameterException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        return disassociateSecurityKey(DisassociateSecurityKeyRequest.builder().applyMutation(disassociateSecurityKeyRequest)
                .build());
    }

    /**
     * <p>
     * Disassociates an agent from a traffic distribution group.
     * </p>
     *
     * @param disassociateTrafficDistributionGroupUserRequest
     * @return Result of the DisassociateTrafficDistributionGroupUser operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DisassociateTrafficDistributionGroupUser
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateTrafficDistributionGroupUser"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateTrafficDistributionGroupUserResponse disassociateTrafficDistributionGroupUser(
            DisassociateTrafficDistributionGroupUserRequest disassociateTrafficDistributionGroupUserRequest)
            throws InvalidRequestException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            ResourceConflictException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates an agent from a traffic distribution group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateTrafficDistributionGroupUserRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociateTrafficDistributionGroupUserRequest#builder()}
     * </p>
     *
     * @param disassociateTrafficDistributionGroupUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DisassociateTrafficDistributionGroupUserRequest.Builder}
     *        to create a request.
     * @return Result of the DisassociateTrafficDistributionGroupUser operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DisassociateTrafficDistributionGroupUser
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateTrafficDistributionGroupUser"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateTrafficDistributionGroupUserResponse disassociateTrafficDistributionGroupUser(
            Consumer<DisassociateTrafficDistributionGroupUserRequest.Builder> disassociateTrafficDistributionGroupUserRequest)
            throws InvalidRequestException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            ResourceConflictException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return disassociateTrafficDistributionGroupUser(DisassociateTrafficDistributionGroupUserRequest.builder()
                .applyMutation(disassociateTrafficDistributionGroupUserRequest).build());
    }

    /**
     * <p>
     * Disassociates a set of proficiencies from a user.
     * </p>
     *
     * @param disassociateUserProficienciesRequest
     * @return Result of the DisassociateUserProficiencies operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DisassociateUserProficiencies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateUserProficiencies"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateUserProficienciesResponse disassociateUserProficiencies(
            DisassociateUserProficienciesRequest disassociateUserProficienciesRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a set of proficiencies from a user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateUserProficienciesRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateUserProficienciesRequest#builder()}
     * </p>
     *
     * @param disassociateUserProficienciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DisassociateUserProficienciesRequest.Builder} to
     *        create a request.
     * @return Result of the DisassociateUserProficiencies operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DisassociateUserProficiencies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateUserProficiencies"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateUserProficienciesResponse disassociateUserProficiencies(
            Consumer<DisassociateUserProficienciesRequest.Builder> disassociateUserProficienciesRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return disassociateUserProficiencies(DisassociateUserProficienciesRequest.builder()
                .applyMutation(disassociateUserProficienciesRequest).build());
    }

    /**
     * <p>
     * Dismisses contacts from an agent’s CCP and returns the agent to an available state, which allows the agent to
     * receive a new routed contact. Contacts can only be dismissed if they are in a <code>MISSED</code>,
     * <code>ERROR</code>, <code>ENDED</code>, or <code>REJECTED</code> state in the <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/about-contact-states.html">Agent Event Stream</a>.
     * </p>
     *
     * @param dismissUserContactRequest
     * @return Result of the DismissUserContact operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DismissUserContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DismissUserContact" target="_top">AWS
     *      API Documentation</a>
     */
    default DismissUserContactResponse dismissUserContact(DismissUserContactRequest dismissUserContactRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            AccessDeniedException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Dismisses contacts from an agent’s CCP and returns the agent to an available state, which allows the agent to
     * receive a new routed contact. Contacts can only be dismissed if they are in a <code>MISSED</code>,
     * <code>ERROR</code>, <code>ENDED</code>, or <code>REJECTED</code> state in the <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/about-contact-states.html">Agent Event Stream</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DismissUserContactRequest.Builder} avoiding the
     * need to create one manually via {@link DismissUserContactRequest#builder()}
     * </p>
     *
     * @param dismissUserContactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.DismissUserContactRequest.Builder} to create a
     *        request.
     * @return Result of the DismissUserContact operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DismissUserContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DismissUserContact" target="_top">AWS
     *      API Documentation</a>
     */
    default DismissUserContactResponse dismissUserContact(Consumer<DismissUserContactRequest.Builder> dismissUserContactRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            AccessDeniedException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return dismissUserContact(DismissUserContactRequest.builder().applyMutation(dismissUserContactRequest).build());
    }

    /**
     * <p>
     * Provides a pre-signed URL for download of an approved attached file. This API also returns metadata about the
     * attached file. It will only return a downloadURL if the status of the attached file is <code>APPROVED</code>.
     * </p>
     *
     * @param getAttachedFileRequest
     *        Request to GetAttachedFile API.
     * @return Result of the GetAttachedFile operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.GetAttachedFile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetAttachedFile" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAttachedFileResponse getAttachedFile(GetAttachedFileRequest getAttachedFileRequest) throws AccessDeniedException,
            InvalidRequestException, InternalServiceException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a pre-signed URL for download of an approved attached file. This API also returns metadata about the
     * attached file. It will only return a downloadURL if the status of the attached file is <code>APPROVED</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAttachedFileRequest.Builder} avoiding the need
     * to create one manually via {@link GetAttachedFileRequest#builder()}
     * </p>
     *
     * @param getAttachedFileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.GetAttachedFileRequest.Builder} to create a request.
     *        Request to GetAttachedFile API.
     * @return Result of the GetAttachedFile operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.GetAttachedFile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetAttachedFile" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAttachedFileResponse getAttachedFile(Consumer<GetAttachedFileRequest.Builder> getAttachedFileRequest)
            throws AccessDeniedException, InvalidRequestException, InternalServiceException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return getAttachedFile(GetAttachedFileRequest.builder().applyMutation(getAttachedFileRequest).build());
    }

    /**
     * <p>
     * Retrieves the contact attributes for the specified contact.
     * </p>
     *
     * @param getContactAttributesRequest
     * @return Result of the GetContactAttributes operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.GetContactAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetContactAttributes" target="_top">AWS
     *      API Documentation</a>
     */
    default GetContactAttributesResponse getContactAttributes(GetContactAttributesRequest getContactAttributesRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalServiceException, AwsServiceException,
            SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the contact attributes for the specified contact.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetContactAttributesRequest.Builder} avoiding the
     * need to create one manually via {@link GetContactAttributesRequest#builder()}
     * </p>
     *
     * @param getContactAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.GetContactAttributesRequest.Builder} to create a
     *        request.
     * @return Result of the GetContactAttributes operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.GetContactAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetContactAttributes" target="_top">AWS
     *      API Documentation</a>
     */
    default GetContactAttributesResponse getContactAttributes(
            Consumer<GetContactAttributesRequest.Builder> getContactAttributesRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return getContactAttributes(GetContactAttributesRequest.builder().applyMutation(getContactAttributesRequest).build());
    }

    /**
     * <p>
     * Gets the real-time metric data from the specified Amazon Connect instance.
     * </p>
     * <p>
     * For a description of each metric, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html">Real-time Metrics
     * Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     *
     * @param getCurrentMetricDataRequest
     * @return Result of the GetCurrentMetricData operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.GetCurrentMetricData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetCurrentMetricData" target="_top">AWS
     *      API Documentation</a>
     */
    default GetCurrentMetricDataResponse getCurrentMetricData(GetCurrentMetricDataRequest getCurrentMetricDataRequest)
            throws InvalidRequestException, InvalidParameterException, InternalServiceException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the real-time metric data from the specified Amazon Connect instance.
     * </p>
     * <p>
     * For a description of each metric, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html">Real-time Metrics
     * Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCurrentMetricDataRequest.Builder} avoiding the
     * need to create one manually via {@link GetCurrentMetricDataRequest#builder()}
     * </p>
     *
     * @param getCurrentMetricDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.GetCurrentMetricDataRequest.Builder} to create a
     *        request.
     * @return Result of the GetCurrentMetricData operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.GetCurrentMetricData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetCurrentMetricData" target="_top">AWS
     *      API Documentation</a>
     */
    default GetCurrentMetricDataResponse getCurrentMetricData(
            Consumer<GetCurrentMetricDataRequest.Builder> getCurrentMetricDataRequest) throws InvalidRequestException,
            InvalidParameterException, InternalServiceException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, ConnectException {
        return getCurrentMetricData(GetCurrentMetricDataRequest.builder().applyMutation(getCurrentMetricDataRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getCurrentMetricData(software.amazon.awssdk.services.connect.model.GetCurrentMetricDataRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.GetCurrentMetricDataIterable responses = client.getCurrentMetricDataPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.GetCurrentMetricDataIterable responses = client
     *             .getCurrentMetricDataPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.GetCurrentMetricDataResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.GetCurrentMetricDataIterable responses = client.getCurrentMetricDataPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCurrentMetricData(software.amazon.awssdk.services.connect.model.GetCurrentMetricDataRequest)}
     * operation.</b>
     * </p>
     *
     * @param getCurrentMetricDataRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.GetCurrentMetricData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetCurrentMetricData" target="_top">AWS
     *      API Documentation</a>
     */
    default GetCurrentMetricDataIterable getCurrentMetricDataPaginator(GetCurrentMetricDataRequest getCurrentMetricDataRequest)
            throws InvalidRequestException, InvalidParameterException, InternalServiceException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ConnectException {
        return new GetCurrentMetricDataIterable(this, getCurrentMetricDataRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getCurrentMetricData(software.amazon.awssdk.services.connect.model.GetCurrentMetricDataRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.GetCurrentMetricDataIterable responses = client.getCurrentMetricDataPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.GetCurrentMetricDataIterable responses = client
     *             .getCurrentMetricDataPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.GetCurrentMetricDataResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.GetCurrentMetricDataIterable responses = client.getCurrentMetricDataPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCurrentMetricData(software.amazon.awssdk.services.connect.model.GetCurrentMetricDataRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCurrentMetricDataRequest.Builder} avoiding the
     * need to create one manually via {@link GetCurrentMetricDataRequest#builder()}
     * </p>
     *
     * @param getCurrentMetricDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.GetCurrentMetricDataRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.GetCurrentMetricData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetCurrentMetricData" target="_top">AWS
     *      API Documentation</a>
     */
    default GetCurrentMetricDataIterable getCurrentMetricDataPaginator(
            Consumer<GetCurrentMetricDataRequest.Builder> getCurrentMetricDataRequest) throws InvalidRequestException,
            InvalidParameterException, InternalServiceException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, ConnectException {
        return getCurrentMetricDataPaginator(GetCurrentMetricDataRequest.builder().applyMutation(getCurrentMetricDataRequest)
                .build());
    }

    /**
     * <p>
     * Gets the real-time active user data from the specified Amazon Connect instance.
     * </p>
     *
     * @param getCurrentUserDataRequest
     * @return Result of the GetCurrentUserData operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.GetCurrentUserData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetCurrentUserData" target="_top">AWS
     *      API Documentation</a>
     */
    default GetCurrentUserDataResponse getCurrentUserData(GetCurrentUserDataRequest getCurrentUserDataRequest)
            throws InvalidRequestException, InvalidParameterException, InternalServiceException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the real-time active user data from the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCurrentUserDataRequest.Builder} avoiding the
     * need to create one manually via {@link GetCurrentUserDataRequest#builder()}
     * </p>
     *
     * @param getCurrentUserDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.GetCurrentUserDataRequest.Builder} to create a
     *        request.
     * @return Result of the GetCurrentUserData operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.GetCurrentUserData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetCurrentUserData" target="_top">AWS
     *      API Documentation</a>
     */
    default GetCurrentUserDataResponse getCurrentUserData(Consumer<GetCurrentUserDataRequest.Builder> getCurrentUserDataRequest)
            throws InvalidRequestException, InvalidParameterException, InternalServiceException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ConnectException {
        return getCurrentUserData(GetCurrentUserDataRequest.builder().applyMutation(getCurrentUserDataRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getCurrentUserData(software.amazon.awssdk.services.connect.model.GetCurrentUserDataRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.GetCurrentUserDataIterable responses = client.getCurrentUserDataPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.GetCurrentUserDataIterable responses = client
     *             .getCurrentUserDataPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.GetCurrentUserDataResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.GetCurrentUserDataIterable responses = client.getCurrentUserDataPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCurrentUserData(software.amazon.awssdk.services.connect.model.GetCurrentUserDataRequest)}
     * operation.</b>
     * </p>
     *
     * @param getCurrentUserDataRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.GetCurrentUserData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetCurrentUserData" target="_top">AWS
     *      API Documentation</a>
     */
    default GetCurrentUserDataIterable getCurrentUserDataPaginator(GetCurrentUserDataRequest getCurrentUserDataRequest)
            throws InvalidRequestException, InvalidParameterException, InternalServiceException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ConnectException {
        return new GetCurrentUserDataIterable(this, getCurrentUserDataRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getCurrentUserData(software.amazon.awssdk.services.connect.model.GetCurrentUserDataRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.GetCurrentUserDataIterable responses = client.getCurrentUserDataPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.GetCurrentUserDataIterable responses = client
     *             .getCurrentUserDataPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.GetCurrentUserDataResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.GetCurrentUserDataIterable responses = client.getCurrentUserDataPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCurrentUserData(software.amazon.awssdk.services.connect.model.GetCurrentUserDataRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCurrentUserDataRequest.Builder} avoiding the
     * need to create one manually via {@link GetCurrentUserDataRequest#builder()}
     * </p>
     *
     * @param getCurrentUserDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.GetCurrentUserDataRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.GetCurrentUserData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetCurrentUserData" target="_top">AWS
     *      API Documentation</a>
     */
    default GetCurrentUserDataIterable getCurrentUserDataPaginator(
            Consumer<GetCurrentUserDataRequest.Builder> getCurrentUserDataRequest) throws InvalidRequestException,
            InvalidParameterException, InternalServiceException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, ConnectException {
        return getCurrentUserDataPaginator(GetCurrentUserDataRequest.builder().applyMutation(getCurrentUserDataRequest).build());
    }

    /**
     * <p>
     * Supports SAML sign-in for Amazon Connect. Retrieves a token for federation. The token is for the Amazon Connect
     * user which corresponds to the IAM credentials that were used to invoke this action.
     * </p>
     * <p>
     * For more information about how SAML sign-in works in Amazon Connect, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/configure-saml.html ">Configure SAML with IAM for
     * Amazon Connect in the <i>Amazon Connect Administrator Guide</i>.</a>
     * </p>
     * <note>
     * <p>
     * This API doesn't support root users. If you try to invoke GetFederationToken with root credentials, an error
     * message similar to the following one appears:
     * </p>
     * <p>
     * <code>Provided identity: Principal: .... User: .... cannot be used for federation with Amazon Connect</code>
     * </p>
     * </note>
     *
     * @param getFederationTokenRequest
     * @return Result of the GetFederationToken operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws UserNotFoundException
     *         No user with the specified credentials was found in the Amazon Connect instance.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.GetFederationToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetFederationToken" target="_top">AWS
     *      API Documentation</a>
     */
    default GetFederationTokenResponse getFederationToken(GetFederationTokenRequest getFederationTokenRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, UserNotFoundException,
            InternalServiceException, DuplicateResourceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Supports SAML sign-in for Amazon Connect. Retrieves a token for federation. The token is for the Amazon Connect
     * user which corresponds to the IAM credentials that were used to invoke this action.
     * </p>
     * <p>
     * For more information about how SAML sign-in works in Amazon Connect, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/configure-saml.html ">Configure SAML with IAM for
     * Amazon Connect in the <i>Amazon Connect Administrator Guide</i>.</a>
     * </p>
     * <note>
     * <p>
     * This API doesn't support root users. If you try to invoke GetFederationToken with root credentials, an error
     * message similar to the following one appears:
     * </p>
     * <p>
     * <code>Provided identity: Principal: .... User: .... cannot be used for federation with Amazon Connect</code>
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFederationTokenRequest.Builder} avoiding the
     * need to create one manually via {@link GetFederationTokenRequest#builder()}
     * </p>
     *
     * @param getFederationTokenRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.GetFederationTokenRequest.Builder} to create a
     *        request.
     * @return Result of the GetFederationToken operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws UserNotFoundException
     *         No user with the specified credentials was found in the Amazon Connect instance.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.GetFederationToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetFederationToken" target="_top">AWS
     *      API Documentation</a>
     */
    default GetFederationTokenResponse getFederationToken(Consumer<GetFederationTokenRequest.Builder> getFederationTokenRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, UserNotFoundException,
            InternalServiceException, DuplicateResourceException, AwsServiceException, SdkClientException, ConnectException {
        return getFederationToken(GetFederationTokenRequest.builder().applyMutation(getFederationTokenRequest).build());
    }

    /**
     * <p>
     * Retrieves the flow associated for a given resource.
     * </p>
     *
     * @param getFlowAssociationRequest
     * @return Result of the GetFlowAssociation operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.GetFlowAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetFlowAssociation" target="_top">AWS
     *      API Documentation</a>
     */
    default GetFlowAssociationResponse getFlowAssociation(GetFlowAssociationRequest getFlowAssociationRequest)
            throws AccessDeniedException, ResourceNotFoundException, InternalServiceException, InvalidRequestException,
            InvalidParameterException, ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the flow associated for a given resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFlowAssociationRequest.Builder} avoiding the
     * need to create one manually via {@link GetFlowAssociationRequest#builder()}
     * </p>
     *
     * @param getFlowAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.GetFlowAssociationRequest.Builder} to create a
     *        request.
     * @return Result of the GetFlowAssociation operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.GetFlowAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetFlowAssociation" target="_top">AWS
     *      API Documentation</a>
     */
    default GetFlowAssociationResponse getFlowAssociation(Consumer<GetFlowAssociationRequest.Builder> getFlowAssociationRequest)
            throws AccessDeniedException, ResourceNotFoundException, InternalServiceException, InvalidRequestException,
            InvalidParameterException, ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return getFlowAssociation(GetFlowAssociationRequest.builder().applyMutation(getFlowAssociationRequest).build());
    }

    /**
     * <p>
     * Gets historical metric data from the specified Amazon Connect instance.
     * </p>
     * <p>
     * For a description of each historical metric, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html">Historical
     * Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <note>
     * <p>
     * We recommend using the <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_GetMetricDataV2.html">GetMetricDataV2</a> API.
     * It provides more flexibility, features, and the ability to query longer time ranges than
     * <code>GetMetricData</code>. Use it to retrieve historical agent and contact metrics for the last 3 months, at
     * varying intervals. You can also use it to build custom dashboards to measure historical queue and agent
     * performance. For example, you can track the number of incoming contacts for the last 7 days, with data split by
     * day, to see how contact volume changed per day of the week.
     * </p>
     * </note>
     *
     * @param getMetricDataRequest
     * @return Result of the GetMetricData operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.GetMetricData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetMetricData" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMetricDataResponse getMetricData(GetMetricDataRequest getMetricDataRequest) throws InvalidRequestException,
            InvalidParameterException, InternalServiceException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets historical metric data from the specified Amazon Connect instance.
     * </p>
     * <p>
     * For a description of each historical metric, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html">Historical
     * Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <note>
     * <p>
     * We recommend using the <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_GetMetricDataV2.html">GetMetricDataV2</a> API.
     * It provides more flexibility, features, and the ability to query longer time ranges than
     * <code>GetMetricData</code>. Use it to retrieve historical agent and contact metrics for the last 3 months, at
     * varying intervals. You can also use it to build custom dashboards to measure historical queue and agent
     * performance. For example, you can track the number of incoming contacts for the last 7 days, with data split by
     * day, to see how contact volume changed per day of the week.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMetricDataRequest.Builder} avoiding the need to
     * create one manually via {@link GetMetricDataRequest#builder()}
     * </p>
     *
     * @param getMetricDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.GetMetricDataRequest.Builder} to create a request.
     * @return Result of the GetMetricData operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.GetMetricData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetMetricData" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMetricDataResponse getMetricData(Consumer<GetMetricDataRequest.Builder> getMetricDataRequest)
            throws InvalidRequestException, InvalidParameterException, InternalServiceException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ConnectException {
        return getMetricData(GetMetricDataRequest.builder().applyMutation(getMetricDataRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #getMetricData(software.amazon.awssdk.services.connect.model.GetMetricDataRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.GetMetricDataIterable responses = client.getMetricDataPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.GetMetricDataIterable responses = client.getMetricDataPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.GetMetricDataResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.GetMetricDataIterable responses = client.getMetricDataPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getMetricData(software.amazon.awssdk.services.connect.model.GetMetricDataRequest)} operation.</b>
     * </p>
     *
     * @param getMetricDataRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.GetMetricData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetMetricData" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMetricDataIterable getMetricDataPaginator(GetMetricDataRequest getMetricDataRequest)
            throws InvalidRequestException, InvalidParameterException, InternalServiceException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ConnectException {
        return new GetMetricDataIterable(this, getMetricDataRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #getMetricData(software.amazon.awssdk.services.connect.model.GetMetricDataRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.GetMetricDataIterable responses = client.getMetricDataPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.GetMetricDataIterable responses = client.getMetricDataPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.GetMetricDataResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.GetMetricDataIterable responses = client.getMetricDataPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getMetricData(software.amazon.awssdk.services.connect.model.GetMetricDataRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMetricDataRequest.Builder} avoiding the need to
     * create one manually via {@link GetMetricDataRequest#builder()}
     * </p>
     *
     * @param getMetricDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.GetMetricDataRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.GetMetricData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetMetricData" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMetricDataIterable getMetricDataPaginator(Consumer<GetMetricDataRequest.Builder> getMetricDataRequest)
            throws InvalidRequestException, InvalidParameterException, InternalServiceException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ConnectException {
        return getMetricDataPaginator(GetMetricDataRequest.builder().applyMutation(getMetricDataRequest).build());
    }

    /**
     * <p>
     * Gets metric data from the specified Amazon Connect instance.
     * </p>
     * <p>
     * <code>GetMetricDataV2</code> offers more features than <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_GetMetricData.html">GetMetricData</a>, the
     * previous version of this API. It has new metrics, offers filtering at a metric level, and offers the ability to
     * filter and group data by channels, queues, routing profiles, agents, and agent hierarchy levels. It can retrieve
     * historical data for the last 3 months, at varying intervals.
     * </p>
     * <p>
     * For a description of the historical metrics that are supported by <code>GetMetricDataV2</code> and
     * <code>GetMetricData</code>, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html">Historical
     * metrics definitions</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     *
     * @param getMetricDataV2Request
     * @return Result of the GetMetricDataV2 operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.GetMetricDataV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetMetricDataV2" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMetricDataV2Response getMetricDataV2(GetMetricDataV2Request getMetricDataV2Request)
            throws InvalidRequestException, InvalidParameterException, InternalServiceException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets metric data from the specified Amazon Connect instance.
     * </p>
     * <p>
     * <code>GetMetricDataV2</code> offers more features than <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_GetMetricData.html">GetMetricData</a>, the
     * previous version of this API. It has new metrics, offers filtering at a metric level, and offers the ability to
     * filter and group data by channels, queues, routing profiles, agents, and agent hierarchy levels. It can retrieve
     * historical data for the last 3 months, at varying intervals.
     * </p>
     * <p>
     * For a description of the historical metrics that are supported by <code>GetMetricDataV2</code> and
     * <code>GetMetricData</code>, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html">Historical
     * metrics definitions</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMetricDataV2Request.Builder} avoiding the need
     * to create one manually via {@link GetMetricDataV2Request#builder()}
     * </p>
     *
     * @param getMetricDataV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.GetMetricDataV2Request.Builder} to create a request.
     * @return Result of the GetMetricDataV2 operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.GetMetricDataV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetMetricDataV2" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMetricDataV2Response getMetricDataV2(Consumer<GetMetricDataV2Request.Builder> getMetricDataV2Request)
            throws InvalidRequestException, InvalidParameterException, InternalServiceException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ConnectException {
        return getMetricDataV2(GetMetricDataV2Request.builder().applyMutation(getMetricDataV2Request).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getMetricDataV2(software.amazon.awssdk.services.connect.model.GetMetricDataV2Request)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.GetMetricDataV2Iterable responses = client.getMetricDataV2Paginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.GetMetricDataV2Iterable responses = client
     *             .getMetricDataV2Paginator(request);
     *     for (software.amazon.awssdk.services.connect.model.GetMetricDataV2Response response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.GetMetricDataV2Iterable responses = client.getMetricDataV2Paginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getMetricDataV2(software.amazon.awssdk.services.connect.model.GetMetricDataV2Request)} operation.</b>
     * </p>
     *
     * @param getMetricDataV2Request
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.GetMetricDataV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetMetricDataV2" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMetricDataV2Iterable getMetricDataV2Paginator(GetMetricDataV2Request getMetricDataV2Request)
            throws InvalidRequestException, InvalidParameterException, InternalServiceException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ConnectException {
        return new GetMetricDataV2Iterable(this, getMetricDataV2Request);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getMetricDataV2(software.amazon.awssdk.services.connect.model.GetMetricDataV2Request)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.GetMetricDataV2Iterable responses = client.getMetricDataV2Paginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.GetMetricDataV2Iterable responses = client
     *             .getMetricDataV2Paginator(request);
     *     for (software.amazon.awssdk.services.connect.model.GetMetricDataV2Response response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.GetMetricDataV2Iterable responses = client.getMetricDataV2Paginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getMetricDataV2(software.amazon.awssdk.services.connect.model.GetMetricDataV2Request)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMetricDataV2Request.Builder} avoiding the need
     * to create one manually via {@link GetMetricDataV2Request#builder()}
     * </p>
     *
     * @param getMetricDataV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.GetMetricDataV2Request.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.GetMetricDataV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetMetricDataV2" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMetricDataV2Iterable getMetricDataV2Paginator(Consumer<GetMetricDataV2Request.Builder> getMetricDataV2Request)
            throws InvalidRequestException, InvalidParameterException, InternalServiceException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ConnectException {
        return getMetricDataV2Paginator(GetMetricDataV2Request.builder().applyMutation(getMetricDataV2Request).build());
    }

    /**
     * <p>
     * Gets the prompt file.
     * </p>
     *
     * @param getPromptFileRequest
     * @return Result of the GetPromptFile operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.GetPromptFile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetPromptFile" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPromptFileResponse getPromptFile(GetPromptFileRequest getPromptFileRequest) throws InvalidParameterException,
            InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the prompt file.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPromptFileRequest.Builder} avoiding the need to
     * create one manually via {@link GetPromptFileRequest#builder()}
     * </p>
     *
     * @param getPromptFileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.GetPromptFileRequest.Builder} to create a request.
     * @return Result of the GetPromptFile operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.GetPromptFile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetPromptFile" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPromptFileResponse getPromptFile(Consumer<GetPromptFileRequest.Builder> getPromptFileRequest)
            throws InvalidParameterException, InvalidRequestException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return getPromptFile(GetPromptFileRequest.builder().applyMutation(getPromptFileRequest).build());
    }

    /**
     * <p>
     * Gets details about a specific task template in the specified Amazon Connect instance.
     * </p>
     *
     * @param getTaskTemplateRequest
     * @return Result of the GetTaskTemplate operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.GetTaskTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetTaskTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTaskTemplateResponse getTaskTemplate(GetTaskTemplateRequest getTaskTemplateRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details about a specific task template in the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTaskTemplateRequest.Builder} avoiding the need
     * to create one manually via {@link GetTaskTemplateRequest#builder()}
     * </p>
     *
     * @param getTaskTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.GetTaskTemplateRequest.Builder} to create a request.
     * @return Result of the GetTaskTemplate operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.GetTaskTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetTaskTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTaskTemplateResponse getTaskTemplate(Consumer<GetTaskTemplateRequest.Builder> getTaskTemplateRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return getTaskTemplate(GetTaskTemplateRequest.builder().applyMutation(getTaskTemplateRequest).build());
    }

    /**
     * <p>
     * Retrieves the current traffic distribution for a given traffic distribution group.
     * </p>
     *
     * @param getTrafficDistributionRequest
     * @return Result of the GetTrafficDistribution operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.GetTrafficDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetTrafficDistribution"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTrafficDistributionResponse getTrafficDistribution(GetTrafficDistributionRequest getTrafficDistributionRequest)
            throws InvalidRequestException, AccessDeniedException, ResourceNotFoundException, InternalServiceException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the current traffic distribution for a given traffic distribution group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTrafficDistributionRequest.Builder} avoiding the
     * need to create one manually via {@link GetTrafficDistributionRequest#builder()}
     * </p>
     *
     * @param getTrafficDistributionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.GetTrafficDistributionRequest.Builder} to create a
     *        request.
     * @return Result of the GetTrafficDistribution operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.GetTrafficDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetTrafficDistribution"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTrafficDistributionResponse getTrafficDistribution(
            Consumer<GetTrafficDistributionRequest.Builder> getTrafficDistributionRequest) throws InvalidRequestException,
            AccessDeniedException, ResourceNotFoundException, InternalServiceException, ThrottlingException, AwsServiceException,
            SdkClientException, ConnectException {
        return getTrafficDistribution(GetTrafficDistributionRequest.builder().applyMutation(getTrafficDistributionRequest)
                .build());
    }

    /**
     * <p>
     * Imports a claimed phone number from an external service, such as Amazon Pinpoint, into an Amazon Connect
     * instance. You can call this API only in the same Amazon Web Services Region where the Amazon Connect instance was
     * created.
     * </p>
     * <important>
     * <p>
     * Call the <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribePhoneNumber.html">DescribePhoneNumber
     * </a> API to verify the status of a previous <code>ImportPhoneNumber</code> operation.
     * </p>
     * </important>
     * <p>
     * If you plan to claim or import numbers and then release numbers frequently, contact us for a service quota
     * exception. Otherwise, it is possible you will be blocked from claiming and releasing any more numbers until up to
     * 180 days past the oldest number released has expired.
     * </p>
     * <p>
     * By default you can claim or import and then release up to 200% of your maximum number of active phone numbers. If
     * you claim or import and then release phone numbers using the UI or API during a rolling 180 day cycle that
     * exceeds 200% of your phone number service level quota, you will be blocked from claiming or importing any more
     * numbers until 180 days past the oldest number released has expired.
     * </p>
     * <p>
     * For example, if you already have 99 claimed or imported numbers and a service level quota of 99 phone numbers,
     * and in any 180 day period you release 99, claim 99, and then release 99, you will have exceeded the 200% limit.
     * At that point you are blocked from claiming any more numbers until you open an Amazon Web Services Support
     * ticket.
     * </p>
     *
     * @param importPhoneNumberRequest
     * @return Result of the ImportPhoneNumber operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws IdempotencyException
     *         An entity with the same name already exists.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ImportPhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ImportPhoneNumber" target="_top">AWS API
     *      Documentation</a>
     */
    default ImportPhoneNumberResponse importPhoneNumber(ImportPhoneNumberRequest importPhoneNumberRequest)
            throws InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            IdempotencyException, AccessDeniedException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Imports a claimed phone number from an external service, such as Amazon Pinpoint, into an Amazon Connect
     * instance. You can call this API only in the same Amazon Web Services Region where the Amazon Connect instance was
     * created.
     * </p>
     * <important>
     * <p>
     * Call the <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribePhoneNumber.html">DescribePhoneNumber
     * </a> API to verify the status of a previous <code>ImportPhoneNumber</code> operation.
     * </p>
     * </important>
     * <p>
     * If you plan to claim or import numbers and then release numbers frequently, contact us for a service quota
     * exception. Otherwise, it is possible you will be blocked from claiming and releasing any more numbers until up to
     * 180 days past the oldest number released has expired.
     * </p>
     * <p>
     * By default you can claim or import and then release up to 200% of your maximum number of active phone numbers. If
     * you claim or import and then release phone numbers using the UI or API during a rolling 180 day cycle that
     * exceeds 200% of your phone number service level quota, you will be blocked from claiming or importing any more
     * numbers until 180 days past the oldest number released has expired.
     * </p>
     * <p>
     * For example, if you already have 99 claimed or imported numbers and a service level quota of 99 phone numbers,
     * and in any 180 day period you release 99, claim 99, and then release 99, you will have exceeded the 200% limit.
     * At that point you are blocked from claiming any more numbers until you open an Amazon Web Services Support
     * ticket.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportPhoneNumberRequest.Builder} avoiding the need
     * to create one manually via {@link ImportPhoneNumberRequest#builder()}
     * </p>
     *
     * @param importPhoneNumberRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ImportPhoneNumberRequest.Builder} to create a
     *        request.
     * @return Result of the ImportPhoneNumber operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws IdempotencyException
     *         An entity with the same name already exists.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ImportPhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ImportPhoneNumber" target="_top">AWS API
     *      Documentation</a>
     */
    default ImportPhoneNumberResponse importPhoneNumber(Consumer<ImportPhoneNumberRequest.Builder> importPhoneNumberRequest)
            throws InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            IdempotencyException, AccessDeniedException, AwsServiceException, SdkClientException, ConnectException {
        return importPhoneNumber(ImportPhoneNumberRequest.builder().applyMutation(importPhoneNumberRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Lists agent statuses.
     * </p>
     *
     * @param listAgentStatusesRequest
     * @return Result of the ListAgentStatuses operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListAgentStatuses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListAgentStatuses" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAgentStatusesResponse listAgentStatuses(ListAgentStatusesRequest listAgentStatusesRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Lists agent statuses.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAgentStatusesRequest.Builder} avoiding the need
     * to create one manually via {@link ListAgentStatusesRequest#builder()}
     * </p>
     *
     * @param listAgentStatusesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ListAgentStatusesRequest.Builder} to create a
     *        request.
     * @return Result of the ListAgentStatuses operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListAgentStatuses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListAgentStatuses" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAgentStatusesResponse listAgentStatuses(Consumer<ListAgentStatusesRequest.Builder> listAgentStatusesRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return listAgentStatuses(ListAgentStatusesRequest.builder().applyMutation(listAgentStatusesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAgentStatuses(software.amazon.awssdk.services.connect.model.ListAgentStatusesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListAgentStatusesIterable responses = client.listAgentStatusesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListAgentStatusesIterable responses = client
     *             .listAgentStatusesPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListAgentStatusesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListAgentStatusesIterable responses = client.listAgentStatusesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAgentStatuses(software.amazon.awssdk.services.connect.model.ListAgentStatusesRequest)} operation.</b>
     * </p>
     *
     * @param listAgentStatusesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListAgentStatuses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListAgentStatuses" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAgentStatusesIterable listAgentStatusesPaginator(ListAgentStatusesRequest listAgentStatusesRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return new ListAgentStatusesIterable(this, listAgentStatusesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAgentStatuses(software.amazon.awssdk.services.connect.model.ListAgentStatusesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListAgentStatusesIterable responses = client.listAgentStatusesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListAgentStatusesIterable responses = client
     *             .listAgentStatusesPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListAgentStatusesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListAgentStatusesIterable responses = client.listAgentStatusesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAgentStatuses(software.amazon.awssdk.services.connect.model.ListAgentStatusesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAgentStatusesRequest.Builder} avoiding the need
     * to create one manually via {@link ListAgentStatusesRequest#builder()}
     * </p>
     *
     * @param listAgentStatusesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ListAgentStatusesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListAgentStatuses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListAgentStatuses" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAgentStatusesIterable listAgentStatusesPaginator(
            Consumer<ListAgentStatusesRequest.Builder> listAgentStatusesRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return listAgentStatusesPaginator(ListAgentStatusesRequest.builder().applyMutation(listAgentStatusesRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Lists the association status of requested dataset ID for a given Amazon Connect instance.
     * </p>
     *
     * @param listAnalyticsDataAssociationsRequest
     * @return Result of the ListAnalyticsDataAssociations operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListAnalyticsDataAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListAnalyticsDataAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnalyticsDataAssociationsResponse listAnalyticsDataAssociations(
            ListAnalyticsDataAssociationsRequest listAnalyticsDataAssociationsRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Lists the association status of requested dataset ID for a given Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnalyticsDataAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListAnalyticsDataAssociationsRequest#builder()}
     * </p>
     *
     * @param listAnalyticsDataAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ListAnalyticsDataAssociationsRequest.Builder} to
     *        create a request.
     * @return Result of the ListAnalyticsDataAssociations operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListAnalyticsDataAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListAnalyticsDataAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnalyticsDataAssociationsResponse listAnalyticsDataAssociations(
            Consumer<ListAnalyticsDataAssociationsRequest.Builder> listAnalyticsDataAssociationsRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return listAnalyticsDataAssociations(ListAnalyticsDataAssociationsRequest.builder()
                .applyMutation(listAnalyticsDataAssociationsRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Returns a paginated list of all approved origins associated with the instance.
     * </p>
     *
     * @param listApprovedOriginsRequest
     * @return Result of the ListApprovedOrigins operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListApprovedOrigins
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListApprovedOrigins" target="_top">AWS
     *      API Documentation</a>
     */
    default ListApprovedOriginsResponse listApprovedOrigins(ListApprovedOriginsRequest listApprovedOriginsRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Returns a paginated list of all approved origins associated with the instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApprovedOriginsRequest.Builder} avoiding the
     * need to create one manually via {@link ListApprovedOriginsRequest#builder()}
     * </p>
     *
     * @param listApprovedOriginsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ListApprovedOriginsRequest.Builder} to create a
     *        request.
     * @return Result of the ListApprovedOrigins operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListApprovedOrigins
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListApprovedOrigins" target="_top">AWS
     *      API Documentation</a>
     */
    default ListApprovedOriginsResponse listApprovedOrigins(
            Consumer<ListApprovedOriginsRequest.Builder> listApprovedOriginsRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, InvalidParameterException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        return listApprovedOrigins(ListApprovedOriginsRequest.builder().applyMutation(listApprovedOriginsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApprovedOrigins(software.amazon.awssdk.services.connect.model.ListApprovedOriginsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListApprovedOriginsIterable responses = client.listApprovedOriginsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListApprovedOriginsIterable responses = client
     *             .listApprovedOriginsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListApprovedOriginsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListApprovedOriginsIterable responses = client.listApprovedOriginsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApprovedOrigins(software.amazon.awssdk.services.connect.model.ListApprovedOriginsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listApprovedOriginsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListApprovedOrigins
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListApprovedOrigins" target="_top">AWS
     *      API Documentation</a>
     */
    default ListApprovedOriginsIterable listApprovedOriginsPaginator(ListApprovedOriginsRequest listApprovedOriginsRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return new ListApprovedOriginsIterable(this, listApprovedOriginsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApprovedOrigins(software.amazon.awssdk.services.connect.model.ListApprovedOriginsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListApprovedOriginsIterable responses = client.listApprovedOriginsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListApprovedOriginsIterable responses = client
     *             .listApprovedOriginsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListApprovedOriginsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListApprovedOriginsIterable responses = client.listApprovedOriginsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApprovedOrigins(software.amazon.awssdk.services.connect.model.ListApprovedOriginsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApprovedOriginsRequest.Builder} avoiding the
     * need to create one manually via {@link ListApprovedOriginsRequest#builder()}
     * </p>
     *
     * @param listApprovedOriginsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ListApprovedOriginsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListApprovedOrigins
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListApprovedOrigins" target="_top">AWS
     *      API Documentation</a>
     */
    default ListApprovedOriginsIterable listApprovedOriginsPaginator(
            Consumer<ListApprovedOriginsRequest.Builder> listApprovedOriginsRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, InvalidParameterException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        return listApprovedOriginsPaginator(ListApprovedOriginsRequest.builder().applyMutation(listApprovedOriginsRequest)
                .build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * For the specified version of Amazon Lex, returns a paginated list of all the Amazon Lex bots currently associated
     * with the instance. Use this API to returns both Amazon Lex V1 and V2 bots.
     * </p>
     *
     * @param listBotsRequest
     * @return Result of the ListBots operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListBots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListBots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBotsResponse listBots(ListBotsRequest listBotsRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, ThrottlingException, AwsServiceException, SdkClientException,
            ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * For the specified version of Amazon Lex, returns a paginated list of all the Amazon Lex bots currently associated
     * with the instance. Use this API to returns both Amazon Lex V1 and V2 bots.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBotsRequest.Builder} avoiding the need to
     * create one manually via {@link ListBotsRequest#builder()}
     * </p>
     *
     * @param listBotsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ListBotsRequest.Builder} to create a request.
     * @return Result of the ListBots operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListBots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListBots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBotsResponse listBots(Consumer<ListBotsRequest.Builder> listBotsRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, ThrottlingException, AwsServiceException, SdkClientException,
            ConnectException {
        return listBots(ListBotsRequest.builder().applyMutation(listBotsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listBots(software.amazon.awssdk.services.connect.model.ListBotsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListBotsIterable responses = client.listBotsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListBotsIterable responses = client.listBotsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListBotsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListBotsIterable responses = client.listBotsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBots(software.amazon.awssdk.services.connect.model.ListBotsRequest)} operation.</b>
     * </p>
     *
     * @param listBotsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListBots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListBots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBotsIterable listBotsPaginator(ListBotsRequest listBotsRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, ThrottlingException, AwsServiceException, SdkClientException,
            ConnectException {
        return new ListBotsIterable(this, listBotsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listBots(software.amazon.awssdk.services.connect.model.ListBotsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListBotsIterable responses = client.listBotsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListBotsIterable responses = client.listBotsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListBotsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListBotsIterable responses = client.listBotsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBots(software.amazon.awssdk.services.connect.model.ListBotsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBotsRequest.Builder} avoiding the need to
     * create one manually via {@link ListBotsRequest#builder()}
     * </p>
     *
     * @param listBotsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ListBotsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListBots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListBots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBotsIterable listBotsPaginator(Consumer<ListBotsRequest.Builder> listBotsRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        return listBotsPaginator(ListBotsRequest.builder().applyMutation(listBotsRequest).build());
    }

    /**
     * <p>
     * Lists contact evaluations in the specified Amazon Connect instance.
     * </p>
     *
     * @param listContactEvaluationsRequest
     * @return Result of the ListContactEvaluations operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListContactEvaluations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListContactEvaluations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListContactEvaluationsResponse listContactEvaluations(ListContactEvaluationsRequest listContactEvaluationsRequest)
            throws InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists contact evaluations in the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListContactEvaluationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListContactEvaluationsRequest#builder()}
     * </p>
     *
     * @param listContactEvaluationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ListContactEvaluationsRequest.Builder} to create a
     *        request.
     * @return Result of the ListContactEvaluations operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListContactEvaluations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListContactEvaluations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListContactEvaluationsResponse listContactEvaluations(
            Consumer<ListContactEvaluationsRequest.Builder> listContactEvaluationsRequest) throws InvalidParameterException,
            ResourceNotFoundException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException,
            ConnectException {
        return listContactEvaluations(ListContactEvaluationsRequest.builder().applyMutation(listContactEvaluationsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listContactEvaluations(software.amazon.awssdk.services.connect.model.ListContactEvaluationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListContactEvaluationsIterable responses = client.listContactEvaluationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListContactEvaluationsIterable responses = client
     *             .listContactEvaluationsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListContactEvaluationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListContactEvaluationsIterable responses = client.listContactEvaluationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContactEvaluations(software.amazon.awssdk.services.connect.model.ListContactEvaluationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listContactEvaluationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListContactEvaluations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListContactEvaluations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListContactEvaluationsIterable listContactEvaluationsPaginator(
            ListContactEvaluationsRequest listContactEvaluationsRequest) throws InvalidParameterException,
            ResourceNotFoundException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException,
            ConnectException {
        return new ListContactEvaluationsIterable(this, listContactEvaluationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listContactEvaluations(software.amazon.awssdk.services.connect.model.ListContactEvaluationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListContactEvaluationsIterable responses = client.listContactEvaluationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListContactEvaluationsIterable responses = client
     *             .listContactEvaluationsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListContactEvaluationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListContactEvaluationsIterable responses = client.listContactEvaluationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContactEvaluations(software.amazon.awssdk.services.connect.model.ListContactEvaluationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListContactEvaluationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListContactEvaluationsRequest#builder()}
     * </p>
     *
     * @param listContactEvaluationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ListContactEvaluationsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListContactEvaluations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListContactEvaluations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListContactEvaluationsIterable listContactEvaluationsPaginator(
            Consumer<ListContactEvaluationsRequest.Builder> listContactEvaluationsRequest) throws InvalidParameterException,
            ResourceNotFoundException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException,
            ConnectException {
        return listContactEvaluationsPaginator(ListContactEvaluationsRequest.builder()
                .applyMutation(listContactEvaluationsRequest).build());
    }

    /**
     * <p>
     * Provides information about the flow modules for the specified Amazon Connect instance.
     * </p>
     *
     * @param listContactFlowModulesRequest
     * @return Result of the ListContactFlowModules operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListContactFlowModules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListContactFlowModules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListContactFlowModulesResponse listContactFlowModules(ListContactFlowModulesRequest listContactFlowModulesRequest)
            throws AccessDeniedException, InvalidRequestException, InvalidParameterException, ResourceNotFoundException,
            ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about the flow modules for the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListContactFlowModulesRequest.Builder} avoiding the
     * need to create one manually via {@link ListContactFlowModulesRequest#builder()}
     * </p>
     *
     * @param listContactFlowModulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ListContactFlowModulesRequest.Builder} to create a
     *        request.
     * @return Result of the ListContactFlowModules operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListContactFlowModules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListContactFlowModules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListContactFlowModulesResponse listContactFlowModules(
            Consumer<ListContactFlowModulesRequest.Builder> listContactFlowModulesRequest) throws AccessDeniedException,
            InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return listContactFlowModules(ListContactFlowModulesRequest.builder().applyMutation(listContactFlowModulesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listContactFlowModules(software.amazon.awssdk.services.connect.model.ListContactFlowModulesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListContactFlowModulesIterable responses = client.listContactFlowModulesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListContactFlowModulesIterable responses = client
     *             .listContactFlowModulesPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListContactFlowModulesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListContactFlowModulesIterable responses = client.listContactFlowModulesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContactFlowModules(software.amazon.awssdk.services.connect.model.ListContactFlowModulesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listContactFlowModulesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListContactFlowModules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListContactFlowModules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListContactFlowModulesIterable listContactFlowModulesPaginator(
            ListContactFlowModulesRequest listContactFlowModulesRequest) throws AccessDeniedException, InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return new ListContactFlowModulesIterable(this, listContactFlowModulesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listContactFlowModules(software.amazon.awssdk.services.connect.model.ListContactFlowModulesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListContactFlowModulesIterable responses = client.listContactFlowModulesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListContactFlowModulesIterable responses = client
     *             .listContactFlowModulesPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListContactFlowModulesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListContactFlowModulesIterable responses = client.listContactFlowModulesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContactFlowModules(software.amazon.awssdk.services.connect.model.ListContactFlowModulesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListContactFlowModulesRequest.Builder} avoiding the
     * need to create one manually via {@link ListContactFlowModulesRequest#builder()}
     * </p>
     *
     * @param listContactFlowModulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ListContactFlowModulesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListContactFlowModules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListContactFlowModules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListContactFlowModulesIterable listContactFlowModulesPaginator(
            Consumer<ListContactFlowModulesRequest.Builder> listContactFlowModulesRequest) throws AccessDeniedException,
            InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return listContactFlowModulesPaginator(ListContactFlowModulesRequest.builder()
                .applyMutation(listContactFlowModulesRequest).build());
    }

    /**
     * <p>
     * Provides information about the flows for the specified Amazon Connect instance.
     * </p>
     * <p>
     * You can also create and update flows using the <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/flow-language.html">Amazon Connect Flow
     * language</a>.
     * </p>
     * <p>
     * For more information about flows, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-contact-flows.html">Flows</a> in the
     * <i>Amazon Connect Administrator Guide</i>.
     * </p>
     *
     * @param listContactFlowsRequest
     * @return Result of the ListContactFlows operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListContactFlows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListContactFlows" target="_top">AWS API
     *      Documentation</a>
     */
    default ListContactFlowsResponse listContactFlows(ListContactFlowsRequest listContactFlowsRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about the flows for the specified Amazon Connect instance.
     * </p>
     * <p>
     * You can also create and update flows using the <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/flow-language.html">Amazon Connect Flow
     * language</a>.
     * </p>
     * <p>
     * For more information about flows, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-contact-flows.html">Flows</a> in the
     * <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListContactFlowsRequest.Builder} avoiding the need
     * to create one manually via {@link ListContactFlowsRequest#builder()}
     * </p>
     *
     * @param listContactFlowsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ListContactFlowsRequest.Builder} to create a request.
     * @return Result of the ListContactFlows operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListContactFlows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListContactFlows" target="_top">AWS API
     *      Documentation</a>
     */
    default ListContactFlowsResponse listContactFlows(Consumer<ListContactFlowsRequest.Builder> listContactFlowsRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return listContactFlows(ListContactFlowsRequest.builder().applyMutation(listContactFlowsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listContactFlows(software.amazon.awssdk.services.connect.model.ListContactFlowsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListContactFlowsIterable responses = client.listContactFlowsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListContactFlowsIterable responses = client
     *             .listContactFlowsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListContactFlowsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListContactFlowsIterable responses = client.listContactFlowsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContactFlows(software.amazon.awssdk.services.connect.model.ListContactFlowsRequest)} operation.</b>
     * </p>
     *
     * @param listContactFlowsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListContactFlows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListContactFlows" target="_top">AWS API
     *      Documentation</a>
     */
    default ListContactFlowsIterable listContactFlowsPaginator(ListContactFlowsRequest listContactFlowsRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return new ListContactFlowsIterable(this, listContactFlowsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listContactFlows(software.amazon.awssdk.services.connect.model.ListContactFlowsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListContactFlowsIterable responses = client.listContactFlowsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListContactFlowsIterable responses = client
     *             .listContactFlowsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListContactFlowsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListContactFlowsIterable responses = client.listContactFlowsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContactFlows(software.amazon.awssdk.services.connect.model.ListContactFlowsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListContactFlowsRequest.Builder} avoiding the need
     * to create one manually via {@link ListContactFlowsRequest#builder()}
     * </p>
     *
     * @param listContactFlowsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ListContactFlowsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListContactFlows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListContactFlows" target="_top">AWS API
     *      Documentation</a>
     */
    default ListContactFlowsIterable listContactFlowsPaginator(Consumer<ListContactFlowsRequest.Builder> listContactFlowsRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return listContactFlowsPaginator(ListContactFlowsRequest.builder().applyMutation(listContactFlowsRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * For the specified <code>referenceTypes</code>, returns a list of references associated with the contact.
     * <i>References</i> are links to documents that are related to a contact, such as emails, attachments, or URLs.
     * </p>
     *
     * @param listContactReferencesRequest
     * @return Result of the ListContactReferences operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListContactReferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListContactReferences" target="_top">AWS
     *      API Documentation</a>
     */
    default ListContactReferencesResponse listContactReferences(ListContactReferencesRequest listContactReferencesRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, InternalServiceException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * For the specified <code>referenceTypes</code>, returns a list of references associated with the contact.
     * <i>References</i> are links to documents that are related to a contact, such as emails, attachments, or URLs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListContactReferencesRequest.Builder} avoiding the
     * need to create one manually via {@link ListContactReferencesRequest#builder()}
     * </p>
     *
     * @param listContactReferencesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ListContactReferencesRequest.Builder} to create a
     *        request.
     * @return Result of the ListContactReferences operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListContactReferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListContactReferences" target="_top">AWS
     *      API Documentation</a>
     */
    default ListContactReferencesResponse listContactReferences(
            Consumer<ListContactReferencesRequest.Builder> listContactReferencesRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, InternalServiceException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        return listContactReferences(ListContactReferencesRequest.builder().applyMutation(listContactReferencesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listContactReferences(software.amazon.awssdk.services.connect.model.ListContactReferencesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListContactReferencesIterable responses = client.listContactReferencesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListContactReferencesIterable responses = client
     *             .listContactReferencesPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListContactReferencesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListContactReferencesIterable responses = client.listContactReferencesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContactReferences(software.amazon.awssdk.services.connect.model.ListContactReferencesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listContactReferencesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListContactReferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListContactReferences" target="_top">AWS
     *      API Documentation</a>
     */
    default ListContactReferencesIterable listContactReferencesPaginator(ListContactReferencesRequest listContactReferencesRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, InternalServiceException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return new ListContactReferencesIterable(this, listContactReferencesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listContactReferences(software.amazon.awssdk.services.connect.model.ListContactReferencesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListContactReferencesIterable responses = client.listContactReferencesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListContactReferencesIterable responses = client
     *             .listContactReferencesPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListContactReferencesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListContactReferencesIterable responses = client.listContactReferencesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContactReferences(software.amazon.awssdk.services.connect.model.ListContactReferencesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListContactReferencesRequest.Builder} avoiding the
     * need to create one manually via {@link ListContactReferencesRequest#builder()}
     * </p>
     *
     * @param listContactReferencesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ListContactReferencesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListContactReferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListContactReferences" target="_top">AWS
     *      API Documentation</a>
     */
    default ListContactReferencesIterable listContactReferencesPaginator(
            Consumer<ListContactReferencesRequest.Builder> listContactReferencesRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, InternalServiceException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        return listContactReferencesPaginator(ListContactReferencesRequest.builder().applyMutation(listContactReferencesRequest)
                .build());
    }

    /**
     * <p>
     * Lists the default vocabularies for the specified Amazon Connect instance.
     * </p>
     *
     * @param listDefaultVocabulariesRequest
     * @return Result of the ListDefaultVocabularies operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListDefaultVocabularies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListDefaultVocabularies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDefaultVocabulariesResponse listDefaultVocabularies(ListDefaultVocabulariesRequest listDefaultVocabulariesRequest)
            throws InvalidRequestException, InternalServiceException, ThrottlingException, AccessDeniedException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the default vocabularies for the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDefaultVocabulariesRequest.Builder} avoiding
     * the need to create one manually via {@link ListDefaultVocabulariesRequest#builder()}
     * </p>
     *
     * @param listDefaultVocabulariesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ListDefaultVocabulariesRequest.Builder} to create a
     *        request.
     * @return Result of the ListDefaultVocabularies operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListDefaultVocabularies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListDefaultVocabularies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDefaultVocabulariesResponse listDefaultVocabularies(
            Consumer<ListDefaultVocabulariesRequest.Builder> listDefaultVocabulariesRequest) throws InvalidRequestException,
            InternalServiceException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            ConnectException {
        return listDefaultVocabularies(ListDefaultVocabulariesRequest.builder().applyMutation(listDefaultVocabulariesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDefaultVocabularies(software.amazon.awssdk.services.connect.model.ListDefaultVocabulariesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListDefaultVocabulariesIterable responses = client.listDefaultVocabulariesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListDefaultVocabulariesIterable responses = client
     *             .listDefaultVocabulariesPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListDefaultVocabulariesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListDefaultVocabulariesIterable responses = client.listDefaultVocabulariesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDefaultVocabularies(software.amazon.awssdk.services.connect.model.ListDefaultVocabulariesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDefaultVocabulariesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListDefaultVocabularies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListDefaultVocabularies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDefaultVocabulariesIterable listDefaultVocabulariesPaginator(
            ListDefaultVocabulariesRequest listDefaultVocabulariesRequest) throws InvalidRequestException,
            InternalServiceException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            ConnectException {
        return new ListDefaultVocabulariesIterable(this, listDefaultVocabulariesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDefaultVocabularies(software.amazon.awssdk.services.connect.model.ListDefaultVocabulariesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListDefaultVocabulariesIterable responses = client.listDefaultVocabulariesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListDefaultVocabulariesIterable responses = client
     *             .listDefaultVocabulariesPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListDefaultVocabulariesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListDefaultVocabulariesIterable responses = client.listDefaultVocabulariesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDefaultVocabularies(software.amazon.awssdk.services.connect.model.ListDefaultVocabulariesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDefaultVocabulariesRequest.Builder} avoiding
     * the need to create one manually via {@link ListDefaultVocabulariesRequest#builder()}
     * </p>
     *
     * @param listDefaultVocabulariesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ListDefaultVocabulariesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListDefaultVocabularies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListDefaultVocabularies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDefaultVocabulariesIterable listDefaultVocabulariesPaginator(
            Consumer<ListDefaultVocabulariesRequest.Builder> listDefaultVocabulariesRequest) throws InvalidRequestException,
            InternalServiceException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            ConnectException {
        return listDefaultVocabulariesPaginator(ListDefaultVocabulariesRequest.builder()
                .applyMutation(listDefaultVocabulariesRequest).build());
    }

    /**
     * <p>
     * Lists versions of an evaluation form in the specified Amazon Connect instance.
     * </p>
     *
     * @param listEvaluationFormVersionsRequest
     * @return Result of the ListEvaluationFormVersions operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListEvaluationFormVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListEvaluationFormVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEvaluationFormVersionsResponse listEvaluationFormVersions(
            ListEvaluationFormVersionsRequest listEvaluationFormVersionsRequest) throws InvalidParameterException,
            ResourceNotFoundException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException,
            ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists versions of an evaluation form in the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEvaluationFormVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListEvaluationFormVersionsRequest#builder()}
     * </p>
     *
     * @param listEvaluationFormVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ListEvaluationFormVersionsRequest.Builder} to create
     *        a request.
     * @return Result of the ListEvaluationFormVersions operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListEvaluationFormVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListEvaluationFormVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEvaluationFormVersionsResponse listEvaluationFormVersions(
            Consumer<ListEvaluationFormVersionsRequest.Builder> listEvaluationFormVersionsRequest)
            throws InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return listEvaluationFormVersions(ListEvaluationFormVersionsRequest.builder()
                .applyMutation(listEvaluationFormVersionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEvaluationFormVersions(software.amazon.awssdk.services.connect.model.ListEvaluationFormVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListEvaluationFormVersionsIterable responses = client.listEvaluationFormVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListEvaluationFormVersionsIterable responses = client
     *             .listEvaluationFormVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListEvaluationFormVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListEvaluationFormVersionsIterable responses = client.listEvaluationFormVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEvaluationFormVersions(software.amazon.awssdk.services.connect.model.ListEvaluationFormVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEvaluationFormVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListEvaluationFormVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListEvaluationFormVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEvaluationFormVersionsIterable listEvaluationFormVersionsPaginator(
            ListEvaluationFormVersionsRequest listEvaluationFormVersionsRequest) throws InvalidParameterException,
            ResourceNotFoundException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException,
            ConnectException {
        return new ListEvaluationFormVersionsIterable(this, listEvaluationFormVersionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEvaluationFormVersions(software.amazon.awssdk.services.connect.model.ListEvaluationFormVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListEvaluationFormVersionsIterable responses = client.listEvaluationFormVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListEvaluationFormVersionsIterable responses = client
     *             .listEvaluationFormVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListEvaluationFormVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListEvaluationFormVersionsIterable responses = client.listEvaluationFormVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEvaluationFormVersions(software.amazon.awssdk.services.connect.model.ListEvaluationFormVersionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEvaluationFormVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListEvaluationFormVersionsRequest#builder()}
     * </p>
     *
     * @param listEvaluationFormVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ListEvaluationFormVersionsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListEvaluationFormVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListEvaluationFormVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEvaluationFormVersionsIterable listEvaluationFormVersionsPaginator(
            Consumer<ListEvaluationFormVersionsRequest.Builder> listEvaluationFormVersionsRequest)
            throws InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return listEvaluationFormVersionsPaginator(ListEvaluationFormVersionsRequest.builder()
                .applyMutation(listEvaluationFormVersionsRequest).build());
    }

    /**
     * <p>
     * Lists evaluation forms in the specified Amazon Connect instance.
     * </p>
     *
     * @param listEvaluationFormsRequest
     * @return Result of the ListEvaluationForms operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListEvaluationForms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListEvaluationForms" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEvaluationFormsResponse listEvaluationForms(ListEvaluationFormsRequest listEvaluationFormsRequest)
            throws InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists evaluation forms in the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEvaluationFormsRequest.Builder} avoiding the
     * need to create one manually via {@link ListEvaluationFormsRequest#builder()}
     * </p>
     *
     * @param listEvaluationFormsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ListEvaluationFormsRequest.Builder} to create a
     *        request.
     * @return Result of the ListEvaluationForms operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListEvaluationForms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListEvaluationForms" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEvaluationFormsResponse listEvaluationForms(
            Consumer<ListEvaluationFormsRequest.Builder> listEvaluationFormsRequest) throws InvalidParameterException,
            ResourceNotFoundException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException,
            ConnectException {
        return listEvaluationForms(ListEvaluationFormsRequest.builder().applyMutation(listEvaluationFormsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEvaluationForms(software.amazon.awssdk.services.connect.model.ListEvaluationFormsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListEvaluationFormsIterable responses = client.listEvaluationFormsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListEvaluationFormsIterable responses = client
     *             .listEvaluationFormsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListEvaluationFormsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListEvaluationFormsIterable responses = client.listEvaluationFormsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEvaluationForms(software.amazon.awssdk.services.connect.model.ListEvaluationFormsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEvaluationFormsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListEvaluationForms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListEvaluationForms" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEvaluationFormsIterable listEvaluationFormsPaginator(ListEvaluationFormsRequest listEvaluationFormsRequest)
            throws InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return new ListEvaluationFormsIterable(this, listEvaluationFormsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEvaluationForms(software.amazon.awssdk.services.connect.model.ListEvaluationFormsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListEvaluationFormsIterable responses = client.listEvaluationFormsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListEvaluationFormsIterable responses = client
     *             .listEvaluationFormsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListEvaluationFormsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListEvaluationFormsIterable responses = client.listEvaluationFormsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEvaluationForms(software.amazon.awssdk.services.connect.model.ListEvaluationFormsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEvaluationFormsRequest.Builder} avoiding the
     * need to create one manually via {@link ListEvaluationFormsRequest#builder()}
     * </p>
     *
     * @param listEvaluationFormsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ListEvaluationFormsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListEvaluationForms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListEvaluationForms" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEvaluationFormsIterable listEvaluationFormsPaginator(
            Consumer<ListEvaluationFormsRequest.Builder> listEvaluationFormsRequest) throws InvalidParameterException,
            ResourceNotFoundException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException,
            ConnectException {
        return listEvaluationFormsPaginator(ListEvaluationFormsRequest.builder().applyMutation(listEvaluationFormsRequest)
                .build());
    }

    /**
     * <p>
     * List the flow association based on the filters.
     * </p>
     *
     * @param listFlowAssociationsRequest
     * @return Result of the ListFlowAssociations operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListFlowAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListFlowAssociations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListFlowAssociationsResponse listFlowAssociations(ListFlowAssociationsRequest listFlowAssociationsRequest)
            throws AccessDeniedException, ResourceNotFoundException, InternalServiceException, InvalidRequestException,
            InvalidParameterException, ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the flow association based on the filters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFlowAssociationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListFlowAssociationsRequest#builder()}
     * </p>
     *
     * @param listFlowAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ListFlowAssociationsRequest.Builder} to create a
     *        request.
     * @return Result of the ListFlowAssociations operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListFlowAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListFlowAssociations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListFlowAssociationsResponse listFlowAssociations(
            Consumer<ListFlowAssociationsRequest.Builder> listFlowAssociationsRequest) throws AccessDeniedException,
            ResourceNotFoundException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return listFlowAssociations(ListFlowAssociationsRequest.builder().applyMutation(listFlowAssociationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFlowAssociations(software.amazon.awssdk.services.connect.model.ListFlowAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListFlowAssociationsIterable responses = client.listFlowAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListFlowAssociationsIterable responses = client
     *             .listFlowAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListFlowAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListFlowAssociationsIterable responses = client.listFlowAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFlowAssociations(software.amazon.awssdk.services.connect.model.ListFlowAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFlowAssociationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListFlowAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListFlowAssociations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListFlowAssociationsIterable listFlowAssociationsPaginator(ListFlowAssociationsRequest listFlowAssociationsRequest)
            throws AccessDeniedException, ResourceNotFoundException, InternalServiceException, InvalidRequestException,
            InvalidParameterException, ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return new ListFlowAssociationsIterable(this, listFlowAssociationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFlowAssociations(software.amazon.awssdk.services.connect.model.ListFlowAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListFlowAssociationsIterable responses = client.listFlowAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListFlowAssociationsIterable responses = client
     *             .listFlowAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListFlowAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListFlowAssociationsIterable responses = client.listFlowAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFlowAssociations(software.amazon.awssdk.services.connect.model.ListFlowAssociationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFlowAssociationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListFlowAssociationsRequest#builder()}
     * </p>
     *
     * @param listFlowAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ListFlowAssociationsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListFlowAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListFlowAssociations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListFlowAssociationsIterable listFlowAssociationsPaginator(
            Consumer<ListFlowAssociationsRequest.Builder> listFlowAssociationsRequest) throws AccessDeniedException,
            ResourceNotFoundException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return listFlowAssociationsPaginator(ListFlowAssociationsRequest.builder().applyMutation(listFlowAssociationsRequest)
                .build());
    }

    /**
     * <p>
     * Provides information about the hours of operation for the specified Amazon Connect instance.
     * </p>
     * <p>
     * For more information about hours of operation, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/set-hours-operation.html">Set the Hours of Operation
     * for a Queue</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     *
     * @param listHoursOfOperationsRequest
     * @return Result of the ListHoursOfOperations operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListHoursOfOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListHoursOfOperations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListHoursOfOperationsResponse listHoursOfOperations(ListHoursOfOperationsRequest listHoursOfOperationsRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about the hours of operation for the specified Amazon Connect instance.
     * </p>
     * <p>
     * For more information about hours of operation, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/set-hours-operation.html">Set the Hours of Operation
     * for a Queue</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListHoursOfOperationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListHoursOfOperationsRequest#builder()}
     * </p>
     *
     * @param listHoursOfOperationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ListHoursOfOperationsRequest.Builder} to create a
     *        request.
     * @return Result of the ListHoursOfOperations operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListHoursOfOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListHoursOfOperations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListHoursOfOperationsResponse listHoursOfOperations(
            Consumer<ListHoursOfOperationsRequest.Builder> listHoursOfOperationsRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return listHoursOfOperations(ListHoursOfOperationsRequest.builder().applyMutation(listHoursOfOperationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listHoursOfOperations(software.amazon.awssdk.services.connect.model.ListHoursOfOperationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListHoursOfOperationsIterable responses = client.listHoursOfOperationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListHoursOfOperationsIterable responses = client
     *             .listHoursOfOperationsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListHoursOfOperationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListHoursOfOperationsIterable responses = client.listHoursOfOperationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listHoursOfOperations(software.amazon.awssdk.services.connect.model.ListHoursOfOperationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listHoursOfOperationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListHoursOfOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListHoursOfOperations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListHoursOfOperationsIterable listHoursOfOperationsPaginator(ListHoursOfOperationsRequest listHoursOfOperationsRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return new ListHoursOfOperationsIterable(this, listHoursOfOperationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listHoursOfOperations(software.amazon.awssdk.services.connect.model.ListHoursOfOperationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListHoursOfOperationsIterable responses = client.listHoursOfOperationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListHoursOfOperationsIterable responses = client
     *             .listHoursOfOperationsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListHoursOfOperationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListHoursOfOperationsIterable responses = client.listHoursOfOperationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listHoursOfOperations(software.amazon.awssdk.services.connect.model.ListHoursOfOperationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListHoursOfOperationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListHoursOfOperationsRequest#builder()}
     * </p>
     *
     * @param listHoursOfOperationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ListHoursOfOperationsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListHoursOfOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListHoursOfOperations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListHoursOfOperationsIterable listHoursOfOperationsPaginator(
            Consumer<ListHoursOfOperationsRequest.Builder> listHoursOfOperationsRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return listHoursOfOperationsPaginator(ListHoursOfOperationsRequest.builder().applyMutation(listHoursOfOperationsRequest)
                .build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Returns a paginated list of all attribute types for the given instance.
     * </p>
     *
     * @param listInstanceAttributesRequest
     * @return Result of the ListInstanceAttributes operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListInstanceAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListInstanceAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstanceAttributesResponse listInstanceAttributes(ListInstanceAttributesRequest listInstanceAttributesRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Returns a paginated list of all attribute types for the given instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstanceAttributesRequest.Builder} avoiding the
     * need to create one manually via {@link ListInstanceAttributesRequest#builder()}
     * </p>
     *
     * @param listInstanceAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ListInstanceAttributesRequest.Builder} to create a
     *        request.
     * @return Result of the ListInstanceAttributes operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListInstanceAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListInstanceAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstanceAttributesResponse listInstanceAttributes(
            Consumer<ListInstanceAttributesRequest.Builder> listInstanceAttributesRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, InvalidParameterException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        return listInstanceAttributes(ListInstanceAttributesRequest.builder().applyMutation(listInstanceAttributesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInstanceAttributes(software.amazon.awssdk.services.connect.model.ListInstanceAttributesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListInstanceAttributesIterable responses = client.listInstanceAttributesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListInstanceAttributesIterable responses = client
     *             .listInstanceAttributesPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListInstanceAttributesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListInstanceAttributesIterable responses = client.listInstanceAttributesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstanceAttributes(software.amazon.awssdk.services.connect.model.ListInstanceAttributesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listInstanceAttributesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListInstanceAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListInstanceAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstanceAttributesIterable listInstanceAttributesPaginator(
            ListInstanceAttributesRequest listInstanceAttributesRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, InvalidParameterException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        return new ListInstanceAttributesIterable(this, listInstanceAttributesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInstanceAttributes(software.amazon.awssdk.services.connect.model.ListInstanceAttributesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListInstanceAttributesIterable responses = client.listInstanceAttributesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListInstanceAttributesIterable responses = client
     *             .listInstanceAttributesPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListInstanceAttributesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListInstanceAttributesIterable responses = client.listInstanceAttributesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstanceAttributes(software.amazon.awssdk.services.connect.model.ListInstanceAttributesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstanceAttributesRequest.Builder} avoiding the
     * need to create one manually via {@link ListInstanceAttributesRequest#builder()}
     * </p>
     *
     * @param listInstanceAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ListInstanceAttributesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListInstanceAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListInstanceAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstanceAttributesIterable listInstanceAttributesPaginator(
            Consumer<ListInstanceAttributesRequest.Builder> listInstanceAttributesRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, InvalidParameterException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        return listInstanceAttributesPaginator(ListInstanceAttributesRequest.builder()
                .applyMutation(listInstanceAttributesRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Returns a paginated list of storage configs for the identified instance and resource type.
     * </p>
     *
     * @param listInstanceStorageConfigsRequest
     * @return Result of the ListInstanceStorageConfigs operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListInstanceStorageConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListInstanceStorageConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstanceStorageConfigsResponse listInstanceStorageConfigs(
            ListInstanceStorageConfigsRequest listInstanceStorageConfigsRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, InvalidParameterException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Returns a paginated list of storage configs for the identified instance and resource type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstanceStorageConfigsRequest.Builder} avoiding
     * the need to create one manually via {@link ListInstanceStorageConfigsRequest#builder()}
     * </p>
     *
     * @param listInstanceStorageConfigsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ListInstanceStorageConfigsRequest.Builder} to create
     *        a request.
     * @return Result of the ListInstanceStorageConfigs operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListInstanceStorageConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListInstanceStorageConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstanceStorageConfigsResponse listInstanceStorageConfigs(
            Consumer<ListInstanceStorageConfigsRequest.Builder> listInstanceStorageConfigsRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return listInstanceStorageConfigs(ListInstanceStorageConfigsRequest.builder()
                .applyMutation(listInstanceStorageConfigsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInstanceStorageConfigs(software.amazon.awssdk.services.connect.model.ListInstanceStorageConfigsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListInstanceStorageConfigsIterable responses = client.listInstanceStorageConfigsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListInstanceStorageConfigsIterable responses = client
     *             .listInstanceStorageConfigsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListInstanceStorageConfigsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListInstanceStorageConfigsIterable responses = client.listInstanceStorageConfigsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstanceStorageConfigs(software.amazon.awssdk.services.connect.model.ListInstanceStorageConfigsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listInstanceStorageConfigsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListInstanceStorageConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListInstanceStorageConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstanceStorageConfigsIterable listInstanceStorageConfigsPaginator(
            ListInstanceStorageConfigsRequest listInstanceStorageConfigsRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, InvalidParameterException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        return new ListInstanceStorageConfigsIterable(this, listInstanceStorageConfigsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInstanceStorageConfigs(software.amazon.awssdk.services.connect.model.ListInstanceStorageConfigsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListInstanceStorageConfigsIterable responses = client.listInstanceStorageConfigsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListInstanceStorageConfigsIterable responses = client
     *             .listInstanceStorageConfigsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListInstanceStorageConfigsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListInstanceStorageConfigsIterable responses = client.listInstanceStorageConfigsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstanceStorageConfigs(software.amazon.awssdk.services.connect.model.ListInstanceStorageConfigsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstanceStorageConfigsRequest.Builder} avoiding
     * the need to create one manually via {@link ListInstanceStorageConfigsRequest#builder()}
     * </p>
     *
     * @param listInstanceStorageConfigsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ListInstanceStorageConfigsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListInstanceStorageConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListInstanceStorageConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstanceStorageConfigsIterable listInstanceStorageConfigsPaginator(
            Consumer<ListInstanceStorageConfigsRequest.Builder> listInstanceStorageConfigsRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return listInstanceStorageConfigsPaginator(ListInstanceStorageConfigsRequest.builder()
                .applyMutation(listInstanceStorageConfigsRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Return a list of instances which are in active state, creation-in-progress state, and failed state. Instances
     * that aren't successfully created (they are in a failed state) are returned only for 24 hours after the
     * CreateInstance API was invoked.
     * </p>
     *
     * @param listInstancesRequest
     * @return Result of the ListInstances operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInstancesResponse listInstances(ListInstancesRequest listInstancesRequest) throws InvalidRequestException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Return a list of instances which are in active state, creation-in-progress state, and failed state. Instances
     * that aren't successfully created (they are in a failed state) are returned only for 24 hours after the
     * CreateInstance API was invoked.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstancesRequest.Builder} avoiding the need to
     * create one manually via {@link ListInstancesRequest#builder()}
     * </p>
     *
     * @param listInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ListInstancesRequest.Builder} to create a request.
     * @return Result of the ListInstances operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInstancesResponse listInstances(Consumer<ListInstancesRequest.Builder> listInstancesRequest)
            throws InvalidRequestException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return listInstances(ListInstancesRequest.builder().applyMutation(listInstancesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listInstances(software.amazon.awssdk.services.connect.model.ListInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListInstancesIterable responses = client.listInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListInstancesIterable responses = client.listInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListInstancesIterable responses = client.listInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstances(software.amazon.awssdk.services.connect.model.ListInstancesRequest)} operation.</b>
     * </p>
     *
     * @param listInstancesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInstancesIterable listInstancesPaginator(ListInstancesRequest listInstancesRequest)
            throws InvalidRequestException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return new ListInstancesIterable(this, listInstancesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listInstances(software.amazon.awssdk.services.connect.model.ListInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListInstancesIterable responses = client.listInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListInstancesIterable responses = client.listInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListInstancesIterable responses = client.listInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstances(software.amazon.awssdk.services.connect.model.ListInstancesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstancesRequest.Builder} avoiding the need to
     * create one manually via {@link ListInstancesRequest#builder()}
     * </p>
     *
     * @param listInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ListInstancesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInstancesIterable listInstancesPaginator(Consumer<ListInstancesRequest.Builder> listInstancesRequest)
            throws InvalidRequestException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return listInstancesPaginator(ListInstancesRequest.builder().applyMutation(listInstancesRequest).build());
    }

    /**
     * <p>
     * Provides summary information about the Amazon Web Services resource associations for the specified Amazon Connect
     * instance.
     * </p>
     *
     * @param listIntegrationAssociationsRequest
     * @return Result of the ListIntegrationAssociations operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListIntegrationAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListIntegrationAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIntegrationAssociationsResponse listIntegrationAssociations(
            ListIntegrationAssociationsRequest listIntegrationAssociationsRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, ThrottlingException, AwsServiceException, SdkClientException,
            ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides summary information about the Amazon Web Services resource associations for the specified Amazon Connect
     * instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIntegrationAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListIntegrationAssociationsRequest#builder()}
     * </p>
     *
     * @param listIntegrationAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ListIntegrationAssociationsRequest.Builder} to create
     *        a request.
     * @return Result of the ListIntegrationAssociations operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListIntegrationAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListIntegrationAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIntegrationAssociationsResponse listIntegrationAssociations(
            Consumer<ListIntegrationAssociationsRequest.Builder> listIntegrationAssociationsRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        return listIntegrationAssociations(ListIntegrationAssociationsRequest.builder()
                .applyMutation(listIntegrationAssociationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listIntegrationAssociations(software.amazon.awssdk.services.connect.model.ListIntegrationAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListIntegrationAssociationsIterable responses = client.listIntegrationAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListIntegrationAssociationsIterable responses = client
     *             .listIntegrationAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListIntegrationAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListIntegrationAssociationsIterable responses = client.listIntegrationAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIntegrationAssociations(software.amazon.awssdk.services.connect.model.ListIntegrationAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listIntegrationAssociationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListIntegrationAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListIntegrationAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIntegrationAssociationsIterable listIntegrationAssociationsPaginator(
            ListIntegrationAssociationsRequest listIntegrationAssociationsRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, ThrottlingException, AwsServiceException, SdkClientException,
            ConnectException {
        return new ListIntegrationAssociationsIterable(this, listIntegrationAssociationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listIntegrationAssociations(software.amazon.awssdk.services.connect.model.ListIntegrationAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListIntegrationAssociationsIterable responses = client.listIntegrationAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListIntegrationAssociationsIterable responses = client
     *             .listIntegrationAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListIntegrationAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListIntegrationAssociationsIterable responses = client.listIntegrationAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIntegrationAssociations(software.amazon.awssdk.services.connect.model.ListIntegrationAssociationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIntegrationAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListIntegrationAssociationsRequest#builder()}
     * </p>
     *
     * @param listIntegrationAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ListIntegrationAssociationsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListIntegrationAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListIntegrationAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIntegrationAssociationsIterable listIntegrationAssociationsPaginator(
            Consumer<ListIntegrationAssociationsRequest.Builder> listIntegrationAssociationsRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        return listIntegrationAssociationsPaginator(ListIntegrationAssociationsRequest.builder()
                .applyMutation(listIntegrationAssociationsRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Returns a paginated list of all Lambda functions that display in the dropdown options in the relevant flow
     * blocks.
     * </p>
     *
     * @param listLambdaFunctionsRequest
     * @return Result of the ListLambdaFunctions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListLambdaFunctions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListLambdaFunctions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLambdaFunctionsResponse listLambdaFunctions(ListLambdaFunctionsRequest listLambdaFunctionsRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Returns a paginated list of all Lambda functions that display in the dropdown options in the relevant flow
     * blocks.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLambdaFunctionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListLambdaFunctionsRequest#builder()}
     * </p>
     *
     * @param listLambdaFunctionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ListLambdaFunctionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListLambdaFunctions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListLambdaFunctions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListLambdaFunctions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLambdaFunctionsResponse listLambdaFunctions(
            Consumer<ListLambdaFunctionsRequest.Builder> listLambdaFunctionsRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, InvalidParameterException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        return listLambdaFunctions(ListLambdaFunctionsRequest.builder().applyMutation(listLambdaFunctionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLambdaFunctions(software.amazon.awssdk.services.connect.model.ListLambdaFunctionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListLambdaFunctionsIterable responses = client.listLambdaFunctionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListLambdaFunctionsIterable responses = client
     *             .listLambdaFunctionsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListLambdaFunctionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListLambdaFunctionsIterable responses = client.listLambdaFunctionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLambdaFunctions(software.amazon.awssdk.services.connect.model.ListLambdaFunctionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listLambdaFunctionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListLambdaFunctions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListLambdaFunctions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLambdaFunctionsIterable listLambdaFunctionsPaginator(ListLambdaFunctionsRequest listLambdaFunctionsRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return new ListLambdaFunctionsIterable(this, listLambdaFunctionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLambdaFunctions(software.amazon.awssdk.services.connect.model.ListLambdaFunctionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListLambdaFunctionsIterable responses = client.listLambdaFunctionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListLambdaFunctionsIterable responses = client
     *             .listLambdaFunctionsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListLambdaFunctionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListLambdaFunctionsIterable responses = client.listLambdaFunctionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLambdaFunctions(software.amazon.awssdk.services.connect.model.ListLambdaFunctionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLambdaFunctionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListLambdaFunctionsRequest#builder()}
     * </p>
     *
     * @param listLambdaFunctionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ListLambdaFunctionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListLambdaFunctions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListLambdaFunctions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLambdaFunctionsIterable listLambdaFunctionsPaginator(
            Consumer<ListLambdaFunctionsRequest.Builder> listLambdaFunctionsRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, InvalidParameterException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        return listLambdaFunctionsPaginator(ListLambdaFunctionsRequest.builder().applyMutation(listLambdaFunctionsRequest)
                .build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Returns a paginated list of all the Amazon Lex V1 bots currently associated with the instance. To return both
     * Amazon Lex V1 and V2 bots, use the <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_ListBots.html">ListBots</a> API.
     * </p>
     *
     * @param listLexBotsRequest
     * @return Result of the ListLexBots operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListLexBots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListLexBots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLexBotsResponse listLexBots(ListLexBotsRequest listLexBotsRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, InvalidParameterException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Returns a paginated list of all the Amazon Lex V1 bots currently associated with the instance. To return both
     * Amazon Lex V1 and V2 bots, use the <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_ListBots.html">ListBots</a> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLexBotsRequest.Builder} avoiding the need to
     * create one manually via {@link ListLexBotsRequest#builder()}
     * </p>
     *
     * @param listLexBotsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ListLexBotsRequest.Builder} to create a request.
     * @return Result of the ListLexBots operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListLexBots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListLexBots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLexBotsResponse listLexBots(Consumer<ListLexBotsRequest.Builder> listLexBotsRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return listLexBots(ListLexBotsRequest.builder().applyMutation(listLexBotsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listLexBots(software.amazon.awssdk.services.connect.model.ListLexBotsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListLexBotsIterable responses = client.listLexBotsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListLexBotsIterable responses = client.listLexBotsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListLexBotsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListLexBotsIterable responses = client.listLexBotsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLexBots(software.amazon.awssdk.services.connect.model.ListLexBotsRequest)} operation.</b>
     * </p>
     *
     * @param listLexBotsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListLexBots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListLexBots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLexBotsIterable listLexBotsPaginator(ListLexBotsRequest listLexBotsRequest) throws ResourceNotFoundException,
            InternalServiceException, InvalidRequestException, InvalidParameterException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        return new ListLexBotsIterable(this, listLexBotsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listLexBots(software.amazon.awssdk.services.connect.model.ListLexBotsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListLexBotsIterable responses = client.listLexBotsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListLexBotsIterable responses = client.listLexBotsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListLexBotsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListLexBotsIterable responses = client.listLexBotsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLexBots(software.amazon.awssdk.services.connect.model.ListLexBotsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLexBotsRequest.Builder} avoiding the need to
     * create one manually via {@link ListLexBotsRequest#builder()}
     * </p>
     *
     * @param listLexBotsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ListLexBotsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListLexBots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListLexBots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLexBotsIterable listLexBotsPaginator(Consumer<ListLexBotsRequest.Builder> listLexBotsRequest)
            throws ResourceNotFoundException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        return listLexBotsPaginator(ListLexBotsRequest.builder().applyMutation(listLexBotsRequest).build());
    }

    /**
     * <p>
     * Provides information about the phone numbers for the specified Amazon Connect instance.
     * </p>
     * <p>
     * For more information about phone numbers, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-center-phone-number.html">Set Up Phone
     * Numbers for Your Contact Center</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <important>
     * <ul>
     * <li>
     * <p>
     * We recommend using <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_ListPhoneNumbersV2.html">ListPhoneNumbersV2</a>
     * to return phone number types. ListPhoneNumbers doesn't support number types <code>UIFN</code>,
     * <code>SHARED</code>, <code>THIRD_PARTY_TF</code>, and <code>THIRD_PARTY_DID</code>. While it returns numbers of
     * those types, it incorrectly lists them as <code>TOLL_FREE</code> or <code>DID</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The phone number <code>Arn</code> value that is returned from each of the items in the <a href=
     * "https://docs.aws.amazon.com/connect/latest/APIReference/API_ListPhoneNumbers.html#connect-ListPhoneNumbers-response-PhoneNumberSummaryList"
     * >PhoneNumberSummaryList</a> cannot be used to tag phone number resources. It will fail with a
     * <code>ResourceNotFoundException</code>. Instead, use the <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_ListPhoneNumbersV2.html">ListPhoneNumbersV2</a>
     * API. It returns the new phone number ARN that can be used to tag phone number resources.
     * </p>
     * </li>
     * </ul>
     * </important>
     *
     * @param listPhoneNumbersRequest
     * @return Result of the ListPhoneNumbers operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListPhoneNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListPhoneNumbers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPhoneNumbersResponse listPhoneNumbers(ListPhoneNumbersRequest listPhoneNumbersRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about the phone numbers for the specified Amazon Connect instance.
     * </p>
     * <p>
     * For more information about phone numbers, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-center-phone-number.html">Set Up Phone
     * Numbers for Your Contact Center</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <important>
     * <ul>
     * <li>
     * <p>
     * We recommend using <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_ListPhoneNumbersV2.html">ListPhoneNumbersV2</a>
     * to return phone number types. ListPhoneNumbers doesn't support number types <code>UIFN</code>,
     * <code>SHARED</code>, <code>THIRD_PARTY_TF</code>, and <code>THIRD_PARTY_DID</code>. While it returns numbers of
     * those types, it incorrectly lists them as <code>TOLL_FREE</code> or <code>DID</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The phone number <code>Arn</code> value that is returned from each of the items in the <a href=
     * "https://docs.aws.amazon.com/connect/latest/APIReference/API_ListPhoneNumbers.html#connect-ListPhoneNumbers-response-PhoneNumberSummaryList"
     * >PhoneNumberSummaryList</a> cannot be used to tag phone number resources. It will fail with a
     * <code>ResourceNotFoundException</code>. Instead, use the <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_ListPhoneNumbersV2.html">ListPhoneNumbersV2</a>
     * API. It returns the new phone number ARN that can be used to tag phone number resources.
     * </p>
     * </li>
     * </ul>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPhoneNumbersRequest.Builder} avoiding the need
     * to create one manually via {@link ListPhoneNumbersRequest#builder()}
     * </p>
     *
     * @param listPhoneNumbersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ListPhoneNumbersRequest.Builder} to create a request.
     * @return Result of the ListPhoneNumbers operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListPhoneNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListPhoneNumbers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPhoneNumbersResponse listPhoneNumbers(Consumer<ListPhoneNumbersRequest.Builder> listPhoneNumbersRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return listPhoneNumbers(ListPhoneNumbersRequest.builder().applyMutation(listPhoneNumbersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPhoneNumbers(software.amazon.awssdk.services.connect.model.ListPhoneNumbersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListPhoneNumbersIterable responses = client.listPhoneNumbersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListPhoneNumbersIterable responses = client
     *             .listPhoneNumbersPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListPhoneNumbersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListPhoneNumbersIterable responses = client.listPhoneNumbersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPhoneNumbers(software.amazon.awssdk.services.connect.model.ListPhoneNumbersRequest)} operation.</b>
     * </p>
     *
     * @param listPhoneNumbersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListPhoneNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListPhoneNumbers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPhoneNumbersIterable listPhoneNumbersPaginator(ListPhoneNumbersRequest listPhoneNumbersRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return new ListPhoneNumbersIterable(this, listPhoneNumbersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPhoneNumbers(software.amazon.awssdk.services.connect.model.ListPhoneNumbersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListPhoneNumbersIterable responses = client.listPhoneNumbersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListPhoneNumbersIterable responses = client
     *             .listPhoneNumbersPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListPhoneNumbersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListPhoneNumbersIterable responses = client.listPhoneNumbersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPhoneNumbers(software.amazon.awssdk.services.connect.model.ListPhoneNumbersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPhoneNumbersRequest.Builder} avoiding the need
     * to create one manually via {@link ListPhoneNumbersRequest#builder()}
     * </p>
     *
     * @param listPhoneNumbersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ListPhoneNumbersRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListPhoneNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListPhoneNumbers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPhoneNumbersIterable listPhoneNumbersPaginator(Consumer<ListPhoneNumbersRequest.Builder> listPhoneNumbersRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return listPhoneNumbersPaginator(ListPhoneNumbersRequest.builder().applyMutation(listPhoneNumbersRequest).build());
    }

    /**
     * <p>
     * Lists phone numbers claimed to your Amazon Connect instance or traffic distribution group. If the provided
     * <code>TargetArn</code> is a traffic distribution group, you can call this API in both Amazon Web Services Regions
     * associated with traffic distribution group.
     * </p>
     * <p>
     * For more information about phone numbers, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-center-phone-number.html">Set Up Phone
     * Numbers for Your Contact Center</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * When given an instance ARN, <code>ListPhoneNumbersV2</code> returns only the phone numbers claimed to the
     * instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * When given a traffic distribution group ARN <code>ListPhoneNumbersV2</code> returns only the phone numbers
     * claimed to the traffic distribution group.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param listPhoneNumbersV2Request
     * @return Result of the ListPhoneNumbersV2 operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListPhoneNumbersV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListPhoneNumbersV2" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPhoneNumbersV2Response listPhoneNumbersV2(ListPhoneNumbersV2Request listPhoneNumbersV2Request)
            throws InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AccessDeniedException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists phone numbers claimed to your Amazon Connect instance or traffic distribution group. If the provided
     * <code>TargetArn</code> is a traffic distribution group, you can call this API in both Amazon Web Services Regions
     * associated with traffic distribution group.
     * </p>
     * <p>
     * For more information about phone numbers, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-center-phone-number.html">Set Up Phone
     * Numbers for Your Contact Center</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * When given an instance ARN, <code>ListPhoneNumbersV2</code> returns only the phone numbers claimed to the
     * instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * When given a traffic distribution group ARN <code>ListPhoneNumbersV2</code> returns only the phone numbers
     * claimed to the traffic distribution group.
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPhoneNumbersV2Request.Builder} avoiding the
     * need to create one manually via {@link ListPhoneNumbersV2Request#builder()}
     * </p>
     *
     * @param listPhoneNumbersV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ListPhoneNumbersV2Request.Builder} to create a
     *        request.
     * @return Result of the ListPhoneNumbersV2 operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListPhoneNumbersV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListPhoneNumbersV2" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPhoneNumbersV2Response listPhoneNumbersV2(Consumer<ListPhoneNumbersV2Request.Builder> listPhoneNumbersV2Request)
            throws InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AccessDeniedException, AwsServiceException, SdkClientException, ConnectException {
        return listPhoneNumbersV2(ListPhoneNumbersV2Request.builder().applyMutation(listPhoneNumbersV2Request).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPhoneNumbersV2(software.amazon.awssdk.services.connect.model.ListPhoneNumbersV2Request)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListPhoneNumbersV2Iterable responses = client.listPhoneNumbersV2Paginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListPhoneNumbersV2Iterable responses = client
     *             .listPhoneNumbersV2Paginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListPhoneNumbersV2Response response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListPhoneNumbersV2Iterable responses = client.listPhoneNumbersV2Paginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPhoneNumbersV2(software.amazon.awssdk.services.connect.model.ListPhoneNumbersV2Request)}
     * operation.</b>
     * </p>
     *
     * @param listPhoneNumbersV2Request
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListPhoneNumbersV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListPhoneNumbersV2" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPhoneNumbersV2Iterable listPhoneNumbersV2Paginator(ListPhoneNumbersV2Request listPhoneNumbersV2Request)
            throws InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AccessDeniedException, AwsServiceException, SdkClientException, ConnectException {
        return new ListPhoneNumbersV2Iterable(this, listPhoneNumbersV2Request);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPhoneNumbersV2(software.amazon.awssdk.services.connect.model.ListPhoneNumbersV2Request)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListPhoneNumbersV2Iterable responses = client.listPhoneNumbersV2Paginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListPhoneNumbersV2Iterable responses = client
     *             .listPhoneNumbersV2Paginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListPhoneNumbersV2Response response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListPhoneNumbersV2Iterable responses = client.listPhoneNumbersV2Paginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPhoneNumbersV2(software.amazon.awssdk.services.connect.model.ListPhoneNumbersV2Request)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPhoneNumbersV2Request.Builder} avoiding the
     * need to create one manually via {@link ListPhoneNumbersV2Request#builder()}
     * </p>
     *
     * @param listPhoneNumbersV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ListPhoneNumbersV2Request.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListPhoneNumbersV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListPhoneNumbersV2" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPhoneNumbersV2Iterable listPhoneNumbersV2Paginator(
            Consumer<ListPhoneNumbersV2Request.Builder> listPhoneNumbersV2Request) throws InvalidParameterException,
            ResourceNotFoundException, ThrottlingException, InternalServiceException, AccessDeniedException, AwsServiceException,
            SdkClientException, ConnectException {
        return listPhoneNumbersV2Paginator(ListPhoneNumbersV2Request.builder().applyMutation(listPhoneNumbersV2Request).build());
    }

    /**
     * <p>
     * Lists predefined attributes for the specified Amazon Connect instance.
     * </p>
     *
     * @param listPredefinedAttributesRequest
     * @return Result of the ListPredefinedAttributes operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListPredefinedAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListPredefinedAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPredefinedAttributesResponse listPredefinedAttributes(
            ListPredefinedAttributesRequest listPredefinedAttributesRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists predefined attributes for the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPredefinedAttributesRequest.Builder} avoiding
     * the need to create one manually via {@link ListPredefinedAttributesRequest#builder()}
     * </p>
     *
     * @param listPredefinedAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ListPredefinedAttributesRequest.Builder} to create a
     *        request.
     * @return Result of the ListPredefinedAttributes operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListPredefinedAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListPredefinedAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPredefinedAttributesResponse listPredefinedAttributes(
            Consumer<ListPredefinedAttributesRequest.Builder> listPredefinedAttributesRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return listPredefinedAttributes(ListPredefinedAttributesRequest.builder().applyMutation(listPredefinedAttributesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPredefinedAttributes(software.amazon.awssdk.services.connect.model.ListPredefinedAttributesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListPredefinedAttributesIterable responses = client.listPredefinedAttributesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListPredefinedAttributesIterable responses = client
     *             .listPredefinedAttributesPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListPredefinedAttributesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListPredefinedAttributesIterable responses = client.listPredefinedAttributesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPredefinedAttributes(software.amazon.awssdk.services.connect.model.ListPredefinedAttributesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPredefinedAttributesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListPredefinedAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListPredefinedAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPredefinedAttributesIterable listPredefinedAttributesPaginator(
            ListPredefinedAttributesRequest listPredefinedAttributesRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return new ListPredefinedAttributesIterable(this, listPredefinedAttributesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPredefinedAttributes(software.amazon.awssdk.services.connect.model.ListPredefinedAttributesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListPredefinedAttributesIterable responses = client.listPredefinedAttributesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListPredefinedAttributesIterable responses = client
     *             .listPredefinedAttributesPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListPredefinedAttributesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListPredefinedAttributesIterable responses = client.listPredefinedAttributesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPredefinedAttributes(software.amazon.awssdk.services.connect.model.ListPredefinedAttributesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPredefinedAttributesRequest.Builder} avoiding
     * the need to create one manually via {@link ListPredefinedAttributesRequest#builder()}
     * </p>
     *
     * @param listPredefinedAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ListPredefinedAttributesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListPredefinedAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListPredefinedAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPredefinedAttributesIterable listPredefinedAttributesPaginator(
            Consumer<ListPredefinedAttributesRequest.Builder> listPredefinedAttributesRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return listPredefinedAttributesPaginator(ListPredefinedAttributesRequest.builder()
                .applyMutation(listPredefinedAttributesRequest).build());
    }

    /**
     * <p>
     * Provides information about the prompts for the specified Amazon Connect instance.
     * </p>
     *
     * @param listPromptsRequest
     * @return Result of the ListPrompts operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListPrompts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListPrompts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPromptsResponse listPrompts(ListPromptsRequest listPromptsRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about the prompts for the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPromptsRequest.Builder} avoiding the need to
     * create one manually via {@link ListPromptsRequest#builder()}
     * </p>
     *
     * @param listPromptsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ListPromptsRequest.Builder} to create a request.
     * @return Result of the ListPrompts operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListPrompts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListPrompts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPromptsResponse listPrompts(Consumer<ListPromptsRequest.Builder> listPromptsRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return listPrompts(ListPromptsRequest.builder().applyMutation(listPromptsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listPrompts(software.amazon.awssdk.services.connect.model.ListPromptsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListPromptsIterable responses = client.listPromptsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListPromptsIterable responses = client.listPromptsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListPromptsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListPromptsIterable responses = client.listPromptsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPrompts(software.amazon.awssdk.services.connect.model.ListPromptsRequest)} operation.</b>
     * </p>
     *
     * @param listPromptsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListPrompts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListPrompts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPromptsIterable listPromptsPaginator(ListPromptsRequest listPromptsRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return new ListPromptsIterable(this, listPromptsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listPrompts(software.amazon.awssdk.services.connect.model.ListPromptsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListPromptsIterable responses = client.listPromptsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListPromptsIterable responses = client.listPromptsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListPromptsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListPromptsIterable responses = client.listPromptsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPrompts(software.amazon.awssdk.services.connect.model.ListPromptsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPromptsRequest.Builder} avoiding the need to
     * create one manually via {@link ListPromptsRequest#builder()}
     * </p>
     *
     * @param listPromptsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ListPromptsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListPrompts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListPrompts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPromptsIterable listPromptsPaginator(Consumer<ListPromptsRequest.Builder> listPromptsRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return listPromptsPaginator(ListPromptsRequest.builder().applyMutation(listPromptsRequest).build());
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Lists the quick connects associated with a queue.
     * </p>
     *
     * @param listQueueQuickConnectsRequest
     * @return Result of the ListQueueQuickConnects operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListQueueQuickConnects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListQueueQuickConnects"
     *      target="_top">AWS API Documentation</a>
     */
    default ListQueueQuickConnectsResponse listQueueQuickConnects(ListQueueQuickConnectsRequest listQueueQuickConnectsRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Lists the quick connects associated with a queue.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQueueQuickConnectsRequest.Builder} avoiding the
     * need to create one manually via {@link ListQueueQuickConnectsRequest#builder()}
     * </p>
     *
     * @param listQueueQuickConnectsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ListQueueQuickConnectsRequest.Builder} to create a
     *        request.
     * @return Result of the ListQueueQuickConnects operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListQueueQuickConnects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListQueueQuickConnects"
     *      target="_top">AWS API Documentation</a>
     */
    default ListQueueQuickConnectsResponse listQueueQuickConnects(
            Consumer<ListQueueQuickConnectsRequest.Builder> listQueueQuickConnectsRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return listQueueQuickConnects(ListQueueQuickConnectsRequest.builder().applyMutation(listQueueQuickConnectsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listQueueQuickConnects(software.amazon.awssdk.services.connect.model.ListQueueQuickConnectsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListQueueQuickConnectsIterable responses = client.listQueueQuickConnectsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListQueueQuickConnectsIterable responses = client
     *             .listQueueQuickConnectsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListQueueQuickConnectsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListQueueQuickConnectsIterable responses = client.listQueueQuickConnectsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQueueQuickConnects(software.amazon.awssdk.services.connect.model.ListQueueQuickConnectsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listQueueQuickConnectsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListQueueQuickConnects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListQueueQuickConnects"
     *      target="_top">AWS API Documentation</a>
     */
    default ListQueueQuickConnectsIterable listQueueQuickConnectsPaginator(
            ListQueueQuickConnectsRequest listQueueQuickConnectsRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return new ListQueueQuickConnectsIterable(this, listQueueQuickConnectsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listQueueQuickConnects(software.amazon.awssdk.services.connect.model.ListQueueQuickConnectsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListQueueQuickConnectsIterable responses = client.listQueueQuickConnectsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListQueueQuickConnectsIterable responses = client
     *             .listQueueQuickConnectsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListQueueQuickConnectsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListQueueQuickConnectsIterable responses = client.listQueueQuickConnectsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQueueQuickConnects(software.amazon.awssdk.services.connect.model.ListQueueQuickConnectsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQueueQuickConnectsRequest.Builder} avoiding the
     * need to create one manually via {@link ListQueueQuickConnectsRequest#builder()}
     * </p>
     *
     * @param listQueueQuickConnectsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ListQueueQuickConnectsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListQueueQuickConnects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListQueueQuickConnects"
     *      target="_top">AWS API Documentation</a>
     */
    default ListQueueQuickConnectsIterable listQueueQuickConnectsPaginator(
            Consumer<ListQueueQuickConnectsRequest.Builder> listQueueQuickConnectsRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return listQueueQuickConnectsPaginator(ListQueueQuickConnectsRequest.builder()
                .applyMutation(listQueueQuickConnectsRequest).build());
    }

    /**
     * <p>
     * Provides information about the queues for the specified Amazon Connect instance.
     * </p>
     * <p>
     * If you do not specify a <code>QueueTypes</code> parameter, both standard and agent queues are returned. This
     * might cause an unexpected truncation of results if you have more than 1000 agents and you limit the number of
     * results of the API call in code.
     * </p>
     * <p>
     * For more information about queues, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-queues-standard-and-agent.html">Queues:
     * Standard and Agent</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     *
     * @param listQueuesRequest
     * @return Result of the ListQueues operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListQueues" target="_top">AWS API
     *      Documentation</a>
     */
    default ListQueuesResponse listQueues(ListQueuesRequest listQueuesRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about the queues for the specified Amazon Connect instance.
     * </p>
     * <p>
     * If you do not specify a <code>QueueTypes</code> parameter, both standard and agent queues are returned. This
     * might cause an unexpected truncation of results if you have more than 1000 agents and you limit the number of
     * results of the API call in code.
     * </p>
     * <p>
     * For more information about queues, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-queues-standard-and-agent.html">Queues:
     * Standard and Agent</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQueuesRequest.Builder} avoiding the need to
     * create one manually via {@link ListQueuesRequest#builder()}
     * </p>
     *
     * @param listQueuesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ListQueuesRequest.Builder} to create a request.
     * @return Result of the ListQueues operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListQueues" target="_top">AWS API
     *      Documentation</a>
     */
    default ListQueuesResponse listQueues(Consumer<ListQueuesRequest.Builder> listQueuesRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return listQueues(ListQueuesRequest.builder().applyMutation(listQueuesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listQueues(software.amazon.awssdk.services.connect.model.ListQueuesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListQueuesIterable responses = client.listQueuesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListQueuesIterable responses = client.listQueuesPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListQueuesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListQueuesIterable responses = client.listQueuesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQueues(software.amazon.awssdk.services.connect.model.ListQueuesRequest)} operation.</b>
     * </p>
     *
     * @param listQueuesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListQueues" target="_top">AWS API
     *      Documentation</a>
     */
    default ListQueuesIterable listQueuesPaginator(ListQueuesRequest listQueuesRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        return new ListQueuesIterable(this, listQueuesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listQueues(software.amazon.awssdk.services.connect.model.ListQueuesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListQueuesIterable responses = client.listQueuesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListQueuesIterable responses = client.listQueuesPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListQueuesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListQueuesIterable responses = client.listQueuesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQueues(software.amazon.awssdk.services.connect.model.ListQueuesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQueuesRequest.Builder} avoiding the need to
     * create one manually via {@link ListQueuesRequest#builder()}
     * </p>
     *
     * @param listQueuesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ListQueuesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListQueues" target="_top">AWS API
     *      Documentation</a>
     */
    default ListQueuesIterable listQueuesPaginator(Consumer<ListQueuesRequest.Builder> listQueuesRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return listQueuesPaginator(ListQueuesRequest.builder().applyMutation(listQueuesRequest).build());
    }

    /**
     * <p>
     * Provides information about the quick connects for the specified Amazon Connect instance.
     * </p>
     *
     * @param listQuickConnectsRequest
     * @return Result of the ListQuickConnects operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListQuickConnects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListQuickConnects" target="_top">AWS API
     *      Documentation</a>
     */
    default ListQuickConnectsResponse listQuickConnects(ListQuickConnectsRequest listQuickConnectsRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about the quick connects for the specified Amazon Connect instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQuickConnectsRequest.Builder} avoiding the need
     * to create one manually via {@link ListQuickConnectsRequest#builder()}
     * </p>
     *
     * @param listQuickConnectsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ListQuickConnectsRequest.Builder} to create a
     *        request.
     * @return Result of the ListQuickConnects operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListQuickConnects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListQuickConnects" target="_top">AWS API
     *      Documentation</a>
     */
    default ListQuickConnectsResponse listQuickConnects(Consumer<ListQuickConnectsRequest.Builder> listQuickConnectsRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return listQuickConnects(ListQuickConnectsRequest.builder().applyMutation(listQuickConnectsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listQuickConnects(software.amazon.awssdk.services.connect.model.ListQuickConnectsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListQuickConnectsIterable responses = client.listQuickConnectsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListQuickConnectsIterable responses = client
     *             .listQuickConnectsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListQuickConnectsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListQuickConnectsIterable responses = client.listQuickConnectsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQuickConnects(software.amazon.awssdk.services.connect.model.ListQuickConnectsRequest)} operation.</b>
     * </p>
     *
     * @param listQuickConnectsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ListQuickConnects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListQuickConnects" target="_top">AWS API
     *      Documentation</a>
     */
    default ListQuickConnectsIterable listQuickConnectsPaginator(ListQuickConnectsRequest listQuickConnectsRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        return new ListQuickConnectsIterable(this, listQuickConnectsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listQuickConnects(software.amazon.awssdk.services.connect.model.ListQuickConnectsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListQuickConnectsIterable responses = client.listQuickConnectsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.connect.paginators.ListQuickConnectsIterable responses = client
     *             .listQuickConnectsPaginator(request);
     *     for (software.amazon.awssdk.services.connect.model.ListQuickConnectsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connect.paginators.ListQuickConnectsIterable responses = client.listQuickConnectsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQuickConnects(software.amazon.awssdk.services.connect.model.ListQuickConnectsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQuickConnectsRequest.Builder} avoiding the need
     * to create one manually via {@link ListQuickConnectsRequest#builder()}
     * </p>
     *
     * @param listQuickConnectsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.connect.model.ListQuickConnectsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both 