/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Error describing a failure to retrieve attached file metadata through BatchGetAttachedFileMetadata action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttachedFileError implements SdkPojo, Serializable,
        ToCopyableBuilder<AttachedFileError.Builder, AttachedFileError> {
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorCode").getter(getter(AttachedFileError::errorCode)).setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(AttachedFileError::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final SdkField<String> FILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("FileId")
            .getter(getter(AttachedFileError::fileId)).setter(setter(Builder::fileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_CODE_FIELD,
            ERROR_MESSAGE_FIELD, FILE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String errorCode;

    private final String errorMessage;

    private final String fileId;

    private AttachedFileError(BuilderImpl builder) {
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
        this.fileId = builder.fileId;
    }

    /**
     * <p>
     * Status code describing the failure.
     * </p>
     * 
     * @return Status code describing the failure.
     */
    public final String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * Why the attached file couldn't be retrieved.
     * </p>
     * 
     * @return Why the attached file couldn't be retrieved.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * The unique identifier of the attached file resource.
     * </p>
     * 
     * @return The unique identifier of the attached file resource.
     */
    public final String fileId() {
        return fileId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(fileId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachedFileError)) {
            return false;
        }
        AttachedFileError other = (AttachedFileError) obj;
        return Objects.equals(errorCode(), other.errorCode()) && Objects.equals(errorMessage(), other.errorMessage())
                && Objects.equals(fileId(), other.fileId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AttachedFileError").add("ErrorCode", errorCode()).add("ErrorMessage", errorMessage())
                .add("FileId", fileId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ErrorCode":
            return Optional.ofNullable(clazz.cast(errorCode()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "FileId":
            return Optional.ofNullable(clazz.cast(fileId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttachedFileError, T> g) {
        return obj -> g.apply((AttachedFileError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AttachedFileError> {
        /**
         * <p>
         * Status code describing the failure.
         * </p>
         * 
         * @param errorCode
         *        Status code describing the failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * Why the attached file couldn't be retrieved.
         * </p>
         * 
         * @param errorMessage
         *        Why the attached file couldn't be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * The unique identifier of the attached file resource.
         * </p>
         * 
         * @param fileId
         *        The unique identifier of the attached file resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileId(String fileId);
    }

    static final class BuilderImpl implements Builder {
        private String errorCode;

        private String errorMessage;

        private String fileId;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachedFileError model) {
            errorCode(model.errorCode);
            errorMessage(model.errorMessage);
            fileId(model.fileId);
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getFileId() {
            return fileId;
        }

        public final void setFileId(String fileId) {
            this.fileId = fileId;
        }

        @Override
        public final Builder fileId(String fileId) {
            this.fileId = fileId;
            return this;
        }

        @Override
        public AttachedFileError build() {
            return new AttachedFileError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
