/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Request to CompleteAttachedFileUpload API
 */
@Generated("software.amazon.awssdk:codegen")
public final class CompleteAttachedFileUploadRequest extends ConnectRequest implements
        ToCopyableBuilder<CompleteAttachedFileUploadRequest.Builder, CompleteAttachedFileUploadRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(CompleteAttachedFileUploadRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> FILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("FileId")
            .getter(getter(CompleteAttachedFileUploadRequest::fileId)).setter(setter(Builder::fileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("FileId").build()).build();

    private static final SdkField<String> ASSOCIATED_RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssociatedResourceArn").getter(getter(CompleteAttachedFileUploadRequest::associatedResourceArn))
            .setter(setter(Builder::associatedResourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("associatedResourceArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            FILE_ID_FIELD, ASSOCIATED_RESOURCE_ARN_FIELD));

    private final String instanceId;

    private final String fileId;

    private final String associatedResourceArn;

    private CompleteAttachedFileUploadRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.fileId = builder.fileId;
        this.associatedResourceArn = builder.associatedResourceArn;
    }

    /**
     * <p>
     * The unique identifier of the Connect instance.
     * </p>
     * 
     * @return The unique identifier of the Connect instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The unique identifier of the attached file resource.
     * </p>
     * 
     * @return The unique identifier of the attached file resource.
     */
    public final String fileId() {
        return fileId;
    }

    /**
     * <p>
     * The resource to which the attached file is (being) uploaded to. <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_connect-cases_CreateCase.html">Cases</a> are
     * the only current supported resource.
     * </p>
     * <note>
     * <p>
     * This value must be a valid ARN.
     * </p>
     * </note>
     * 
     * @return The resource to which the attached file is (being) uploaded to. <a
     *         href="https://docs.aws.amazon.com/connect/latest/APIReference/API_connect-cases_CreateCase.html"
     *         >Cases</a> are the only current supported resource.</p> <note>
     *         <p>
     *         This value must be a valid ARN.
     *         </p>
     */
    public final String associatedResourceArn() {
        return associatedResourceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(fileId());
        hashCode = 31 * hashCode + Objects.hashCode(associatedResourceArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompleteAttachedFileUploadRequest)) {
            return false;
        }
        CompleteAttachedFileUploadRequest other = (CompleteAttachedFileUploadRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(fileId(), other.fileId())
                && Objects.equals(associatedResourceArn(), other.associatedResourceArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CompleteAttachedFileUploadRequest").add("InstanceId", instanceId()).add("FileId", fileId())
                .add("AssociatedResourceArn", associatedResourceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "FileId":
            return Optional.ofNullable(clazz.cast(fileId()));
        case "AssociatedResourceArn":
            return Optional.ofNullable(clazz.cast(associatedResourceArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CompleteAttachedFileUploadRequest, T> g) {
        return obj -> g.apply((CompleteAttachedFileUploadRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, CompleteAttachedFileUploadRequest> {
        /**
         * <p>
         * The unique identifier of the Connect instance.
         * </p>
         * 
         * @param instanceId
         *        The unique identifier of the Connect instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The unique identifier of the attached file resource.
         * </p>
         * 
         * @param fileId
         *        The unique identifier of the attached file resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileId(String fileId);

        /**
         * <p>
         * The resource to which the attached file is (being) uploaded to. <a
         * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_connect-cases_CreateCase.html">Cases</a>
         * are the only current supported resource.
         * </p>
         * <note>
         * <p>
         * This value must be a valid ARN.
         * </p>
         * </note>
         * 
         * @param associatedResourceArn
         *        The resource to which the attached file is (being) uploaded to. <a
         *        href="https://docs.aws.amazon.com/connect/latest/APIReference/API_connect-cases_CreateCase.html"
         *        >Cases</a> are the only current supported resource.</p> <note>
         *        <p>
         *        This value must be a valid ARN.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedResourceArn(String associatedResourceArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String fileId;

        private String associatedResourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CompleteAttachedFileUploadRequest model) {
            super(model);
            instanceId(model.instanceId);
            fileId(model.fileId);
            associatedResourceArn(model.associatedResourceArn);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getFileId() {
            return fileId;
        }

        public final void setFileId(String fileId) {
            this.fileId = fileId;
        }

        @Override
        public final Builder fileId(String fileId) {
            this.fileId = fileId;
            return this;
        }

        public final String getAssociatedResourceArn() {
            return associatedResourceArn;
        }

        public final void setAssociatedResourceArn(String associatedResourceArn) {
            this.associatedResourceArn = associatedResourceArn;
        }

        @Override
        public final Builder associatedResourceArn(String associatedResourceArn) {
            this.associatedResourceArn = associatedResourceArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CompleteAttachedFileUploadRequest build() {
            return new CompleteAttachedFileUploadRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
