/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The search criteria to be used to return contact flows.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContactFlowSearchCriteria implements SdkPojo, Serializable,
        ToCopyableBuilder<ContactFlowSearchCriteria.Builder, ContactFlowSearchCriteria> {
    private static final SdkField<List<ContactFlowSearchCriteria>> OR_CONDITIONS_FIELD = SdkField
            .<List<ContactFlowSearchCriteria>> builder(MarshallingType.LIST)
            .memberName("OrConditions")
            .getter(getter(ContactFlowSearchCriteria::orConditions))
            .setter(setter(Builder::orConditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrConditions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContactFlowSearchCriteria> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContactFlowSearchCriteria::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ContactFlowSearchCriteria>> AND_CONDITIONS_FIELD = SdkField
            .<List<ContactFlowSearchCriteria>> builder(MarshallingType.LIST)
            .memberName("AndConditions")
            .getter(getter(ContactFlowSearchCriteria::andConditions))
            .setter(setter(Builder::andConditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AndConditions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContactFlowSearchCriteria> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContactFlowSearchCriteria::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<StringCondition> STRING_CONDITION_FIELD = SdkField
            .<StringCondition> builder(MarshallingType.SDK_POJO).memberName("StringCondition")
            .getter(getter(ContactFlowSearchCriteria::stringCondition)).setter(setter(Builder::stringCondition))
            .constructor(StringCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringCondition").build()).build();

    private static final SdkField<String> TYPE_CONDITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeCondition").getter(getter(ContactFlowSearchCriteria::typeConditionAsString))
            .setter(setter(Builder::typeCondition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeCondition").build()).build();

    private static final SdkField<String> STATE_CONDITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StateCondition").getter(getter(ContactFlowSearchCriteria::stateConditionAsString))
            .setter(setter(Builder::stateCondition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateCondition").build()).build();

    private static final SdkField<String> STATUS_CONDITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusCondition").getter(getter(ContactFlowSearchCriteria::statusConditionAsString))
            .setter(setter(Builder::statusCondition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusCondition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OR_CONDITIONS_FIELD,
            AND_CONDITIONS_FIELD, STRING_CONDITION_FIELD, TYPE_CONDITION_FIELD, STATE_CONDITION_FIELD, STATUS_CONDITION_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ContactFlowSearchCriteria> orConditions;

    private final List<ContactFlowSearchCriteria> andConditions;

    private final StringCondition stringCondition;

    private final String typeCondition;

    private final String stateCondition;

    private final String statusCondition;

    private ContactFlowSearchCriteria(BuilderImpl builder) {
        this.orConditions = builder.orConditions;
        this.andConditions = builder.andConditions;
        this.stringCondition = builder.stringCondition;
        this.typeCondition = builder.typeCondition;
        this.stateCondition = builder.stateCondition;
        this.statusCondition = builder.statusCondition;
    }

    /**
     * For responses, this returns true if the service returned a value for the OrConditions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOrConditions() {
        return orConditions != null && !(orConditions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of conditions which would be applied together with an <code>OR</code> condition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOrConditions} method.
     * </p>
     * 
     * @return A list of conditions which would be applied together with an <code>OR</code> condition.
     */
    public final List<ContactFlowSearchCriteria> orConditions() {
        return orConditions;
    }

    /**
     * For responses, this returns true if the service returned a value for the AndConditions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAndConditions() {
        return andConditions != null && !(andConditions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of conditions which would be applied together with an <code>AND</code> condition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAndConditions} method.
     * </p>
     * 
     * @return A list of conditions which would be applied together with an <code>AND</code> condition.
     */
    public final List<ContactFlowSearchCriteria> andConditions() {
        return andConditions;
    }

    /**
     * Returns the value of the StringCondition property for this object.
     * 
     * @return The value of the StringCondition property for this object.
     */
    public final StringCondition stringCondition() {
        return stringCondition;
    }

    /**
     * <p>
     * The type of flow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #typeCondition}
     * will return {@link ContactFlowType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeConditionAsString}.
     * </p>
     * 
     * @return The type of flow.
     * @see ContactFlowType
     */
    public final ContactFlowType typeCondition() {
        return ContactFlowType.fromValue(typeCondition);
    }

    /**
     * <p>
     * The type of flow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #typeCondition}
     * will return {@link ContactFlowType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeConditionAsString}.
     * </p>
     * 
     * @return The type of flow.
     * @see ContactFlowType
     */
    public final String typeConditionAsString() {
        return typeCondition;
    }

    /**
     * <p>
     * The state of the flow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stateCondition}
     * will return {@link ContactFlowState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stateConditionAsString}.
     * </p>
     * 
     * @return The state of the flow.
     * @see ContactFlowState
     */
    public final ContactFlowState stateCondition() {
        return ContactFlowState.fromValue(stateCondition);
    }

    /**
     * <p>
     * The state of the flow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stateCondition}
     * will return {@link ContactFlowState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stateConditionAsString}.
     * </p>
     * 
     * @return The state of the flow.
     * @see ContactFlowState
     */
    public final String stateConditionAsString() {
        return stateCondition;
    }

    /**
     * <p>
     * The status of the flow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCondition}
     * will return {@link ContactFlowStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusConditionAsString}.
     * </p>
     * 
     * @return The status of the flow.
     * @see ContactFlowStatus
     */
    public final ContactFlowStatus statusCondition() {
        return ContactFlowStatus.fromValue(statusCondition);
    }

    /**
     * <p>
     * The status of the flow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCondition}
     * will return {@link ContactFlowStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusConditionAsString}.
     * </p>
     * 
     * @return The status of the flow.
     * @see ContactFlowStatus
     */
    public final String statusConditionAsString() {
        return statusCondition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasOrConditions() ? orConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAndConditions() ? andConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(stringCondition());
        hashCode = 31 * hashCode + Objects.hashCode(typeConditionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateConditionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusConditionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactFlowSearchCriteria)) {
            return false;
        }
        ContactFlowSearchCriteria other = (ContactFlowSearchCriteria) obj;
        return hasOrConditions() == other.hasOrConditions() && Objects.equals(orConditions(), other.orConditions())
                && hasAndConditions() == other.hasAndConditions() && Objects.equals(andConditions(), other.andConditions())
                && Objects.equals(stringCondition(), other.stringCondition())
                && Objects.equals(typeConditionAsString(), other.typeConditionAsString())
                && Objects.equals(stateConditionAsString(), other.stateConditionAsString())
                && Objects.equals(statusConditionAsString(), other.statusConditionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContactFlowSearchCriteria").add("OrConditions", hasOrConditions() ? orConditions() : null)
                .add("AndConditions", hasAndConditions() ? andConditions() : null).add("StringCondition", stringCondition())
                .add("TypeCondition", typeConditionAsString()).add("StateCondition", stateConditionAsString())
                .add("StatusCondition", statusConditionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrConditions":
            return Optional.ofNullable(clazz.cast(orConditions()));
        case "AndConditions":
            return Optional.ofNullable(clazz.cast(andConditions()));
        case "StringCondition":
            return Optional.ofNullable(clazz.cast(stringCondition()));
        case "TypeCondition":
            return Optional.ofNullable(clazz.cast(typeConditionAsString()));
        case "StateCondition":
            return Optional.ofNullable(clazz.cast(stateConditionAsString()));
        case "StatusCondition":
            return Optional.ofNullable(clazz.cast(statusConditionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContactFlowSearchCriteria, T> g) {
        return obj -> g.apply((ContactFlowSearchCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContactFlowSearchCriteria> {
        /**
         * <p>
         * A list of conditions which would be applied together with an <code>OR</code> condition.
         * </p>
         * 
         * @param orConditions
         *        A list of conditions which would be applied together with an <code>OR</code> condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orConditions(Collection<ContactFlowSearchCriteria> orConditions);

        /**
         * <p>
         * A list of conditions which would be applied together with an <code>OR</code> condition.
         * </p>
         * 
         * @param orConditions
         *        A list of conditions which would be applied together with an <code>OR</code> condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orConditions(ContactFlowSearchCriteria... orConditions);

        /**
         * <p>
         * A list of conditions which would be applied together with an <code>OR</code> condition.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.ContactFlowSearchCriteria.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.connect.model.ContactFlowSearchCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.ContactFlowSearchCriteria.Builder#build()} is called
         * immediately and its result is passed to {@link #orConditions(List<ContactFlowSearchCriteria>)}.
         * 
         * @param orConditions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.ContactFlowSearchCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #orConditions(java.util.Collection<ContactFlowSearchCriteria>)
         */
        Builder orConditions(Consumer<Builder>... orConditions);

        /**
         * <p>
         * A list of conditions which would be applied together with an <code>AND</code> condition.
         * </p>
         * 
         * @param andConditions
         *        A list of conditions which would be applied together with an <code>AND</code> condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder andConditions(Collection<ContactFlowSearchCriteria> andConditions);

        /**
         * <p>
         * A list of conditions which would be applied together with an <code>AND</code> condition.
         * </p>
         * 
         * @param andConditions
         *        A list of conditions which would be applied together with an <code>AND</code> condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder andConditions(ContactFlowSearchCriteria... andConditions);

        /**
         * <p>
         * A list of conditions which would be applied together with an <code>AND</code> condition.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.ContactFlowSearchCriteria.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.connect.model.ContactFlowSearchCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.ContactFlowSearchCriteria.Builder#build()} is called
         * immediately and its result is passed to {@link #andConditions(List<ContactFlowSearchCriteria>)}.
         * 
         * @param andConditions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.ContactFlowSearchCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #andConditions(java.util.Collection<ContactFlowSearchCriteria>)
         */
        Builder andConditions(Consumer<Builder>... andConditions);

        /**
         * Sets the value of the StringCondition property for this object.
         *
         * @param stringCondition
         *        The new value for the StringCondition property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringCondition(StringCondition stringCondition);

        /**
         * Sets the value of the StringCondition property for this object.
         *
         * This is a convenience method that creates an instance of the {@link StringCondition.Builder} avoiding the
         * need to create one manually via {@link StringCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StringCondition.Builder#build()} is called immediately and its
         * result is passed to {@link #stringCondition(StringCondition)}.
         * 
         * @param stringCondition
         *        a consumer that will call methods on {@link StringCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stringCondition(StringCondition)
         */
        default Builder stringCondition(Consumer<StringCondition.Builder> stringCondition) {
            return stringCondition(StringCondition.builder().applyMutation(stringCondition).build());
        }

        /**
         * <p>
         * The type of flow.
         * </p>
         * 
         * @param typeCondition
         *        The type of flow.
         * @see ContactFlowType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactFlowType
         */
        Builder typeCondition(String typeCondition);

        /**
         * <p>
         * The type of flow.
         * </p>
         * 
         * @param typeCondition
         *        The type of flow.
         * @see ContactFlowType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactFlowType
         */
        Builder typeCondition(ContactFlowType typeCondition);

        /**
         * <p>
         * The state of the flow.
         * </p>
         * 
         * @param stateCondition
         *        The state of the flow.
         * @see ContactFlowState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactFlowState
         */
        Builder stateCondition(String stateCondition);

        /**
         * <p>
         * The state of the flow.
         * </p>
         * 
         * @param stateCondition
         *        The state of the flow.
         * @see ContactFlowState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactFlowState
         */
        Builder stateCondition(ContactFlowState stateCondition);

        /**
         * <p>
         * The status of the flow.
         * </p>
         * 
         * @param statusCondition
         *        The status of the flow.
         * @see ContactFlowStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactFlowStatus
         */
        Builder statusCondition(String statusCondition);

        /**
         * <p>
         * The status of the flow.
         * </p>
         * 
         * @param statusCondition
         *        The status of the flow.
         * @see ContactFlowStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactFlowStatus
         */
        Builder statusCondition(ContactFlowStatus statusCondition);
    }

    static final class BuilderImpl implements Builder {
        private List<ContactFlowSearchCriteria> orConditions = DefaultSdkAutoConstructList.getInstance();

        private List<ContactFlowSearchCriteria> andConditions = DefaultSdkAutoConstructList.getInstance();

        private StringCondition stringCondition;

        private String typeCondition;

        private String stateCondition;

        private String statusCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(ContactFlowSearchCriteria model) {
            orConditions(model.orConditions);
            andConditions(model.andConditions);
            stringCondition(model.stringCondition);
            typeCondition(model.typeCondition);
            stateCondition(model.stateCondition);
            statusCondition(model.statusCondition);
        }

        public final List<Builder> getOrConditions() {
            List<Builder> result = ContactFlowSearchConditionListCopier.copyToBuilder(this.orConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrConditions(Collection<BuilderImpl> orConditions) {
            this.orConditions = ContactFlowSearchConditionListCopier.copyFromBuilder(orConditions);
        }

        @Override
        public final Builder orConditions(Collection<ContactFlowSearchCriteria> orConditions) {
            this.orConditions = ContactFlowSearchConditionListCopier.copy(orConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orConditions(ContactFlowSearchCriteria... orConditions) {
            orConditions(Arrays.asList(orConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orConditions(Consumer<Builder>... orConditions) {
            orConditions(Stream.of(orConditions).map(c -> ContactFlowSearchCriteria.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Builder> getAndConditions() {
            List<Builder> result = ContactFlowSearchConditionListCopier.copyToBuilder(this.andConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAndConditions(Collection<BuilderImpl> andConditions) {
            this.andConditions = ContactFlowSearchConditionListCopier.copyFromBuilder(andConditions);
        }

        @Override
        public final Builder andConditions(Collection<ContactFlowSearchCriteria> andConditions) {
            this.andConditions = ContactFlowSearchConditionListCopier.copy(andConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andConditions(ContactFlowSearchCriteria... andConditions) {
            andConditions(Arrays.asList(andConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andConditions(Consumer<Builder>... andConditions) {
            andConditions(Stream.of(andConditions).map(c -> ContactFlowSearchCriteria.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final StringCondition.Builder getStringCondition() {
            return stringCondition != null ? stringCondition.toBuilder() : null;
        }

        public final void setStringCondition(StringCondition.BuilderImpl stringCondition) {
            this.stringCondition = stringCondition != null ? stringCondition.build() : null;
        }

        @Override
        public final Builder stringCondition(StringCondition stringCondition) {
            this.stringCondition = stringCondition;
            return this;
        }

        public final String getTypeCondition() {
            return typeCondition;
        }

        public final void setTypeCondition(String typeCondition) {
            this.typeCondition = typeCondition;
        }

        @Override
        public final Builder typeCondition(String typeCondition) {
            this.typeCondition = typeCondition;
            return this;
        }

        @Override
        public final Builder typeCondition(ContactFlowType typeCondition) {
            this.typeCondition(typeCondition == null ? null : typeCondition.toString());
            return this;
        }

        public final String getStateCondition() {
            return stateCondition;
        }

        public final void setStateCondition(String stateCondition) {
            this.stateCondition = stateCondition;
        }

        @Override
        public final Builder stateCondition(String stateCondition) {
            this.stateCondition = stateCondition;
            return this;
        }

        @Override
        public final Builder stateCondition(ContactFlowState stateCondition) {
            this.stateCondition(stateCondition == null ? null : stateCondition.toString());
            return this;
        }

        public final String getStatusCondition() {
            return statusCondition;
        }

        public final void setStatusCondition(String statusCondition) {
            this.statusCondition = statusCondition;
        }

        @Override
        public final Builder statusCondition(String statusCondition) {
            this.statusCondition = statusCondition;
            return this;
        }

        @Override
        public final Builder statusCondition(ContactFlowStatus statusCondition) {
            this.statusCondition(statusCondition == null ? null : statusCondition.toString());
            return this;
        }

        @Override
        public ContactFlowSearchCriteria build() {
            return new ContactFlowSearchCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
