/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the quality of the participant's media connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QualityMetrics implements SdkPojo, Serializable, ToCopyableBuilder<QualityMetrics.Builder, QualityMetrics> {
    private static final SdkField<AgentQualityMetrics> AGENT_FIELD = SdkField
            .<AgentQualityMetrics> builder(MarshallingType.SDK_POJO).memberName("Agent").getter(getter(QualityMetrics::agent))
            .setter(setter(Builder::agent)).constructor(AgentQualityMetrics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Agent").build()).build();

    private static final SdkField<CustomerQualityMetrics> CUSTOMER_FIELD = SdkField
            .<CustomerQualityMetrics> builder(MarshallingType.SDK_POJO).memberName("Customer")
            .getter(getter(QualityMetrics::customer)).setter(setter(Builder::customer))
            .constructor(CustomerQualityMetrics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Customer").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_FIELD, CUSTOMER_FIELD));

    private static final long serialVersionUID = 1L;

    private final AgentQualityMetrics agent;

    private final CustomerQualityMetrics customer;

    private QualityMetrics(BuilderImpl builder) {
        this.agent = builder.agent;
        this.customer = builder.customer;
    }

    /**
     * <p>
     * Information about the quality of Agent media connection.
     * </p>
     * 
     * @return Information about the quality of Agent media connection.
     */
    public final AgentQualityMetrics agent() {
        return agent;
    }

    /**
     * <p>
     * Information about the quality of Customer media connection.
     * </p>
     * 
     * @return Information about the quality of Customer media connection.
     */
    public final CustomerQualityMetrics customer() {
        return customer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(agent());
        hashCode = 31 * hashCode + Objects.hashCode(customer());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QualityMetrics)) {
            return false;
        }
        QualityMetrics other = (QualityMetrics) obj;
        return Objects.equals(agent(), other.agent()) && Objects.equals(customer(), other.customer());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QualityMetrics").add("Agent", agent()).add("Customer", customer()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Agent":
            return Optional.ofNullable(clazz.cast(agent()));
        case "Customer":
            return Optional.ofNullable(clazz.cast(customer()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QualityMetrics, T> g) {
        return obj -> g.apply((QualityMetrics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QualityMetrics> {
        /**
         * <p>
         * Information about the quality of Agent media connection.
         * </p>
         * 
         * @param agent
         *        Information about the quality of Agent media connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agent(AgentQualityMetrics agent);

        /**
         * <p>
         * Information about the quality of Agent media connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link AgentQualityMetrics.Builder} avoiding the
         * need to create one manually via {@link AgentQualityMetrics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AgentQualityMetrics.Builder#build()} is called immediately and
         * its result is passed to {@link #agent(AgentQualityMetrics)}.
         * 
         * @param agent
         *        a consumer that will call methods on {@link AgentQualityMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agent(AgentQualityMetrics)
         */
        default Builder agent(Consumer<AgentQualityMetrics.Builder> agent) {
            return agent(AgentQualityMetrics.builder().applyMutation(agent).build());
        }

        /**
         * <p>
         * Information about the quality of Customer media connection.
         * </p>
         * 
         * @param customer
         *        Information about the quality of Customer media connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customer(CustomerQualityMetrics customer);

        /**
         * <p>
         * Information about the quality of Customer media connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomerQualityMetrics.Builder} avoiding
         * the need to create one manually via {@link CustomerQualityMetrics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomerQualityMetrics.Builder#build()} is called immediately and
         * its result is passed to {@link #customer(CustomerQualityMetrics)}.
         * 
         * @param customer
         *        a consumer that will call methods on {@link CustomerQualityMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customer(CustomerQualityMetrics)
         */
        default Builder customer(Consumer<CustomerQualityMetrics.Builder> customer) {
            return customer(CustomerQualityMetrics.builder().applyMutation(customer).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AgentQualityMetrics agent;

        private CustomerQualityMetrics customer;

        private BuilderImpl() {
        }

        private BuilderImpl(QualityMetrics model) {
            agent(model.agent);
            customer(model.customer);
        }

        public final AgentQualityMetrics.Builder getAgent() {
            return agent != null ? agent.toBuilder() : null;
        }

        public final void setAgent(AgentQualityMetrics.BuilderImpl agent) {
            this.agent = agent != null ? agent.build() : null;
        }

        @Override
        public final Builder agent(AgentQualityMetrics agent) {
            this.agent = agent;
            return this;
        }

        public final CustomerQualityMetrics.Builder getCustomer() {
            return customer != null ? customer.toBuilder() : null;
        }

        public final void setCustomer(CustomerQualityMetrics.BuilderImpl customer) {
            this.customer = customer != null ? customer.build() : null;
        }

        @Override
        public final Builder customer(CustomerQualityMetrics customer) {
            this.customer = customer;
            return this;
        }

        @Override
        public QualityMetrics build() {
            return new QualityMetrics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
