/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.Attribute;
import software.amazon.awssdk.services.connect.model.ListInstanceAttributesRequest;
import software.amazon.awssdk.services.connect.model.ListInstanceAttributesResponse;

public class ListInstanceAttributesPublisher
implements SdkPublisher<ListInstanceAttributesResponse> {
    private final ConnectAsyncClient client;
    private final ListInstanceAttributesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListInstanceAttributesPublisher(ConnectAsyncClient client, ListInstanceAttributesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListInstanceAttributesPublisher(ConnectAsyncClient client, ListInstanceAttributesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListInstanceAttributesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListInstanceAttributesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Attribute> attributes() {
        Function<ListInstanceAttributesResponse, Iterator> getIterator = response -> {
            if (response != null && response.attributes() != null) {
                return response.attributes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListInstanceAttributesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListInstanceAttributesResponseFetcher
    implements AsyncPageFetcher<ListInstanceAttributesResponse> {
        private ListInstanceAttributesResponseFetcher() {
        }

        public boolean hasNextPage(ListInstanceAttributesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListInstanceAttributesResponse> nextPage(ListInstanceAttributesResponse previousPage) {
            if (previousPage == null) {
                return ListInstanceAttributesPublisher.this.client.listInstanceAttributes(ListInstanceAttributesPublisher.this.firstRequest);
            }
            return ListInstanceAttributesPublisher.this.client.listInstanceAttributes((ListInstanceAttributesRequest)((Object)ListInstanceAttributesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

