/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about customer’s voice activity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomerVoiceActivity implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomerVoiceActivity.Builder, CustomerVoiceActivity> {
    private static final SdkField<Instant> GREETING_START_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("GreetingStartTimestamp").getter(getter(CustomerVoiceActivity::greetingStartTimestamp))
            .setter(setter(Builder::greetingStartTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GreetingStartTimestamp").build())
            .build();

    private static final SdkField<Instant> GREETING_END_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("GreetingEndTimestamp").getter(getter(CustomerVoiceActivity::greetingEndTimestamp))
            .setter(setter(Builder::greetingEndTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GreetingEndTimestamp").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            GREETING_START_TIMESTAMP_FIELD, GREETING_END_TIMESTAMP_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant greetingStartTimestamp;

    private final Instant greetingEndTimestamp;

    private CustomerVoiceActivity(BuilderImpl builder) {
        this.greetingStartTimestamp = builder.greetingStartTimestamp;
        this.greetingEndTimestamp = builder.greetingEndTimestamp;
    }

    /**
     * <p>
     * Timestamp that measures the beginning of the customer greeting from an outbound voice call.
     * </p>
     * 
     * @return Timestamp that measures the beginning of the customer greeting from an outbound voice call.
     */
    public final Instant greetingStartTimestamp() {
        return greetingStartTimestamp;
    }

    /**
     * <p>
     * Timestamp that measures the end of the customer greeting from an outbound voice call.
     * </p>
     * 
     * @return Timestamp that measures the end of the customer greeting from an outbound voice call.
     */
    public final Instant greetingEndTimestamp() {
        return greetingEndTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(greetingStartTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(greetingEndTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomerVoiceActivity)) {
            return false;
        }
        CustomerVoiceActivity other = (CustomerVoiceActivity) obj;
        return Objects.equals(greetingStartTimestamp(), other.greetingStartTimestamp())
                && Objects.equals(greetingEndTimestamp(), other.greetingEndTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomerVoiceActivity").add("GreetingStartTimestamp", greetingStartTimestamp())
                .add("GreetingEndTimestamp", greetingEndTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GreetingStartTimestamp":
            return Optional.ofNullable(clazz.cast(greetingStartTimestamp()));
        case "GreetingEndTimestamp":
            return Optional.ofNullable(clazz.cast(greetingEndTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomerVoiceActivity, T> g) {
        return obj -> g.apply((CustomerVoiceActivity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomerVoiceActivity> {
        /**
         * <p>
         * Timestamp that measures the beginning of the customer greeting from an outbound voice call.
         * </p>
         * 
         * @param greetingStartTimestamp
         *        Timestamp that measures the beginning of the customer greeting from an outbound voice call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder greetingStartTimestamp(Instant greetingStartTimestamp);

        /**
         * <p>
         * Timestamp that measures the end of the customer greeting from an outbound voice call.
         * </p>
         * 
         * @param greetingEndTimestamp
         *        Timestamp that measures the end of the customer greeting from an outbound voice call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder greetingEndTimestamp(Instant greetingEndTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private Instant greetingStartTimestamp;

        private Instant greetingEndTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomerVoiceActivity model) {
            greetingStartTimestamp(model.greetingStartTimestamp);
            greetingEndTimestamp(model.greetingEndTimestamp);
        }

        public final Instant getGreetingStartTimestamp() {
            return greetingStartTimestamp;
        }

        public final void setGreetingStartTimestamp(Instant greetingStartTimestamp) {
            this.greetingStartTimestamp = greetingStartTimestamp;
        }

        @Override
        public final Builder greetingStartTimestamp(Instant greetingStartTimestamp) {
            this.greetingStartTimestamp = greetingStartTimestamp;
            return this;
        }

        public final Instant getGreetingEndTimestamp() {
            return greetingEndTimestamp;
        }

        public final void setGreetingEndTimestamp(Instant greetingEndTimestamp) {
            this.greetingEndTimestamp = greetingEndTimestamp;
        }

        @Override
        public final Builder greetingEndTimestamp(Instant greetingEndTimestamp) {
            this.greetingEndTimestamp = greetingEndTimestamp;
            return this;
        }

        @Override
        public CustomerVoiceActivity build() {
            return new CustomerVoiceActivity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
