/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMetricDataRequest extends ConnectRequest implements
        ToCopyableBuilder<GetMetricDataRequest.Builder, GetMetricDataRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(GetMetricDataRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(GetMetricDataRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(GetMetricDataRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<Filters> FILTERS_FIELD = SdkField.<Filters> builder(MarshallingType.SDK_POJO)
            .memberName("Filters").getter(getter(GetMetricDataRequest::filters)).setter(setter(Builder::filters))
            .constructor(Filters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()).build();

    private static final SdkField<List<String>> GROUPINGS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Groupings")
            .getter(getter(GetMetricDataRequest::groupingsAsStrings))
            .setter(setter(Builder::groupingsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Groupings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<HistoricalMetric>> HISTORICAL_METRICS_FIELD = SdkField
            .<List<HistoricalMetric>> builder(MarshallingType.LIST)
            .memberName("HistoricalMetrics")
            .getter(getter(GetMetricDataRequest::historicalMetrics))
            .setter(setter(Builder::historicalMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HistoricalMetrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HistoricalMetric> builder(MarshallingType.SDK_POJO)
                                            .constructor(HistoricalMetric::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetMetricDataRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(GetMetricDataRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            START_TIME_FIELD, END_TIME_FIELD, FILTERS_FIELD, GROUPINGS_FIELD, HISTORICAL_METRICS_FIELD, NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD));

    private final String instanceId;

    private final Instant startTime;

    private final Instant endTime;

    private final Filters filters;

    private final List<String> groupings;

    private final List<HistoricalMetric> historicalMetrics;

    private final String nextToken;

    private final Integer maxResults;

    private GetMetricDataRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.filters = builder.filters;
        this.groupings = builder.groupings;
        this.historicalMetrics = builder.historicalMetrics;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in
     * the Amazon Resource Name (ARN) of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
     *         ID</a> in the Amazon Resource Name (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The timestamp, in UNIX Epoch time format, at which to start the reporting interval for the retrieval of
     * historical metrics data. The time must be specified using a multiple of 5 minutes, such as 10:05, 10:10, 10:15.
     * </p>
     * <p>
     * The start time cannot be earlier than 24 hours before the time of the request. Historical metrics are available
     * only for 24 hours.
     * </p>
     * 
     * @return The timestamp, in UNIX Epoch time format, at which to start the reporting interval for the retrieval of
     *         historical metrics data. The time must be specified using a multiple of 5 minutes, such as 10:05, 10:10,
     *         10:15.</p>
     *         <p>
     *         The start time cannot be earlier than 24 hours before the time of the request. Historical metrics are
     *         available only for 24 hours.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The timestamp, in UNIX Epoch time format, at which to end the reporting interval for the retrieval of historical
     * metrics data. The time must be specified using an interval of 5 minutes, such as 11:00, 11:05, 11:10, and must be
     * later than the start time timestamp.
     * </p>
     * <p>
     * The time range between the start and end time must be less than 24 hours.
     * </p>
     * 
     * @return The timestamp, in UNIX Epoch time format, at which to end the reporting interval for the retrieval of
     *         historical metrics data. The time must be specified using an interval of 5 minutes, such as 11:00, 11:05,
     *         11:10, and must be later than the start time timestamp.</p>
     *         <p>
     *         The time range between the start and end time must be less than 24 hours.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The queues, up to 100, or channels, to use to filter the metrics returned. Metric data is retrieved only for the
     * resources associated with the queues or channels included in the filter. You can include both queue IDs and queue
     * ARNs in the same request. VOICE, CHAT, and TASK channels are supported.
     * </p>
     * <p>
     * RoutingStepExpression is not a valid filter for GetMetricData and we recommend switching to GetMetricDataV2 for
     * more up-to-date features.
     * </p>
     * <note>
     * <p>
     * To filter by <code>Queues</code>, enter the queue ID/ARN, not the name of the queue.
     * </p>
     * </note>
     * 
     * @return The queues, up to 100, or channels, to use to filter the metrics returned. Metric data is retrieved only
     *         for the resources associated with the queues or channels included in the filter. You can include both
     *         queue IDs and queue ARNs in the same request. VOICE, CHAT, and TASK channels are supported.</p>
     *         <p>
     *         RoutingStepExpression is not a valid filter for GetMetricData and we recommend switching to
     *         GetMetricDataV2 for more up-to-date features.
     *         </p>
     *         <note>
     *         <p>
     *         To filter by <code>Queues</code>, enter the queue ID/ARN, not the name of the queue.
     *         </p>
     */
    public final Filters filters() {
        return filters;
    }

    /**
     * <p>
     * The grouping applied to the metrics returned. For example, when results are grouped by queue, the metrics
     * returned are grouped by queue. The values returned apply to the metrics for each queue rather than aggregated for
     * all queues.
     * </p>
     * <p>
     * If no grouping is specified, a summary of metrics for all queues is returned.
     * </p>
     * <p>
     * RoutingStepExpression is not a valid filter for GetMetricData and we recommend switching to GetMetricDataV2 for
     * more up-to-date features.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroupings} method.
     * </p>
     * 
     * @return The grouping applied to the metrics returned. For example, when results are grouped by queue, the metrics
     *         returned are grouped by queue. The values returned apply to the metrics for each queue rather than
     *         aggregated for all queues.</p>
     *         <p>
     *         If no grouping is specified, a summary of metrics for all queues is returned.
     *         </p>
     *         <p>
     *         RoutingStepExpression is not a valid filter for GetMetricData and we recommend switching to
     *         GetMetricDataV2 for more up-to-date features.
     */
    public final List<Grouping> groupings() {
        return GroupingsCopier.copyStringToEnum(groupings);
    }

    /**
     * For responses, this returns true if the service returned a value for the Groupings property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGroupings() {
        return groupings != null && !(groupings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The grouping applied to the metrics returned. For example, when results are grouped by queue, the metrics
     * returned are grouped by queue. The values returned apply to the metrics for each queue rather than aggregated for
     * all queues.
     * </p>
     * <p>
     * If no grouping is specified, a summary of metrics for all queues is returned.
     * </p>
     * <p>
     * RoutingStepExpression is not a valid filter for GetMetricData and we recommend switching to GetMetricDataV2 for
     * more up-to-date features.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroupings} method.
     * </p>
     * 
     * @return The grouping applied to the metrics returned. For example, when results are grouped by queue, the metrics
     *         returned are grouped by queue. The values returned apply to the metrics for each queue rather than
     *         aggregated for all queues.</p>
     *         <p>
     *         If no grouping is specified, a summary of metrics for all queues is returned.
     *         </p>
     *         <p>
     *         RoutingStepExpression is not a valid filter for GetMetricData and we recommend switching to
     *         GetMetricDataV2 for more up-to-date features.
     */
    public final List<String> groupingsAsStrings() {
        return groupings;
    }

    /**
     * For responses, this returns true if the service returned a value for the HistoricalMetrics property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHistoricalMetrics() {
        return historicalMetrics != null && !(historicalMetrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metrics to retrieve. Specify the name, unit, and statistic for each metric. The following historical metrics
     * are available. For a description of each metric, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html">Historical
     * Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <note>
     * <p>
     * This API does not support a contacts incoming metric (there's no CONTACTS_INCOMING metric missing from the
     * documented list).
     * </p>
     * </note>
     * <dl>
     * <dt>ABANDON_TIME</dt>
     * <dd>
     * <p>
     * Unit: SECONDS
     * </p>
     * <p>
     * Statistic: AVG
     * </p>
     * </dd>
     * <dt>AFTER_CONTACT_WORK_TIME</dt>
     * <dd>
     * <p>
     * Unit: SECONDS
     * </p>
     * <p>
     * Statistic: AVG
     * </p>
     * </dd>
     * <dt>API_CONTACTS_HANDLED</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistic: SUM
     * </p>
     * </dd>
     * <dt>CALLBACK_CONTACTS_HANDLED</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistic: SUM
     * </p>
     * </dd>
     * <dt>CONTACTS_ABANDONED</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistic: SUM
     * </p>
     * </dd>
     * <dt>CONTACTS_AGENT_HUNG_UP_FIRST</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistic: SUM
     * </p>
     * </dd>
     * <dt>CONTACTS_CONSULTED</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistic: SUM
     * </p>
     * </dd>
     * <dt>CONTACTS_HANDLED</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistic: SUM
     * </p>
     * </dd>
     * <dt>CONTACTS_HANDLED_INCOMING</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistic: SUM
     * </p>
     * </dd>
     * <dt>CONTACTS_HANDLED_OUTBOUND</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistic: SUM
     * </p>
     * </dd>
     * <dt>CONTACTS_HOLD_ABANDONS</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistic: SUM
     * </p>
     * </dd>
     * <dt>CONTACTS_MISSED</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistic: SUM
     * </p>
     * </dd>
     * <dt>CONTACTS_QUEUED</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistic: SUM
     * </p>
     * </dd>
     * <dt>CONTACTS_TRANSFERRED_IN</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistic: SUM
     * </p>
     * </dd>
     * <dt>CONTACTS_TRANSFERRED_IN_FROM_QUEUE</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistic: SUM
     * </p>
     * </dd>
     * <dt>CONTACTS_TRANSFERRED_OUT</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistic: SUM
     * </p>
     * </dd>
     * <dt>CONTACTS_TRANSFERRED_OUT_FROM_QUEUE</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistic: SUM
     * </p>
     * </dd>
     * <dt>HANDLE_TIME</dt>
     * <dd>
     * <p>
     * Unit: SECONDS
     * </p>
     * <p>
     * Statistic: AVG
     * </p>
     * </dd>
     * <dt>HOLD_TIME</dt>
     * <dd>
     * <p>
     * Unit: SECONDS
     * </p>
     * <p>
     * Statistic: AVG
     * </p>
     * </dd>
     * <dt>INTERACTION_AND_HOLD_TIME</dt>
     * <dd>
     * <p>
     * Unit: SECONDS
     * </p>
     * <p>
     * Statistic: AVG
     * </p>
     * </dd>
     * <dt>INTERACTION_TIME</dt>
     * <dd>
     * <p>
     * Unit: SECONDS
     * </p>
     * <p>
     * Statistic: AVG
     * </p>
     * </dd>
     * <dt>OCCUPANCY</dt>
     * <dd>
     * <p>
     * Unit: PERCENT
     * </p>
     * <p>
     * Statistic: AVG
     * </p>
     * </dd>
     * <dt>QUEUE_ANSWER_TIME</dt>
     * <dd>
     * <p>
     * Unit: SECONDS
     * </p>
     * <p>
     * Statistic: AVG
     * </p>
     * </dd>
     * <dt>QUEUED_TIME</dt>
     * <dd>
     * <p>
     * Unit: SECONDS
     * </p>
     * <p>
     * Statistic: MAX
     * </p>
     * </dd>
     * <dt>SERVICE_LEVEL</dt>
     * <dd>
     * <p>
     * You can include up to 20 SERVICE_LEVEL metrics in a request.
     * </p>
     * <p>
     * Unit: PERCENT
     * </p>
     * <p>
     * Statistic: AVG
     * </p>
     * <p>
     * Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds. For
     * <code>Comparison</code>, you must enter <code>LT</code> (for "Less than").
     * </p>
     * </dd>
     * </dl>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHistoricalMetrics} method.
     * </p>
     * 
     * @return The metrics to retrieve. Specify the name, unit, and statistic for each metric. The following historical
     *         metrics are available. For a description of each metric, see <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html"
     *         >Historical Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.</p> <note>
     *         <p>
     *         This API does not support a contacts incoming metric (there's no CONTACTS_INCOMING metric missing from
     *         the documented list).
     *         </p>
     *         </note>
     *         <dl>
     *         <dt>ABANDON_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: SECONDS
     *         </p>
     *         <p>
     *         Statistic: AVG
     *         </p>
     *         </dd>
     *         <dt>AFTER_CONTACT_WORK_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: SECONDS
     *         </p>
     *         <p>
     *         Statistic: AVG
     *         </p>
     *         </dd>
     *         <dt>API_CONTACTS_HANDLED</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistic: SUM
     *         </p>
     *         </dd>
     *         <dt>CALLBACK_CONTACTS_HANDLED</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistic: SUM
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_ABANDONED</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistic: SUM
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_AGENT_HUNG_UP_FIRST</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistic: SUM
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_CONSULTED</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistic: SUM
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_HANDLED</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistic: SUM
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_HANDLED_INCOMING</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistic: SUM
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_HANDLED_OUTBOUND</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistic: SUM
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_HOLD_ABANDONS</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistic: SUM
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_MISSED</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistic: SUM
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_QUEUED</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistic: SUM
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_TRANSFERRED_IN</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistic: SUM
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_TRANSFERRED_IN_FROM_QUEUE</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistic: SUM
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_TRANSFERRED_OUT</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistic: SUM
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_TRANSFERRED_OUT_FROM_QUEUE</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistic: SUM
     *         </p>
     *         </dd>
     *         <dt>HANDLE_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: SECONDS
     *         </p>
     *         <p>
     *         Statistic: AVG
     *         </p>
     *         </dd>
     *         <dt>HOLD_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: SECONDS
     *         </p>
     *         <p>
     *         Statistic: AVG
     *         </p>
     *         </dd>
     *         <dt>INTERACTION_AND_HOLD_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: SECONDS
     *         </p>
     *         <p>
     *         Statistic: AVG
     *         </p>
     *         </dd>
     *         <dt>INTERACTION_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: SECONDS
     *         </p>
     *         <p>
     *         Statistic: AVG
     *         </p>
     *         </dd>
     *         <dt>OCCUPANCY</dt>
     *         <dd>
     *         <p>
     *         Unit: PERCENT
     *         </p>
     *         <p>
     *         Statistic: AVG
     *         </p>
     *         </dd>
     *         <dt>QUEUE_ANSWER_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: SECONDS
     *         </p>
     *         <p>
     *         Statistic: AVG
     *         </p>
     *         </dd>
     *         <dt>QUEUED_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: SECONDS
     *         </p>
     *         <p>
     *         Statistic: MAX
     *         </p>
     *         </dd>
     *         <dt>SERVICE_LEVEL</dt>
     *         <dd>
     *         <p>
     *         You can include up to 20 SERVICE_LEVEL metrics in a request.
     *         </p>
     *         <p>
     *         Unit: PERCENT
     *         </p>
     *         <p>
     *         Statistic: AVG
     *         </p>
     *         <p>
     *         Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in
     *         seconds. For <code>Comparison</code>, you must enter <code>LT</code> (for "Less than").
     *         </p>
     *         </dd>
     */
    public final List<HistoricalMetric> historicalMetrics() {
        return historicalMetrics;
    }

    /**
     * <p>
     * The token for the next set of results. Use the value returned in the previous response in the next request to
     * retrieve the next set of results.
     * </p>
     * 
     * @return The token for the next set of results. Use the value returned in the previous response in the next
     *         request to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return per page.
     * </p>
     * 
     * @return The maximum number of results to return per page.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(hasGroupings() ? groupingsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasHistoricalMetrics() ? historicalMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMetricDataRequest)) {
            return false;
        }
        GetMetricDataRequest other = (GetMetricDataRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(filters(), other.filters())
                && hasGroupings() == other.hasGroupings() && Objects.equals(groupingsAsStrings(), other.groupingsAsStrings())
                && hasHistoricalMetrics() == other.hasHistoricalMetrics()
                && Objects.equals(historicalMetrics(), other.historicalMetrics())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMetricDataRequest").add("InstanceId", instanceId()).add("StartTime", startTime())
                .add("EndTime", endTime()).add("Filters", filters())
                .add("Groupings", hasGroupings() ? groupingsAsStrings() : null)
                .add("HistoricalMetrics", hasHistoricalMetrics() ? historicalMetrics() : null).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "Groupings":
            return Optional.ofNullable(clazz.cast(groupingsAsStrings()));
        case "HistoricalMetrics":
            return Optional.ofNullable(clazz.cast(historicalMetrics()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMetricDataRequest, T> g) {
        return obj -> g.apply((GetMetricDataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetMetricDataRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a>
         * in the Amazon Resource Name (ARN) of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
         *        ID</a> in the Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The timestamp, in UNIX Epoch time format, at which to start the reporting interval for the retrieval of
         * historical metrics data. The time must be specified using a multiple of 5 minutes, such as 10:05, 10:10,
         * 10:15.
         * </p>
         * <p>
         * The start time cannot be earlier than 24 hours before the time of the request. Historical metrics are
         * available only for 24 hours.
         * </p>
         * 
         * @param startTime
         *        The timestamp, in UNIX Epoch time format, at which to start the reporting interval for the retrieval
         *        of historical metrics data. The time must be specified using a multiple of 5 minutes, such as 10:05,
         *        10:10, 10:15.</p>
         *        <p>
         *        The start time cannot be earlier than 24 hours before the time of the request. Historical metrics are
         *        available only for 24 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The timestamp, in UNIX Epoch time format, at which to end the reporting interval for the retrieval of
         * historical metrics data. The time must be specified using an interval of 5 minutes, such as 11:00, 11:05,
         * 11:10, and must be later than the start time timestamp.
         * </p>
         * <p>
         * The time range between the start and end time must be less than 24 hours.
         * </p>
         * 
         * @param endTime
         *        The timestamp, in UNIX Epoch time format, at which to end the reporting interval for the retrieval of
         *        historical metrics data. The time must be specified using an interval of 5 minutes, such as 11:00,
         *        11:05, 11:10, and must be later than the start time timestamp.</p>
         *        <p>
         *        The time range between the start and end time must be less than 24 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The queues, up to 100, or channels, to use to filter the metrics returned. Metric data is retrieved only for
         * the resources associated with the queues or channels included in the filter. You can include both queue IDs
         * and queue ARNs in the same request. VOICE, CHAT, and TASK channels are supported.
         * </p>
         * <p>
         * RoutingStepExpression is not a valid filter for GetMetricData and we recommend switching to GetMetricDataV2
         * for more up-to-date features.
         * </p>
         * <note>
         * <p>
         * To filter by <code>Queues</code>, enter the queue ID/ARN, not the name of the queue.
         * </p>
         * </note>
         * 
         * @param filters
         *        The queues, up to 100, or channels, to use to filter the metrics returned. Metric data is retrieved
         *        only for the resources associated with the queues or channels included in the filter. You can include
         *        both queue IDs and queue ARNs in the same request. VOICE, CHAT, and TASK channels are supported.</p>
         *        <p>
         *        RoutingStepExpression is not a valid filter for GetMetricData and we recommend switching to
         *        GetMetricDataV2 for more up-to-date features.
         *        </p>
         *        <note>
         *        <p>
         *        To filter by <code>Queues</code>, enter the queue ID/ARN, not the name of the queue.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filters filters);

        /**
         * <p>
         * The queues, up to 100, or channels, to use to filter the metrics returned. Metric data is retrieved only for
         * the resources associated with the queues or channels included in the filter. You can include both queue IDs
         * and queue ARNs in the same request. VOICE, CHAT, and TASK channels are supported.
         * </p>
         * <p>
         * RoutingStepExpression is not a valid filter for GetMetricData and we recommend switching to GetMetricDataV2
         * for more up-to-date features.
         * </p>
         * <note>
         * <p>
         * To filter by <code>Queues</code>, enter the queue ID/ARN, not the name of the queue.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link Filters.Builder} avoiding the
         * need to create one manually via {@link Filters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Filters.Builder#build()} is called immediately and its result is
         * passed to {@link #filters(Filters)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link Filters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(Filters)
         */
        default Builder filters(Consumer<Filters.Builder> filters) {
            return filters(Filters.builder().applyMutation(filters).build());
        }

        /**
         * <p>
         * The grouping applied to the metrics returned. For example, when results are grouped by queue, the metrics
         * returned are grouped by queue. The values returned apply to the metrics for each queue rather than aggregated
         * for all queues.
         * </p>
         * <p>
         * If no grouping is specified, a summary of metrics for all queues is returned.
         * </p>
         * <p>
         * RoutingStepExpression is not a valid filter for GetMetricData and we recommend switching to GetMetricDataV2
         * for more up-to-date features.
         * </p>
         * 
         * @param groupings
         *        The grouping applied to the metrics returned. For example, when results are grouped by queue, the
         *        metrics returned are grouped by queue. The values returned apply to the metrics for each queue rather
         *        than aggregated for all queues.</p>
         *        <p>
         *        If no grouping is specified, a summary of metrics for all queues is returned.
         *        </p>
         *        <p>
         *        RoutingStepExpression is not a valid filter for GetMetricData and we recommend switching to
         *        GetMetricDataV2 for more up-to-date features.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupingsWithStrings(Collection<String> groupings);

        /**
         * <p>
         * The grouping applied to the metrics returned. For example, when results are grouped by queue, the metrics
         * returned are grouped by queue. The values returned apply to the metrics for each queue rather than aggregated
         * for all queues.
         * </p>
         * <p>
         * If no grouping is specified, a summary of metrics for all queues is returned.
         * </p>
         * <p>
         * RoutingStepExpression is not a valid filter for GetMetricData and we recommend switching to GetMetricDataV2
         * for more up-to-date features.
         * </p>
         * 
         * @param groupings
         *        The grouping applied to the metrics returned. For example, when results are grouped by queue, the
         *        metrics returned are grouped by queue. The values returned apply to the metrics for each queue rather
         *        than aggregated for all queues.</p>
         *        <p>
         *        If no grouping is specified, a summary of metrics for all queues is returned.
         *        </p>
         *        <p>
         *        RoutingStepExpression is not a valid filter for GetMetricData and we recommend switching to
         *        GetMetricDataV2 for more up-to-date features.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupingsWithStrings(String... groupings);

        /**
         * <p>
         * The grouping applied to the metrics returned. For example, when results are grouped by queue, the metrics
         * returned are grouped by queue. The values returned apply to the metrics for each queue rather than aggregated
         * for all queues.
         * </p>
         * <p>
         * If no grouping is specified, a summary of metrics for all queues is returned.
         * </p>
         * <p>
         * RoutingStepExpression is not a valid filter for GetMetricData and we recommend switching to GetMetricDataV2
         * for more up-to-date features.
         * </p>
         * 
         * @param groupings
         *        The grouping applied to the metrics returned. For example, when results are grouped by queue, the
         *        metrics returned are grouped by queue. The values returned apply to the metrics for each queue rather
         *        than aggregated for all queues.</p>
         *        <p>
         *        If no grouping is specified, a summary of metrics for all queues is returned.
         *        </p>
         *        <p>
         *        RoutingStepExpression is not a valid filter for GetMetricData and we recommend switching to
         *        GetMetricDataV2 for more up-to-date features.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupings(Collection<Grouping> groupings);

        /**
         * <p>
         * The grouping applied to the metrics returned. For example, when results are grouped by queue, the metrics
         * returned are grouped by queue. The values returned apply to the metrics for each queue rather than aggregated
         * for all queues.
         * </p>
         * <p>
         * If no grouping is specified, a summary of metrics for all queues is returned.
         * </p>
         * <p>
         * RoutingStepExpression is not a valid filter for GetMetricData and we recommend switching to GetMetricDataV2
         * for more up-to-date features.
         * </p>
         * 
         * @param groupings
         *        The grouping applied to the metrics returned. For example, when results are grouped by queue, the
         *        metrics returned are grouped by queue. The values returned apply to the metrics for each queue rather
         *        than aggregated for all queues.</p>
         *        <p>
         *        If no grouping is specified, a summary of metrics for all queues is returned.
         *        </p>
         *        <p>
         *        RoutingStepExpression is not a valid filter for GetMetricData and we recommend switching to
         *        GetMetricDataV2 for more up-to-date features.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupings(Grouping... groupings);

        /**
         * <p>
         * The metrics to retrieve. Specify the name, unit, and statistic for each metric. The following historical
         * metrics are available. For a description of each metric, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html">Historical
         * Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.
         * </p>
         * <note>
         * <p>
         * This API does not support a contacts incoming metric (there's no CONTACTS_INCOMING metric missing from the
         * documented list).
         * </p>
         * </note>
         * <dl>
         * <dt>ABANDON_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistic: AVG
         * </p>
         * </dd>
         * <dt>AFTER_CONTACT_WORK_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistic: AVG
         * </p>
         * </dd>
         * <dt>API_CONTACTS_HANDLED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * </dd>
         * <dt>CALLBACK_CONTACTS_HANDLED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_ABANDONED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_AGENT_HUNG_UP_FIRST</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_CONSULTED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_HANDLED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_HANDLED_INCOMING</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_HANDLED_OUTBOUND</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_HOLD_ABANDONS</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_MISSED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_QUEUED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_TRANSFERRED_IN</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_TRANSFERRED_IN_FROM_QUEUE</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_TRANSFERRED_OUT</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_TRANSFERRED_OUT_FROM_QUEUE</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * </dd>
         * <dt>HANDLE_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistic: AVG
         * </p>
         * </dd>
         * <dt>HOLD_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistic: AVG
         * </p>
         * </dd>
         * <dt>INTERACTION_AND_HOLD_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistic: AVG
         * </p>
         * </dd>
         * <dt>INTERACTION_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistic: AVG
         * </p>
         * </dd>
         * <dt>OCCUPANCY</dt>
         * <dd>
         * <p>
         * Unit: PERCENT
         * </p>
         * <p>
         * Statistic: AVG
         * </p>
         * </dd>
         * <dt>QUEUE_ANSWER_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistic: AVG
         * </p>
         * </dd>
         * <dt>QUEUED_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistic: MAX
         * </p>
         * </dd>
         * <dt>SERVICE_LEVEL</dt>
         * <dd>
         * <p>
         * You can include up to 20 SERVICE_LEVEL metrics in a request.
         * </p>
         * <p>
         * Unit: PERCENT
         * </p>
         * <p>
         * Statistic: AVG
         * </p>
         * <p>
         * Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds.
         * For <code>Comparison</code>, you must enter <code>LT</code> (for "Less than").
         * </p>
         * </dd>
         * </dl>
         * 
         * @param historicalMetrics
         *        The metrics to retrieve. Specify the name, unit, and statistic for each metric. The following
         *        historical metrics are available. For a description of each metric, see <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html"
         *        >Historical Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.</p> <note>
         *        <p>
         *        This API does not support a contacts incoming metric (there's no CONTACTS_INCOMING metric missing from
         *        the documented list).
         *        </p>
         *        </note>
         *        <dl>
         *        <dt>ABANDON_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: SECONDS
         *        </p>
         *        <p>
         *        Statistic: AVG
         *        </p>
         *        </dd>
         *        <dt>AFTER_CONTACT_WORK_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: SECONDS
         *        </p>
         *        <p>
         *        Statistic: AVG
         *        </p>
         *        </dd>
         *        <dt>API_CONTACTS_HANDLED</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        </dd>
         *        <dt>CALLBACK_CONTACTS_HANDLED</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_ABANDONED</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_AGENT_HUNG_UP_FIRST</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_CONSULTED</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_HANDLED</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_HANDLED_INCOMING</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_HANDLED_OUTBOUND</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_HOLD_ABANDONS</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_MISSED</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_QUEUED</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_TRANSFERRED_IN</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_TRANSFERRED_IN_FROM_QUEUE</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_TRANSFERRED_OUT</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_TRANSFERRED_OUT_FROM_QUEUE</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        </dd>
         *        <dt>HANDLE_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: SECONDS
         *        </p>
         *        <p>
         *        Statistic: AVG
         *        </p>
         *        </dd>
         *        <dt>HOLD_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: SECONDS
         *        </p>
         *        <p>
         *        Statistic: AVG
         *        </p>
         *        </dd>
         *        <dt>INTERACTION_AND_HOLD_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: SECONDS
         *        </p>
         *        <p>
         *        Statistic: AVG
         *        </p>
         *        </dd>
         *        <dt>INTERACTION_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: SECONDS
         *        </p>
         *        <p>
         *        Statistic: AVG
         *        </p>
         *        </dd>
         *        <dt>OCCUPANCY</dt>
         *        <dd>
         *        <p>
         *        Unit: PERCENT
         *        </p>
         *        <p>
         *        Statistic: AVG
         *        </p>
         *        </dd>
         *        <dt>QUEUE_ANSWER_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: SECONDS
         *        </p>
         *        <p>
         *        Statistic: AVG
         *        </p>
         *        </dd>
         *        <dt>QUEUED_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: SECONDS
         *        </p>
         *        <p>
         *        Statistic: MAX
         *        </p>
         *        </dd>
         *        <dt>SERVICE_LEVEL</dt>
         *        <dd>
         *        <p>
         *        You can include up to 20 SERVICE_LEVEL metrics in a request.
         *        </p>
         *        <p>
         *        Unit: PERCENT
         *        </p>
         *        <p>
         *        Statistic: AVG
         *        </p>
         *        <p>
         *        Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in
         *        seconds. For <code>Comparison</code>, you must enter <code>LT</code> (for "Less than").
         *        </p>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder historicalMetrics(Collection<HistoricalMetric> historicalMetrics);

        /**
         * <p>
         * The metrics to retrieve. Specify the name, unit, and statistic for each metric. The following historical
         * metrics are available. For a description of each metric, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html">Historical
         * Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.
         * </p>
         * <note>
         * <p>
         * This API does not support a contacts incoming metric (there's no CONTACTS_INCOMING metric missing from the
         * documented list).
         * </p>
         * </note>
         * <dl>
         * <dt>ABANDON_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistic: AVG
         * </p>
         * </dd>
         * <dt>AFTER_CONTACT_WORK_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistic: AVG
         * </p>
         * </dd>
         * <dt>API_CONTACTS_HANDLED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * </dd>
         * <dt>CALLBACK_CONTACTS_HANDLED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_ABANDONED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_AGENT_HUNG_UP_FIRST</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_CONSULTED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_HANDLED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_HANDLED_INCOMING</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_HANDLED_OUTBOUND</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_HOLD_ABANDONS</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_MISSED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_QUEUED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_TRANSFERRED_IN</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_TRANSFERRED_IN_FROM_QUEUE</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_TRANSFERRED_OUT</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_TRANSFERRED_OUT_FROM_QUEUE</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * </dd>
         * <dt>HANDLE_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistic: AVG
         * </p>
         * </dd>
         * <dt>HOLD_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistic: AVG
         * </p>
         * </dd>
         * <dt>INTERACTION_AND_HOLD_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistic: AVG
         * </p>
         * </dd>
         * <dt>INTERACTION_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistic: AVG
         * </p>
         * </dd>
         * <dt>OCCUPANCY</dt>
         * <dd>
         * <p>
         * Unit: PERCENT
         * </p>
         * <p>
         * Statistic: AVG
         * </p>
         * </dd>
         * <dt>QUEUE_ANSWER_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistic: AVG
         * </p>
         * </dd>
         * <dt>QUEUED_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistic: MAX
         * </p>
         * </dd>
         * <dt>SERVICE_LEVEL</dt>
         * <dd>
         * <p>
         * You can include up to 20 SERVICE_LEVEL metrics in a request.
         * </p>
         * <p>
         * Unit: PERCENT
         * </p>
         * <p>
         * Statistic: AVG
         * </p>
         * <p>
         * Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds.
         * For <code>Comparison</code>, you must enter <code>LT</code> (for "Less than").
         * </p>
         * </dd>
         * </dl>
         * 
         * @param historicalMetrics
         *        The metrics to retrieve. Specify the name, unit, and statistic for each metric. The following
         *        historical metrics are available. For a description of each metric, see <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html"
         *        >Historical Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.</p> <note>
         *        <p>
         *        This API does not support a contacts incoming metric (there's no CONTACTS_INCOMING metric missing from
         *        the documented list).
         *        </p>
         *        </note>
         *        <dl>
         *        <dt>ABANDON_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: SECONDS
         *        </p>
         *        <p>
         *        Statistic: AVG
         *        </p>
         *        </dd>
         *        <dt>AFTER_CONTACT_WORK_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: SECONDS
         *        </p>
         *        <p>
         *        Statistic: AVG
         *        </p>
         *        </dd>
         *        <dt>API_CONTACTS_HANDLED</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        </dd>
         *        <dt>CALLBACK_CONTACTS_HANDLED</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_ABANDONED</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_AGENT_HUNG_UP_FIRST</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_CONSULTED</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_HANDLED</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_HANDLED_INCOMING</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_HANDLED_OUTBOUND</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_HOLD_ABANDONS</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_MISSED</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_QUEUED</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_TRANSFERRED_IN</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_TRANSFERRED_IN_FROM_QUEUE</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_TRANSFERRED_OUT</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_TRANSFERRED_OUT_FROM_QUEUE</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        </dd>
         *        <dt>HANDLE_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: SECONDS
         *        </p>
         *        <p>
         *        Statistic: AVG
         *        </p>
         *        </dd>
         *        <dt>HOLD_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: SECONDS
         *        </p>
         *        <p>
         *        Statistic: AVG
         *        </p>
         *        </dd>
         *        <dt>INTERACTION_AND_HOLD_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: SECONDS
         *        </p>
         *        <p>
         *        Statistic: AVG
         *        </p>
         *        </dd>
         *        <dt>INTERACTION_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: SECONDS
         *        </p>
         *        <p>
         *        Statistic: AVG
         *        </p>
         *        </dd>
         *        <dt>OCCUPANCY</dt>
         *        <dd>
         *        <p>
         *        Unit: PERCENT
         *        </p>
         *        <p>
         *        Statistic: AVG
         *        </p>
         *        </dd>
         *        <dt>QUEUE_ANSWER_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: SECONDS
         *        </p>
         *        <p>
         *        Statistic: AVG
         *        </p>
         *        </dd>
         *        <dt>QUEUED_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: SECONDS
         *        </p>
         *        <p>
         *        Statistic: MAX
         *        </p>
         *        </dd>
         *        <dt>SERVICE_LEVEL</dt>
         *        <dd>
         *        <p>
         *        You can include up to 20 SERVICE_LEVEL metrics in a request.
         *        </p>
         *        <p>
         *        Unit: PERCENT
         *        </p>
         *        <p>
         *        Statistic: AVG
         *        </p>
         *        <p>
         *        Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in
         *        seconds. For <code>Comparison</code>, you must enter <code>LT</code> (for "Less than").
         *        </p>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder historicalMetrics(HistoricalMetric... historicalMetrics);

        /**
         * <p>
         * The metrics to retrieve. Specify the name, unit, and statistic for each metric. The following historical
         * metrics are available. For a description of each metric, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html">Historical
         * Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.
         * </p>
         * <note>
         * <p>
         * This API does not support a contacts incoming metric (there's no CONTACTS_INCOMING metric missing from the
         * documented list).
         * </p>
         * </note>
         * <dl>
         * <dt>ABANDON_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistic: AVG
         * </p>
         * </dd>
         * <dt>AFTER_CONTACT_WORK_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistic: AVG
         * </p>
         * </dd>
         * <dt>API_CONTACTS_HANDLED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * </dd>
         * <dt>CALLBACK_CONTACTS_HANDLED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_ABANDONED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_AGENT_HUNG_UP_FIRST</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_CONSULTED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_HANDLED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_HANDLED_INCOMING</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_HANDLED_OUTBOUND</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_HOLD_ABANDONS</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_MISSED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_QUEUED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_TRANSFERRED_IN</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_TRANSFERRED_IN_FROM_QUEUE</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_TRANSFERRED_OUT</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * </dd>
         * <dt>CONTACTS_TRANSFERRED_OUT_FROM_QUEUE</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * </dd>
         * <dt>HANDLE_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistic: AVG
         * </p>
         * </dd>
         * <dt>HOLD_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistic: AVG
         * </p>
         * </dd>
         * <dt>INTERACTION_AND_HOLD_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistic: AVG
         * </p>
         * </dd>
         * <dt>INTERACTION_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistic: AVG
         * </p>
         * </dd>
         * <dt>OCCUPANCY</dt>
         * <dd>
         * <p>
         * Unit: PERCENT
         * </p>
         * <p>
         * Statistic: AVG
         * </p>
         * </dd>
         * <dt>QUEUE_ANSWER_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistic: AVG
         * </p>
         * </dd>
         * <dt>QUEUED_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistic: MAX
         * </p>
         * </dd>
         * <dt>SERVICE_LEVEL</dt>
         * <dd>
         * <p>
         * You can include up to 20 SERVICE_LEVEL metrics in a request.
         * </p>
         * <p>
         * Unit: PERCENT
         * </p>
         * <p>
         * Statistic: AVG
         * </p>
         * <p>
         * Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds.
         * For <code>Comparison</code>, you must enter <code>LT</code> (for "Less than").
         * </p>
         * </dd>
         * </dl>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.HistoricalMetric.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.connect.model.HistoricalMetric#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.HistoricalMetric.Builder#build()} is called immediately
         * and its result is passed to {@link #historicalMetrics(List<HistoricalMetric>)}.
         * 
         * @param historicalMetrics
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.HistoricalMetric.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #historicalMetrics(java.util.Collection<HistoricalMetric>)
         */
        Builder historicalMetrics(Consumer<HistoricalMetric.Builder>... historicalMetrics);

        /**
         * <p>
         * The token for the next set of results. Use the value returned in the previous response in the next request to
         * retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. Use the value returned in the previous response in the next
         *        request to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return per page.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return per page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private Instant startTime;

        private Instant endTime;

        private Filters filters;

        private List<String> groupings = DefaultSdkAutoConstructList.getInstance();

        private List<HistoricalMetric> historicalMetrics = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMetricDataRequest model) {
            super(model);
            instanceId(model.instanceId);
            startTime(model.startTime);
            endTime(model.endTime);
            filters(model.filters);
            groupingsWithStrings(model.groupings);
            historicalMetrics(model.historicalMetrics);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Filters.Builder getFilters() {
            return filters != null ? filters.toBuilder() : null;
        }

        public final void setFilters(Filters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(Filters filters) {
            this.filters = filters;
            return this;
        }

        public final Collection<String> getGroupings() {
            if (groupings instanceof SdkAutoConstructList) {
                return null;
            }
            return groupings;
        }

        public final void setGroupings(Collection<String> groupings) {
            this.groupings = GroupingsCopier.copy(groupings);
        }

        @Override
        public final Builder groupingsWithStrings(Collection<String> groupings) {
            this.groupings = GroupingsCopier.copy(groupings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupingsWithStrings(String... groupings) {
            groupingsWithStrings(Arrays.asList(groupings));
            return this;
        }

        @Override
        public final Builder groupings(Collection<Grouping> groupings) {
            this.groupings = GroupingsCopier.copyEnumToString(groupings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupings(Grouping... groupings) {
            groupings(Arrays.asList(groupings));
            return this;
        }

        public final List<HistoricalMetric.Builder> getHistoricalMetrics() {
            List<HistoricalMetric.Builder> result = HistoricalMetricsCopier.copyToBuilder(this.historicalMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHistoricalMetrics(Collection<HistoricalMetric.BuilderImpl> historicalMetrics) {
            this.historicalMetrics = HistoricalMetricsCopier.copyFromBuilder(historicalMetrics);
        }

        @Override
        public final Builder historicalMetrics(Collection<HistoricalMetric> historicalMetrics) {
            this.historicalMetrics = HistoricalMetricsCopier.copy(historicalMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder historicalMetrics(HistoricalMetric... historicalMetrics) {
            historicalMetrics(Arrays.asList(historicalMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder historicalMetrics(Consumer<HistoricalMetric.Builder>... historicalMetrics) {
            historicalMetrics(Stream.of(historicalMetrics).map(c -> HistoricalMetric.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetMetricDataRequest build() {
            return new GetMetricDataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
