/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.KinesisFirehoseConfig;
import software.amazon.awssdk.services.connect.model.KinesisStreamConfig;
import software.amazon.awssdk.services.connect.model.KinesisVideoStreamConfig;
import software.amazon.awssdk.services.connect.model.S3Config;
import software.amazon.awssdk.services.connect.model.StorageType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceStorageConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceStorageConfig> {
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationId").getter(InstanceStorageConfig.getter(InstanceStorageConfig::associationId)).setter(InstanceStorageConfig.setter(Builder::associationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId").build()}).build();
    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageType").getter(InstanceStorageConfig.getter(InstanceStorageConfig::storageTypeAsString)).setter(InstanceStorageConfig.setter(Builder::storageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()}).build();
    private static final SdkField<S3Config> S3_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3Config").getter(InstanceStorageConfig.getter(InstanceStorageConfig::s3Config)).setter(InstanceStorageConfig.setter(Builder::s3Config)).constructor(S3Config::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Config").build()}).build();
    private static final SdkField<KinesisVideoStreamConfig> KINESIS_VIDEO_STREAM_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KinesisVideoStreamConfig").getter(InstanceStorageConfig.getter(InstanceStorageConfig::kinesisVideoStreamConfig)).setter(InstanceStorageConfig.setter(Builder::kinesisVideoStreamConfig)).constructor(KinesisVideoStreamConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisVideoStreamConfig").build()}).build();
    private static final SdkField<KinesisStreamConfig> KINESIS_STREAM_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KinesisStreamConfig").getter(InstanceStorageConfig.getter(InstanceStorageConfig::kinesisStreamConfig)).setter(InstanceStorageConfig.setter(Builder::kinesisStreamConfig)).constructor(KinesisStreamConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisStreamConfig").build()}).build();
    private static final SdkField<KinesisFirehoseConfig> KINESIS_FIREHOSE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KinesisFirehoseConfig").getter(InstanceStorageConfig.getter(InstanceStorageConfig::kinesisFirehoseConfig)).setter(InstanceStorageConfig.setter(Builder::kinesisFirehoseConfig)).constructor(KinesisFirehoseConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisFirehoseConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_ID_FIELD, STORAGE_TYPE_FIELD, S3_CONFIG_FIELD, KINESIS_VIDEO_STREAM_CONFIG_FIELD, KINESIS_STREAM_CONFIG_FIELD, KINESIS_FIREHOSE_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String associationId;
    private final String storageType;
    private final S3Config s3Config;
    private final KinesisVideoStreamConfig kinesisVideoStreamConfig;
    private final KinesisStreamConfig kinesisStreamConfig;
    private final KinesisFirehoseConfig kinesisFirehoseConfig;

    private InstanceStorageConfig(BuilderImpl builder) {
        this.associationId = builder.associationId;
        this.storageType = builder.storageType;
        this.s3Config = builder.s3Config;
        this.kinesisVideoStreamConfig = builder.kinesisVideoStreamConfig;
        this.kinesisStreamConfig = builder.kinesisStreamConfig;
        this.kinesisFirehoseConfig = builder.kinesisFirehoseConfig;
    }

    public final String associationId() {
        return this.associationId;
    }

    public final StorageType storageType() {
        return StorageType.fromValue(this.storageType);
    }

    public final String storageTypeAsString() {
        return this.storageType;
    }

    public final S3Config s3Config() {
        return this.s3Config;
    }

    public final KinesisVideoStreamConfig kinesisVideoStreamConfig() {
        return this.kinesisVideoStreamConfig;
    }

    public final KinesisStreamConfig kinesisStreamConfig() {
        return this.kinesisStreamConfig;
    }

    public final KinesisFirehoseConfig kinesisFirehoseConfig() {
        return this.kinesisFirehoseConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.associationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Config());
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisVideoStreamConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisStreamConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisFirehoseConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceStorageConfig)) {
            return false;
        }
        InstanceStorageConfig other = (InstanceStorageConfig)obj;
        return Objects.equals(this.associationId(), other.associationId()) && Objects.equals(this.storageTypeAsString(), other.storageTypeAsString()) && Objects.equals(this.s3Config(), other.s3Config()) && Objects.equals(this.kinesisVideoStreamConfig(), other.kinesisVideoStreamConfig()) && Objects.equals(this.kinesisStreamConfig(), other.kinesisStreamConfig()) && Objects.equals(this.kinesisFirehoseConfig(), other.kinesisFirehoseConfig());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceStorageConfig").add("AssociationId", (Object)this.associationId()).add("StorageType", (Object)this.storageTypeAsString()).add("S3Config", (Object)this.s3Config()).add("KinesisVideoStreamConfig", (Object)this.kinesisVideoStreamConfig()).add("KinesisStreamConfig", (Object)this.kinesisStreamConfig()).add("KinesisFirehoseConfig", (Object)this.kinesisFirehoseConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociationId": {
                return Optional.ofNullable(clazz.cast(this.associationId()));
            }
            case "StorageType": {
                return Optional.ofNullable(clazz.cast(this.storageTypeAsString()));
            }
            case "S3Config": {
                return Optional.ofNullable(clazz.cast(this.s3Config()));
            }
            case "KinesisVideoStreamConfig": {
                return Optional.ofNullable(clazz.cast(this.kinesisVideoStreamConfig()));
            }
            case "KinesisStreamConfig": {
                return Optional.ofNullable(clazz.cast(this.kinesisStreamConfig()));
            }
            case "KinesisFirehoseConfig": {
                return Optional.ofNullable(clazz.cast(this.kinesisFirehoseConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceStorageConfig, T> g) {
        return obj -> g.apply((InstanceStorageConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String associationId;
        private String storageType;
        private S3Config s3Config;
        private KinesisVideoStreamConfig kinesisVideoStreamConfig;
        private KinesisStreamConfig kinesisStreamConfig;
        private KinesisFirehoseConfig kinesisFirehoseConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceStorageConfig model) {
            this.associationId(model.associationId);
            this.storageType(model.storageType);
            this.s3Config(model.s3Config);
            this.kinesisVideoStreamConfig(model.kinesisVideoStreamConfig);
            this.kinesisStreamConfig(model.kinesisStreamConfig);
            this.kinesisFirehoseConfig(model.kinesisFirehoseConfig);
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final String getStorageType() {
            return this.storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        @Override
        public final Builder storageType(StorageType storageType) {
            this.storageType(storageType == null ? null : storageType.toString());
            return this;
        }

        public final S3Config.Builder getS3Config() {
            return this.s3Config != null ? this.s3Config.toBuilder() : null;
        }

        public final void setS3Config(S3Config.BuilderImpl s3Config) {
            this.s3Config = s3Config != null ? s3Config.build() : null;
        }

        @Override
        public final Builder s3Config(S3Config s3Config) {
            this.s3Config = s3Config;
            return this;
        }

        public final KinesisVideoStreamConfig.Builder getKinesisVideoStreamConfig() {
            return this.kinesisVideoStreamConfig != null ? this.kinesisVideoStreamConfig.toBuilder() : null;
        }

        public final void setKinesisVideoStreamConfig(KinesisVideoStreamConfig.BuilderImpl kinesisVideoStreamConfig) {
            this.kinesisVideoStreamConfig = kinesisVideoStreamConfig != null ? kinesisVideoStreamConfig.build() : null;
        }

        @Override
        public final Builder kinesisVideoStreamConfig(KinesisVideoStreamConfig kinesisVideoStreamConfig) {
            this.kinesisVideoStreamConfig = kinesisVideoStreamConfig;
            return this;
        }

        public final KinesisStreamConfig.Builder getKinesisStreamConfig() {
            return this.kinesisStreamConfig != null ? this.kinesisStreamConfig.toBuilder() : null;
        }

        public final void setKinesisStreamConfig(KinesisStreamConfig.BuilderImpl kinesisStreamConfig) {
            this.kinesisStreamConfig = kinesisStreamConfig != null ? kinesisStreamConfig.build() : null;
        }

        @Override
        public final Builder kinesisStreamConfig(KinesisStreamConfig kinesisStreamConfig) {
            this.kinesisStreamConfig = kinesisStreamConfig;
            return this;
        }

        public final KinesisFirehoseConfig.Builder getKinesisFirehoseConfig() {
            return this.kinesisFirehoseConfig != null ? this.kinesisFirehoseConfig.toBuilder() : null;
        }

        public final void setKinesisFirehoseConfig(KinesisFirehoseConfig.BuilderImpl kinesisFirehoseConfig) {
            this.kinesisFirehoseConfig = kinesisFirehoseConfig != null ? kinesisFirehoseConfig.build() : null;
        }

        @Override
        public final Builder kinesisFirehoseConfig(KinesisFirehoseConfig kinesisFirehoseConfig) {
            this.kinesisFirehoseConfig = kinesisFirehoseConfig;
            return this;
        }

        public InstanceStorageConfig build() {
            return new InstanceStorageConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceStorageConfig> {
        public Builder associationId(String var1);

        public Builder storageType(String var1);

        public Builder storageType(StorageType var1);

        public Builder s3Config(S3Config var1);

        default public Builder s3Config(Consumer<S3Config.Builder> s3Config) {
            return this.s3Config((S3Config)((S3Config.Builder)S3Config.builder().applyMutation(s3Config)).build());
        }

        public Builder kinesisVideoStreamConfig(KinesisVideoStreamConfig var1);

        default public Builder kinesisVideoStreamConfig(Consumer<KinesisVideoStreamConfig.Builder> kinesisVideoStreamConfig) {
            return this.kinesisVideoStreamConfig((KinesisVideoStreamConfig)((KinesisVideoStreamConfig.Builder)KinesisVideoStreamConfig.builder().applyMutation(kinesisVideoStreamConfig)).build());
        }

        public Builder kinesisStreamConfig(KinesisStreamConfig var1);

        default public Builder kinesisStreamConfig(Consumer<KinesisStreamConfig.Builder> kinesisStreamConfig) {
            return this.kinesisStreamConfig((KinesisStreamConfig)((KinesisStreamConfig.Builder)KinesisStreamConfig.builder().applyMutation(kinesisStreamConfig)).build());
        }

        public Builder kinesisFirehoseConfig(KinesisFirehoseConfig var1);

        default public Builder kinesisFirehoseConfig(Consumer<KinesisFirehoseConfig.Builder> kinesisFirehoseConfig) {
            return this.kinesisFirehoseConfig((KinesisFirehoseConfig)((KinesisFirehoseConfig.Builder)KinesisFirehoseConfig.builder().applyMutation(kinesisFirehoseConfig)).build());
        }
    }
}

