/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAuthenticationProfileRequest extends ConnectRequest implements
        ToCopyableBuilder<UpdateAuthenticationProfileRequest.Builder, UpdateAuthenticationProfileRequest> {
    private static final SdkField<String> AUTHENTICATION_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthenticationProfileId").getter(getter(UpdateAuthenticationProfileRequest::authenticationProfileId))
            .setter(setter(Builder::authenticationProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AuthenticationProfileId").build())
            .build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(UpdateAuthenticationProfileRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateAuthenticationProfileRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateAuthenticationProfileRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<String>> ALLOWED_IPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AllowedIps")
            .getter(getter(UpdateAuthenticationProfileRequest::allowedIps))
            .setter(setter(Builder::allowedIps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedIps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> BLOCKED_IPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("BlockedIps")
            .getter(getter(UpdateAuthenticationProfileRequest::blockedIps))
            .setter(setter(Builder::blockedIps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockedIps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> PERIODIC_SESSION_DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PeriodicSessionDuration").getter(getter(UpdateAuthenticationProfileRequest::periodicSessionDuration))
            .setter(setter(Builder::periodicSessionDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeriodicSessionDuration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AUTHENTICATION_PROFILE_ID_FIELD, INSTANCE_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, ALLOWED_IPS_FIELD,
            BLOCKED_IPS_FIELD, PERIODIC_SESSION_DURATION_FIELD));

    private final String authenticationProfileId;

    private final String instanceId;

    private final String name;

    private final String description;

    private final List<String> allowedIps;

    private final List<String> blockedIps;

    private final Integer periodicSessionDuration;

    private UpdateAuthenticationProfileRequest(BuilderImpl builder) {
        super(builder);
        this.authenticationProfileId = builder.authenticationProfileId;
        this.instanceId = builder.instanceId;
        this.name = builder.name;
        this.description = builder.description;
        this.allowedIps = builder.allowedIps;
        this.blockedIps = builder.blockedIps;
        this.periodicSessionDuration = builder.periodicSessionDuration;
    }

    /**
     * <p>
     * A unique identifier for the authentication profile.
     * </p>
     * 
     * @return A unique identifier for the authentication profile.
     */
    public final String authenticationProfileId() {
        return authenticationProfileId;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in
     * the Amazon Resource Name (ARN) of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
     *         ID</a> in the Amazon Resource Name (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The name for the authentication profile.
     * </p>
     * 
     * @return The name for the authentication profile.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description for the authentication profile.
     * </p>
     * 
     * @return The description for the authentication profile.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedIps property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAllowedIps() {
        return allowedIps != null && !(allowedIps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of IP address range strings that are allowed to access the instance. For more information on how to
     * configure IP addresses, see<a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-session-timeouts"
     * >Configure session timeouts</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedIps} method.
     * </p>
     * 
     * @return A list of IP address range strings that are allowed to access the instance. For more information on how
     *         to configure IP addresses, see<a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-session-timeouts"
     *         >Configure session timeouts</a> in the <i>Amazon Connect Administrator Guide</i>.
     */
    public final List<String> allowedIps() {
        return allowedIps;
    }

    /**
     * For responses, this returns true if the service returned a value for the BlockedIps property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBlockedIps() {
        return blockedIps != null && !(blockedIps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of IP address range strings that are blocked from accessing the instance. For more information on how to
     * configure IP addresses, For more information on how to configure IP addresses, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-ip-based-ac"
     * >Configure IP-based access control</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlockedIps} method.
     * </p>
     * 
     * @return A list of IP address range strings that are blocked from accessing the instance. For more information on
     *         how to configure IP addresses, For more information on how to configure IP addresses, see <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-ip-based-ac"
     *         >Configure IP-based access control</a> in the <i>Amazon Connect Administrator Guide</i>.
     */
    public final List<String> blockedIps() {
        return blockedIps;
    }

    /**
     * <p>
     * The short lived session duration configuration for users logged in to Amazon Connect, in minutes. This value
     * determines the maximum possible time before an agent is authenticated. For more information, For more information
     * on how to configure IP addresses, see <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-session-timeouts"
     * >Configure session timeouts</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * 
     * @return The short lived session duration configuration for users logged in to Amazon Connect, in minutes. This
     *         value determines the maximum possible time before an agent is authenticated. For more information, For
     *         more information on how to configure IP addresses, see <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-session-timeouts"
     *         >Configure session timeouts</a> in the <i>Amazon Connect Administrator Guide</i>.
     */
    public final Integer periodicSessionDuration() {
        return periodicSessionDuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(authenticationProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedIps() ? allowedIps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBlockedIps() ? blockedIps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(periodicSessionDuration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAuthenticationProfileRequest)) {
            return false;
        }
        UpdateAuthenticationProfileRequest other = (UpdateAuthenticationProfileRequest) obj;
        return Objects.equals(authenticationProfileId(), other.authenticationProfileId())
                && Objects.equals(instanceId(), other.instanceId()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && hasAllowedIps() == other.hasAllowedIps()
                && Objects.equals(allowedIps(), other.allowedIps()) && hasBlockedIps() == other.hasBlockedIps()
                && Objects.equals(blockedIps(), other.blockedIps())
                && Objects.equals(periodicSessionDuration(), other.periodicSessionDuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAuthenticationProfileRequest").add("AuthenticationProfileId", authenticationProfileId())
                .add("InstanceId", instanceId()).add("Name", name()).add("Description", description())
                .add("AllowedIps", hasAllowedIps() ? allowedIps() : null)
                .add("BlockedIps", hasBlockedIps() ? blockedIps() : null)
                .add("PeriodicSessionDuration", periodicSessionDuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthenticationProfileId":
            return Optional.ofNullable(clazz.cast(authenticationProfileId()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "AllowedIps":
            return Optional.ofNullable(clazz.cast(allowedIps()));
        case "BlockedIps":
            return Optional.ofNullable(clazz.cast(blockedIps()));
        case "PeriodicSessionDuration":
            return Optional.ofNullable(clazz.cast(periodicSessionDuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAuthenticationProfileRequest, T> g) {
        return obj -> g.apply((UpdateAuthenticationProfileRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateAuthenticationProfileRequest> {
        /**
         * <p>
         * A unique identifier for the authentication profile.
         * </p>
         * 
         * @param authenticationProfileId
         *        A unique identifier for the authentication profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationProfileId(String authenticationProfileId);

        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a>
         * in the Amazon Resource Name (ARN) of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
         *        ID</a> in the Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The name for the authentication profile.
         * </p>
         * 
         * @param name
         *        The name for the authentication profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description for the authentication profile.
         * </p>
         * 
         * @param description
         *        The description for the authentication profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A list of IP address range strings that are allowed to access the instance. For more information on how to
         * configure IP addresses, see<a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-session-timeouts"
         * >Configure session timeouts</a> in the <i>Amazon Connect Administrator Guide</i>.
         * </p>
         * 
         * @param allowedIps
         *        A list of IP address range strings that are allowed to access the instance. For more information on
         *        how to configure IP addresses, see<a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-session-timeouts"
         *        >Configure session timeouts</a> in the <i>Amazon Connect Administrator Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedIps(Collection<String> allowedIps);

        /**
         * <p>
         * A list of IP address range strings that are allowed to access the instance. For more information on how to
         * configure IP addresses, see<a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-session-timeouts"
         * >Configure session timeouts</a> in the <i>Amazon Connect Administrator Guide</i>.
         * </p>
         * 
         * @param allowedIps
         *        A list of IP address range strings that are allowed to access the instance. For more information on
         *        how to configure IP addresses, see<a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-session-timeouts"
         *        >Configure session timeouts</a> in the <i>Amazon Connect Administrator Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedIps(String... allowedIps);

        /**
         * <p>
         * A list of IP address range strings that are blocked from accessing the instance. For more information on how
         * to configure IP addresses, For more information on how to configure IP addresses, see <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-ip-based-ac"
         * >Configure IP-based access control</a> in the <i>Amazon Connect Administrator Guide</i>.
         * </p>
         * 
         * @param blockedIps
         *        A list of IP address range strings that are blocked from accessing the instance. For more information
         *        on how to configure IP addresses, For more information on how to configure IP addresses, see <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-ip-based-ac"
         *        >Configure IP-based access control</a> in the <i>Amazon Connect Administrator Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockedIps(Collection<String> blockedIps);

        /**
         * <p>
         * A list of IP address range strings that are blocked from accessing the instance. For more information on how
         * to configure IP addresses, For more information on how to configure IP addresses, see <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-ip-based-ac"
         * >Configure IP-based access control</a> in the <i>Amazon Connect Administrator Guide</i>.
         * </p>
         * 
         * @param blockedIps
         *        A list of IP address range strings that are blocked from accessing the instance. For more information
         *        on how to configure IP addresses, For more information on how to configure IP addresses, see <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-ip-based-ac"
         *        >Configure IP-based access control</a> in the <i>Amazon Connect Administrator Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockedIps(String... blockedIps);

        /**
         * <p>
         * The short lived session duration configuration for users logged in to Amazon Connect, in minutes. This value
         * determines the maximum possible time before an agent is authenticated. For more information, For more
         * information on how to configure IP addresses, see <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-session-timeouts"
         * >Configure session timeouts</a> in the <i>Amazon Connect Administrator Guide</i>.
         * </p>
         * 
         * @param periodicSessionDuration
         *        The short lived session duration configuration for users logged in to Amazon Connect, in minutes. This
         *        value determines the maximum possible time before an agent is authenticated. For more information, For
         *        more information on how to configure IP addresses, see <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-session-timeouts"
         *        >Configure session timeouts</a> in the <i>Amazon Connect Administrator Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder periodicSessionDuration(Integer periodicSessionDuration);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String authenticationProfileId;

        private String instanceId;

        private String name;

        private String description;

        private List<String> allowedIps = DefaultSdkAutoConstructList.getInstance();

        private List<String> blockedIps = DefaultSdkAutoConstructList.getInstance();

        private Integer periodicSessionDuration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAuthenticationProfileRequest model) {
            super(model);
            authenticationProfileId(model.authenticationProfileId);
            instanceId(model.instanceId);
            name(model.name);
            description(model.description);
            allowedIps(model.allowedIps);
            blockedIps(model.blockedIps);
            periodicSessionDuration(model.periodicSessionDuration);
        }

        public final String getAuthenticationProfileId() {
            return authenticationProfileId;
        }

        public final void setAuthenticationProfileId(String authenticationProfileId) {
            this.authenticationProfileId = authenticationProfileId;
        }

        @Override
        public final Builder authenticationProfileId(String authenticationProfileId) {
            this.authenticationProfileId = authenticationProfileId;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getAllowedIps() {
            if (allowedIps instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedIps;
        }

        public final void setAllowedIps(Collection<String> allowedIps) {
            this.allowedIps = IpCidrListCopier.copy(allowedIps);
        }

        @Override
        public final Builder allowedIps(Collection<String> allowedIps) {
            this.allowedIps = IpCidrListCopier.copy(allowedIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedIps(String... allowedIps) {
            allowedIps(Arrays.asList(allowedIps));
            return this;
        }

        public final Collection<String> getBlockedIps() {
            if (blockedIps instanceof SdkAutoConstructList) {
                return null;
            }
            return blockedIps;
        }

        public final void setBlockedIps(Collection<String> blockedIps) {
            this.blockedIps = IpCidrListCopier.copy(blockedIps);
        }

        @Override
        public final Builder blockedIps(Collection<String> blockedIps) {
            this.blockedIps = IpCidrListCopier.copy(blockedIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockedIps(String... blockedIps) {
            blockedIps(Arrays.asList(blockedIps));
            return this;
        }

        public final Integer getPeriodicSessionDuration() {
            return periodicSessionDuration;
        }

        public final void setPeriodicSessionDuration(Integer periodicSessionDuration) {
            this.periodicSessionDuration = periodicSessionDuration;
        }

        @Override
        public final Builder periodicSessionDuration(Integer periodicSessionDuration) {
            this.periodicSessionDuration = periodicSessionDuration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAuthenticationProfileRequest build() {
            return new UpdateAuthenticationProfileRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
