/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information on the identity that created the file.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatedByInfo implements SdkPojo, Serializable, ToCopyableBuilder<CreatedByInfo.Builder, CreatedByInfo> {
    private static final SdkField<String> CONNECT_USER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectUserArn").getter(getter(CreatedByInfo::connectUserArn)).setter(setter(Builder::connectUserArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectUserArn").build()).build();

    private static final SdkField<String> AWS_IDENTITY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AWSIdentityArn").getter(getter(CreatedByInfo::awsIdentityArn)).setter(setter(Builder::awsIdentityArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AWSIdentityArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECT_USER_ARN_FIELD,
            AWS_IDENTITY_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String connectUserArn;

    private final String awsIdentityArn;

    private final Type type;

    private CreatedByInfo(BuilderImpl builder) {
        this.connectUserArn = builder.connectUserArn;
        this.awsIdentityArn = builder.awsIdentityArn;
        this.type = builder.type;
    }

    /**
     * <p>
     * An agent ARN representing a <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonconnect.html#amazonconnect-resources-for-iam-policies"
     * >connect user</a>.
     * </p>
     * 
     * @return An agent ARN representing a <a href=
     *         "https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonconnect.html#amazonconnect-resources-for-iam-policies"
     *         >connect user</a>.
     */
    public final String connectUserArn() {
        return connectUserArn;
    }

    /**
     * <p>
     * STS or IAM ARN representing the identity of API Caller. SDK users cannot populate this and this value is
     * calculated automatically if <code>ConnectUserArn</code> is not provided.
     * </p>
     * 
     * @return STS or IAM ARN representing the identity of API Caller. SDK users cannot populate this and this value is
     *         calculated automatically if <code>ConnectUserArn</code> is not provided.
     */
    public final String awsIdentityArn() {
        return awsIdentityArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectUserArn());
        hashCode = 31 * hashCode + Objects.hashCode(awsIdentityArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatedByInfo)) {
            return false;
        }
        CreatedByInfo other = (CreatedByInfo) obj;
        return Objects.equals(connectUserArn(), other.connectUserArn())
                && Objects.equals(awsIdentityArn(), other.awsIdentityArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatedByInfo").add("ConnectUserArn", connectUserArn()).add("AWSIdentityArn", awsIdentityArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectUserArn":
            return Optional.ofNullable(clazz.cast(connectUserArn()));
        case "AWSIdentityArn":
            return Optional.ofNullable(clazz.cast(awsIdentityArn()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #connectUserArn()} initialized to the given value.
     *
     * <p>
     * An agent ARN representing a <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonconnect.html#amazonconnect-resources-for-iam-policies"
     * >connect user</a>.
     * </p>
     * 
     * @param connectUserArn
     *        An agent ARN representing a <a href=
     *        "https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonconnect.html#amazonconnect-resources-for-iam-policies"
     *        >connect user</a>.
     */
    public static CreatedByInfo fromConnectUserArn(String connectUserArn) {
        return builder().connectUserArn(connectUserArn).build();
    }

    /**
     * Create an instance of this class with {@link #awsIdentityArn()} initialized to the given value.
     *
     * <p>
     * STS or IAM ARN representing the identity of API Caller. SDK users cannot populate this and this value is
     * calculated automatically if <code>ConnectUserArn</code> is not provided.
     * </p>
     * 
     * @param awsIdentityArn
     *        STS or IAM ARN representing the identity of API Caller. SDK users cannot populate this and this value is
     *        calculated automatically if <code>ConnectUserArn</code> is not provided.
     */
    public static CreatedByInfo fromAwsIdentityArn(String awsIdentityArn) {
        return builder().awsIdentityArn(awsIdentityArn).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatedByInfo, T> g) {
        return obj -> g.apply((CreatedByInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreatedByInfo> {
        /**
         * <p>
         * An agent ARN representing a <a href=
         * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonconnect.html#amazonconnect-resources-for-iam-policies"
         * >connect user</a>.
         * </p>
         * 
         * @param connectUserArn
         *        An agent ARN representing a <a href=
         *        "https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonconnect.html#amazonconnect-resources-for-iam-policies"
         *        >connect user</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectUserArn(String connectUserArn);

        /**
         * <p>
         * STS or IAM ARN representing the identity of API Caller. SDK users cannot populate this and this value is
         * calculated automatically if <code>ConnectUserArn</code> is not provided.
         * </p>
         * 
         * @param awsIdentityArn
         *        STS or IAM ARN representing the identity of API Caller. SDK users cannot populate this and this value
         *        is calculated automatically if <code>ConnectUserArn</code> is not provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsIdentityArn(String awsIdentityArn);
    }

    static final class BuilderImpl implements Builder {
        private String connectUserArn;

        private String awsIdentityArn;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(CreatedByInfo model) {
            connectUserArn(model.connectUserArn);
            awsIdentityArn(model.awsIdentityArn);
        }

        public final String getConnectUserArn() {
            return connectUserArn;
        }

        public final void setConnectUserArn(String connectUserArn) {
            Object oldValue = this.connectUserArn;
            this.connectUserArn = connectUserArn;
            handleUnionValueChange(Type.CONNECT_USER_ARN, oldValue, this.connectUserArn);
        }

        @Override
        public final Builder connectUserArn(String connectUserArn) {
            Object oldValue = this.connectUserArn;
            this.connectUserArn = connectUserArn;
            handleUnionValueChange(Type.CONNECT_USER_ARN, oldValue, this.connectUserArn);
            return this;
        }

        public final String getAwsIdentityArn() {
            return awsIdentityArn;
        }

        public final void setAwsIdentityArn(String awsIdentityArn) {
            Object oldValue = this.awsIdentityArn;
            this.awsIdentityArn = awsIdentityArn;
            handleUnionValueChange(Type.AWS_IDENTITY_ARN, oldValue, this.awsIdentityArn);
        }

        @Override
        public final Builder awsIdentityArn(String awsIdentityArn) {
            Object oldValue = this.awsIdentityArn;
            this.awsIdentityArn = awsIdentityArn;
            handleUnionValueChange(Type.AWS_IDENTITY_ARN, oldValue, this.awsIdentityArn);
            return this;
        }

        @Override
        public CreatedByInfo build() {
            return new CreatedByInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see CreatedByInfo#type()
     */
    public enum Type {
        CONNECT_USER_ARN,

        AWS_IDENTITY_ARN,

        UNKNOWN_TO_SDK_VERSION
    }
}
