/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object to define AgentsCriteria.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MatchCriteria implements SdkPojo, Serializable, ToCopyableBuilder<MatchCriteria.Builder, MatchCriteria> {
    private static final SdkField<AgentsCriteria> AGENTS_CRITERIA_FIELD = SdkField
            .<AgentsCriteria> builder(MarshallingType.SDK_POJO).memberName("AgentsCriteria")
            .getter(getter(MatchCriteria::agentsCriteria)).setter(setter(Builder::agentsCriteria))
            .constructor(AgentsCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentsCriteria").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENTS_CRITERIA_FIELD));

    private static final long serialVersionUID = 1L;

    private final AgentsCriteria agentsCriteria;

    private MatchCriteria(BuilderImpl builder) {
        this.agentsCriteria = builder.agentsCriteria;
    }

    /**
     * <p>
     * An object to define agentIds.
     * </p>
     * 
     * @return An object to define agentIds.
     */
    public final AgentsCriteria agentsCriteria() {
        return agentsCriteria;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(agentsCriteria());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MatchCriteria)) {
            return false;
        }
        MatchCriteria other = (MatchCriteria) obj;
        return Objects.equals(agentsCriteria(), other.agentsCriteria());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MatchCriteria").add("AgentsCriteria", agentsCriteria()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AgentsCriteria":
            return Optional.ofNullable(clazz.cast(agentsCriteria()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MatchCriteria, T> g) {
        return obj -> g.apply((MatchCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MatchCriteria> {
        /**
         * <p>
         * An object to define agentIds.
         * </p>
         * 
         * @param agentsCriteria
         *        An object to define agentIds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentsCriteria(AgentsCriteria agentsCriteria);

        /**
         * <p>
         * An object to define agentIds.
         * </p>
         * This is a convenience method that creates an instance of the {@link AgentsCriteria.Builder} avoiding the need
         * to create one manually via {@link AgentsCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AgentsCriteria.Builder#build()} is called immediately and its
         * result is passed to {@link #agentsCriteria(AgentsCriteria)}.
         * 
         * @param agentsCriteria
         *        a consumer that will call methods on {@link AgentsCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agentsCriteria(AgentsCriteria)
         */
        default Builder agentsCriteria(Consumer<AgentsCriteria.Builder> agentsCriteria) {
            return agentsCriteria(AgentsCriteria.builder().applyMutation(agentsCriteria).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AgentsCriteria agentsCriteria;

        private BuilderImpl() {
        }

        private BuilderImpl(MatchCriteria model) {
            agentsCriteria(model.agentsCriteria);
        }

        public final AgentsCriteria.Builder getAgentsCriteria() {
            return agentsCriteria != null ? agentsCriteria.toBuilder() : null;
        }

        public final void setAgentsCriteria(AgentsCriteria.BuilderImpl agentsCriteria) {
            this.agentsCriteria = agentsCriteria != null ? agentsCriteria.build() : null;
        }

        @Override
        public final Builder agentsCriteria(AgentsCriteria agentsCriteria) {
            this.agentsCriteria = agentsCriteria;
            return this;
        }

        @Override
        public MatchCriteria build() {
            return new MatchCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
