/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchUserHierarchyGroupsResponse extends ConnectResponse implements
        ToCopyableBuilder<SearchUserHierarchyGroupsResponse.Builder, SearchUserHierarchyGroupsResponse> {
    private static final SdkField<List<HierarchyGroup>> USER_HIERARCHY_GROUPS_FIELD = SdkField
            .<List<HierarchyGroup>> builder(MarshallingType.LIST)
            .memberName("UserHierarchyGroups")
            .getter(getter(SearchUserHierarchyGroupsResponse::userHierarchyGroups))
            .setter(setter(Builder::userHierarchyGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserHierarchyGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HierarchyGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(HierarchyGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(SearchUserHierarchyGroupsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Long> APPROXIMATE_TOTAL_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ApproximateTotalCount").getter(getter(SearchUserHierarchyGroupsResponse::approximateTotalCount))
            .setter(setter(Builder::approximateTotalCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproximateTotalCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_HIERARCHY_GROUPS_FIELD,
            NEXT_TOKEN_FIELD, APPROXIMATE_TOTAL_COUNT_FIELD));

    private final List<HierarchyGroup> userHierarchyGroups;

    private final String nextToken;

    private final Long approximateTotalCount;

    private SearchUserHierarchyGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.userHierarchyGroups = builder.userHierarchyGroups;
        this.nextToken = builder.nextToken;
        this.approximateTotalCount = builder.approximateTotalCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserHierarchyGroups property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserHierarchyGroups() {
        return userHierarchyGroups != null && !(userHierarchyGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the userHierarchyGroups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserHierarchyGroups} method.
     * </p>
     * 
     * @return Information about the userHierarchyGroups.
     */
    public final List<HierarchyGroup> userHierarchyGroups() {
        return userHierarchyGroups;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @return If there are additional results, this is the token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The total number of userHierarchyGroups which matched your search query.
     * </p>
     * 
     * @return The total number of userHierarchyGroups which matched your search query.
     */
    public final Long approximateTotalCount() {
        return approximateTotalCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasUserHierarchyGroups() ? userHierarchyGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(approximateTotalCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchUserHierarchyGroupsResponse)) {
            return false;
        }
        SearchUserHierarchyGroupsResponse other = (SearchUserHierarchyGroupsResponse) obj;
        return hasUserHierarchyGroups() == other.hasUserHierarchyGroups()
                && Objects.equals(userHierarchyGroups(), other.userHierarchyGroups())
                && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(approximateTotalCount(), other.approximateTotalCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchUserHierarchyGroupsResponse")
                .add("UserHierarchyGroups", hasUserHierarchyGroups() ? userHierarchyGroups() : null)
                .add("NextToken", nextToken()).add("ApproximateTotalCount", approximateTotalCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserHierarchyGroups":
            return Optional.ofNullable(clazz.cast(userHierarchyGroups()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ApproximateTotalCount":
            return Optional.ofNullable(clazz.cast(approximateTotalCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchUserHierarchyGroupsResponse, T> g) {
        return obj -> g.apply((SearchUserHierarchyGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, SearchUserHierarchyGroupsResponse> {
        /**
         * <p>
         * Information about the userHierarchyGroups.
         * </p>
         * 
         * @param userHierarchyGroups
         *        Information about the userHierarchyGroups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userHierarchyGroups(Collection<HierarchyGroup> userHierarchyGroups);

        /**
         * <p>
         * Information about the userHierarchyGroups.
         * </p>
         * 
         * @param userHierarchyGroups
         *        Information about the userHierarchyGroups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userHierarchyGroups(HierarchyGroup... userHierarchyGroups);

        /**
         * <p>
         * Information about the userHierarchyGroups.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.HierarchyGroup.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.connect.model.HierarchyGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.HierarchyGroup.Builder#build()} is called immediately
         * and its result is passed to {@link #userHierarchyGroups(List<HierarchyGroup>)}.
         * 
         * @param userHierarchyGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.HierarchyGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userHierarchyGroups(java.util.Collection<HierarchyGroup>)
         */
        Builder userHierarchyGroups(Consumer<HierarchyGroup.Builder>... userHierarchyGroups);

        /**
         * <p>
         * If there are additional results, this is the token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If there are additional results, this is the token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The total number of userHierarchyGroups which matched your search query.
         * </p>
         * 
         * @param approximateTotalCount
         *        The total number of userHierarchyGroups which matched your search query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approximateTotalCount(Long approximateTotalCount);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private List<HierarchyGroup> userHierarchyGroups = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Long approximateTotalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchUserHierarchyGroupsResponse model) {
            super(model);
            userHierarchyGroups(model.userHierarchyGroups);
            nextToken(model.nextToken);
            approximateTotalCount(model.approximateTotalCount);
        }

        public final List<HierarchyGroup.Builder> getUserHierarchyGroups() {
            List<HierarchyGroup.Builder> result = UserHierarchyGroupListCopier.copyToBuilder(this.userHierarchyGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserHierarchyGroups(Collection<HierarchyGroup.BuilderImpl> userHierarchyGroups) {
            this.userHierarchyGroups = UserHierarchyGroupListCopier.copyFromBuilder(userHierarchyGroups);
        }

        @Override
        public final Builder userHierarchyGroups(Collection<HierarchyGroup> userHierarchyGroups) {
            this.userHierarchyGroups = UserHierarchyGroupListCopier.copy(userHierarchyGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userHierarchyGroups(HierarchyGroup... userHierarchyGroups) {
            userHierarchyGroups(Arrays.asList(userHierarchyGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userHierarchyGroups(Consumer<HierarchyGroup.Builder>... userHierarchyGroups) {
            userHierarchyGroups(Stream.of(userHierarchyGroups).map(c -> HierarchyGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Long getApproximateTotalCount() {
            return approximateTotalCount;
        }

        public final void setApproximateTotalCount(Long approximateTotalCount) {
            this.approximateTotalCount = approximateTotalCount;
        }

        @Override
        public final Builder approximateTotalCount(Long approximateTotalCount) {
            this.approximateTotalCount = approximateTotalCount;
            return this;
        }

        @Override
        public SearchUserHierarchyGroupsResponse build() {
            return new SearchUserHierarchyGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
