/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the automation option based on a rule category for a single select question.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SingleSelectQuestionRuleCategoryAutomation implements SdkPojo, Serializable,
        ToCopyableBuilder<SingleSelectQuestionRuleCategoryAutomation.Builder, SingleSelectQuestionRuleCategoryAutomation> {
    private static final SdkField<String> CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Category").getter(getter(SingleSelectQuestionRuleCategoryAutomation::category))
            .setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()).build();

    private static final SdkField<String> CONDITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Condition").getter(getter(SingleSelectQuestionRuleCategoryAutomation::conditionAsString))
            .setter(setter(Builder::condition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Condition").build()).build();

    private static final SdkField<String> OPTION_REF_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptionRefId").getter(getter(SingleSelectQuestionRuleCategoryAutomation::optionRefId))
            .setter(setter(Builder::optionRefId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionRefId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_FIELD,
            CONDITION_FIELD, OPTION_REF_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String category;

    private final String condition;

    private final String optionRefId;

    private SingleSelectQuestionRuleCategoryAutomation(BuilderImpl builder) {
        this.category = builder.category;
        this.condition = builder.condition;
        this.optionRefId = builder.optionRefId;
    }

    /**
     * <p>
     * The category name, as defined in Rules.
     * </p>
     * 
     * @return The category name, as defined in Rules.
     */
    public final String category() {
        return category;
    }

    /**
     * <p>
     * The condition to apply for the automation option. If the condition is <code>PRESENT</code>, then the option is
     * applied when the contact data includes the category. Similarly, if the condition is <code>NOT_PRESENT</code>,
     * then the option is applied when the contact data does not include the category.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #condition} will
     * return {@link SingleSelectQuestionRuleCategoryAutomationCondition#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #conditionAsString}.
     * </p>
     * 
     * @return The condition to apply for the automation option. If the condition is <code>PRESENT</code>, then the
     *         option is applied when the contact data includes the category. Similarly, if the condition is
     *         <code>NOT_PRESENT</code>, then the option is applied when the contact data does not include the category.
     * @see SingleSelectQuestionRuleCategoryAutomationCondition
     */
    public final SingleSelectQuestionRuleCategoryAutomationCondition condition() {
        return SingleSelectQuestionRuleCategoryAutomationCondition.fromValue(condition);
    }

    /**
     * <p>
     * The condition to apply for the automation option. If the condition is <code>PRESENT</code>, then the option is
     * applied when the contact data includes the category. Similarly, if the condition is <code>NOT_PRESENT</code>,
     * then the option is applied when the contact data does not include the category.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #condition} will
     * return {@link SingleSelectQuestionRuleCategoryAutomationCondition#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #conditionAsString}.
     * </p>
     * 
     * @return The condition to apply for the automation option. If the condition is <code>PRESENT</code>, then the
     *         option is applied when the contact data includes the category. Similarly, if the condition is
     *         <code>NOT_PRESENT</code>, then the option is applied when the contact data does not include the category.
     * @see SingleSelectQuestionRuleCategoryAutomationCondition
     */
    public final String conditionAsString() {
        return condition;
    }

    /**
     * <p>
     * The identifier of the answer option.
     * </p>
     * 
     * @return The identifier of the answer option.
     */
    public final String optionRefId() {
        return optionRefId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(category());
        hashCode = 31 * hashCode + Objects.hashCode(conditionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(optionRefId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SingleSelectQuestionRuleCategoryAutomation)) {
            return false;
        }
        SingleSelectQuestionRuleCategoryAutomation other = (SingleSelectQuestionRuleCategoryAutomation) obj;
        return Objects.equals(category(), other.category()) && Objects.equals(conditionAsString(), other.conditionAsString())
                && Objects.equals(optionRefId(), other.optionRefId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SingleSelectQuestionRuleCategoryAutomation").add("Category", category())
                .add("Condition", conditionAsString()).add("OptionRefId", optionRefId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Category":
            return Optional.ofNullable(clazz.cast(category()));
        case "Condition":
            return Optional.ofNullable(clazz.cast(conditionAsString()));
        case "OptionRefId":
            return Optional.ofNullable(clazz.cast(optionRefId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SingleSelectQuestionRuleCategoryAutomation, T> g) {
        return obj -> g.apply((SingleSelectQuestionRuleCategoryAutomation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SingleSelectQuestionRuleCategoryAutomation> {
        /**
         * <p>
         * The category name, as defined in Rules.
         * </p>
         * 
         * @param category
         *        The category name, as defined in Rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder category(String category);

        /**
         * <p>
         * The condition to apply for the automation option. If the condition is <code>PRESENT</code>, then the option
         * is applied when the contact data includes the category. Similarly, if the condition is
         * <code>NOT_PRESENT</code>, then the option is applied when the contact data does not include the category.
         * </p>
         * 
         * @param condition
         *        The condition to apply for the automation option. If the condition is <code>PRESENT</code>, then the
         *        option is applied when the contact data includes the category. Similarly, if the condition is
         *        <code>NOT_PRESENT</code>, then the option is applied when the contact data does not include the
         *        category.
         * @see SingleSelectQuestionRuleCategoryAutomationCondition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SingleSelectQuestionRuleCategoryAutomationCondition
         */
        Builder condition(String condition);

        /**
         * <p>
         * The condition to apply for the automation option. If the condition is <code>PRESENT</code>, then the option
         * is applied when the contact data includes the category. Similarly, if the condition is
         * <code>NOT_PRESENT</code>, then the option is applied when the contact data does not include the category.
         * </p>
         * 
         * @param condition
         *        The condition to apply for the automation option. If the condition is <code>PRESENT</code>, then the
         *        option is applied when the contact data includes the category. Similarly, if the condition is
         *        <code>NOT_PRESENT</code>, then the option is applied when the contact data does not include the
         *        category.
         * @see SingleSelectQuestionRuleCategoryAutomationCondition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SingleSelectQuestionRuleCategoryAutomationCondition
         */
        Builder condition(SingleSelectQuestionRuleCategoryAutomationCondition condition);

        /**
         * <p>
         * The identifier of the answer option.
         * </p>
         * 
         * @param optionRefId
         *        The identifier of the answer option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionRefId(String optionRefId);
    }

    static final class BuilderImpl implements Builder {
        private String category;

        private String condition;

        private String optionRefId;

        private BuilderImpl() {
        }

        private BuilderImpl(SingleSelectQuestionRuleCategoryAutomation model) {
            category(model.category);
            condition(model.condition);
            optionRefId(model.optionRefId);
        }

        public final String getCategory() {
            return category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public final String getCondition() {
            return condition;
        }

        public final void setCondition(String condition) {
            this.condition = condition;
        }

        @Override
        public final Builder condition(String condition) {
            this.condition = condition;
            return this;
        }

        @Override
        public final Builder condition(SingleSelectQuestionRuleCategoryAutomationCondition condition) {
            this.condition(condition == null ? null : condition.toString());
            return this;
        }

        public final String getOptionRefId() {
            return optionRefId;
        }

        public final void setOptionRefId(String optionRefId) {
            this.optionRefId = optionRefId;
        }

        @Override
        public final Builder optionRefId(String optionRefId) {
            this.optionRefId = optionRefId;
            return this;
        }

        @Override
        public SingleSelectQuestionRuleCategoryAutomation build() {
            return new SingleSelectQuestionRuleCategoryAutomation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
