/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.InstanceStorageConfig;
import software.amazon.awssdk.services.connect.model.ListInstanceStorageConfigsRequest;
import software.amazon.awssdk.services.connect.model.ListInstanceStorageConfigsResponse;

public class ListInstanceStorageConfigsIterable
implements SdkIterable<ListInstanceStorageConfigsResponse> {
    private final ConnectClient client;
    private final ListInstanceStorageConfigsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListInstanceStorageConfigsIterable(ConnectClient client, ListInstanceStorageConfigsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListInstanceStorageConfigsResponseFetcher();
    }

    public Iterator<ListInstanceStorageConfigsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<InstanceStorageConfig> storageConfigs() {
        Function<ListInstanceStorageConfigsResponse, Iterator> getIterator = response -> {
            if (response != null && response.storageConfigs() != null) {
                return response.storageConfigs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListInstanceStorageConfigsResponseFetcher
    implements SyncPageFetcher<ListInstanceStorageConfigsResponse> {
        private ListInstanceStorageConfigsResponseFetcher() {
        }

        public boolean hasNextPage(ListInstanceStorageConfigsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListInstanceStorageConfigsResponse nextPage(ListInstanceStorageConfigsResponse previousPage) {
            if (previousPage == null) {
                return ListInstanceStorageConfigsIterable.this.client.listInstanceStorageConfigs(ListInstanceStorageConfigsIterable.this.firstRequest);
            }
            return ListInstanceStorageConfigsIterable.this.client.listInstanceStorageConfigs((ListInstanceStorageConfigsRequest)((Object)ListInstanceStorageConfigsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

