/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the agent who accepted the contact.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AgentInfo implements SdkPojo, Serializable, ToCopyableBuilder<AgentInfo.Builder, AgentInfo> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(AgentInfo::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<Instant> CONNECTED_TO_AGENT_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).memberName("ConnectedToAgentTimestamp")
            .getter(getter(AgentInfo::connectedToAgentTimestamp)).setter(setter(Builder::connectedToAgentTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectedToAgentTimestamp").build())
            .build();

    private static final SdkField<Integer> AGENT_PAUSE_DURATION_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("AgentPauseDurationInSeconds")
            .getter(getter(AgentInfo::agentPauseDurationInSeconds))
            .setter(setter(Builder::agentPauseDurationInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentPauseDurationInSeconds")
                    .build()).build();

    private static final SdkField<HierarchyGroups> HIERARCHY_GROUPS_FIELD = SdkField
            .<HierarchyGroups> builder(MarshallingType.SDK_POJO).memberName("HierarchyGroups")
            .getter(getter(AgentInfo::hierarchyGroups)).setter(setter(Builder::hierarchyGroups))
            .constructor(HierarchyGroups::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HierarchyGroups").build()).build();

    private static final SdkField<DeviceInfo> DEVICE_INFO_FIELD = SdkField.<DeviceInfo> builder(MarshallingType.SDK_POJO)
            .memberName("DeviceInfo").getter(getter(AgentInfo::deviceInfo)).setter(setter(Builder::deviceInfo))
            .constructor(DeviceInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceInfo").build()).build();

    private static final SdkField<ParticipantCapabilities> CAPABILITIES_FIELD = SdkField
            .<ParticipantCapabilities> builder(MarshallingType.SDK_POJO).memberName("Capabilities")
            .getter(getter(AgentInfo::capabilities)).setter(setter(Builder::capabilities))
            .constructor(ParticipantCapabilities::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capabilities").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            CONNECTED_TO_AGENT_TIMESTAMP_FIELD, AGENT_PAUSE_DURATION_IN_SECONDS_FIELD, HIERARCHY_GROUPS_FIELD, DEVICE_INFO_FIELD,
            CAPABILITIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final Instant connectedToAgentTimestamp;

    private final Integer agentPauseDurationInSeconds;

    private final HierarchyGroups hierarchyGroups;

    private final DeviceInfo deviceInfo;

    private final ParticipantCapabilities capabilities;

    private AgentInfo(BuilderImpl builder) {
        this.id = builder.id;
        this.connectedToAgentTimestamp = builder.connectedToAgentTimestamp;
        this.agentPauseDurationInSeconds = builder.agentPauseDurationInSeconds;
        this.hierarchyGroups = builder.hierarchyGroups;
        this.deviceInfo = builder.deviceInfo;
        this.capabilities = builder.capabilities;
    }

    /**
     * <p>
     * The identifier of the agent who accepted the contact.
     * </p>
     * 
     * @return The identifier of the agent who accepted the contact.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The timestamp when the contact was connected to the agent.
     * </p>
     * 
     * @return The timestamp when the contact was connected to the agent.
     */
    public final Instant connectedToAgentTimestamp() {
        return connectedToAgentTimestamp;
    }

    /**
     * <p>
     * Agent pause duration for a contact in seconds.
     * </p>
     * 
     * @return Agent pause duration for a contact in seconds.
     */
    public final Integer agentPauseDurationInSeconds() {
        return agentPauseDurationInSeconds;
    }

    /**
     * <p>
     * The agent hierarchy groups for the agent.
     * </p>
     * 
     * @return The agent hierarchy groups for the agent.
     */
    public final HierarchyGroups hierarchyGroups() {
        return hierarchyGroups;
    }

    /**
     * <p>
     * Information regarding Agent’s device.
     * </p>
     * 
     * @return Information regarding Agent’s device.
     */
    public final DeviceInfo deviceInfo() {
        return deviceInfo;
    }

    /**
     * Returns the value of the Capabilities property for this object.
     * 
     * @return The value of the Capabilities property for this object.
     */
    public final ParticipantCapabilities capabilities() {
        return capabilities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(connectedToAgentTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(agentPauseDurationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(hierarchyGroups());
        hashCode = 31 * hashCode + Objects.hashCode(deviceInfo());
        hashCode = 31 * hashCode + Objects.hashCode(capabilities());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentInfo)) {
            return false;
        }
        AgentInfo other = (AgentInfo) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(connectedToAgentTimestamp(), other.connectedToAgentTimestamp())
                && Objects.equals(agentPauseDurationInSeconds(), other.agentPauseDurationInSeconds())
                && Objects.equals(hierarchyGroups(), other.hierarchyGroups()) && Objects.equals(deviceInfo(), other.deviceInfo())
                && Objects.equals(capabilities(), other.capabilities());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AgentInfo").add("Id", id()).add("ConnectedToAgentTimestamp", connectedToAgentTimestamp())
                .add("AgentPauseDurationInSeconds", agentPauseDurationInSeconds()).add("HierarchyGroups", hierarchyGroups())
                .add("DeviceInfo", deviceInfo()).add("Capabilities", capabilities()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "ConnectedToAgentTimestamp":
            return Optional.ofNullable(clazz.cast(connectedToAgentTimestamp()));
        case "AgentPauseDurationInSeconds":
            return Optional.ofNullable(clazz.cast(agentPauseDurationInSeconds()));
        case "HierarchyGroups":
            return Optional.ofNullable(clazz.cast(hierarchyGroups()));
        case "DeviceInfo":
            return Optional.ofNullable(clazz.cast(deviceInfo()));
        case "Capabilities":
            return Optional.ofNullable(clazz.cast(capabilities()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AgentInfo, T> g) {
        return obj -> g.apply((AgentInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AgentInfo> {
        /**
         * <p>
         * The identifier of the agent who accepted the contact.
         * </p>
         * 
         * @param id
         *        The identifier of the agent who accepted the contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The timestamp when the contact was connected to the agent.
         * </p>
         * 
         * @param connectedToAgentTimestamp
         *        The timestamp when the contact was connected to the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectedToAgentTimestamp(Instant connectedToAgentTimestamp);

        /**
         * <p>
         * Agent pause duration for a contact in seconds.
         * </p>
         * 
         * @param agentPauseDurationInSeconds
         *        Agent pause duration for a contact in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentPauseDurationInSeconds(Integer agentPauseDurationInSeconds);

        /**
         * <p>
         * The agent hierarchy groups for the agent.
         * </p>
         * 
         * @param hierarchyGroups
         *        The agent hierarchy groups for the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hierarchyGroups(HierarchyGroups hierarchyGroups);

        /**
         * <p>
         * The agent hierarchy groups for the agent.
         * </p>
         * This is a convenience method that creates an instance of the {@link HierarchyGroups.Builder} avoiding the
         * need to create one manually via {@link HierarchyGroups#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HierarchyGroups.Builder#build()} is called immediately and its
         * result is passed to {@link #hierarchyGroups(HierarchyGroups)}.
         * 
         * @param hierarchyGroups
         *        a consumer that will call methods on {@link HierarchyGroups.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hierarchyGroups(HierarchyGroups)
         */
        default Builder hierarchyGroups(Consumer<HierarchyGroups.Builder> hierarchyGroups) {
            return hierarchyGroups(HierarchyGroups.builder().applyMutation(hierarchyGroups).build());
        }

        /**
         * <p>
         * Information regarding Agent’s device.
         * </p>
         * 
         * @param deviceInfo
         *        Information regarding Agent’s device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceInfo(DeviceInfo deviceInfo);

        /**
         * <p>
         * Information regarding Agent’s device.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeviceInfo.Builder} avoiding the need to
         * create one manually via {@link DeviceInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeviceInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #deviceInfo(DeviceInfo)}.
         * 
         * @param deviceInfo
         *        a consumer that will call methods on {@link DeviceInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceInfo(DeviceInfo)
         */
        default Builder deviceInfo(Consumer<DeviceInfo.Builder> deviceInfo) {
            return deviceInfo(DeviceInfo.builder().applyMutation(deviceInfo).build());
        }

        /**
         * Sets the value of the Capabilities property for this object.
         *
         * @param capabilities
         *        The new value for the Capabilities property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(ParticipantCapabilities capabilities);

        /**
         * Sets the value of the Capabilities property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ParticipantCapabilities.Builder} avoiding
         * the need to create one manually via {@link ParticipantCapabilities#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParticipantCapabilities.Builder#build()} is called immediately
         * and its result is passed to {@link #capabilities(ParticipantCapabilities)}.
         * 
         * @param capabilities
         *        a consumer that will call methods on {@link ParticipantCapabilities.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capabilities(ParticipantCapabilities)
         */
        default Builder capabilities(Consumer<ParticipantCapabilities.Builder> capabilities) {
            return capabilities(ParticipantCapabilities.builder().applyMutation(capabilities).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private Instant connectedToAgentTimestamp;

        private Integer agentPauseDurationInSeconds;

        private HierarchyGroups hierarchyGroups;

        private DeviceInfo deviceInfo;

        private ParticipantCapabilities capabilities;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentInfo model) {
            id(model.id);
            connectedToAgentTimestamp(model.connectedToAgentTimestamp);
            agentPauseDurationInSeconds(model.agentPauseDurationInSeconds);
            hierarchyGroups(model.hierarchyGroups);
            deviceInfo(model.deviceInfo);
            capabilities(model.capabilities);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getConnectedToAgentTimestamp() {
            return connectedToAgentTimestamp;
        }

        public final void setConnectedToAgentTimestamp(Instant connectedToAgentTimestamp) {
            this.connectedToAgentTimestamp = connectedToAgentTimestamp;
        }

        @Override
        public final Builder connectedToAgentTimestamp(Instant connectedToAgentTimestamp) {
            this.connectedToAgentTimestamp = connectedToAgentTimestamp;
            return this;
        }

        public final Integer getAgentPauseDurationInSeconds() {
            return agentPauseDurationInSeconds;
        }

        public final void setAgentPauseDurationInSeconds(Integer agentPauseDurationInSeconds) {
            this.agentPauseDurationInSeconds = agentPauseDurationInSeconds;
        }

        @Override
        public final Builder agentPauseDurationInSeconds(Integer agentPauseDurationInSeconds) {
            this.agentPauseDurationInSeconds = agentPauseDurationInSeconds;
            return this;
        }

        public final HierarchyGroups.Builder getHierarchyGroups() {
            return hierarchyGroups != null ? hierarchyGroups.toBuilder() : null;
        }

        public final void setHierarchyGroups(HierarchyGroups.BuilderImpl hierarchyGroups) {
            this.hierarchyGroups = hierarchyGroups != null ? hierarchyGroups.build() : null;
        }

        @Override
        public final Builder hierarchyGroups(HierarchyGroups hierarchyGroups) {
            this.hierarchyGroups = hierarchyGroups;
            return this;
        }

        public final DeviceInfo.Builder getDeviceInfo() {
            return deviceInfo != null ? deviceInfo.toBuilder() : null;
        }

        public final void setDeviceInfo(DeviceInfo.BuilderImpl deviceInfo) {
            this.deviceInfo = deviceInfo != null ? deviceInfo.build() : null;
        }

        @Override
        public final Builder deviceInfo(DeviceInfo deviceInfo) {
            this.deviceInfo = deviceInfo;
            return this;
        }

        public final ParticipantCapabilities.Builder getCapabilities() {
            return capabilities != null ? capabilities.toBuilder() : null;
        }

        public final void setCapabilities(ParticipantCapabilities.BuilderImpl capabilities) {
            this.capabilities = capabilities != null ? capabilities.build() : null;
        }

        @Override
        public final Builder capabilities(ParticipantCapabilities capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        @Override
        public AgentInfo build() {
            return new AgentInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
