/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Status information about the replication process, where you use the <a
 * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_ReplicateInstance.html">ReplicateInstance</a> API
 * to create a replica of your Amazon Connect instance in another Amazon Web Services Region. For more information, see
 * <a href="https://docs.aws.amazon.com/connect/latest/adminguide/setup-connect-global-resiliency.html">Set up Amazon
 * Connect Global Resiliency</a> in the <i>Amazon Connect Administrator Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicationStatusSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ReplicationStatusSummary.Builder, ReplicationStatusSummary> {
    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Region")
            .getter(getter(ReplicationStatusSummary::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<String> REPLICATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationStatus").getter(getter(ReplicationStatusSummary::replicationStatusAsString))
            .setter(setter(Builder::replicationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationStatus").build()).build();

    private static final SdkField<String> REPLICATION_STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationStatusReason").getter(getter(ReplicationStatusSummary::replicationStatusReason))
            .setter(setter(Builder::replicationStatusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationStatusReason").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_FIELD,
            REPLICATION_STATUS_FIELD, REPLICATION_STATUS_REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String region;

    private final String replicationStatus;

    private final String replicationStatusReason;

    private ReplicationStatusSummary(BuilderImpl builder) {
        this.region = builder.region;
        this.replicationStatus = builder.replicationStatus;
        this.replicationStatusReason = builder.replicationStatusReason;
    }

    /**
     * <p>
     * The Amazon Web Services Region. This can be either the source or the replica Region, depending where it appears
     * in the summary list.
     * </p>
     * 
     * @return The Amazon Web Services Region. This can be either the source or the replica Region, depending where it
     *         appears in the summary list.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * The state of the replication.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replicationStatus}
     * will return {@link InstanceReplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #replicationStatusAsString}.
     * </p>
     * 
     * @return The state of the replication.
     * @see InstanceReplicationStatus
     */
    public final InstanceReplicationStatus replicationStatus() {
        return InstanceReplicationStatus.fromValue(replicationStatus);
    }

    /**
     * <p>
     * The state of the replication.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replicationStatus}
     * will return {@link InstanceReplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #replicationStatusAsString}.
     * </p>
     * 
     * @return The state of the replication.
     * @see InstanceReplicationStatus
     */
    public final String replicationStatusAsString() {
        return replicationStatus;
    }

    /**
     * <p>
     * A description of the replication status. Use this information to resolve any issues that are preventing the
     * successful replication of your Amazon Connect instance to another Region.
     * </p>
     * 
     * @return A description of the replication status. Use this information to resolve any issues that are preventing
     *         the successful replication of your Amazon Connect instance to another Region.
     */
    public final String replicationStatusReason() {
        return replicationStatusReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(replicationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(replicationStatusReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationStatusSummary)) {
            return false;
        }
        ReplicationStatusSummary other = (ReplicationStatusSummary) obj;
        return Objects.equals(region(), other.region())
                && Objects.equals(replicationStatusAsString(), other.replicationStatusAsString())
                && Objects.equals(replicationStatusReason(), other.replicationStatusReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplicationStatusSummary").add("Region", region())
                .add("ReplicationStatus", replicationStatusAsString()).add("ReplicationStatusReason", replicationStatusReason())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "ReplicationStatus":
            return Optional.ofNullable(clazz.cast(replicationStatusAsString()));
        case "ReplicationStatusReason":
            return Optional.ofNullable(clazz.cast(replicationStatusReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicationStatusSummary, T> g) {
        return obj -> g.apply((ReplicationStatusSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicationStatusSummary> {
        /**
         * <p>
         * The Amazon Web Services Region. This can be either the source or the replica Region, depending where it
         * appears in the summary list.
         * </p>
         * 
         * @param region
         *        The Amazon Web Services Region. This can be either the source or the replica Region, depending where
         *        it appears in the summary list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The state of the replication.
         * </p>
         * 
         * @param replicationStatus
         *        The state of the replication.
         * @see InstanceReplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceReplicationStatus
         */
        Builder replicationStatus(String replicationStatus);

        /**
         * <p>
         * The state of the replication.
         * </p>
         * 
         * @param replicationStatus
         *        The state of the replication.
         * @see InstanceReplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceReplicationStatus
         */
        Builder replicationStatus(InstanceReplicationStatus replicationStatus);

        /**
         * <p>
         * A description of the replication status. Use this information to resolve any issues that are preventing the
         * successful replication of your Amazon Connect instance to another Region.
         * </p>
         * 
         * @param replicationStatusReason
         *        A description of the replication status. Use this information to resolve any issues that are
         *        preventing the successful replication of your Amazon Connect instance to another Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationStatusReason(String replicationStatusReason);
    }

    static final class BuilderImpl implements Builder {
        private String region;

        private String replicationStatus;

        private String replicationStatusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationStatusSummary model) {
            region(model.region);
            replicationStatus(model.replicationStatus);
            replicationStatusReason(model.replicationStatusReason);
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getReplicationStatus() {
            return replicationStatus;
        }

        public final void setReplicationStatus(String replicationStatus) {
            this.replicationStatus = replicationStatus;
        }

        @Override
        public final Builder replicationStatus(String replicationStatus) {
            this.replicationStatus = replicationStatus;
            return this;
        }

        @Override
        public final Builder replicationStatus(InstanceReplicationStatus replicationStatus) {
            this.replicationStatus(replicationStatus == null ? null : replicationStatus.toString());
            return this;
        }

        public final String getReplicationStatusReason() {
            return replicationStatusReason;
        }

        public final void setReplicationStatusReason(String replicationStatusReason) {
            this.replicationStatusReason = replicationStatusReason;
        }

        @Override
        public final Builder replicationStatusReason(String replicationStatusReason) {
            this.replicationStatusReason = replicationStatusReason;
            return this;
        }

        @Override
        public ReplicationStatusSummary build() {
            return new ReplicationStatusSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
