/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Step defines the list of agents to be routed or route based on the agent requirements such as ProficiencyLevel, Name,
 * or Value.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RoutingCriteriaInputStep implements SdkPojo, Serializable,
        ToCopyableBuilder<RoutingCriteriaInputStep.Builder, RoutingCriteriaInputStep> {
    private static final SdkField<RoutingCriteriaInputStepExpiry> EXPIRY_FIELD = SdkField
            .<RoutingCriteriaInputStepExpiry> builder(MarshallingType.SDK_POJO).memberName("Expiry")
            .getter(getter(RoutingCriteriaInputStep::expiry)).setter(setter(Builder::expiry))
            .constructor(RoutingCriteriaInputStepExpiry::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expiry").build()).build();

    private static final SdkField<Expression> EXPRESSION_FIELD = SdkField.<Expression> builder(MarshallingType.SDK_POJO)
            .memberName("Expression").getter(getter(RoutingCriteriaInputStep::expression)).setter(setter(Builder::expression))
            .constructor(Expression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expression").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(EXPIRY_FIELD, EXPRESSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final RoutingCriteriaInputStepExpiry expiry;

    private final Expression expression;

    private RoutingCriteriaInputStep(BuilderImpl builder) {
        this.expiry = builder.expiry;
        this.expression = builder.expression;
    }

    /**
     * <p>
     * An object to specify the expiration of a routing step.
     * </p>
     * 
     * @return An object to specify the expiration of a routing step.
     */
    public final RoutingCriteriaInputStepExpiry expiry() {
        return expiry;
    }

    /**
     * <p>
     * A tagged union to specify expression for a routing step.
     * </p>
     * 
     * @return A tagged union to specify expression for a routing step.
     */
    public final Expression expression() {
        return expression;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(expiry());
        hashCode = 31 * hashCode + Objects.hashCode(expression());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoutingCriteriaInputStep)) {
            return false;
        }
        RoutingCriteriaInputStep other = (RoutingCriteriaInputStep) obj;
        return Objects.equals(expiry(), other.expiry()) && Objects.equals(expression(), other.expression());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RoutingCriteriaInputStep").add("Expiry", expiry()).add("Expression", expression()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Expiry":
            return Optional.ofNullable(clazz.cast(expiry()));
        case "Expression":
            return Optional.ofNullable(clazz.cast(expression()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RoutingCriteriaInputStep, T> g) {
        return obj -> g.apply((RoutingCriteriaInputStep) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RoutingCriteriaInputStep> {
        /**
         * <p>
         * An object to specify the expiration of a routing step.
         * </p>
         * 
         * @param expiry
         *        An object to specify the expiration of a routing step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiry(RoutingCriteriaInputStepExpiry expiry);

        /**
         * <p>
         * An object to specify the expiration of a routing step.
         * </p>
         * This is a convenience method that creates an instance of the {@link RoutingCriteriaInputStepExpiry.Builder}
         * avoiding the need to create one manually via {@link RoutingCriteriaInputStepExpiry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RoutingCriteriaInputStepExpiry.Builder#build()} is called
         * immediately and its result is passed to {@link #expiry(RoutingCriteriaInputStepExpiry)}.
         * 
         * @param expiry
         *        a consumer that will call methods on {@link RoutingCriteriaInputStepExpiry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #expiry(RoutingCriteriaInputStepExpiry)
         */
        default Builder expiry(Consumer<RoutingCriteriaInputStepExpiry.Builder> expiry) {
            return expiry(RoutingCriteriaInputStepExpiry.builder().applyMutation(expiry).build());
        }

        /**
         * <p>
         * A tagged union to specify expression for a routing step.
         * </p>
         * 
         * @param expression
         *        A tagged union to specify expression for a routing step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expression(Expression expression);

        /**
         * <p>
         * A tagged union to specify expression for a routing step.
         * </p>
         * This is a convenience method that creates an instance of the {@link Expression.Builder} avoiding the need to
         * create one manually via {@link Expression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Expression.Builder#build()} is called immediately and its result
         * is passed to {@link #expression(Expression)}.
         * 
         * @param expression
         *        a consumer that will call methods on {@link Expression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #expression(Expression)
         */
        default Builder expression(Consumer<Expression.Builder> expression) {
            return expression(Expression.builder().applyMutation(expression).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RoutingCriteriaInputStepExpiry expiry;

        private Expression expression;

        private BuilderImpl() {
        }

        private BuilderImpl(RoutingCriteriaInputStep model) {
            expiry(model.expiry);
            expression(model.expression);
        }

        public final RoutingCriteriaInputStepExpiry.Builder getExpiry() {
            return expiry != null ? expiry.toBuilder() : null;
        }

        public final void setExpiry(RoutingCriteriaInputStepExpiry.BuilderImpl expiry) {
            this.expiry = expiry != null ? expiry.build() : null;
        }

        @Override
        public final Builder expiry(RoutingCriteriaInputStepExpiry expiry) {
            this.expiry = expiry;
            return this;
        }

        public final Expression.Builder getExpression() {
            return expression != null ? expression.toBuilder() : null;
        }

        public final void setExpression(Expression.BuilderImpl expression) {
            this.expression = expression != null ? expression.build() : null;
        }

        @Override
        public final Builder expression(Expression expression) {
            this.expression = expression;
            return this;
        }

        @Override
        public RoutingCriteriaInputStep build() {
            return new RoutingCriteriaInputStep(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
