/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartOutboundChatContactRequest extends ConnectRequest implements
        ToCopyableBuilder<StartOutboundChatContactRequest.Builder, StartOutboundChatContactRequest> {
    private static final SdkField<Endpoint> SOURCE_ENDPOINT_FIELD = SdkField.<Endpoint> builder(MarshallingType.SDK_POJO)
            .memberName("SourceEndpoint").getter(getter(StartOutboundChatContactRequest::sourceEndpoint))
            .setter(setter(Builder::sourceEndpoint)).constructor(Endpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceEndpoint").build()).build();

    private static final SdkField<Endpoint> DESTINATION_ENDPOINT_FIELD = SdkField.<Endpoint> builder(MarshallingType.SDK_POJO)
            .memberName("DestinationEndpoint").getter(getter(StartOutboundChatContactRequest::destinationEndpoint))
            .setter(setter(Builder::destinationEndpoint)).constructor(Endpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationEndpoint").build())
            .build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(StartOutboundChatContactRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<Map<String, SegmentAttributeValue>> SEGMENT_ATTRIBUTES_FIELD = SdkField
            .<Map<String, SegmentAttributeValue>> builder(MarshallingType.MAP)
            .memberName("SegmentAttributes")
            .getter(getter(StartOutboundChatContactRequest::segmentAttributes))
            .setter(setter(Builder::segmentAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<SegmentAttributeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(SegmentAttributeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Attributes")
            .getter(getter(StartOutboundChatContactRequest::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CONTACT_FLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactFlowId").getter(getter(StartOutboundChatContactRequest::contactFlowId))
            .setter(setter(Builder::contactFlowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactFlowId").build()).build();

    private static final SdkField<Integer> CHAT_DURATION_IN_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ChatDurationInMinutes").getter(getter(StartOutboundChatContactRequest::chatDurationInMinutes))
            .setter(setter(Builder::chatDurationInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChatDurationInMinutes").build())
            .build();

    private static final SdkField<ParticipantDetails> PARTICIPANT_DETAILS_FIELD = SdkField
            .<ParticipantDetails> builder(MarshallingType.SDK_POJO).memberName("ParticipantDetails")
            .getter(getter(StartOutboundChatContactRequest::participantDetails)).setter(setter(Builder::participantDetails))
            .constructor(ParticipantDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantDetails").build())
            .build();

    private static final SdkField<ChatMessage> INITIAL_SYSTEM_MESSAGE_FIELD = SdkField
            .<ChatMessage> builder(MarshallingType.SDK_POJO).memberName("InitialSystemMessage")
            .getter(getter(StartOutboundChatContactRequest::initialSystemMessage)).setter(setter(Builder::initialSystemMessage))
            .constructor(ChatMessage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitialSystemMessage").build())
            .build();

    private static final SdkField<String> RELATED_CONTACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RelatedContactId").getter(getter(StartOutboundChatContactRequest::relatedContactId))
            .setter(setter(Builder::relatedContactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedContactId").build()).build();

    private static final SdkField<List<String>> SUPPORTED_MESSAGING_CONTENT_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SupportedMessagingContentTypes")
            .getter(getter(StartOutboundChatContactRequest::supportedMessagingContentTypes))
            .setter(setter(Builder::supportedMessagingContentTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedMessagingContentTypes")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(StartOutboundChatContactRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_ENDPOINT_FIELD,
            DESTINATION_ENDPOINT_FIELD, INSTANCE_ID_FIELD, SEGMENT_ATTRIBUTES_FIELD, ATTRIBUTES_FIELD, CONTACT_FLOW_ID_FIELD,
            CHAT_DURATION_IN_MINUTES_FIELD, PARTICIPANT_DETAILS_FIELD, INITIAL_SYSTEM_MESSAGE_FIELD, RELATED_CONTACT_ID_FIELD,
            SUPPORTED_MESSAGING_CONTENT_TYPES_FIELD, CLIENT_TOKEN_FIELD));

    private final Endpoint sourceEndpoint;

    private final Endpoint destinationEndpoint;

    private final String instanceId;

    private final Map<String, SegmentAttributeValue> segmentAttributes;

    private final Map<String, String> attributes;

    private final String contactFlowId;

    private final Integer chatDurationInMinutes;

    private final ParticipantDetails participantDetails;

    private final ChatMessage initialSystemMessage;

    private final String relatedContactId;

    private final List<String> supportedMessagingContentTypes;

    private final String clientToken;

    private StartOutboundChatContactRequest(BuilderImpl builder) {
        super(builder);
        this.sourceEndpoint = builder.sourceEndpoint;
        this.destinationEndpoint = builder.destinationEndpoint;
        this.instanceId = builder.instanceId;
        this.segmentAttributes = builder.segmentAttributes;
        this.attributes = builder.attributes;
        this.contactFlowId = builder.contactFlowId;
        this.chatDurationInMinutes = builder.chatDurationInMinutes;
        this.participantDetails = builder.participantDetails;
        this.initialSystemMessage = builder.initialSystemMessage;
        this.relatedContactId = builder.relatedContactId;
        this.supportedMessagingContentTypes = builder.supportedMessagingContentTypes;
        this.clientToken = builder.clientToken;
    }

    /**
     * Returns the value of the SourceEndpoint property for this object.
     * 
     * @return The value of the SourceEndpoint property for this object.
     */
    public final Endpoint sourceEndpoint() {
        return sourceEndpoint;
    }

    /**
     * Returns the value of the DestinationEndpoint property for this object.
     * 
     * @return The value of the DestinationEndpoint property for this object.
     */
    public final Endpoint destinationEndpoint() {
        return destinationEndpoint;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can find the instance ID in the Amazon Resource Name (ARN) of
     * the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can find the instance ID in the Amazon Resource Name
     *         (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SegmentAttributes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSegmentAttributes() {
        return segmentAttributes != null && !(segmentAttributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A set of system defined key-value pairs stored on individual contact segments using an attribute map. The
     * attributes are standard Amazon Connect attributes. They can be accessed in flows.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Attribute keys can include only alphanumeric, <code>-</code>, and <code>_</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * This field can be used to show channel subtype, such as <code>connect:Guide</code> and <code>connect:SMS</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSegmentAttributes} method.
     * </p>
     * 
     * @return A set of system defined key-value pairs stored on individual contact segments using an attribute map. The
     *         attributes are standard Amazon Connect attributes. They can be accessed in flows.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Attribute keys can include only alphanumeric, <code>-</code>, and <code>_</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         This field can be used to show channel subtype, such as <code>connect:Guide</code> and
     *         <code>connect:SMS</code>.
     *         </p>
     *         </li>
     */
    public final Map<String, SegmentAttributeValue> segmentAttributes() {
        return segmentAttributes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes, and can be
     * accessed in flows just like any other contact attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes,
     *         and can be accessed in flows just like any other contact attributes.
     */
    public final Map<String, String> attributes() {
        return attributes;
    }

    /**
     * <p>
     * The identifier of the flow for the call. To see the ContactFlowId in the Amazon Connect console user interface,
     * on the navigation menu go to <b>Routing, Contact Flows</b>. Choose the flow. On the flow page, under the name of
     * the flow, choose <b>Show additional flow information</b>. The ContactFlowId is the last part of the ARN, shown
     * here in bold:
     * </p>
     * <ul>
     * <li>
     * <p>
     * arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>
     * 123ec456-a007-89c0-1234-xxxxxxxxxxxx</b>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The identifier of the flow for the call. To see the ContactFlowId in the Amazon Connect console user
     *         interface, on the navigation menu go to <b>Routing, Contact Flows</b>. Choose the flow. On the flow page,
     *         under the name of the flow, choose <b>Show additional flow information</b>. The ContactFlowId is the last
     *         part of the ARN, shown here in bold:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>
     *         123ec456-a007-89c0-1234-xxxxxxxxxxxx</b>
     *         </p>
     *         </li>
     */
    public final String contactFlowId() {
        return contactFlowId;
    }

    /**
     * <p>
     * The total duration of the newly started chat session. If not specified, the chat session duration defaults to 25
     * hour. The minimum configurable time is 60 minutes. The maximum configurable time is 10,080 minutes (7 days).
     * </p>
     * 
     * @return The total duration of the newly started chat session. If not specified, the chat session duration
     *         defaults to 25 hour. The minimum configurable time is 60 minutes. The maximum configurable time is 10,080
     *         minutes (7 days).
     */
    public final Integer chatDurationInMinutes() {
        return chatDurationInMinutes;
    }

    /**
     * Returns the value of the ParticipantDetails property for this object.
     * 
     * @return The value of the ParticipantDetails property for this object.
     */
    public final ParticipantDetails participantDetails() {
        return participantDetails;
    }

    /**
     * Returns the value of the InitialSystemMessage property for this object.
     * 
     * @return The value of the InitialSystemMessage property for this object.
     */
    public final ChatMessage initialSystemMessage() {
        return initialSystemMessage;
    }

    /**
     * <p>
     * The unique identifier for an Amazon Connect contact. This identifier is related to the contact starting.
     * </p>
     * 
     * @return The unique identifier for an Amazon Connect contact. This identifier is related to the contact starting.
     */
    public final String relatedContactId() {
        return relatedContactId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedMessagingContentTypes property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSupportedMessagingContentTypes() {
        return supportedMessagingContentTypes != null && !(supportedMessagingContentTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The supported chat message content types. Supported types are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>text/plain</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>text/markdown</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>application/json, application/vnd.amazonaws.connect.message.interactive</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>application/vnd.amazonaws.connect.message.interactive.response</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Content types must always contain <code>text/plain</code>. You can then put any other supported type in the list.
     * For example, all the following lists are valid because they contain <code>text/plain</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>[text/plain, text/markdown, application/json]</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>[text/markdown, text/plain]</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>[text/plain, application/json, application/vnd.amazonaws.connect.message.interactive.response]</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedMessagingContentTypes} method.
     * </p>
     * 
     * @return The supported chat message content types. Supported types are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>text/plain</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>text/markdown</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>application/json, application/vnd.amazonaws.connect.message.interactive</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>application/vnd.amazonaws.connect.message.interactive.response</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Content types must always contain <code>text/plain</code>. You can then put any other supported type in
     *         the list. For example, all the following lists are valid because they contain <code>text/plain</code>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>[text/plain, text/markdown, application/json]</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>[text/markdown, text/plain]</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>[text/plain, application/json, application/vnd.amazonaws.connect.message.interactive.response]</code>
     *         </p>
     *         </li>
     */
    public final List<String> supportedMessagingContentTypes() {
        return supportedMessagingContentTypes;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided,
     * the AWS SDK populates this field. For more information about idempotency, see <a
     * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with
     * idempotent APIs</a>. The token is valid for 7 days after creation. If a contact is already started, the contact
     * ID is returned.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
     *         provided, the AWS SDK populates this field. For more information about idempotency, see <a
     *         href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries
     *         safe with idempotent APIs</a>. The token is valid for 7 days after creation. If a contact is already
     *         started, the contact ID is returned.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sourceEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(destinationEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSegmentAttributes() ? segmentAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(contactFlowId());
        hashCode = 31 * hashCode + Objects.hashCode(chatDurationInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(participantDetails());
        hashCode = 31 * hashCode + Objects.hashCode(initialSystemMessage());
        hashCode = 31 * hashCode + Objects.hashCode(relatedContactId());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasSupportedMessagingContentTypes() ? supportedMessagingContentTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartOutboundChatContactRequest)) {
            return false;
        }
        StartOutboundChatContactRequest other = (StartOutboundChatContactRequest) obj;
        return Objects.equals(sourceEndpoint(), other.sourceEndpoint())
                && Objects.equals(destinationEndpoint(), other.destinationEndpoint())
                && Objects.equals(instanceId(), other.instanceId()) && hasSegmentAttributes() == other.hasSegmentAttributes()
                && Objects.equals(segmentAttributes(), other.segmentAttributes()) && hasAttributes() == other.hasAttributes()
                && Objects.equals(attributes(), other.attributes()) && Objects.equals(contactFlowId(), other.contactFlowId())
                && Objects.equals(chatDurationInMinutes(), other.chatDurationInMinutes())
                && Objects.equals(participantDetails(), other.participantDetails())
                && Objects.equals(initialSystemMessage(), other.initialSystemMessage())
                && Objects.equals(relatedContactId(), other.relatedContactId())
                && hasSupportedMessagingContentTypes() == other.hasSupportedMessagingContentTypes()
                && Objects.equals(supportedMessagingContentTypes(), other.supportedMessagingContentTypes())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("StartOutboundChatContactRequest")
                .add("SourceEndpoint", sourceEndpoint())
                .add("DestinationEndpoint", destinationEndpoint())
                .add("InstanceId", instanceId())
                .add("SegmentAttributes", hasSegmentAttributes() ? segmentAttributes() : null)
                .add("Attributes", hasAttributes() ? attributes() : null)
                .add("ContactFlowId", contactFlowId())
                .add("ChatDurationInMinutes", chatDurationInMinutes())
                .add("ParticipantDetails", participantDetails())
                .add("InitialSystemMessage", initialSystemMessage())
                .add("RelatedContactId", relatedContactId())
                .add("SupportedMessagingContentTypes",
                        hasSupportedMessagingContentTypes() ? supportedMessagingContentTypes() : null)
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceEndpoint":
            return Optional.ofNullable(clazz.cast(sourceEndpoint()));
        case "DestinationEndpoint":
            return Optional.ofNullable(clazz.cast(destinationEndpoint()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "SegmentAttributes":
            return Optional.ofNullable(clazz.cast(segmentAttributes()));
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "ContactFlowId":
            return Optional.ofNullable(clazz.cast(contactFlowId()));
        case "ChatDurationInMinutes":
            return Optional.ofNullable(clazz.cast(chatDurationInMinutes()));
        case "ParticipantDetails":
            return Optional.ofNullable(clazz.cast(participantDetails()));
        case "InitialSystemMessage":
            return Optional.ofNullable(clazz.cast(initialSystemMessage()));
        case "RelatedContactId":
            return Optional.ofNullable(clazz.cast(relatedContactId()));
        case "SupportedMessagingContentTypes":
            return Optional.ofNullable(clazz.cast(supportedMessagingContentTypes()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartOutboundChatContactRequest, T> g) {
        return obj -> g.apply((StartOutboundChatContactRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartOutboundChatContactRequest> {
        /**
         * Sets the value of the SourceEndpoint property for this object.
         *
         * @param sourceEndpoint
         *        The new value for the SourceEndpoint property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceEndpoint(Endpoint sourceEndpoint);

        /**
         * Sets the value of the SourceEndpoint property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Endpoint.Builder} avoiding the need to
         * create one manually via {@link Endpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Endpoint.Builder#build()} is called immediately and its result is
         * passed to {@link #sourceEndpoint(Endpoint)}.
         * 
         * @param sourceEndpoint
         *        a consumer that will call methods on {@link Endpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceEndpoint(Endpoint)
         */
        default Builder sourceEndpoint(Consumer<Endpoint.Builder> sourceEndpoint) {
            return sourceEndpoint(Endpoint.builder().applyMutation(sourceEndpoint).build());
        }

        /**
         * Sets the value of the DestinationEndpoint property for this object.
         *
         * @param destinationEndpoint
         *        The new value for the DestinationEndpoint property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationEndpoint(Endpoint destinationEndpoint);

        /**
         * Sets the value of the DestinationEndpoint property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Endpoint.Builder} avoiding the need to
         * create one manually via {@link Endpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Endpoint.Builder#build()} is called immediately and its result is
         * passed to {@link #destinationEndpoint(Endpoint)}.
         * 
         * @param destinationEndpoint
         *        a consumer that will call methods on {@link Endpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationEndpoint(Endpoint)
         */
        default Builder destinationEndpoint(Consumer<Endpoint.Builder> destinationEndpoint) {
            return destinationEndpoint(Endpoint.builder().applyMutation(destinationEndpoint).build());
        }

        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can find the instance ID in the Amazon Resource Name (ARN)
         * of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can find the instance ID in the Amazon Resource
         *        Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * A set of system defined key-value pairs stored on individual contact segments using an attribute map. The
         * attributes are standard Amazon Connect attributes. They can be accessed in flows.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Attribute keys can include only alphanumeric, <code>-</code>, and <code>_</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * This field can be used to show channel subtype, such as <code>connect:Guide</code> and
         * <code>connect:SMS</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param segmentAttributes
         *        A set of system defined key-value pairs stored on individual contact segments using an attribute map.
         *        The attributes are standard Amazon Connect attributes. They can be accessed in flows.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Attribute keys can include only alphanumeric, <code>-</code>, and <code>_</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        This field can be used to show channel subtype, such as <code>connect:Guide</code> and
         *        <code>connect:SMS</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentAttributes(Map<String, SegmentAttributeValue> segmentAttributes);

        /**
         * <p>
         * A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes, and
         * can be accessed in flows just like any other contact attributes.
         * </p>
         * 
         * @param attributes
         *        A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes,
         *        and can be accessed in flows just like any other contact attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        /**
         * <p>
         * The identifier of the flow for the call. To see the ContactFlowId in the Amazon Connect console user
         * interface, on the navigation menu go to <b>Routing, Contact Flows</b>. Choose the flow. On the flow page,
         * under the name of the flow, choose <b>Show additional flow information</b>. The ContactFlowId is the last
         * part of the ARN, shown here in bold:
         * </p>
         * <ul>
         * <li>
         * <p>
         * arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>
         * 123ec456-a007-89c0-1234-xxxxxxxxxxxx</b>
         * </p>
         * </li>
         * </ul>
         * 
         * @param contactFlowId
         *        The identifier of the flow for the call. To see the ContactFlowId in the Amazon Connect console user
         *        interface, on the navigation menu go to <b>Routing, Contact Flows</b>. Choose the flow. On the flow
         *        page, under the name of the flow, choose <b>Show additional flow information</b>. The ContactFlowId is
         *        the last part of the ARN, shown here in bold:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>
         *        123ec456-a007-89c0-1234-xxxxxxxxxxxx</b>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactFlowId(String contactFlowId);

        /**
         * <p>
         * The total duration of the newly started chat session. If not specified, the chat session duration defaults to
         * 25 hour. The minimum configurable time is 60 minutes. The maximum configurable time is 10,080 minutes (7
         * days).
         * </p>
         * 
         * @param chatDurationInMinutes
         *        The total duration of the newly started chat session. If not specified, the chat session duration
         *        defaults to 25 hour. The minimum configurable time is 60 minutes. The maximum configurable time is
         *        10,080 minutes (7 days).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chatDurationInMinutes(Integer chatDurationInMinutes);

        /**
         * Sets the value of the ParticipantDetails property for this object.
         *
         * @param participantDetails
         *        The new value for the ParticipantDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder participantDetails(ParticipantDetails participantDetails);

        /**
         * Sets the value of the ParticipantDetails property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ParticipantDetails.Builder} avoiding the
         * need to create one manually via {@link ParticipantDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParticipantDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #participantDetails(ParticipantDetails)}.
         * 
         * @param participantDetails
         *        a consumer that will call methods on {@link ParticipantDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #participantDetails(ParticipantDetails)
         */
        default Builder participantDetails(Consumer<ParticipantDetails.Builder> participantDetails) {
            return participantDetails(ParticipantDetails.builder().applyMutation(participantDetails).build());
        }

        /**
         * Sets the value of the InitialSystemMessage property for this object.
         *
         * @param initialSystemMessage
         *        The new value for the InitialSystemMessage property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initialSystemMessage(ChatMessage initialSystemMessage);

        /**
         * Sets the value of the InitialSystemMessage property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ChatMessage.Builder} avoiding the need to
         * create one manually via {@link ChatMessage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChatMessage.Builder#build()} is called immediately and its result
         * is passed to {@link #initialSystemMessage(ChatMessage)}.
         * 
         * @param initialSystemMessage
         *        a consumer that will call methods on {@link ChatMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #initialSystemMessage(ChatMessage)
         */
        default Builder initialSystemMessage(Consumer<ChatMessage.Builder> initialSystemMessage) {
            return initialSystemMessage(ChatMessage.builder().applyMutation(initialSystemMessage).build());
        }

        /**
         * <p>
         * The unique identifier for an Amazon Connect contact. This identifier is related to the contact starting.
         * </p>
         * 
         * @param relatedContactId
         *        The unique identifier for an Amazon Connect contact. This identifier is related to the contact
         *        starting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedContactId(String relatedContactId);

        /**
         * <p>
         * The supported chat message content types. Supported types are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>text/plain</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>text/markdown</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>application/json, application/vnd.amazonaws.connect.message.interactive</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>application/vnd.amazonaws.connect.message.interactive.response</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Content types must always contain <code>text/plain</code>. You can then put any other supported type in the
         * list. For example, all the following lists are valid because they contain <code>text/plain</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>[text/plain, text/markdown, application/json]</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>[text/markdown, text/plain]</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>[text/plain, application/json, application/vnd.amazonaws.connect.message.interactive.response]</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param supportedMessagingContentTypes
         *        The supported chat message content types. Supported types are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>text/plain</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>text/markdown</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>application/json, application/vnd.amazonaws.connect.message.interactive</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>application/vnd.amazonaws.connect.message.interactive.response</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Content types must always contain <code>text/plain</code>. You can then put any other supported type
         *        in the list. For example, all the following lists are valid because they contain
         *        <code>text/plain</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>[text/plain, text/markdown, application/json]</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>[text/markdown, text/plain]</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>[text/plain, application/json, application/vnd.amazonaws.connect.message.interactive.response]</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedMessagingContentTypes(Collection<String> supportedMessagingContentTypes);

        /**
         * <p>
         * The supported chat message content types. Supported types are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>text/plain</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>text/markdown</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>application/json, application/vnd.amazonaws.connect.message.interactive</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>application/vnd.amazonaws.connect.message.interactive.response</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Content types must always contain <code>text/plain</code>. You can then put any other supported type in the
         * list. For example, all the following lists are valid because they contain <code>text/plain</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>[text/plain, text/markdown, application/json]</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>[text/markdown, text/plain]</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>[text/plain, application/json, application/vnd.amazonaws.connect.message.interactive.response]</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param supportedMessagingContentTypes
         *        The supported chat message content types. Supported types are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>text/plain</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>text/markdown</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>application/json, application/vnd.amazonaws.connect.message.interactive</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>application/vnd.amazonaws.connect.message.interactive.response</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Content types must always contain <code>text/plain</code>. You can then put any other supported type
         *        in the list. For example, all the following lists are valid because they contain
         *        <code>text/plain</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>[text/plain, text/markdown, application/json]</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>[text/markdown, text/plain]</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>[text/plain, application/json, application/vnd.amazonaws.connect.message.interactive.response]</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedMessagingContentTypes(String... supportedMessagingContentTypes);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         * provided, the AWS SDK populates this field. For more information about idempotency, see <a
         * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe
         * with idempotent APIs</a>. The token is valid for 7 days after creation. If a contact is already started, the
         * contact ID is returned.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         *        provided, the AWS SDK populates this field. For more information about idempotency, see <a
         *        href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
         *        retries safe with idempotent APIs</a>. The token is valid for 7 days after creation. If a contact is
         *        already started, the contact ID is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private Endpoint sourceEndpoint;

        private Endpoint destinationEndpoint;

        private String instanceId;

        private Map<String, SegmentAttributeValue> segmentAttributes = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private String contactFlowId;

        private Integer chatDurationInMinutes;

        private ParticipantDetails participantDetails;

        private ChatMessage initialSystemMessage;

        private String relatedContactId;

        private List<String> supportedMessagingContentTypes = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartOutboundChatContactRequest model) {
            super(model);
            sourceEndpoint(model.sourceEndpoint);
            destinationEndpoint(model.destinationEndpoint);
            instanceId(model.instanceId);
            segmentAttributes(model.segmentAttributes);
            attributes(model.attributes);
            contactFlowId(model.contactFlowId);
            chatDurationInMinutes(model.chatDurationInMinutes);
            participantDetails(model.participantDetails);
            initialSystemMessage(model.initialSystemMessage);
            relatedContactId(model.relatedContactId);
            supportedMessagingContentTypes(model.supportedMessagingContentTypes);
            clientToken(model.clientToken);
        }

        public final Endpoint.Builder getSourceEndpoint() {
            return sourceEndpoint != null ? sourceEndpoint.toBuilder() : null;
        }

        public final void setSourceEndpoint(Endpoint.BuilderImpl sourceEndpoint) {
            this.sourceEndpoint = sourceEndpoint != null ? sourceEndpoint.build() : null;
        }

        @Override
        public final Builder sourceEndpoint(Endpoint sourceEndpoint) {
            this.sourceEndpoint = sourceEndpoint;
            return this;
        }

        public final Endpoint.Builder getDestinationEndpoint() {
            return destinationEndpoint != null ? destinationEndpoint.toBuilder() : null;
        }

        public final void setDestinationEndpoint(Endpoint.BuilderImpl destinationEndpoint) {
            this.destinationEndpoint = destinationEndpoint != null ? destinationEndpoint.build() : null;
        }

        @Override
        public final Builder destinationEndpoint(Endpoint destinationEndpoint) {
            this.destinationEndpoint = destinationEndpoint;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final Map<String, SegmentAttributeValue.Builder> getSegmentAttributes() {
            Map<String, SegmentAttributeValue.Builder> result = SegmentAttributesCopier.copyToBuilder(this.segmentAttributes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setSegmentAttributes(Map<String, SegmentAttributeValue.BuilderImpl> segmentAttributes) {
            this.segmentAttributes = SegmentAttributesCopier.copyFromBuilder(segmentAttributes);
        }

        @Override
        public final Builder segmentAttributes(Map<String, SegmentAttributeValue> segmentAttributes) {
            this.segmentAttributes = SegmentAttributesCopier.copy(segmentAttributes);
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final String getContactFlowId() {
            return contactFlowId;
        }

        public final void setContactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
        }

        @Override
        public final Builder contactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
            return this;
        }

        public final Integer getChatDurationInMinutes() {
            return chatDurationInMinutes;
        }

        public final void setChatDurationInMinutes(Integer chatDurationInMinutes) {
            this.chatDurationInMinutes = chatDurationInMinutes;
        }

        @Override
        public final Builder chatDurationInMinutes(Integer chatDurationInMinutes) {
            this.chatDurationInMinutes = chatDurationInMinutes;
            return this;
        }

        public final ParticipantDetails.Builder getParticipantDetails() {
            return participantDetails != null ? participantDetails.toBuilder() : null;
        }

        public final void setParticipantDetails(ParticipantDetails.BuilderImpl participantDetails) {
            this.participantDetails = participantDetails != null ? participantDetails.build() : null;
        }

        @Override
        public final Builder participantDetails(ParticipantDetails participantDetails) {
            this.participantDetails = participantDetails;
            return this;
        }

        public final ChatMessage.Builder getInitialSystemMessage() {
            return initialSystemMessage != null ? initialSystemMessage.toBuilder() : null;
        }

        public final void setInitialSystemMessage(ChatMessage.BuilderImpl initialSystemMessage) {
            this.initialSystemMessage = initialSystemMessage != null ? initialSystemMessage.build() : null;
        }

        @Override
        public final Builder initialSystemMessage(ChatMessage initialSystemMessage) {
            this.initialSystemMessage = initialSystemMessage;
            return this;
        }

        public final String getRelatedContactId() {
            return relatedContactId;
        }

        public final void setRelatedContactId(String relatedContactId) {
            this.relatedContactId = relatedContactId;
        }

        @Override
        public final Builder relatedContactId(String relatedContactId) {
            this.relatedContactId = relatedContactId;
            return this;
        }

        public final Collection<String> getSupportedMessagingContentTypes() {
            if (supportedMessagingContentTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedMessagingContentTypes;
        }

        public final void setSupportedMessagingContentTypes(Collection<String> supportedMessagingContentTypes) {
            this.supportedMessagingContentTypes = SupportedMessagingContentTypesCopier.copy(supportedMessagingContentTypes);
        }

        @Override
        public final Builder supportedMessagingContentTypes(Collection<String> supportedMessagingContentTypes) {
            this.supportedMessagingContentTypes = SupportedMessagingContentTypesCopier.copy(supportedMessagingContentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedMessagingContentTypes(String... supportedMessagingContentTypes) {
            supportedMessagingContentTypes(Arrays.asList(supportedMessagingContentTypes));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartOutboundChatContactRequest build() {
            return new StartOutboundChatContactRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
