/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.Evaluation;
import software.amazon.awssdk.services.connect.model.EvaluationFormContent;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeContactEvaluationResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, DescribeContactEvaluationResponse> {
    private static final SdkField<Evaluation> EVALUATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Evaluation").getter(DescribeContactEvaluationResponse.getter(DescribeContactEvaluationResponse::evaluation)).setter(DescribeContactEvaluationResponse.setter(Builder::evaluation)).constructor(Evaluation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Evaluation").build()}).build();
    private static final SdkField<EvaluationFormContent> EVALUATION_FORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EvaluationForm").getter(DescribeContactEvaluationResponse.getter(DescribeContactEvaluationResponse::evaluationForm)).setter(DescribeContactEvaluationResponse.setter(Builder::evaluationForm)).constructor(EvaluationFormContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationForm").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATION_FIELD, EVALUATION_FORM_FIELD));
    private final Evaluation evaluation;
    private final EvaluationFormContent evaluationForm;

    private DescribeContactEvaluationResponse(BuilderImpl builder) {
        super(builder);
        this.evaluation = builder.evaluation;
        this.evaluationForm = builder.evaluationForm;
    }

    public final Evaluation evaluation() {
        return this.evaluation;
    }

    public final EvaluationFormContent evaluationForm() {
        return this.evaluationForm;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluation());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationForm());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeContactEvaluationResponse)) {
            return false;
        }
        DescribeContactEvaluationResponse other = (DescribeContactEvaluationResponse)((Object)obj);
        return Objects.equals(this.evaluation(), other.evaluation()) && Objects.equals(this.evaluationForm(), other.evaluationForm());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeContactEvaluationResponse").add("Evaluation", (Object)this.evaluation()).add("EvaluationForm", (Object)this.evaluationForm()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Evaluation": {
                return Optional.ofNullable(clazz.cast(this.evaluation()));
            }
            case "EvaluationForm": {
                return Optional.ofNullable(clazz.cast(this.evaluationForm()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeContactEvaluationResponse, T> g) {
        return obj -> g.apply((DescribeContactEvaluationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private Evaluation evaluation;
        private EvaluationFormContent evaluationForm;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeContactEvaluationResponse model) {
            super(model);
            this.evaluation(model.evaluation);
            this.evaluationForm(model.evaluationForm);
        }

        public final Evaluation.Builder getEvaluation() {
            return this.evaluation != null ? this.evaluation.toBuilder() : null;
        }

        public final void setEvaluation(Evaluation.BuilderImpl evaluation) {
            this.evaluation = evaluation != null ? evaluation.build() : null;
        }

        @Override
        public final Builder evaluation(Evaluation evaluation) {
            this.evaluation = evaluation;
            return this;
        }

        public final EvaluationFormContent.Builder getEvaluationForm() {
            return this.evaluationForm != null ? this.evaluationForm.toBuilder() : null;
        }

        public final void setEvaluationForm(EvaluationFormContent.BuilderImpl evaluationForm) {
            this.evaluationForm = evaluationForm != null ? evaluationForm.build() : null;
        }

        @Override
        public final Builder evaluationForm(EvaluationFormContent evaluationForm) {
            this.evaluationForm = evaluationForm;
            return this;
        }

        @Override
        public DescribeContactEvaluationResponse build() {
            return new DescribeContactEvaluationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeContactEvaluationResponse> {
        public Builder evaluation(Evaluation var1);

        default public Builder evaluation(Consumer<Evaluation.Builder> evaluation) {
            return this.evaluation((Evaluation)((Evaluation.Builder)Evaluation.builder().applyMutation(evaluation)).build());
        }

        public Builder evaluationForm(EvaluationFormContent var1);

        default public Builder evaluationForm(Consumer<EvaluationFormContent.Builder> evaluationForm) {
            return this.evaluationForm((EvaluationFormContent)((EvaluationFormContent.Builder)EvaluationFormContent.builder().applyMutation(evaluationForm)).build());
        }
    }
}

