/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.PredefinedAttributeSummary;
import software.amazon.awssdk.services.connect.model.PredefinedAttributeSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPredefinedAttributesResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, ListPredefinedAttributesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListPredefinedAttributesResponse.getter(ListPredefinedAttributesResponse::nextToken)).setter(ListPredefinedAttributesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<PredefinedAttributeSummary>> PREDEFINED_ATTRIBUTE_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PredefinedAttributeSummaryList").getter(ListPredefinedAttributesResponse.getter(ListPredefinedAttributesResponse::predefinedAttributeSummaryList)).setter(ListPredefinedAttributesResponse.setter(Builder::predefinedAttributeSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredefinedAttributeSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PredefinedAttributeSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, PREDEFINED_ATTRIBUTE_SUMMARY_LIST_FIELD));
    private final String nextToken;
    private final List<PredefinedAttributeSummary> predefinedAttributeSummaryList;

    private ListPredefinedAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.predefinedAttributeSummaryList = builder.predefinedAttributeSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasPredefinedAttributeSummaryList() {
        return this.predefinedAttributeSummaryList != null && !(this.predefinedAttributeSummaryList instanceof SdkAutoConstructList);
    }

    public final List<PredefinedAttributeSummary> predefinedAttributeSummaryList() {
        return this.predefinedAttributeSummaryList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPredefinedAttributeSummaryList() ? this.predefinedAttributeSummaryList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPredefinedAttributesResponse)) {
            return false;
        }
        ListPredefinedAttributesResponse other = (ListPredefinedAttributesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasPredefinedAttributeSummaryList() == other.hasPredefinedAttributeSummaryList() && Objects.equals(this.predefinedAttributeSummaryList(), other.predefinedAttributeSummaryList());
    }

    public final String toString() {
        return ToString.builder((String)"ListPredefinedAttributesResponse").add("NextToken", (Object)this.nextToken()).add("PredefinedAttributeSummaryList", this.hasPredefinedAttributeSummaryList() ? this.predefinedAttributeSummaryList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "PredefinedAttributeSummaryList": {
                return Optional.ofNullable(clazz.cast(this.predefinedAttributeSummaryList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPredefinedAttributesResponse, T> g) {
        return obj -> g.apply((ListPredefinedAttributesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<PredefinedAttributeSummary> predefinedAttributeSummaryList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPredefinedAttributesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.predefinedAttributeSummaryList(model.predefinedAttributeSummaryList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<PredefinedAttributeSummary.Builder> getPredefinedAttributeSummaryList() {
            List<PredefinedAttributeSummary.Builder> result = PredefinedAttributeSummaryListCopier.copyToBuilder(this.predefinedAttributeSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPredefinedAttributeSummaryList(Collection<PredefinedAttributeSummary.BuilderImpl> predefinedAttributeSummaryList) {
            this.predefinedAttributeSummaryList = PredefinedAttributeSummaryListCopier.copyFromBuilder(predefinedAttributeSummaryList);
        }

        @Override
        public final Builder predefinedAttributeSummaryList(Collection<PredefinedAttributeSummary> predefinedAttributeSummaryList) {
            this.predefinedAttributeSummaryList = PredefinedAttributeSummaryListCopier.copy(predefinedAttributeSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder predefinedAttributeSummaryList(PredefinedAttributeSummary ... predefinedAttributeSummaryList) {
            this.predefinedAttributeSummaryList(Arrays.asList(predefinedAttributeSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder predefinedAttributeSummaryList(Consumer<PredefinedAttributeSummary.Builder> ... predefinedAttributeSummaryList) {
            this.predefinedAttributeSummaryList(Stream.of(predefinedAttributeSummaryList).map(c -> (PredefinedAttributeSummary)((PredefinedAttributeSummary.Builder)PredefinedAttributeSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListPredefinedAttributesResponse build() {
            return new ListPredefinedAttributesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPredefinedAttributesResponse> {
        public Builder nextToken(String var1);

        public Builder predefinedAttributeSummaryList(Collection<PredefinedAttributeSummary> var1);

        public Builder predefinedAttributeSummaryList(PredefinedAttributeSummary ... var1);

        public Builder predefinedAttributeSummaryList(Consumer<PredefinedAttributeSummary.Builder> ... var1);
    }
}

