/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the status of the replication of a source Amazon Connect instance across Amazon Web Services Regions.
 * Use these details to understand the general status of a given replication. For information about why a replication
 * process may fail, see <a href=
 * "https://docs.aws.amazon.com/connect/latest/adminguide/create-replica-connect-instance.html#why-replicateinstance-fails"
 * >Why a ReplicateInstance call fails</a> in the <i>Create a replica of your existing Amazon Connect instance</i> topic
 * in the <i>Amazon Connect Administrator Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ReplicationConfiguration.Builder, ReplicationConfiguration> {
    private static final SdkField<List<ReplicationStatusSummary>> REPLICATION_STATUS_SUMMARY_LIST_FIELD = SdkField
            .<List<ReplicationStatusSummary>> builder(MarshallingType.LIST)
            .memberName("ReplicationStatusSummaryList")
            .getter(getter(ReplicationConfiguration::replicationStatusSummaryList))
            .setter(setter(Builder::replicationStatusSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationStatusSummaryList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReplicationStatusSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReplicationStatusSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SOURCE_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceRegion").getter(getter(ReplicationConfiguration::sourceRegion))
            .setter(setter(Builder::sourceRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceRegion").build()).build();

    private static final SdkField<String> GLOBAL_SIGN_IN_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GlobalSignInEndpoint").getter(getter(ReplicationConfiguration::globalSignInEndpoint))
            .setter(setter(Builder::globalSignInEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalSignInEndpoint").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            REPLICATION_STATUS_SUMMARY_LIST_FIELD, SOURCE_REGION_FIELD, GLOBAL_SIGN_IN_ENDPOINT_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ReplicationStatusSummary> replicationStatusSummaryList;

    private final String sourceRegion;

    private final String globalSignInEndpoint;

    private ReplicationConfiguration(BuilderImpl builder) {
        this.replicationStatusSummaryList = builder.replicationStatusSummaryList;
        this.sourceRegion = builder.sourceRegion;
        this.globalSignInEndpoint = builder.globalSignInEndpoint;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReplicationStatusSummaryList property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasReplicationStatusSummaryList() {
        return replicationStatusSummaryList != null && !(replicationStatusSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of replication status summaries. The summaries contain details about the replication of configuration
     * information for Amazon Connect resources, for each Amazon Web Services Region.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplicationStatusSummaryList} method.
     * </p>
     * 
     * @return A list of replication status summaries. The summaries contain details about the replication of
     *         configuration information for Amazon Connect resources, for each Amazon Web Services Region.
     */
    public final List<ReplicationStatusSummary> replicationStatusSummaryList() {
        return replicationStatusSummaryList;
    }

    /**
     * <p>
     * The Amazon Web Services Region where the source Amazon Connect instance was created. This is the Region where the
     * <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_ReplicateInstance.html">ReplicateInstance</a>
     * API was called to start the replication process.
     * </p>
     * 
     * @return The Amazon Web Services Region where the source Amazon Connect instance was created. This is the Region
     *         where the <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_ReplicateInstance.html">
     *         ReplicateInstance</a> API was called to start the replication process.
     */
    public final String sourceRegion() {
        return sourceRegion;
    }

    /**
     * <p>
     * The URL that is used to sign-in to your Amazon Connect instance according to your traffic distribution group
     * configuration. For more information about sign-in and traffic distribution groups, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/setup-traffic-distribution-groups.html">Important
     * things to know</a> in the <i>Create traffic distribution groups</i> topic in the <i>Amazon Connect Administrator
     * Guide</i>.
     * </p>
     * 
     * @return The URL that is used to sign-in to your Amazon Connect instance according to your traffic distribution
     *         group configuration. For more information about sign-in and traffic distribution groups, see <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/setup-traffic-distribution-groups.html"
     *         >Important things to know</a> in the <i>Create traffic distribution groups</i> topic in the <i>Amazon
     *         Connect Administrator Guide</i>.
     */
    public final String globalSignInEndpoint() {
        return globalSignInEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasReplicationStatusSummaryList() ? replicationStatusSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sourceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(globalSignInEndpoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationConfiguration)) {
            return false;
        }
        ReplicationConfiguration other = (ReplicationConfiguration) obj;
        return hasReplicationStatusSummaryList() == other.hasReplicationStatusSummaryList()
                && Objects.equals(replicationStatusSummaryList(), other.replicationStatusSummaryList())
                && Objects.equals(sourceRegion(), other.sourceRegion())
                && Objects.equals(globalSignInEndpoint(), other.globalSignInEndpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplicationConfiguration")
                .add("ReplicationStatusSummaryList", hasReplicationStatusSummaryList() ? replicationStatusSummaryList() : null)
                .add("SourceRegion", sourceRegion()).add("GlobalSignInEndpoint", globalSignInEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationStatusSummaryList":
            return Optional.ofNullable(clazz.cast(replicationStatusSummaryList()));
        case "SourceRegion":
            return Optional.ofNullable(clazz.cast(sourceRegion()));
        case "GlobalSignInEndpoint":
            return Optional.ofNullable(clazz.cast(globalSignInEndpoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicationConfiguration, T> g) {
        return obj -> g.apply((ReplicationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicationConfiguration> {
        /**
         * <p>
         * A list of replication status summaries. The summaries contain details about the replication of configuration
         * information for Amazon Connect resources, for each Amazon Web Services Region.
         * </p>
         * 
         * @param replicationStatusSummaryList
         *        A list of replication status summaries. The summaries contain details about the replication of
         *        configuration information for Amazon Connect resources, for each Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationStatusSummaryList(Collection<ReplicationStatusSummary> replicationStatusSummaryList);

        /**
         * <p>
         * A list of replication status summaries. The summaries contain details about the replication of configuration
         * information for Amazon Connect resources, for each Amazon Web Services Region.
         * </p>
         * 
         * @param replicationStatusSummaryList
         *        A list of replication status summaries. The summaries contain details about the replication of
         *        configuration information for Amazon Connect resources, for each Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationStatusSummaryList(ReplicationStatusSummary... replicationStatusSummaryList);

        /**
         * <p>
         * A list of replication status summaries. The summaries contain details about the replication of configuration
         * information for Amazon Connect resources, for each Amazon Web Services Region.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.ReplicationStatusSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.connect.model.ReplicationStatusSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.ReplicationStatusSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #replicationStatusSummaryList(List<ReplicationStatusSummary>)}.
         * 
         * @param replicationStatusSummaryList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.ReplicationStatusSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicationStatusSummaryList(java.util.Collection<ReplicationStatusSummary>)
         */
        Builder replicationStatusSummaryList(Consumer<ReplicationStatusSummary.Builder>... replicationStatusSummaryList);

        /**
         * <p>
         * The Amazon Web Services Region where the source Amazon Connect instance was created. This is the Region where
         * the <a
         * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_ReplicateInstance.html">ReplicateInstance
         * </a> API was called to start the replication process.
         * </p>
         * 
         * @param sourceRegion
         *        The Amazon Web Services Region where the source Amazon Connect instance was created. This is the
         *        Region where the <a
         *        href="https://docs.aws.amazon.com/connect/latest/APIReference/API_ReplicateInstance.html"
         *        >ReplicateInstance</a> API was called to start the replication process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceRegion(String sourceRegion);

        /**
         * <p>
         * The URL that is used to sign-in to your Amazon Connect instance according to your traffic distribution group
         * configuration. For more information about sign-in and traffic distribution groups, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/setup-traffic-distribution-groups.html">Important
         * things to know</a> in the <i>Create traffic distribution groups</i> topic in the <i>Amazon Connect
         * Administrator Guide</i>.
         * </p>
         * 
         * @param globalSignInEndpoint
         *        The URL that is used to sign-in to your Amazon Connect instance according to your traffic distribution
         *        group configuration. For more information about sign-in and traffic distribution groups, see <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/setup-traffic-distribution-groups.html"
         *        >Important things to know</a> in the <i>Create traffic distribution groups</i> topic in the <i>Amazon
         *        Connect Administrator Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalSignInEndpoint(String globalSignInEndpoint);
    }

    static final class BuilderImpl implements Builder {
        private List<ReplicationStatusSummary> replicationStatusSummaryList = DefaultSdkAutoConstructList.getInstance();

        private String sourceRegion;

        private String globalSignInEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationConfiguration model) {
            replicationStatusSummaryList(model.replicationStatusSummaryList);
            sourceRegion(model.sourceRegion);
            globalSignInEndpoint(model.globalSignInEndpoint);
        }

        public final List<ReplicationStatusSummary.Builder> getReplicationStatusSummaryList() {
            List<ReplicationStatusSummary.Builder> result = ReplicationStatusSummaryListCopier
                    .copyToBuilder(this.replicationStatusSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicationStatusSummaryList(
                Collection<ReplicationStatusSummary.BuilderImpl> replicationStatusSummaryList) {
            this.replicationStatusSummaryList = ReplicationStatusSummaryListCopier.copyFromBuilder(replicationStatusSummaryList);
        }

        @Override
        public final Builder replicationStatusSummaryList(Collection<ReplicationStatusSummary> replicationStatusSummaryList) {
            this.replicationStatusSummaryList = ReplicationStatusSummaryListCopier.copy(replicationStatusSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationStatusSummaryList(ReplicationStatusSummary... replicationStatusSummaryList) {
            replicationStatusSummaryList(Arrays.asList(replicationStatusSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationStatusSummaryList(
                Consumer<ReplicationStatusSummary.Builder>... replicationStatusSummaryList) {
            replicationStatusSummaryList(Stream.of(replicationStatusSummaryList)
                    .map(c -> ReplicationStatusSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSourceRegion() {
            return sourceRegion;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        @Override
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        public final String getGlobalSignInEndpoint() {
            return globalSignInEndpoint;
        }

        public final void setGlobalSignInEndpoint(String globalSignInEndpoint) {
            this.globalSignInEndpoint = globalSignInEndpoint;
        }

        @Override
        public final Builder globalSignInEndpoint(String globalSignInEndpoint) {
            this.globalSignInEndpoint = globalSignInEndpoint;
            return this;
        }

        @Override
        public ReplicationConfiguration build() {
            return new ReplicationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
