/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserIdentityInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UserIdentityInfo> {
    private static final SdkField<String> FIRST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirstName").getter(UserIdentityInfo.getter(UserIdentityInfo::firstName)).setter(UserIdentityInfo.setter(Builder::firstName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstName").build()}).build();
    private static final SdkField<String> LAST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastName").getter(UserIdentityInfo.getter(UserIdentityInfo::lastName)).setter(UserIdentityInfo.setter(Builder::lastName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastName").build()}).build();
    private static final SdkField<String> EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Email").getter(UserIdentityInfo.getter(UserIdentityInfo::email)).setter(UserIdentityInfo.setter(Builder::email)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Email").build()}).build();
    private static final SdkField<String> SECONDARY_EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecondaryEmail").getter(UserIdentityInfo.getter(UserIdentityInfo::secondaryEmail)).setter(UserIdentityInfo.setter(Builder::secondaryEmail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryEmail").build()}).build();
    private static final SdkField<String> MOBILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Mobile").getter(UserIdentityInfo.getter(UserIdentityInfo::mobile)).setter(UserIdentityInfo.setter(Builder::mobile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mobile").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIRST_NAME_FIELD, LAST_NAME_FIELD, EMAIL_FIELD, SECONDARY_EMAIL_FIELD, MOBILE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String firstName;
    private final String lastName;
    private final String email;
    private final String secondaryEmail;
    private final String mobile;

    private UserIdentityInfo(BuilderImpl builder) {
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.email = builder.email;
        this.secondaryEmail = builder.secondaryEmail;
        this.mobile = builder.mobile;
    }

    public final String firstName() {
        return this.firstName;
    }

    public final String lastName() {
        return this.lastName;
    }

    public final String email() {
        return this.email;
    }

    public final String secondaryEmail() {
        return this.secondaryEmail;
    }

    public final String mobile() {
        return this.mobile;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.firstName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastName());
        hashCode = 31 * hashCode + Objects.hashCode(this.email());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondaryEmail());
        hashCode = 31 * hashCode + Objects.hashCode(this.mobile());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserIdentityInfo)) {
            return false;
        }
        UserIdentityInfo other = (UserIdentityInfo)obj;
        return Objects.equals(this.firstName(), other.firstName()) && Objects.equals(this.lastName(), other.lastName()) && Objects.equals(this.email(), other.email()) && Objects.equals(this.secondaryEmail(), other.secondaryEmail()) && Objects.equals(this.mobile(), other.mobile());
    }

    public final String toString() {
        return ToString.builder((String)"UserIdentityInfo").add("FirstName", (Object)(this.firstName() == null ? null : "*** Sensitive Data Redacted ***")).add("LastName", (Object)(this.lastName() == null ? null : "*** Sensitive Data Redacted ***")).add("Email", (Object)(this.email() == null ? null : "*** Sensitive Data Redacted ***")).add("SecondaryEmail", (Object)(this.secondaryEmail() == null ? null : "*** Sensitive Data Redacted ***")).add("Mobile", (Object)this.mobile()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FirstName": {
                return Optional.ofNullable(clazz.cast(this.firstName()));
            }
            case "LastName": {
                return Optional.ofNullable(clazz.cast(this.lastName()));
            }
            case "Email": {
                return Optional.ofNullable(clazz.cast(this.email()));
            }
            case "SecondaryEmail": {
                return Optional.ofNullable(clazz.cast(this.secondaryEmail()));
            }
            case "Mobile": {
                return Optional.ofNullable(clazz.cast(this.mobile()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserIdentityInfo, T> g) {
        return obj -> g.apply((UserIdentityInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String firstName;
        private String lastName;
        private String email;
        private String secondaryEmail;
        private String mobile;

        private BuilderImpl() {
        }

        private BuilderImpl(UserIdentityInfo model) {
            this.firstName(model.firstName);
            this.lastName(model.lastName);
            this.email(model.email);
            this.secondaryEmail(model.secondaryEmail);
            this.mobile(model.mobile);
        }

        public final String getFirstName() {
            return this.firstName;
        }

        public final void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        @Override
        public final Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public final String getLastName() {
            return this.lastName;
        }

        public final void setLastName(String lastName) {
            this.lastName = lastName;
        }

        @Override
        public final Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public final String getEmail() {
            return this.email;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final String getSecondaryEmail() {
            return this.secondaryEmail;
        }

        public final void setSecondaryEmail(String secondaryEmail) {
            this.secondaryEmail = secondaryEmail;
        }

        @Override
        public final Builder secondaryEmail(String secondaryEmail) {
            this.secondaryEmail = secondaryEmail;
            return this;
        }

        public final String getMobile() {
            return this.mobile;
        }

        public final void setMobile(String mobile) {
            this.mobile = mobile;
        }

        @Override
        public final Builder mobile(String mobile) {
            this.mobile = mobile;
            return this;
        }

        public UserIdentityInfo build() {
            return new UserIdentityInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UserIdentityInfo> {
        public Builder firstName(String var1);

        public Builder lastName(String var1);

        public Builder email(String var1);

        public Builder secondaryEmail(String var1);

        public Builder mobile(String var1);
    }
}

