/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.HierarchyGroupCondition;
import software.amazon.awssdk.services.connect.model.ListCondition;
import software.amazon.awssdk.services.connect.model.StringCondition;
import software.amazon.awssdk.services.connect.model.UserSearchConditionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserSearchCriteria
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UserSearchCriteria> {
    private static final SdkField<List<UserSearchCriteria>> OR_CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OrConditions").getter(UserSearchCriteria.getter(UserSearchCriteria::orConditions)).setter(UserSearchCriteria.setter(Builder::orConditions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrConditions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UserSearchCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<UserSearchCriteria>> AND_CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AndConditions").getter(UserSearchCriteria.getter(UserSearchCriteria::andConditions)).setter(UserSearchCriteria.setter(Builder::andConditions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AndConditions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UserSearchCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<StringCondition> STRING_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StringCondition").getter(UserSearchCriteria.getter(UserSearchCriteria::stringCondition)).setter(UserSearchCriteria.setter(Builder::stringCondition)).constructor(StringCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringCondition").build()}).build();
    private static final SdkField<ListCondition> LIST_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ListCondition").getter(UserSearchCriteria.getter(UserSearchCriteria::listCondition)).setter(UserSearchCriteria.setter(Builder::listCondition)).constructor(ListCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListCondition").build()}).build();
    private static final SdkField<HierarchyGroupCondition> HIERARCHY_GROUP_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HierarchyGroupCondition").getter(UserSearchCriteria.getter(UserSearchCriteria::hierarchyGroupCondition)).setter(UserSearchCriteria.setter(Builder::hierarchyGroupCondition)).constructor(HierarchyGroupCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HierarchyGroupCondition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OR_CONDITIONS_FIELD, AND_CONDITIONS_FIELD, STRING_CONDITION_FIELD, LIST_CONDITION_FIELD, HIERARCHY_GROUP_CONDITION_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<UserSearchCriteria> orConditions;
    private final List<UserSearchCriteria> andConditions;
    private final StringCondition stringCondition;
    private final ListCondition listCondition;
    private final HierarchyGroupCondition hierarchyGroupCondition;

    private UserSearchCriteria(BuilderImpl builder) {
        this.orConditions = builder.orConditions;
        this.andConditions = builder.andConditions;
        this.stringCondition = builder.stringCondition;
        this.listCondition = builder.listCondition;
        this.hierarchyGroupCondition = builder.hierarchyGroupCondition;
    }

    public final boolean hasOrConditions() {
        return this.orConditions != null && !(this.orConditions instanceof SdkAutoConstructList);
    }

    public final List<UserSearchCriteria> orConditions() {
        return this.orConditions;
    }

    public final boolean hasAndConditions() {
        return this.andConditions != null && !(this.andConditions instanceof SdkAutoConstructList);
    }

    public final List<UserSearchCriteria> andConditions() {
        return this.andConditions;
    }

    public final StringCondition stringCondition() {
        return this.stringCondition;
    }

    public final ListCondition listCondition() {
        return this.listCondition;
    }

    public final HierarchyGroupCondition hierarchyGroupCondition() {
        return this.hierarchyGroupCondition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrConditions() ? this.orConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAndConditions() ? this.andConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.stringCondition());
        hashCode = 31 * hashCode + Objects.hashCode(this.listCondition());
        hashCode = 31 * hashCode + Objects.hashCode(this.hierarchyGroupCondition());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserSearchCriteria)) {
            return false;
        }
        UserSearchCriteria other = (UserSearchCriteria)obj;
        return this.hasOrConditions() == other.hasOrConditions() && Objects.equals(this.orConditions(), other.orConditions()) && this.hasAndConditions() == other.hasAndConditions() && Objects.equals(this.andConditions(), other.andConditions()) && Objects.equals(this.stringCondition(), other.stringCondition()) && Objects.equals(this.listCondition(), other.listCondition()) && Objects.equals(this.hierarchyGroupCondition(), other.hierarchyGroupCondition());
    }

    public final String toString() {
        return ToString.builder((String)"UserSearchCriteria").add("OrConditions", this.hasOrConditions() ? this.orConditions() : null).add("AndConditions", this.hasAndConditions() ? this.andConditions() : null).add("StringCondition", (Object)this.stringCondition()).add("ListCondition", (Object)this.listCondition()).add("HierarchyGroupCondition", (Object)this.hierarchyGroupCondition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrConditions": {
                return Optional.ofNullable(clazz.cast(this.orConditions()));
            }
            case "AndConditions": {
                return Optional.ofNullable(clazz.cast(this.andConditions()));
            }
            case "StringCondition": {
                return Optional.ofNullable(clazz.cast(this.stringCondition()));
            }
            case "ListCondition": {
                return Optional.ofNullable(clazz.cast(this.listCondition()));
            }
            case "HierarchyGroupCondition": {
                return Optional.ofNullable(clazz.cast(this.hierarchyGroupCondition()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserSearchCriteria, T> g) {
        return obj -> g.apply((UserSearchCriteria)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<UserSearchCriteria> orConditions = DefaultSdkAutoConstructList.getInstance();
        private List<UserSearchCriteria> andConditions = DefaultSdkAutoConstructList.getInstance();
        private StringCondition stringCondition;
        private ListCondition listCondition;
        private HierarchyGroupCondition hierarchyGroupCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(UserSearchCriteria model) {
            this.orConditions(model.orConditions);
            this.andConditions(model.andConditions);
            this.stringCondition(model.stringCondition);
            this.listCondition(model.listCondition);
            this.hierarchyGroupCondition(model.hierarchyGroupCondition);
        }

        public final List<Builder> getOrConditions() {
            List<Builder> result = UserSearchConditionListCopier.copyToBuilder(this.orConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrConditions(Collection<BuilderImpl> orConditions) {
            this.orConditions = UserSearchConditionListCopier.copyFromBuilder(orConditions);
        }

        @Override
        public final Builder orConditions(Collection<UserSearchCriteria> orConditions) {
            this.orConditions = UserSearchConditionListCopier.copy(orConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orConditions(UserSearchCriteria ... orConditions) {
            this.orConditions(Arrays.asList(orConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orConditions(Consumer<Builder> ... orConditions) {
            this.orConditions(Stream.of(orConditions).map(c -> (UserSearchCriteria)((Builder)UserSearchCriteria.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Builder> getAndConditions() {
            List<Builder> result = UserSearchConditionListCopier.copyToBuilder(this.andConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAndConditions(Collection<BuilderImpl> andConditions) {
            this.andConditions = UserSearchConditionListCopier.copyFromBuilder(andConditions);
        }

        @Override
        public final Builder andConditions(Collection<UserSearchCriteria> andConditions) {
            this.andConditions = UserSearchConditionListCopier.copy(andConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andConditions(UserSearchCriteria ... andConditions) {
            this.andConditions(Arrays.asList(andConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andConditions(Consumer<Builder> ... andConditions) {
            this.andConditions(Stream.of(andConditions).map(c -> (UserSearchCriteria)((Builder)UserSearchCriteria.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final StringCondition.Builder getStringCondition() {
            return this.stringCondition != null ? this.stringCondition.toBuilder() : null;
        }

        public final void setStringCondition(StringCondition.BuilderImpl stringCondition) {
            this.stringCondition = stringCondition != null ? stringCondition.build() : null;
        }

        @Override
        public final Builder stringCondition(StringCondition stringCondition) {
            this.stringCondition = stringCondition;
            return this;
        }

        public final ListCondition.Builder getListCondition() {
            return this.listCondition != null ? this.listCondition.toBuilder() : null;
        }

        public final void setListCondition(ListCondition.BuilderImpl listCondition) {
            this.listCondition = listCondition != null ? listCondition.build() : null;
        }

        @Override
        public final Builder listCondition(ListCondition listCondition) {
            this.listCondition = listCondition;
            return this;
        }

        public final HierarchyGroupCondition.Builder getHierarchyGroupCondition() {
            return this.hierarchyGroupCondition != null ? this.hierarchyGroupCondition.toBuilder() : null;
        }

        public final void setHierarchyGroupCondition(HierarchyGroupCondition.BuilderImpl hierarchyGroupCondition) {
            this.hierarchyGroupCondition = hierarchyGroupCondition != null ? hierarchyGroupCondition.build() : null;
        }

        @Override
        public final Builder hierarchyGroupCondition(HierarchyGroupCondition hierarchyGroupCondition) {
            this.hierarchyGroupCondition = hierarchyGroupCondition;
            return this;
        }

        public UserSearchCriteria build() {
            return new UserSearchCriteria(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UserSearchCriteria> {
        public Builder orConditions(Collection<UserSearchCriteria> var1);

        public Builder orConditions(UserSearchCriteria ... var1);

        public Builder orConditions(Consumer<Builder> ... var1);

        public Builder andConditions(Collection<UserSearchCriteria> var1);

        public Builder andConditions(UserSearchCriteria ... var1);

        public Builder andConditions(Consumer<Builder> ... var1);

        public Builder stringCondition(StringCondition var1);

        default public Builder stringCondition(Consumer<StringCondition.Builder> stringCondition) {
            return this.stringCondition((StringCondition)((StringCondition.Builder)StringCondition.builder().applyMutation(stringCondition)).build());
        }

        public Builder listCondition(ListCondition var1);

        default public Builder listCondition(Consumer<ListCondition.Builder> listCondition) {
            return this.listCondition((ListCondition)((ListCondition.Builder)ListCondition.builder().applyMutation(listCondition)).build());
        }

        public Builder hierarchyGroupCondition(HierarchyGroupCondition var1);

        default public Builder hierarchyGroupCondition(Consumer<HierarchyGroupCondition.Builder> hierarchyGroupCondition) {
            return this.hierarchyGroupCondition((HierarchyGroupCondition)((HierarchyGroupCondition.Builder)HierarchyGroupCondition.builder().applyMutation(hierarchyGroupCondition)).build());
        }
    }
}

