/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.FailureReasonCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FailedRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FailedRequest> {
    private static final SdkField<String> REQUEST_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestIdentifier").getter(FailedRequest.getter(FailedRequest::requestIdentifier)).setter(FailedRequest.setter(Builder::requestIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestIdentifier").build()}).build();
    private static final SdkField<String> FAILURE_REASON_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReasonCode").getter(FailedRequest.getter(FailedRequest::failureReasonCodeAsString)).setter(FailedRequest.setter(Builder::failureReasonCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReasonCode").build()}).build();
    private static final SdkField<String> FAILURE_REASON_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReasonMessage").getter(FailedRequest.getter(FailedRequest::failureReasonMessage)).setter(FailedRequest.setter(Builder::failureReasonMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReasonMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_IDENTIFIER_FIELD, FAILURE_REASON_CODE_FIELD, FAILURE_REASON_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("RequestIdentifier", REQUEST_IDENTIFIER_FIELD);
            this.put("FailureReasonCode", FAILURE_REASON_CODE_FIELD);
            this.put("FailureReasonMessage", FAILURE_REASON_MESSAGE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String requestIdentifier;
    private final String failureReasonCode;
    private final String failureReasonMessage;

    private FailedRequest(BuilderImpl builder) {
        this.requestIdentifier = builder.requestIdentifier;
        this.failureReasonCode = builder.failureReasonCode;
        this.failureReasonMessage = builder.failureReasonMessage;
    }

    public final String requestIdentifier() {
        return this.requestIdentifier;
    }

    public final FailureReasonCode failureReasonCode() {
        return FailureReasonCode.fromValue(this.failureReasonCode);
    }

    public final String failureReasonCodeAsString() {
        return this.failureReasonCode;
    }

    public final String failureReasonMessage() {
        return this.failureReasonMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.requestIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReasonCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReasonMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailedRequest)) {
            return false;
        }
        FailedRequest other = (FailedRequest)obj;
        return Objects.equals(this.requestIdentifier(), other.requestIdentifier()) && Objects.equals(this.failureReasonCodeAsString(), other.failureReasonCodeAsString()) && Objects.equals(this.failureReasonMessage(), other.failureReasonMessage());
    }

    public final String toString() {
        return ToString.builder((String)"FailedRequest").add("RequestIdentifier", (Object)this.requestIdentifier()).add("FailureReasonCode", (Object)this.failureReasonCodeAsString()).add("FailureReasonMessage", (Object)this.failureReasonMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RequestIdentifier": {
                return Optional.ofNullable(clazz.cast(this.requestIdentifier()));
            }
            case "FailureReasonCode": {
                return Optional.ofNullable(clazz.cast(this.failureReasonCodeAsString()));
            }
            case "FailureReasonMessage": {
                return Optional.ofNullable(clazz.cast(this.failureReasonMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FailedRequest, T> g) {
        return obj -> g.apply((FailedRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String requestIdentifier;
        private String failureReasonCode;
        private String failureReasonMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(FailedRequest model) {
            this.requestIdentifier(model.requestIdentifier);
            this.failureReasonCode(model.failureReasonCode);
            this.failureReasonMessage(model.failureReasonMessage);
        }

        public final String getRequestIdentifier() {
            return this.requestIdentifier;
        }

        public final void setRequestIdentifier(String requestIdentifier) {
            this.requestIdentifier = requestIdentifier;
        }

        @Override
        public final Builder requestIdentifier(String requestIdentifier) {
            this.requestIdentifier = requestIdentifier;
            return this;
        }

        public final String getFailureReasonCode() {
            return this.failureReasonCode;
        }

        public final void setFailureReasonCode(String failureReasonCode) {
            this.failureReasonCode = failureReasonCode;
        }

        @Override
        public final Builder failureReasonCode(String failureReasonCode) {
            this.failureReasonCode = failureReasonCode;
            return this;
        }

        @Override
        public final Builder failureReasonCode(FailureReasonCode failureReasonCode) {
            this.failureReasonCode(failureReasonCode == null ? null : failureReasonCode.toString());
            return this;
        }

        public final String getFailureReasonMessage() {
            return this.failureReasonMessage;
        }

        public final void setFailureReasonMessage(String failureReasonMessage) {
            this.failureReasonMessage = failureReasonMessage;
        }

        @Override
        public final Builder failureReasonMessage(String failureReasonMessage) {
            this.failureReasonMessage = failureReasonMessage;
            return this;
        }

        public FailedRequest build() {
            return new FailedRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FailedRequest> {
        public Builder requestIdentifier(String var1);

        public Builder failureReasonCode(String var1);

        public Builder failureReasonCode(FailureReasonCode var1);

        public Builder failureReasonMessage(String var1);
    }
}

