/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.HoursOfOperationDays;
import software.amazon.awssdk.services.connect.model.HoursOfOperationTimeSlice;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HoursOfOperationConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HoursOfOperationConfig> {
    private static final SdkField<String> DAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Day").getter(HoursOfOperationConfig.getter(HoursOfOperationConfig::dayAsString)).setter(HoursOfOperationConfig.setter(Builder::day)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Day").build()}).build();
    private static final SdkField<HoursOfOperationTimeSlice> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StartTime").getter(HoursOfOperationConfig.getter(HoursOfOperationConfig::startTime)).setter(HoursOfOperationConfig.setter(Builder::startTime)).constructor(HoursOfOperationTimeSlice::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<HoursOfOperationTimeSlice> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EndTime").getter(HoursOfOperationConfig.getter(HoursOfOperationConfig::endTime)).setter(HoursOfOperationConfig.setter(Builder::endTime)).constructor(HoursOfOperationTimeSlice::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DAY_FIELD, START_TIME_FIELD, END_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Day", DAY_FIELD);
            this.put("StartTime", START_TIME_FIELD);
            this.put("EndTime", END_TIME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String day;
    private final HoursOfOperationTimeSlice startTime;
    private final HoursOfOperationTimeSlice endTime;

    private HoursOfOperationConfig(BuilderImpl builder) {
        this.day = builder.day;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    public final HoursOfOperationDays day() {
        return HoursOfOperationDays.fromValue(this.day);
    }

    public final String dayAsString() {
        return this.day;
    }

    public final HoursOfOperationTimeSlice startTime() {
        return this.startTime;
    }

    public final HoursOfOperationTimeSlice endTime() {
        return this.endTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dayAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HoursOfOperationConfig)) {
            return false;
        }
        HoursOfOperationConfig other = (HoursOfOperationConfig)obj;
        return Objects.equals(this.dayAsString(), other.dayAsString()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime());
    }

    public final String toString() {
        return ToString.builder((String)"HoursOfOperationConfig").add("Day", (Object)this.dayAsString()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Day": {
                return Optional.ofNullable(clazz.cast(this.dayAsString()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<HoursOfOperationConfig, T> g) {
        return obj -> g.apply((HoursOfOperationConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String day;
        private HoursOfOperationTimeSlice startTime;
        private HoursOfOperationTimeSlice endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(HoursOfOperationConfig model) {
            this.day(model.day);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
        }

        public final String getDay() {
            return this.day;
        }

        public final void setDay(String day) {
            this.day = day;
        }

        @Override
        public final Builder day(String day) {
            this.day = day;
            return this;
        }

        @Override
        public final Builder day(HoursOfOperationDays day) {
            this.day(day == null ? null : day.toString());
            return this;
        }

        public final HoursOfOperationTimeSlice.Builder getStartTime() {
            return this.startTime != null ? this.startTime.toBuilder() : null;
        }

        public final void setStartTime(HoursOfOperationTimeSlice.BuilderImpl startTime) {
            this.startTime = startTime != null ? startTime.build() : null;
        }

        @Override
        public final Builder startTime(HoursOfOperationTimeSlice startTime) {
            this.startTime = startTime;
            return this;
        }

        public final HoursOfOperationTimeSlice.Builder getEndTime() {
            return this.endTime != null ? this.endTime.toBuilder() : null;
        }

        public final void setEndTime(HoursOfOperationTimeSlice.BuilderImpl endTime) {
            this.endTime = endTime != null ? endTime.build() : null;
        }

        @Override
        public final Builder endTime(HoursOfOperationTimeSlice endTime) {
            this.endTime = endTime;
            return this;
        }

        public HoursOfOperationConfig build() {
            return new HoursOfOperationConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HoursOfOperationConfig> {
        public Builder day(String var1);

        public Builder day(HoursOfOperationDays var1);

        public Builder startTime(HoursOfOperationTimeSlice var1);

        default public Builder startTime(Consumer<HoursOfOperationTimeSlice.Builder> startTime) {
            return this.startTime((HoursOfOperationTimeSlice)((HoursOfOperationTimeSlice.Builder)HoursOfOperationTimeSlice.builder().applyMutation(startTime)).build());
        }

        public Builder endTime(HoursOfOperationTimeSlice var1);

        default public Builder endTime(Consumer<HoursOfOperationTimeSlice.Builder> endTime) {
            return this.endTime((HoursOfOperationTimeSlice)((HoursOfOperationTimeSlice.Builder)HoursOfOperationTimeSlice.builder().applyMutation(endTime)).build());
        }
    }
}

