/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ReferenceStatus;
import software.amazon.awssdk.services.connect.model.ReferenceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Reference
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Reference> {
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Value").getter(Reference.getter(Reference::value)).setter(Reference.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(Reference.getter(Reference::typeAsString)).setter(Reference.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Reference.getter(Reference::statusAsString)).setter(Reference.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(Reference.getter(Reference::arn)).setter(Reference.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusReason").getter(Reference.getter(Reference::statusReason)).setter(Reference.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, TYPE_FIELD, STATUS_FIELD, ARN_FIELD, STATUS_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Value", VALUE_FIELD);
            this.put("Type", TYPE_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("Arn", ARN_FIELD);
            this.put("StatusReason", STATUS_REASON_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String value;
    private final String type;
    private final String status;
    private final String arn;
    private final String statusReason;

    private Reference(BuilderImpl builder) {
        this.value = builder.value;
        this.type = builder.type;
        this.status = builder.status;
        this.arn = builder.arn;
        this.statusReason = builder.statusReason;
    }

    public final String value() {
        return this.value;
    }

    public final ReferenceType type() {
        return ReferenceType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final ReferenceStatus status() {
        return ReferenceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String arn() {
        return this.arn;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Reference)) {
            return false;
        }
        Reference other = (Reference)obj;
        return Objects.equals(this.value(), other.value()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.statusReason(), other.statusReason());
    }

    public final String toString() {
        return ToString.builder((String)"Reference").add("Value", (Object)this.value()).add("Type", (Object)this.typeAsString()).add("Status", (Object)this.statusAsString()).add("Arn", (Object)this.arn()).add("StatusReason", (Object)this.statusReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "StatusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Reference, T> g) {
        return obj -> g.apply((Reference)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String value;
        private String type;
        private String status;
        private String arn;
        private String statusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(Reference model) {
            this.value(model.value);
            this.type(model.type);
            this.status(model.status);
            this.arn(model.arn);
            this.statusReason(model.statusReason);
        }

        public final String getValue() {
            return this.value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ReferenceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReferenceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public Reference build() {
            return new Reference(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Reference> {
        public Builder value(String var1);

        public Builder type(String var1);

        public Builder type(ReferenceType var1);

        public Builder status(String var1);

        public Builder status(ReferenceStatus var1);

        public Builder arn(String var1);

        public Builder statusReason(String var1);
    }
}

