/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.ContactFlow;
import software.amazon.awssdk.services.connect.model.ContactFlowSearchSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchContactFlowsResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, SearchContactFlowsResponse> {
    private static final SdkField<List<ContactFlow>> CONTACT_FLOWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContactFlows").getter(SearchContactFlowsResponse.getter(SearchContactFlowsResponse::contactFlows)).setter(SearchContactFlowsResponse.setter(Builder::contactFlows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactFlows").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContactFlow::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(SearchContactFlowsResponse.getter(SearchContactFlowsResponse::nextToken)).setter(SearchContactFlowsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Long> APPROXIMATE_TOTAL_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ApproximateTotalCount").getter(SearchContactFlowsResponse.getter(SearchContactFlowsResponse::approximateTotalCount)).setter(SearchContactFlowsResponse.setter(Builder::approximateTotalCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproximateTotalCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_FLOWS_FIELD, NEXT_TOKEN_FIELD, APPROXIMATE_TOTAL_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ContactFlows", CONTACT_FLOWS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("ApproximateTotalCount", APPROXIMATE_TOTAL_COUNT_FIELD);
        }
    });
    private final List<ContactFlow> contactFlows;
    private final String nextToken;
    private final Long approximateTotalCount;

    private SearchContactFlowsResponse(BuilderImpl builder) {
        super(builder);
        this.contactFlows = builder.contactFlows;
        this.nextToken = builder.nextToken;
        this.approximateTotalCount = builder.approximateTotalCount;
    }

    public final boolean hasContactFlows() {
        return this.contactFlows != null && !(this.contactFlows instanceof SdkAutoConstructList);
    }

    public final List<ContactFlow> contactFlows() {
        return this.contactFlows;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Long approximateTotalCount() {
        return this.approximateTotalCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContactFlows() ? this.contactFlows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.approximateTotalCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchContactFlowsResponse)) {
            return false;
        }
        SearchContactFlowsResponse other = (SearchContactFlowsResponse)((Object)obj);
        return this.hasContactFlows() == other.hasContactFlows() && Objects.equals(this.contactFlows(), other.contactFlows()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.approximateTotalCount(), other.approximateTotalCount());
    }

    public final String toString() {
        return ToString.builder((String)"SearchContactFlowsResponse").add("ContactFlows", this.hasContactFlows() ? this.contactFlows() : null).add("NextToken", (Object)this.nextToken()).add("ApproximateTotalCount", (Object)this.approximateTotalCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContactFlows": {
                return Optional.ofNullable(clazz.cast(this.contactFlows()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ApproximateTotalCount": {
                return Optional.ofNullable(clazz.cast(this.approximateTotalCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SearchContactFlowsResponse, T> g) {
        return obj -> g.apply((SearchContactFlowsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<ContactFlow> contactFlows = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Long approximateTotalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchContactFlowsResponse model) {
            super(model);
            this.contactFlows(model.contactFlows);
            this.nextToken(model.nextToken);
            this.approximateTotalCount(model.approximateTotalCount);
        }

        public final List<ContactFlow.Builder> getContactFlows() {
            List<ContactFlow.Builder> result = ContactFlowSearchSummaryListCopier.copyToBuilder(this.contactFlows);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContactFlows(Collection<ContactFlow.BuilderImpl> contactFlows) {
            this.contactFlows = ContactFlowSearchSummaryListCopier.copyFromBuilder(contactFlows);
        }

        @Override
        public final Builder contactFlows(Collection<ContactFlow> contactFlows) {
            this.contactFlows = ContactFlowSearchSummaryListCopier.copy(contactFlows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contactFlows(ContactFlow ... contactFlows) {
            this.contactFlows(Arrays.asList(contactFlows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contactFlows(Consumer<ContactFlow.Builder> ... contactFlows) {
            this.contactFlows(Stream.of(contactFlows).map(c -> (ContactFlow)((ContactFlow.Builder)ContactFlow.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Long getApproximateTotalCount() {
            return this.approximateTotalCount;
        }

        public final void setApproximateTotalCount(Long approximateTotalCount) {
            this.approximateTotalCount = approximateTotalCount;
        }

        @Override
        public final Builder approximateTotalCount(Long approximateTotalCount) {
            this.approximateTotalCount = approximateTotalCount;
            return this;
        }

        @Override
        public SearchContactFlowsResponse build() {
            return new SearchContactFlowsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchContactFlowsResponse> {
        public Builder contactFlows(Collection<ContactFlow> var1);

        public Builder contactFlows(ContactFlow ... var1);

        public Builder contactFlows(Consumer<ContactFlow.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder approximateTotalCount(Long var1);
    }
}

