/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.AttributesCopier;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.ContactReferencesCopier;
import software.amazon.awssdk.services.connect.model.EmailAddressInfo;
import software.amazon.awssdk.services.connect.model.EmailAttachment;
import software.amazon.awssdk.services.connect.model.EmailAttachmentsCopier;
import software.amazon.awssdk.services.connect.model.InboundAdditionalRecipients;
import software.amazon.awssdk.services.connect.model.InboundEmailContent;
import software.amazon.awssdk.services.connect.model.Reference;
import software.amazon.awssdk.services.connect.model.SegmentAttributeValue;
import software.amazon.awssdk.services.connect.model.SegmentAttributesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartEmailContactRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, StartEmailContactRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(StartEmailContactRequest.getter(StartEmailContactRequest::instanceId)).setter(StartEmailContactRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<EmailAddressInfo> FROM_EMAIL_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FromEmailAddress").getter(StartEmailContactRequest.getter(StartEmailContactRequest::fromEmailAddress)).setter(StartEmailContactRequest.setter(Builder::fromEmailAddress)).constructor(EmailAddressInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromEmailAddress").build()}).build();
    private static final SdkField<String> DESTINATION_EMAIL_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationEmailAddress").getter(StartEmailContactRequest.getter(StartEmailContactRequest::destinationEmailAddress)).setter(StartEmailContactRequest.setter(Builder::destinationEmailAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationEmailAddress").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(StartEmailContactRequest.getter(StartEmailContactRequest::description)).setter(StartEmailContactRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Map<String, Reference>> REFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("References").getter(StartEmailContactRequest.getter(StartEmailContactRequest::references)).setter(StartEmailContactRequest.setter(Builder::references)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("References").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Reference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(StartEmailContactRequest.getter(StartEmailContactRequest::name)).setter(StartEmailContactRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<InboundEmailContent> EMAIL_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EmailMessage").getter(StartEmailContactRequest.getter(StartEmailContactRequest::emailMessage)).setter(StartEmailContactRequest.setter(Builder::emailMessage)).constructor(InboundEmailContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailMessage").build()}).build();
    private static final SdkField<InboundAdditionalRecipients> ADDITIONAL_RECIPIENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AdditionalRecipients").getter(StartEmailContactRequest.getter(StartEmailContactRequest::additionalRecipients)).setter(StartEmailContactRequest.setter(Builder::additionalRecipients)).constructor(InboundAdditionalRecipients::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalRecipients").build()}).build();
    private static final SdkField<List<EmailAttachment>> ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Attachments").getter(StartEmailContactRequest.getter(StartEmailContactRequest::attachments)).setter(StartEmailContactRequest.setter(Builder::attachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attachments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EmailAttachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONTACT_FLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactFlowId").getter(StartEmailContactRequest.getter(StartEmailContactRequest::contactFlowId)).setter(StartEmailContactRequest.setter(Builder::contactFlowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactFlowId").build()}).build();
    private static final SdkField<String> RELATED_CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RelatedContactId").getter(StartEmailContactRequest.getter(StartEmailContactRequest::relatedContactId)).setter(StartEmailContactRequest.setter(Builder::relatedContactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedContactId").build()}).build();
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Attributes").getter(StartEmailContactRequest.getter(StartEmailContactRequest::attributes)).setter(StartEmailContactRequest.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, SegmentAttributeValue>> SEGMENT_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("SegmentAttributes").getter(StartEmailContactRequest.getter(StartEmailContactRequest::segmentAttributes)).setter(StartEmailContactRequest.setter(Builder::segmentAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SegmentAttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(StartEmailContactRequest.getter(StartEmailContactRequest::clientToken)).setter(StartEmailContactRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, FROM_EMAIL_ADDRESS_FIELD, DESTINATION_EMAIL_ADDRESS_FIELD, DESCRIPTION_FIELD, REFERENCES_FIELD, NAME_FIELD, EMAIL_MESSAGE_FIELD, ADDITIONAL_RECIPIENTS_FIELD, ATTACHMENTS_FIELD, CONTACT_FLOW_ID_FIELD, RELATED_CONTACT_ID_FIELD, ATTRIBUTES_FIELD, SEGMENT_ATTRIBUTES_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("InstanceId", INSTANCE_ID_FIELD);
            this.put("FromEmailAddress", FROM_EMAIL_ADDRESS_FIELD);
            this.put("DestinationEmailAddress", DESTINATION_EMAIL_ADDRESS_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("References", REFERENCES_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("EmailMessage", EMAIL_MESSAGE_FIELD);
            this.put("AdditionalRecipients", ADDITIONAL_RECIPIENTS_FIELD);
            this.put("Attachments", ATTACHMENTS_FIELD);
            this.put("ContactFlowId", CONTACT_FLOW_ID_FIELD);
            this.put("RelatedContactId", RELATED_CONTACT_ID_FIELD);
            this.put("Attributes", ATTRIBUTES_FIELD);
            this.put("SegmentAttributes", SEGMENT_ATTRIBUTES_FIELD);
            this.put("ClientToken", CLIENT_TOKEN_FIELD);
        }
    });
    private final String instanceId;
    private final EmailAddressInfo fromEmailAddress;
    private final String destinationEmailAddress;
    private final String description;
    private final Map<String, Reference> references;
    private final String name;
    private final InboundEmailContent emailMessage;
    private final InboundAdditionalRecipients additionalRecipients;
    private final List<EmailAttachment> attachments;
    private final String contactFlowId;
    private final String relatedContactId;
    private final Map<String, String> attributes;
    private final Map<String, SegmentAttributeValue> segmentAttributes;
    private final String clientToken;

    private StartEmailContactRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.fromEmailAddress = builder.fromEmailAddress;
        this.destinationEmailAddress = builder.destinationEmailAddress;
        this.description = builder.description;
        this.references = builder.references;
        this.name = builder.name;
        this.emailMessage = builder.emailMessage;
        this.additionalRecipients = builder.additionalRecipients;
        this.attachments = builder.attachments;
        this.contactFlowId = builder.contactFlowId;
        this.relatedContactId = builder.relatedContactId;
        this.attributes = builder.attributes;
        this.segmentAttributes = builder.segmentAttributes;
        this.clientToken = builder.clientToken;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final EmailAddressInfo fromEmailAddress() {
        return this.fromEmailAddress;
    }

    public final String destinationEmailAddress() {
        return this.destinationEmailAddress;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasReferences() {
        return this.references != null && !(this.references instanceof SdkAutoConstructMap);
    }

    public final Map<String, Reference> references() {
        return this.references;
    }

    public final String name() {
        return this.name;
    }

    public final InboundEmailContent emailMessage() {
        return this.emailMessage;
    }

    public final InboundAdditionalRecipients additionalRecipients() {
        return this.additionalRecipients;
    }

    public final boolean hasAttachments() {
        return this.attachments != null && !(this.attachments instanceof SdkAutoConstructList);
    }

    public final List<EmailAttachment> attachments() {
        return this.attachments;
    }

    public final String contactFlowId() {
        return this.contactFlowId;
    }

    public final String relatedContactId() {
        return this.relatedContactId;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> attributes() {
        return this.attributes;
    }

    public final boolean hasSegmentAttributes() {
        return this.segmentAttributes != null && !(this.segmentAttributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, SegmentAttributeValue> segmentAttributes() {
        return this.segmentAttributes;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fromEmailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationEmailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReferences() ? this.references() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalRecipients());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttachments() ? this.attachments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.contactFlowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.relatedContactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSegmentAttributes() ? this.segmentAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartEmailContactRequest)) {
            return false;
        }
        StartEmailContactRequest other = (StartEmailContactRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.fromEmailAddress(), other.fromEmailAddress()) && Objects.equals(this.destinationEmailAddress(), other.destinationEmailAddress()) && Objects.equals(this.description(), other.description()) && this.hasReferences() == other.hasReferences() && Objects.equals(this.references(), other.references()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.emailMessage(), other.emailMessage()) && Objects.equals(this.additionalRecipients(), other.additionalRecipients()) && this.hasAttachments() == other.hasAttachments() && Objects.equals(this.attachments(), other.attachments()) && Objects.equals(this.contactFlowId(), other.contactFlowId()) && Objects.equals(this.relatedContactId(), other.relatedContactId()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && this.hasSegmentAttributes() == other.hasSegmentAttributes() && Objects.equals(this.segmentAttributes(), other.segmentAttributes()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"StartEmailContactRequest").add("InstanceId", (Object)this.instanceId()).add("FromEmailAddress", (Object)this.fromEmailAddress()).add("DestinationEmailAddress", (Object)(this.destinationEmailAddress() == null ? null : "*** Sensitive Data Redacted ***")).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("References", this.hasReferences() ? this.references() : null).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("EmailMessage", (Object)this.emailMessage()).add("AdditionalRecipients", (Object)this.additionalRecipients()).add("Attachments", (Object)(this.attachments() == null ? null : "*** Sensitive Data Redacted ***")).add("ContactFlowId", (Object)this.contactFlowId()).add("RelatedContactId", (Object)this.relatedContactId()).add("Attributes", this.hasAttributes() ? this.attributes() : null).add("SegmentAttributes", this.hasSegmentAttributes() ? this.segmentAttributes() : null).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "FromEmailAddress": {
                return Optional.ofNullable(clazz.cast(this.fromEmailAddress()));
            }
            case "DestinationEmailAddress": {
                return Optional.ofNullable(clazz.cast(this.destinationEmailAddress()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "References": {
                return Optional.ofNullable(clazz.cast(this.references()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "EmailMessage": {
                return Optional.ofNullable(clazz.cast(this.emailMessage()));
            }
            case "AdditionalRecipients": {
                return Optional.ofNullable(clazz.cast(this.additionalRecipients()));
            }
            case "Attachments": {
                return Optional.ofNullable(clazz.cast(this.attachments()));
            }
            case "ContactFlowId": {
                return Optional.ofNullable(clazz.cast(this.contactFlowId()));
            }
            case "RelatedContactId": {
                return Optional.ofNullable(clazz.cast(this.relatedContactId()));
            }
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "SegmentAttributes": {
                return Optional.ofNullable(clazz.cast(this.segmentAttributes()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartEmailContactRequest, T> g) {
        return obj -> g.apply((StartEmailContactRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private EmailAddressInfo fromEmailAddress;
        private String destinationEmailAddress;
        private String description;
        private Map<String, Reference> references = DefaultSdkAutoConstructMap.getInstance();
        private String name;
        private InboundEmailContent emailMessage;
        private InboundAdditionalRecipients additionalRecipients;
        private List<EmailAttachment> attachments = DefaultSdkAutoConstructList.getInstance();
        private String contactFlowId;
        private String relatedContactId;
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, SegmentAttributeValue> segmentAttributes = DefaultSdkAutoConstructMap.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartEmailContactRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.fromEmailAddress(model.fromEmailAddress);
            this.destinationEmailAddress(model.destinationEmailAddress);
            this.description(model.description);
            this.references(model.references);
            this.name(model.name);
            this.emailMessage(model.emailMessage);
            this.additionalRecipients(model.additionalRecipients);
            this.attachments(model.attachments);
            this.contactFlowId(model.contactFlowId);
            this.relatedContactId(model.relatedContactId);
            this.attributes(model.attributes);
            this.segmentAttributes(model.segmentAttributes);
            this.clientToken(model.clientToken);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final EmailAddressInfo.Builder getFromEmailAddress() {
            return this.fromEmailAddress != null ? this.fromEmailAddress.toBuilder() : null;
        }

        public final void setFromEmailAddress(EmailAddressInfo.BuilderImpl fromEmailAddress) {
            this.fromEmailAddress = fromEmailAddress != null ? fromEmailAddress.build() : null;
        }

        @Override
        public final Builder fromEmailAddress(EmailAddressInfo fromEmailAddress) {
            this.fromEmailAddress = fromEmailAddress;
            return this;
        }

        public final String getDestinationEmailAddress() {
            return this.destinationEmailAddress;
        }

        public final void setDestinationEmailAddress(String destinationEmailAddress) {
            this.destinationEmailAddress = destinationEmailAddress;
        }

        @Override
        public final Builder destinationEmailAddress(String destinationEmailAddress) {
            this.destinationEmailAddress = destinationEmailAddress;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, Reference.Builder> getReferences() {
            Map<String, Reference.Builder> result = ContactReferencesCopier.copyToBuilder(this.references);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setReferences(Map<String, Reference.BuilderImpl> references) {
            this.references = ContactReferencesCopier.copyFromBuilder(references);
        }

        @Override
        public final Builder references(Map<String, Reference> references) {
            this.references = ContactReferencesCopier.copy(references);
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final InboundEmailContent.Builder getEmailMessage() {
            return this.emailMessage != null ? this.emailMessage.toBuilder() : null;
        }

        public final void setEmailMessage(InboundEmailContent.BuilderImpl emailMessage) {
            this.emailMessage = emailMessage != null ? emailMessage.build() : null;
        }

        @Override
        public final Builder emailMessage(InboundEmailContent emailMessage) {
            this.emailMessage = emailMessage;
            return this;
        }

        public final InboundAdditionalRecipients.Builder getAdditionalRecipients() {
            return this.additionalRecipients != null ? this.additionalRecipients.toBuilder() : null;
        }

        public final void setAdditionalRecipients(InboundAdditionalRecipients.BuilderImpl additionalRecipients) {
            this.additionalRecipients = additionalRecipients != null ? additionalRecipients.build() : null;
        }

        @Override
        public final Builder additionalRecipients(InboundAdditionalRecipients additionalRecipients) {
            this.additionalRecipients = additionalRecipients;
            return this;
        }

        public final List<EmailAttachment.Builder> getAttachments() {
            List<EmailAttachment.Builder> result = EmailAttachmentsCopier.copyToBuilder(this.attachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttachments(Collection<EmailAttachment.BuilderImpl> attachments) {
            this.attachments = EmailAttachmentsCopier.copyFromBuilder(attachments);
        }

        @Override
        public final Builder attachments(Collection<EmailAttachment> attachments) {
            this.attachments = EmailAttachmentsCopier.copy(attachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(EmailAttachment ... attachments) {
            this.attachments(Arrays.asList(attachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(Consumer<EmailAttachment.Builder> ... attachments) {
            this.attachments(Stream.of(attachments).map(c -> (EmailAttachment)((EmailAttachment.Builder)EmailAttachment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getContactFlowId() {
            return this.contactFlowId;
        }

        public final void setContactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
        }

        @Override
        public final Builder contactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
            return this;
        }

        public final String getRelatedContactId() {
            return this.relatedContactId;
        }

        public final void setRelatedContactId(String relatedContactId) {
            this.relatedContactId = relatedContactId;
        }

        @Override
        public final Builder relatedContactId(String relatedContactId) {
            this.relatedContactId = relatedContactId;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (this.attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final Map<String, SegmentAttributeValue.Builder> getSegmentAttributes() {
            Map<String, SegmentAttributeValue.Builder> result = SegmentAttributesCopier.copyToBuilder(this.segmentAttributes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setSegmentAttributes(Map<String, SegmentAttributeValue.BuilderImpl> segmentAttributes) {
            this.segmentAttributes = SegmentAttributesCopier.copyFromBuilder(segmentAttributes);
        }

        @Override
        public final Builder segmentAttributes(Map<String, SegmentAttributeValue> segmentAttributes) {
            this.segmentAttributes = SegmentAttributesCopier.copy(segmentAttributes);
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartEmailContactRequest build() {
            return new StartEmailContactRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartEmailContactRequest> {
        public Builder instanceId(String var1);

        public Builder fromEmailAddress(EmailAddressInfo var1);

        default public Builder fromEmailAddress(Consumer<EmailAddressInfo.Builder> fromEmailAddress) {
            return this.fromEmailAddress((EmailAddressInfo)((EmailAddressInfo.Builder)EmailAddressInfo.builder().applyMutation(fromEmailAddress)).build());
        }

        public Builder destinationEmailAddress(String var1);

        public Builder description(String var1);

        public Builder references(Map<String, Reference> var1);

        public Builder name(String var1);

        public Builder emailMessage(InboundEmailContent var1);

        default public Builder emailMessage(Consumer<InboundEmailContent.Builder> emailMessage) {
            return this.emailMessage((InboundEmailContent)((InboundEmailContent.Builder)InboundEmailContent.builder().applyMutation(emailMessage)).build());
        }

        public Builder additionalRecipients(InboundAdditionalRecipients var1);

        default public Builder additionalRecipients(Consumer<InboundAdditionalRecipients.Builder> additionalRecipients) {
            return this.additionalRecipients((InboundAdditionalRecipients)((InboundAdditionalRecipients.Builder)InboundAdditionalRecipients.builder().applyMutation(additionalRecipients)).build());
        }

        public Builder attachments(Collection<EmailAttachment> var1);

        public Builder attachments(EmailAttachment ... var1);

        public Builder attachments(Consumer<EmailAttachment.Builder> ... var1);

        public Builder contactFlowId(String var1);

        public Builder relatedContactId(String var1);

        public Builder attributes(Map<String, String> var1);

        public Builder segmentAttributes(Map<String, SegmentAttributeValue> var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

