/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.EmailAddressInfo;
import software.amazon.awssdk.services.connect.model.OutboundAdditionalRecipients;
import software.amazon.awssdk.services.connect.model.OutboundEmailContent;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartOutboundEmailContactRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, StartOutboundEmailContactRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(StartOutboundEmailContactRequest.getter(StartOutboundEmailContactRequest::instanceId)).setter(StartOutboundEmailContactRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactId").getter(StartOutboundEmailContactRequest.getter(StartOutboundEmailContactRequest::contactId)).setter(StartOutboundEmailContactRequest.setter(Builder::contactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactId").build()}).build();
    private static final SdkField<EmailAddressInfo> FROM_EMAIL_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FromEmailAddress").getter(StartOutboundEmailContactRequest.getter(StartOutboundEmailContactRequest::fromEmailAddress)).setter(StartOutboundEmailContactRequest.setter(Builder::fromEmailAddress)).constructor(EmailAddressInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromEmailAddress").build()}).build();
    private static final SdkField<EmailAddressInfo> DESTINATION_EMAIL_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DestinationEmailAddress").getter(StartOutboundEmailContactRequest.getter(StartOutboundEmailContactRequest::destinationEmailAddress)).setter(StartOutboundEmailContactRequest.setter(Builder::destinationEmailAddress)).constructor(EmailAddressInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationEmailAddress").build()}).build();
    private static final SdkField<OutboundAdditionalRecipients> ADDITIONAL_RECIPIENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AdditionalRecipients").getter(StartOutboundEmailContactRequest.getter(StartOutboundEmailContactRequest::additionalRecipients)).setter(StartOutboundEmailContactRequest.setter(Builder::additionalRecipients)).constructor(OutboundAdditionalRecipients::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalRecipients").build()}).build();
    private static final SdkField<OutboundEmailContent> EMAIL_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EmailMessage").getter(StartOutboundEmailContactRequest.getter(StartOutboundEmailContactRequest::emailMessage)).setter(StartOutboundEmailContactRequest.setter(Builder::emailMessage)).constructor(OutboundEmailContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailMessage").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(StartOutboundEmailContactRequest.getter(StartOutboundEmailContactRequest::clientToken)).setter(StartOutboundEmailContactRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, CONTACT_ID_FIELD, FROM_EMAIL_ADDRESS_FIELD, DESTINATION_EMAIL_ADDRESS_FIELD, ADDITIONAL_RECIPIENTS_FIELD, EMAIL_MESSAGE_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("InstanceId", INSTANCE_ID_FIELD);
            this.put("ContactId", CONTACT_ID_FIELD);
            this.put("FromEmailAddress", FROM_EMAIL_ADDRESS_FIELD);
            this.put("DestinationEmailAddress", DESTINATION_EMAIL_ADDRESS_FIELD);
            this.put("AdditionalRecipients", ADDITIONAL_RECIPIENTS_FIELD);
            this.put("EmailMessage", EMAIL_MESSAGE_FIELD);
            this.put("ClientToken", CLIENT_TOKEN_FIELD);
        }
    });
    private final String instanceId;
    private final String contactId;
    private final EmailAddressInfo fromEmailAddress;
    private final EmailAddressInfo destinationEmailAddress;
    private final OutboundAdditionalRecipients additionalRecipients;
    private final OutboundEmailContent emailMessage;
    private final String clientToken;

    private StartOutboundEmailContactRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.contactId = builder.contactId;
        this.fromEmailAddress = builder.fromEmailAddress;
        this.destinationEmailAddress = builder.destinationEmailAddress;
        this.additionalRecipients = builder.additionalRecipients;
        this.emailMessage = builder.emailMessage;
        this.clientToken = builder.clientToken;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String contactId() {
        return this.contactId;
    }

    public final EmailAddressInfo fromEmailAddress() {
        return this.fromEmailAddress;
    }

    public final EmailAddressInfo destinationEmailAddress() {
        return this.destinationEmailAddress;
    }

    public final OutboundAdditionalRecipients additionalRecipients() {
        return this.additionalRecipients;
    }

    public final OutboundEmailContent emailMessage() {
        return this.emailMessage;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fromEmailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationEmailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalRecipients());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartOutboundEmailContactRequest)) {
            return false;
        }
        StartOutboundEmailContactRequest other = (StartOutboundEmailContactRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.contactId(), other.contactId()) && Objects.equals(this.fromEmailAddress(), other.fromEmailAddress()) && Objects.equals(this.destinationEmailAddress(), other.destinationEmailAddress()) && Objects.equals(this.additionalRecipients(), other.additionalRecipients()) && Objects.equals(this.emailMessage(), other.emailMessage()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"StartOutboundEmailContactRequest").add("InstanceId", (Object)this.instanceId()).add("ContactId", (Object)this.contactId()).add("FromEmailAddress", (Object)this.fromEmailAddress()).add("DestinationEmailAddress", (Object)this.destinationEmailAddress()).add("AdditionalRecipients", (Object)this.additionalRecipients()).add("EmailMessage", (Object)this.emailMessage()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "ContactId": {
                return Optional.ofNullable(clazz.cast(this.contactId()));
            }
            case "FromEmailAddress": {
                return Optional.ofNullable(clazz.cast(this.fromEmailAddress()));
            }
            case "DestinationEmailAddress": {
                return Optional.ofNullable(clazz.cast(this.destinationEmailAddress()));
            }
            case "AdditionalRecipients": {
                return Optional.ofNullable(clazz.cast(this.additionalRecipients()));
            }
            case "EmailMessage": {
                return Optional.ofNullable(clazz.cast(this.emailMessage()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartOutboundEmailContactRequest, T> g) {
        return obj -> g.apply((StartOutboundEmailContactRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String contactId;
        private EmailAddressInfo fromEmailAddress;
        private EmailAddressInfo destinationEmailAddress;
        private OutboundAdditionalRecipients additionalRecipients;
        private OutboundEmailContent emailMessage;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartOutboundEmailContactRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.contactId(model.contactId);
            this.fromEmailAddress(model.fromEmailAddress);
            this.destinationEmailAddress(model.destinationEmailAddress);
            this.additionalRecipients(model.additionalRecipients);
            this.emailMessage(model.emailMessage);
            this.clientToken(model.clientToken);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getContactId() {
            return this.contactId;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        @Override
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        public final EmailAddressInfo.Builder getFromEmailAddress() {
            return this.fromEmailAddress != null ? this.fromEmailAddress.toBuilder() : null;
        }

        public final void setFromEmailAddress(EmailAddressInfo.BuilderImpl fromEmailAddress) {
            this.fromEmailAddress = fromEmailAddress != null ? fromEmailAddress.build() : null;
        }

        @Override
        public final Builder fromEmailAddress(EmailAddressInfo fromEmailAddress) {
            this.fromEmailAddress = fromEmailAddress;
            return this;
        }

        public final EmailAddressInfo.Builder getDestinationEmailAddress() {
            return this.destinationEmailAddress != null ? this.destinationEmailAddress.toBuilder() : null;
        }

        public final void setDestinationEmailAddress(EmailAddressInfo.BuilderImpl destinationEmailAddress) {
            this.destinationEmailAddress = destinationEmailAddress != null ? destinationEmailAddress.build() : null;
        }

        @Override
        public final Builder destinationEmailAddress(EmailAddressInfo destinationEmailAddress) {
            this.destinationEmailAddress = destinationEmailAddress;
            return this;
        }

        public final OutboundAdditionalRecipients.Builder getAdditionalRecipients() {
            return this.additionalRecipients != null ? this.additionalRecipients.toBuilder() : null;
        }

        public final void setAdditionalRecipients(OutboundAdditionalRecipients.BuilderImpl additionalRecipients) {
            this.additionalRecipients = additionalRecipients != null ? additionalRecipients.build() : null;
        }

        @Override
        public final Builder additionalRecipients(OutboundAdditionalRecipients additionalRecipients) {
            this.additionalRecipients = additionalRecipients;
            return this;
        }

        public final OutboundEmailContent.Builder getEmailMessage() {
            return this.emailMessage != null ? this.emailMessage.toBuilder() : null;
        }

        public final void setEmailMessage(OutboundEmailContent.BuilderImpl emailMessage) {
            this.emailMessage = emailMessage != null ? emailMessage.build() : null;
        }

        @Override
        public final Builder emailMessage(OutboundEmailContent emailMessage) {
            this.emailMessage = emailMessage;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartOutboundEmailContactRequest build() {
            return new StartOutboundEmailContactRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartOutboundEmailContactRequest> {
        public Builder instanceId(String var1);

        public Builder contactId(String var1);

        public Builder fromEmailAddress(EmailAddressInfo var1);

        default public Builder fromEmailAddress(Consumer<EmailAddressInfo.Builder> fromEmailAddress) {
            return this.fromEmailAddress((EmailAddressInfo)((EmailAddressInfo.Builder)EmailAddressInfo.builder().applyMutation(fromEmailAddress)).build());
        }

        public Builder destinationEmailAddress(EmailAddressInfo var1);

        default public Builder destinationEmailAddress(Consumer<EmailAddressInfo.Builder> destinationEmailAddress) {
            return this.destinationEmailAddress((EmailAddressInfo)((EmailAddressInfo.Builder)EmailAddressInfo.builder().applyMutation(destinationEmailAddress)).build());
        }

        public Builder additionalRecipients(OutboundAdditionalRecipients var1);

        default public Builder additionalRecipients(Consumer<OutboundAdditionalRecipients.Builder> additionalRecipients) {
            return this.additionalRecipients((OutboundAdditionalRecipients)((OutboundAdditionalRecipients.Builder)OutboundAdditionalRecipients.builder().applyMutation(additionalRecipients)).build());
        }

        public Builder emailMessage(OutboundEmailContent var1);

        default public Builder emailMessage(Consumer<OutboundEmailContent.Builder> emailMessage) {
            return this.emailMessage((OutboundEmailContent)((OutboundEmailContent.Builder)OutboundEmailContent.builder().applyMutation(emailMessage)).build());
        }

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

