/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * List of additional email addresses for an email contact.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AdditionalEmailRecipients implements SdkPojo, Serializable,
        ToCopyableBuilder<AdditionalEmailRecipients.Builder, AdditionalEmailRecipients> {
    private static final SdkField<List<EmailRecipient>> TO_LIST_FIELD = SdkField
            .<List<EmailRecipient>> builder(MarshallingType.LIST)
            .memberName("ToList")
            .getter(getter(AdditionalEmailRecipients::toList))
            .setter(setter(Builder::toList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EmailRecipient> builder(MarshallingType.SDK_POJO)
                                            .constructor(EmailRecipient::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<EmailRecipient>> CC_LIST_FIELD = SdkField
            .<List<EmailRecipient>> builder(MarshallingType.LIST)
            .memberName("CcList")
            .getter(getter(AdditionalEmailRecipients::ccList))
            .setter(setter(Builder::ccList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CcList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EmailRecipient> builder(MarshallingType.SDK_POJO)
                                            .constructor(EmailRecipient::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TO_LIST_FIELD, CC_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<EmailRecipient> toList;

    private final List<EmailRecipient> ccList;

    private AdditionalEmailRecipients(BuilderImpl builder) {
        this.toList = builder.toList;
        this.ccList = builder.ccList;
    }

    /**
     * For responses, this returns true if the service returned a value for the ToList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasToList() {
        return toList != null && !(toList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of additional TO email recipients for an email contact.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasToList} method.
     * </p>
     * 
     * @return List of additional TO email recipients for an email contact.
     */
    public final List<EmailRecipient> toList() {
        return toList;
    }

    /**
     * For responses, this returns true if the service returned a value for the CcList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCcList() {
        return ccList != null && !(ccList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of additional CC email recipients for an email contact.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCcList} method.
     * </p>
     * 
     * @return List of additional CC email recipients for an email contact.
     */
    public final List<EmailRecipient> ccList() {
        return ccList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasToList() ? toList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCcList() ? ccList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdditionalEmailRecipients)) {
            return false;
        }
        AdditionalEmailRecipients other = (AdditionalEmailRecipients) obj;
        return hasToList() == other.hasToList() && Objects.equals(toList(), other.toList()) && hasCcList() == other.hasCcList()
                && Objects.equals(ccList(), other.ccList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AdditionalEmailRecipients").add("ToList", hasToList() ? toList() : null)
                .add("CcList", hasCcList() ? ccList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ToList":
            return Optional.ofNullable(clazz.cast(toList()));
        case "CcList":
            return Optional.ofNullable(clazz.cast(ccList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ToList", TO_LIST_FIELD);
        map.put("CcList", CC_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AdditionalEmailRecipients, T> g) {
        return obj -> g.apply((AdditionalEmailRecipients) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AdditionalEmailRecipients> {
        /**
         * <p>
         * List of additional TO email recipients for an email contact.
         * </p>
         * 
         * @param toList
         *        List of additional TO email recipients for an email contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toList(Collection<EmailRecipient> toList);

        /**
         * <p>
         * List of additional TO email recipients for an email contact.
         * </p>
         * 
         * @param toList
         *        List of additional TO email recipients for an email contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toList(EmailRecipient... toList);

        /**
         * <p>
         * List of additional TO email recipients for an email contact.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.EmailRecipient.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.connect.model.EmailRecipient#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.EmailRecipient.Builder#build()} is called immediately
         * and its result is passed to {@link #toList(List<EmailRecipient>)}.
         * 
         * @param toList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.EmailRecipient.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #toList(java.util.Collection<EmailRecipient>)
         */
        Builder toList(Consumer<EmailRecipient.Builder>... toList);

        /**
         * <p>
         * List of additional CC email recipients for an email contact.
         * </p>
         * 
         * @param ccList
         *        List of additional CC email recipients for an email contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ccList(Collection<EmailRecipient> ccList);

        /**
         * <p>
         * List of additional CC email recipients for an email contact.
         * </p>
         * 
         * @param ccList
         *        List of additional CC email recipients for an email contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ccList(EmailRecipient... ccList);

        /**
         * <p>
         * List of additional CC email recipients for an email contact.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.EmailRecipient.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.connect.model.EmailRecipient#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.EmailRecipient.Builder#build()} is called immediately
         * and its result is passed to {@link #ccList(List<EmailRecipient>)}.
         * 
         * @param ccList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.EmailRecipient.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ccList(java.util.Collection<EmailRecipient>)
         */
        Builder ccList(Consumer<EmailRecipient.Builder>... ccList);
    }

    static final class BuilderImpl implements Builder {
        private List<EmailRecipient> toList = DefaultSdkAutoConstructList.getInstance();

        private List<EmailRecipient> ccList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AdditionalEmailRecipients model) {
            toList(model.toList);
            ccList(model.ccList);
        }

        public final List<EmailRecipient.Builder> getToList() {
            List<EmailRecipient.Builder> result = EmailRecipientsListCopier.copyToBuilder(this.toList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setToList(Collection<EmailRecipient.BuilderImpl> toList) {
            this.toList = EmailRecipientsListCopier.copyFromBuilder(toList);
        }

        @Override
        public final Builder toList(Collection<EmailRecipient> toList) {
            this.toList = EmailRecipientsListCopier.copy(toList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder toList(EmailRecipient... toList) {
            toList(Arrays.asList(toList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder toList(Consumer<EmailRecipient.Builder>... toList) {
            toList(Stream.of(toList).map(c -> EmailRecipient.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<EmailRecipient.Builder> getCcList() {
            List<EmailRecipient.Builder> result = EmailRecipientsListCopier.copyToBuilder(this.ccList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCcList(Collection<EmailRecipient.BuilderImpl> ccList) {
            this.ccList = EmailRecipientsListCopier.copyFromBuilder(ccList);
        }

        @Override
        public final Builder ccList(Collection<EmailRecipient> ccList) {
            this.ccList = EmailRecipientsListCopier.copy(ccList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ccList(EmailRecipient... ccList) {
            ccList(Arrays.asList(ccList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ccList(Consumer<EmailRecipient.Builder>... ccList) {
            ccList(Stream.of(ccList).map(c -> EmailRecipient.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public AdditionalEmailRecipients build() {
            return new AdditionalEmailRecipients(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
