/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that defines search criteria for contacts using agent hierarchy group levels. For more information about
 * agent hierarchies, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/agent-hierarchy.html">Set Up
 * Agent Hierarchies</a> in the <i>Amazon Connect Administrator Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AgentHierarchyGroups implements SdkPojo, Serializable,
        ToCopyableBuilder<AgentHierarchyGroups.Builder, AgentHierarchyGroups> {
    private static final SdkField<List<String>> L1_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("L1Ids")
            .getter(getter(AgentHierarchyGroups::l1Ids))
            .setter(setter(Builder::l1Ids))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("L1Ids").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> L2_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("L2Ids")
            .getter(getter(AgentHierarchyGroups::l2Ids))
            .setter(setter(Builder::l2Ids))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("L2Ids").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> L3_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("L3Ids")
            .getter(getter(AgentHierarchyGroups::l3Ids))
            .setter(setter(Builder::l3Ids))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("L3Ids").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> L4_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("L4Ids")
            .getter(getter(AgentHierarchyGroups::l4Ids))
            .setter(setter(Builder::l4Ids))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("L4Ids").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> L5_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("L5Ids")
            .getter(getter(AgentHierarchyGroups::l5Ids))
            .setter(setter(Builder::l5Ids))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("L5Ids").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(L1_IDS_FIELD, L2_IDS_FIELD,
            L3_IDS_FIELD, L4_IDS_FIELD, L5_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> l1Ids;

    private final List<String> l2Ids;

    private final List<String> l3Ids;

    private final List<String> l4Ids;

    private final List<String> l5Ids;

    private AgentHierarchyGroups(BuilderImpl builder) {
        this.l1Ids = builder.l1Ids;
        this.l2Ids = builder.l2Ids;
        this.l3Ids = builder.l3Ids;
        this.l4Ids = builder.l4Ids;
        this.l5Ids = builder.l5Ids;
    }

    /**
     * For responses, this returns true if the service returned a value for the L1Ids property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasL1Ids() {
        return l1Ids != null && !(l1Ids instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifiers for level 1 hierarchy groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasL1Ids} method.
     * </p>
     * 
     * @return The identifiers for level 1 hierarchy groups.
     */
    public final List<String> l1Ids() {
        return l1Ids;
    }

    /**
     * For responses, this returns true if the service returned a value for the L2Ids property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasL2Ids() {
        return l2Ids != null && !(l2Ids instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifiers for level 2 hierarchy groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasL2Ids} method.
     * </p>
     * 
     * @return The identifiers for level 2 hierarchy groups.
     */
    public final List<String> l2Ids() {
        return l2Ids;
    }

    /**
     * For responses, this returns true if the service returned a value for the L3Ids property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasL3Ids() {
        return l3Ids != null && !(l3Ids instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifiers for level 3 hierarchy groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasL3Ids} method.
     * </p>
     * 
     * @return The identifiers for level 3 hierarchy groups.
     */
    public final List<String> l3Ids() {
        return l3Ids;
    }

    /**
     * For responses, this returns true if the service returned a value for the L4Ids property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasL4Ids() {
        return l4Ids != null && !(l4Ids instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifiers for level 4 hierarchy groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasL4Ids} method.
     * </p>
     * 
     * @return The identifiers for level 4 hierarchy groups.
     */
    public final List<String> l4Ids() {
        return l4Ids;
    }

    /**
     * For responses, this returns true if the service returned a value for the L5Ids property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasL5Ids() {
        return l5Ids != null && !(l5Ids instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifiers for level 5 hierarchy groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasL5Ids} method.
     * </p>
     * 
     * @return The identifiers for level 5 hierarchy groups.
     */
    public final List<String> l5Ids() {
        return l5Ids;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasL1Ids() ? l1Ids() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasL2Ids() ? l2Ids() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasL3Ids() ? l3Ids() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasL4Ids() ? l4Ids() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasL5Ids() ? l5Ids() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentHierarchyGroups)) {
            return false;
        }
        AgentHierarchyGroups other = (AgentHierarchyGroups) obj;
        return hasL1Ids() == other.hasL1Ids() && Objects.equals(l1Ids(), other.l1Ids()) && hasL2Ids() == other.hasL2Ids()
                && Objects.equals(l2Ids(), other.l2Ids()) && hasL3Ids() == other.hasL3Ids()
                && Objects.equals(l3Ids(), other.l3Ids()) && hasL4Ids() == other.hasL4Ids()
                && Objects.equals(l4Ids(), other.l4Ids()) && hasL5Ids() == other.hasL5Ids()
                && Objects.equals(l5Ids(), other.l5Ids());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AgentHierarchyGroups").add("L1Ids", hasL1Ids() ? l1Ids() : null)
                .add("L2Ids", hasL2Ids() ? l2Ids() : null).add("L3Ids", hasL3Ids() ? l3Ids() : null)
                .add("L4Ids", hasL4Ids() ? l4Ids() : null).add("L5Ids", hasL5Ids() ? l5Ids() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "L1Ids":
            return Optional.ofNullable(clazz.cast(l1Ids()));
        case "L2Ids":
            return Optional.ofNullable(clazz.cast(l2Ids()));
        case "L3Ids":
            return Optional.ofNullable(clazz.cast(l3Ids()));
        case "L4Ids":
            return Optional.ofNullable(clazz.cast(l4Ids()));
        case "L5Ids":
            return Optional.ofNullable(clazz.cast(l5Ids()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("L1Ids", L1_IDS_FIELD);
        map.put("L2Ids", L2_IDS_FIELD);
        map.put("L3Ids", L3_IDS_FIELD);
        map.put("L4Ids", L4_IDS_FIELD);
        map.put("L5Ids", L5_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AgentHierarchyGroups, T> g) {
        return obj -> g.apply((AgentHierarchyGroups) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AgentHierarchyGroups> {
        /**
         * <p>
         * The identifiers for level 1 hierarchy groups.
         * </p>
         * 
         * @param l1Ids
         *        The identifiers for level 1 hierarchy groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder l1Ids(Collection<String> l1Ids);

        /**
         * <p>
         * The identifiers for level 1 hierarchy groups.
         * </p>
         * 
         * @param l1Ids
         *        The identifiers for level 1 hierarchy groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder l1Ids(String... l1Ids);

        /**
         * <p>
         * The identifiers for level 2 hierarchy groups.
         * </p>
         * 
         * @param l2Ids
         *        The identifiers for level 2 hierarchy groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder l2Ids(Collection<String> l2Ids);

        /**
         * <p>
         * The identifiers for level 2 hierarchy groups.
         * </p>
         * 
         * @param l2Ids
         *        The identifiers for level 2 hierarchy groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder l2Ids(String... l2Ids);

        /**
         * <p>
         * The identifiers for level 3 hierarchy groups.
         * </p>
         * 
         * @param l3Ids
         *        The identifiers for level 3 hierarchy groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder l3Ids(Collection<String> l3Ids);

        /**
         * <p>
         * The identifiers for level 3 hierarchy groups.
         * </p>
         * 
         * @param l3Ids
         *        The identifiers for level 3 hierarchy groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder l3Ids(String... l3Ids);

        /**
         * <p>
         * The identifiers for level 4 hierarchy groups.
         * </p>
         * 
         * @param l4Ids
         *        The identifiers for level 4 hierarchy groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder l4Ids(Collection<String> l4Ids);

        /**
         * <p>
         * The identifiers for level 4 hierarchy groups.
         * </p>
         * 
         * @param l4Ids
         *        The identifiers for level 4 hierarchy groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder l4Ids(String... l4Ids);

        /**
         * <p>
         * The identifiers for level 5 hierarchy groups.
         * </p>
         * 
         * @param l5Ids
         *        The identifiers for level 5 hierarchy groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder l5Ids(Collection<String> l5Ids);

        /**
         * <p>
         * The identifiers for level 5 hierarchy groups.
         * </p>
         * 
         * @param l5Ids
         *        The identifiers for level 5 hierarchy groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder l5Ids(String... l5Ids);
    }

    static final class BuilderImpl implements Builder {
        private List<String> l1Ids = DefaultSdkAutoConstructList.getInstance();

        private List<String> l2Ids = DefaultSdkAutoConstructList.getInstance();

        private List<String> l3Ids = DefaultSdkAutoConstructList.getInstance();

        private List<String> l4Ids = DefaultSdkAutoConstructList.getInstance();

        private List<String> l5Ids = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AgentHierarchyGroups model) {
            l1Ids(model.l1Ids);
            l2Ids(model.l2Ids);
            l3Ids(model.l3Ids);
            l4Ids(model.l4Ids);
            l5Ids(model.l5Ids);
        }

        public final Collection<String> getL1Ids() {
            if (l1Ids instanceof SdkAutoConstructList) {
                return null;
            }
            return l1Ids;
        }

        public final void setL1Ids(Collection<String> l1Ids) {
            this.l1Ids = HierarchyGroupIdListCopier.copy(l1Ids);
        }

        @Override
        public final Builder l1Ids(Collection<String> l1Ids) {
            this.l1Ids = HierarchyGroupIdListCopier.copy(l1Ids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder l1Ids(String... l1Ids) {
            l1Ids(Arrays.asList(l1Ids));
            return this;
        }

        public final Collection<String> getL2Ids() {
            if (l2Ids instanceof SdkAutoConstructList) {
                return null;
            }
            return l2Ids;
        }

        public final void setL2Ids(Collection<String> l2Ids) {
            this.l2Ids = HierarchyGroupIdListCopier.copy(l2Ids);
        }

        @Override
        public final Builder l2Ids(Collection<String> l2Ids) {
            this.l2Ids = HierarchyGroupIdListCopier.copy(l2Ids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder l2Ids(String... l2Ids) {
            l2Ids(Arrays.asList(l2Ids));
            return this;
        }

        public final Collection<String> getL3Ids() {
            if (l3Ids instanceof SdkAutoConstructList) {
                return null;
            }
            return l3Ids;
        }

        public final void setL3Ids(Collection<String> l3Ids) {
            this.l3Ids = HierarchyGroupIdListCopier.copy(l3Ids);
        }

        @Override
        public final Builder l3Ids(Collection<String> l3Ids) {
            this.l3Ids = HierarchyGroupIdListCopier.copy(l3Ids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder l3Ids(String... l3Ids) {
            l3Ids(Arrays.asList(l3Ids));
            return this;
        }

        public final Collection<String> getL4Ids() {
            if (l4Ids instanceof SdkAutoConstructList) {
                return null;
            }
            return l4Ids;
        }

        public final void setL4Ids(Collection<String> l4Ids) {
            this.l4Ids = HierarchyGroupIdListCopier.copy(l4Ids);
        }

        @Override
        public final Builder l4Ids(Collection<String> l4Ids) {
            this.l4Ids = HierarchyGroupIdListCopier.copy(l4Ids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder l4Ids(String... l4Ids) {
            l4Ids(Arrays.asList(l4Ids));
            return this;
        }

        public final Collection<String> getL5Ids() {
            if (l5Ids instanceof SdkAutoConstructList) {
                return null;
            }
            return l5Ids;
        }

        public final void setL5Ids(Collection<String> l5Ids) {
            this.l5Ids = HierarchyGroupIdListCopier.copy(l5Ids);
        }

        @Override
        public final Builder l5Ids(Collection<String> l5Ids) {
            this.l5Ids = HierarchyGroupIdListCopier.copy(l5Ids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder l5Ids(String... l5Ids) {
            l5Ids(Arrays.asList(l5Ids));
            return this;
        }

        @Override
        public AgentHierarchyGroups build() {
            return new AgentHierarchyGroups(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
