/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the agent's status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AgentStatusReference implements SdkPojo, Serializable,
        ToCopyableBuilder<AgentStatusReference.Builder, AgentStatusReference> {
    private static final SdkField<Instant> STATUS_START_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StatusStartTimestamp").getter(getter(AgentStatusReference::statusStartTimestamp))
            .setter(setter(Builder::statusStartTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusStartTimestamp").build())
            .build();

    private static final SdkField<String> STATUS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusArn").getter(getter(AgentStatusReference::statusArn)).setter(setter(Builder::statusArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusArn").build()).build();

    private static final SdkField<String> STATUS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusName").getter(getter(AgentStatusReference::statusName)).setter(setter(Builder::statusName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_START_TIMESTAMP_FIELD,
            STATUS_ARN_FIELD, STATUS_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant statusStartTimestamp;

    private final String statusArn;

    private final String statusName;

    private AgentStatusReference(BuilderImpl builder) {
        this.statusStartTimestamp = builder.statusStartTimestamp;
        this.statusArn = builder.statusArn;
        this.statusName = builder.statusName;
    }

    /**
     * <p>
     * The start timestamp of the agent's status.
     * </p>
     * 
     * @return The start timestamp of the agent's status.
     */
    public final Instant statusStartTimestamp() {
        return statusStartTimestamp;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the agent's status.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the agent's status.
     */
    public final String statusArn() {
        return statusArn;
    }

    /**
     * <p>
     * The name of the agent status.
     * </p>
     * 
     * @return The name of the agent status.
     */
    public final String statusName() {
        return statusName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusStartTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(statusArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentStatusReference)) {
            return false;
        }
        AgentStatusReference other = (AgentStatusReference) obj;
        return Objects.equals(statusStartTimestamp(), other.statusStartTimestamp())
                && Objects.equals(statusArn(), other.statusArn()) && Objects.equals(statusName(), other.statusName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AgentStatusReference").add("StatusStartTimestamp", statusStartTimestamp())
                .add("StatusArn", statusArn()).add("StatusName", statusName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StatusStartTimestamp":
            return Optional.ofNullable(clazz.cast(statusStartTimestamp()));
        case "StatusArn":
            return Optional.ofNullable(clazz.cast(statusArn()));
        case "StatusName":
            return Optional.ofNullable(clazz.cast(statusName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StatusStartTimestamp", STATUS_START_TIMESTAMP_FIELD);
        map.put("StatusArn", STATUS_ARN_FIELD);
        map.put("StatusName", STATUS_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AgentStatusReference, T> g) {
        return obj -> g.apply((AgentStatusReference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AgentStatusReference> {
        /**
         * <p>
         * The start timestamp of the agent's status.
         * </p>
         * 
         * @param statusStartTimestamp
         *        The start timestamp of the agent's status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusStartTimestamp(Instant statusStartTimestamp);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the agent's status.
         * </p>
         * 
         * @param statusArn
         *        The Amazon Resource Name (ARN) of the agent's status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusArn(String statusArn);

        /**
         * <p>
         * The name of the agent status.
         * </p>
         * 
         * @param statusName
         *        The name of the agent status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusName(String statusName);
    }

    static final class BuilderImpl implements Builder {
        private Instant statusStartTimestamp;

        private String statusArn;

        private String statusName;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentStatusReference model) {
            statusStartTimestamp(model.statusStartTimestamp);
            statusArn(model.statusArn);
            statusName(model.statusName);
        }

        public final Instant getStatusStartTimestamp() {
            return statusStartTimestamp;
        }

        public final void setStatusStartTimestamp(Instant statusStartTimestamp) {
            this.statusStartTimestamp = statusStartTimestamp;
        }

        @Override
        public final Builder statusStartTimestamp(Instant statusStartTimestamp) {
            this.statusStartTimestamp = statusStartTimestamp;
            return this;
        }

        public final String getStatusArn() {
            return statusArn;
        }

        public final void setStatusArn(String statusArn) {
            this.statusArn = statusArn;
        }

        @Override
        public final Builder statusArn(String statusArn) {
            this.statusArn = statusArn;
            return this;
        }

        public final String getStatusName() {
            return statusName;
        }

        public final void setStatusName(String statusName) {
            this.statusName = statusName;
        }

        @Override
        public final Builder statusName(String statusName) {
            this.statusName = statusName;
            return this;
        }

        @Override
        public AgentStatusReference build() {
            return new AgentStatusReference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
