/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Filters to be applied to search results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AgentStatusSearchFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<AgentStatusSearchFilter.Builder, AgentStatusSearchFilter> {
    private static final SdkField<ControlPlaneAttributeFilter> ATTRIBUTE_FILTER_FIELD = SdkField
            .<ControlPlaneAttributeFilter> builder(MarshallingType.SDK_POJO).memberName("AttributeFilter")
            .getter(getter(AgentStatusSearchFilter::attributeFilter)).setter(setter(Builder::attributeFilter))
            .constructor(ControlPlaneAttributeFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeFilter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_FILTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ControlPlaneAttributeFilter attributeFilter;

    private AgentStatusSearchFilter(BuilderImpl builder) {
        this.attributeFilter = builder.attributeFilter;
    }

    /**
     * <p>
     * An object that can be used to specify Tag conditions inside the <code>SearchFilter</code>. This accepts an
     * <code>OR</code> of <code>AND</code> (List of List) input where:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The top level list specifies conditions that need to be applied with <code>OR</code> operator.
     * </p>
     * </li>
     * <li>
     * <p>
     * The inner list specifies conditions that need to be applied with <code>AND</code> operator.
     * </p>
     * </li>
     * </ul>
     * 
     * @return An object that can be used to specify Tag conditions inside the <code>SearchFilter</code>. This accepts
     *         an <code>OR</code> of <code>AND</code> (List of List) input where: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The top level list specifies conditions that need to be applied with <code>OR</code> operator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The inner list specifies conditions that need to be applied with <code>AND</code> operator.
     *         </p>
     *         </li>
     */
    public final ControlPlaneAttributeFilter attributeFilter() {
        return attributeFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributeFilter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentStatusSearchFilter)) {
            return false;
        }
        AgentStatusSearchFilter other = (AgentStatusSearchFilter) obj;
        return Objects.equals(attributeFilter(), other.attributeFilter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AgentStatusSearchFilter").add("AttributeFilter", attributeFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttributeFilter":
            return Optional.ofNullable(clazz.cast(attributeFilter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AttributeFilter", ATTRIBUTE_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AgentStatusSearchFilter, T> g) {
        return obj -> g.apply((AgentStatusSearchFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AgentStatusSearchFilter> {
        /**
         * <p>
         * An object that can be used to specify Tag conditions inside the <code>SearchFilter</code>. This accepts an
         * <code>OR</code> of <code>AND</code> (List of List) input where:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The top level list specifies conditions that need to be applied with <code>OR</code> operator.
         * </p>
         * </li>
         * <li>
         * <p>
         * The inner list specifies conditions that need to be applied with <code>AND</code> operator.
         * </p>
         * </li>
         * </ul>
         * 
         * @param attributeFilter
         *        An object that can be used to specify Tag conditions inside the <code>SearchFilter</code>. This
         *        accepts an <code>OR</code> of <code>AND</code> (List of List) input where: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The top level list specifies conditions that need to be applied with <code>OR</code> operator.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The inner list specifies conditions that need to be applied with <code>AND</code> operator.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeFilter(ControlPlaneAttributeFilter attributeFilter);

        /**
         * <p>
         * An object that can be used to specify Tag conditions inside the <code>SearchFilter</code>. This accepts an
         * <code>OR</code> of <code>AND</code> (List of List) input where:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The top level list specifies conditions that need to be applied with <code>OR</code> operator.
         * </p>
         * </li>
         * <li>
         * <p>
         * The inner list specifies conditions that need to be applied with <code>AND</code> operator.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link ControlPlaneAttributeFilter.Builder}
         * avoiding the need to create one manually via {@link ControlPlaneAttributeFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ControlPlaneAttributeFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #attributeFilter(ControlPlaneAttributeFilter)}.
         * 
         * @param attributeFilter
         *        a consumer that will call methods on {@link ControlPlaneAttributeFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributeFilter(ControlPlaneAttributeFilter)
         */
        default Builder attributeFilter(Consumer<ControlPlaneAttributeFilter.Builder> attributeFilter) {
            return attributeFilter(ControlPlaneAttributeFilter.builder().applyMutation(attributeFilter).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ControlPlaneAttributeFilter attributeFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentStatusSearchFilter model) {
            attributeFilter(model.attributeFilter);
        }

        public final ControlPlaneAttributeFilter.Builder getAttributeFilter() {
            return attributeFilter != null ? attributeFilter.toBuilder() : null;
        }

        public final void setAttributeFilter(ControlPlaneAttributeFilter.BuilderImpl attributeFilter) {
            this.attributeFilter = attributeFilter != null ? attributeFilter.build() : null;
        }

        @Override
        public final Builder attributeFilter(ControlPlaneAttributeFilter attributeFilter) {
            this.attributeFilter = attributeFilter;
            return this;
        }

        @Override
        public AgentStatusSearchFilter build() {
            return new AgentStatusSearchFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
