/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the capabilities enabled for participants of the contact.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AllowedCapabilities implements SdkPojo, Serializable,
        ToCopyableBuilder<AllowedCapabilities.Builder, AllowedCapabilities> {
    private static final SdkField<ParticipantCapabilities> CUSTOMER_FIELD = SdkField
            .<ParticipantCapabilities> builder(MarshallingType.SDK_POJO).memberName("Customer")
            .getter(getter(AllowedCapabilities::customer)).setter(setter(Builder::customer))
            .constructor(ParticipantCapabilities::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Customer").build()).build();

    private static final SdkField<ParticipantCapabilities> AGENT_FIELD = SdkField
            .<ParticipantCapabilities> builder(MarshallingType.SDK_POJO).memberName("Agent")
            .getter(getter(AllowedCapabilities::agent)).setter(setter(Builder::agent))
            .constructor(ParticipantCapabilities::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Agent").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOMER_FIELD, AGENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ParticipantCapabilities customer;

    private final ParticipantCapabilities agent;

    private AllowedCapabilities(BuilderImpl builder) {
        this.customer = builder.customer;
        this.agent = builder.agent;
    }

    /**
     * <p>
     * Information about the customer's video sharing capabilities.
     * </p>
     * 
     * @return Information about the customer's video sharing capabilities.
     */
    public final ParticipantCapabilities customer() {
        return customer;
    }

    /**
     * <p>
     * Information about the agent's video sharing capabilities.
     * </p>
     * 
     * @return Information about the agent's video sharing capabilities.
     */
    public final ParticipantCapabilities agent() {
        return agent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customer());
        hashCode = 31 * hashCode + Objects.hashCode(agent());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllowedCapabilities)) {
            return false;
        }
        AllowedCapabilities other = (AllowedCapabilities) obj;
        return Objects.equals(customer(), other.customer()) && Objects.equals(agent(), other.agent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AllowedCapabilities").add("Customer", customer()).add("Agent", agent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Customer":
            return Optional.ofNullable(clazz.cast(customer()));
        case "Agent":
            return Optional.ofNullable(clazz.cast(agent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Customer", CUSTOMER_FIELD);
        map.put("Agent", AGENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AllowedCapabilities, T> g) {
        return obj -> g.apply((AllowedCapabilities) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AllowedCapabilities> {
        /**
         * <p>
         * Information about the customer's video sharing capabilities.
         * </p>
         * 
         * @param customer
         *        Information about the customer's video sharing capabilities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customer(ParticipantCapabilities customer);

        /**
         * <p>
         * Information about the customer's video sharing capabilities.
         * </p>
         * This is a convenience method that creates an instance of the {@link ParticipantCapabilities.Builder} avoiding
         * the need to create one manually via {@link ParticipantCapabilities#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParticipantCapabilities.Builder#build()} is called immediately
         * and its result is passed to {@link #customer(ParticipantCapabilities)}.
         * 
         * @param customer
         *        a consumer that will call methods on {@link ParticipantCapabilities.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customer(ParticipantCapabilities)
         */
        default Builder customer(Consumer<ParticipantCapabilities.Builder> customer) {
            return customer(ParticipantCapabilities.builder().applyMutation(customer).build());
        }

        /**
         * <p>
         * Information about the agent's video sharing capabilities.
         * </p>
         * 
         * @param agent
         *        Information about the agent's video sharing capabilities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agent(ParticipantCapabilities agent);

        /**
         * <p>
         * Information about the agent's video sharing capabilities.
         * </p>
         * This is a convenience method that creates an instance of the {@link ParticipantCapabilities.Builder} avoiding
         * the need to create one manually via {@link ParticipantCapabilities#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParticipantCapabilities.Builder#build()} is called immediately
         * and its result is passed to {@link #agent(ParticipantCapabilities)}.
         * 
         * @param agent
         *        a consumer that will call methods on {@link ParticipantCapabilities.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agent(ParticipantCapabilities)
         */
        default Builder agent(Consumer<ParticipantCapabilities.Builder> agent) {
            return agent(ParticipantCapabilities.builder().applyMutation(agent).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ParticipantCapabilities customer;

        private ParticipantCapabilities agent;

        private BuilderImpl() {
        }

        private BuilderImpl(AllowedCapabilities model) {
            customer(model.customer);
            agent(model.agent);
        }

        public final ParticipantCapabilities.Builder getCustomer() {
            return customer != null ? customer.toBuilder() : null;
        }

        public final void setCustomer(ParticipantCapabilities.BuilderImpl customer) {
            this.customer = customer != null ? customer.build() : null;
        }

        @Override
        public final Builder customer(ParticipantCapabilities customer) {
            this.customer = customer;
            return this;
        }

        public final ParticipantCapabilities.Builder getAgent() {
            return agent != null ? agent.toBuilder() : null;
        }

        public final void setAgent(ParticipantCapabilities.BuilderImpl agent) {
            this.agent = agent != null ? agent.build() : null;
        }

        @Override
        public final Builder agent(ParticipantCapabilities agent) {
            this.agent = agent;
            return this;
        }

        @Override
        public AllowedCapabilities build() {
            return new AllowedCapabilities(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
