/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Has audio-specific configurations as the operating parameter for Echo Reduction.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AudioFeatures implements SdkPojo, Serializable, ToCopyableBuilder<AudioFeatures.Builder, AudioFeatures> {
    private static final SdkField<String> ECHO_REDUCTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EchoReduction").getter(getter(AudioFeatures::echoReductionAsString))
            .setter(setter(Builder::echoReduction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EchoReduction").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ECHO_REDUCTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String echoReduction;

    private AudioFeatures(BuilderImpl builder) {
        this.echoReduction = builder.echoReduction;
    }

    /**
     * <p>
     * Makes echo reduction available to clients who connect to the meeting.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #echoReduction}
     * will return {@link MeetingFeatureStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #echoReductionAsString}.
     * </p>
     * 
     * @return Makes echo reduction available to clients who connect to the meeting.
     * @see MeetingFeatureStatus
     */
    public final MeetingFeatureStatus echoReduction() {
        return MeetingFeatureStatus.fromValue(echoReduction);
    }

    /**
     * <p>
     * Makes echo reduction available to clients who connect to the meeting.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #echoReduction}
     * will return {@link MeetingFeatureStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #echoReductionAsString}.
     * </p>
     * 
     * @return Makes echo reduction available to clients who connect to the meeting.
     * @see MeetingFeatureStatus
     */
    public final String echoReductionAsString() {
        return echoReduction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(echoReductionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioFeatures)) {
            return false;
        }
        AudioFeatures other = (AudioFeatures) obj;
        return Objects.equals(echoReductionAsString(), other.echoReductionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AudioFeatures").add("EchoReduction", echoReductionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EchoReduction":
            return Optional.ofNullable(clazz.cast(echoReductionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EchoReduction", ECHO_REDUCTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AudioFeatures, T> g) {
        return obj -> g.apply((AudioFeatures) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AudioFeatures> {
        /**
         * <p>
         * Makes echo reduction available to clients who connect to the meeting.
         * </p>
         * 
         * @param echoReduction
         *        Makes echo reduction available to clients who connect to the meeting.
         * @see MeetingFeatureStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MeetingFeatureStatus
         */
        Builder echoReduction(String echoReduction);

        /**
         * <p>
         * Makes echo reduction available to clients who connect to the meeting.
         * </p>
         * 
         * @param echoReduction
         *        Makes echo reduction available to clients who connect to the meeting.
         * @see MeetingFeatureStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MeetingFeatureStatus
         */
        Builder echoReduction(MeetingFeatureStatus echoReduction);
    }

    static final class BuilderImpl implements Builder {
        private String echoReduction;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioFeatures model) {
            echoReduction(model.echoReduction);
        }

        public final String getEchoReduction() {
            return echoReduction;
        }

        public final void setEchoReduction(String echoReduction) {
            this.echoReduction = echoReduction;
        }

        @Override
        public final Builder echoReduction(String echoReduction) {
            this.echoReduction = echoReduction;
            return this;
        }

        @Override
        public final Builder echoReduction(MeetingFeatureStatus echoReduction) {
            this.echoReduction(echoReduction == null ? null : echoReduction.toString());
            return this;
        }

        @Override
        public AudioFeatures build() {
            return new AudioFeatures(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
