/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetAttachedFileMetadataResponse extends ConnectResponse implements
        ToCopyableBuilder<BatchGetAttachedFileMetadataResponse.Builder, BatchGetAttachedFileMetadataResponse> {
    private static final SdkField<List<AttachedFile>> FILES_FIELD = SdkField
            .<List<AttachedFile>> builder(MarshallingType.LIST)
            .memberName("Files")
            .getter(getter(BatchGetAttachedFileMetadataResponse::files))
            .setter(setter(Builder::files))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Files").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttachedFile> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttachedFile::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AttachedFileError>> ERRORS_FIELD = SdkField
            .<List<AttachedFileError>> builder(MarshallingType.LIST)
            .memberName("Errors")
            .getter(getter(BatchGetAttachedFileMetadataResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttachedFileError> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttachedFileError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILES_FIELD, ERRORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AttachedFile> files;

    private final List<AttachedFileError> errors;

    private BatchGetAttachedFileMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.files = builder.files;
        this.errors = builder.errors;
    }

    /**
     * For responses, this returns true if the service returned a value for the Files property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasFiles() {
        return files != null && !(files instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of attached files that were successfully retrieved.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFiles} method.
     * </p>
     * 
     * @return List of attached files that were successfully retrieved.
     */
    public final List<AttachedFile> files() {
        return files;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of errors of attached files that could not be retrieved.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return List of errors of attached files that could not be retrieved.
     */
    public final List<AttachedFileError> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFiles() ? files() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetAttachedFileMetadataResponse)) {
            return false;
        }
        BatchGetAttachedFileMetadataResponse other = (BatchGetAttachedFileMetadataResponse) obj;
        return hasFiles() == other.hasFiles() && Objects.equals(files(), other.files()) && hasErrors() == other.hasErrors()
                && Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetAttachedFileMetadataResponse").add("Files", hasFiles() ? files() : null)
                .add("Errors", hasErrors() ? errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Files":
            return Optional.ofNullable(clazz.cast(files()));
        case "Errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Files", FILES_FIELD);
        map.put("Errors", ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetAttachedFileMetadataResponse, T> g) {
        return obj -> g.apply((BatchGetAttachedFileMetadataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetAttachedFileMetadataResponse> {
        /**
         * <p>
         * List of attached files that were successfully retrieved.
         * </p>
         * 
         * @param files
         *        List of attached files that were successfully retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder files(Collection<AttachedFile> files);

        /**
         * <p>
         * List of attached files that were successfully retrieved.
         * </p>
         * 
         * @param files
         *        List of attached files that were successfully retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder files(AttachedFile... files);

        /**
         * <p>
         * List of attached files that were successfully retrieved.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.AttachedFile.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.connect.model.AttachedFile#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.AttachedFile.Builder#build()} is called immediately and
         * its result is passed to {@link #files(List<AttachedFile>)}.
         * 
         * @param files
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.AttachedFile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #files(java.util.Collection<AttachedFile>)
         */
        Builder files(Consumer<AttachedFile.Builder>... files);

        /**
         * <p>
         * List of errors of attached files that could not be retrieved.
         * </p>
         * 
         * @param errors
         *        List of errors of attached files that could not be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<AttachedFileError> errors);

        /**
         * <p>
         * List of errors of attached files that could not be retrieved.
         * </p>
         * 
         * @param errors
         *        List of errors of attached files that could not be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(AttachedFileError... errors);

        /**
         * <p>
         * List of errors of attached files that could not be retrieved.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.AttachedFileError.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.connect.model.AttachedFileError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.AttachedFileError.Builder#build()} is called immediately
         * and its result is passed to {@link #errors(List<AttachedFileError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.AttachedFileError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<AttachedFileError>)
         */
        Builder errors(Consumer<AttachedFileError.Builder>... errors);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private List<AttachedFile> files = DefaultSdkAutoConstructList.getInstance();

        private List<AttachedFileError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetAttachedFileMetadataResponse model) {
            super(model);
            files(model.files);
            errors(model.errors);
        }

        public final List<AttachedFile.Builder> getFiles() {
            List<AttachedFile.Builder> result = AttachedFilesListCopier.copyToBuilder(this.files);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFiles(Collection<AttachedFile.BuilderImpl> files) {
            this.files = AttachedFilesListCopier.copyFromBuilder(files);
        }

        @Override
        public final Builder files(Collection<AttachedFile> files) {
            this.files = AttachedFilesListCopier.copy(files);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder files(AttachedFile... files) {
            files(Arrays.asList(files));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder files(Consumer<AttachedFile.Builder>... files) {
            files(Stream.of(files).map(c -> AttachedFile.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AttachedFileError.Builder> getErrors() {
            List<AttachedFileError.Builder> result = AttachedFileErrorsListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<AttachedFileError.BuilderImpl> errors) {
            this.errors = AttachedFileErrorsListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<AttachedFileError> errors) {
            this.errors = AttachedFileErrorsListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(AttachedFileError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<AttachedFileError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> AttachedFileError.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetAttachedFileMetadataResponse build() {
            return new BatchGetAttachedFileMetadataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
