/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetFlowAssociationRequest extends ConnectRequest implements
        ToCopyableBuilder<BatchGetFlowAssociationRequest.Builder, BatchGetFlowAssociationRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(BatchGetFlowAssociationRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<List<String>> RESOURCE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ResourceIds")
            .getter(getter(BatchGetFlowAssociationRequest::resourceIds))
            .setter(setter(Builder::resourceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(BatchGetFlowAssociationRequest::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            RESOURCE_IDS_FIELD, RESOURCE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final List<String> resourceIds;

    private final String resourceType;

    private BatchGetFlowAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.resourceIds = builder.resourceIds;
        this.resourceType = builder.resourceType;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in
     * the Amazon Resource Name (ARN) of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
     *         ID</a> in the Amazon Resource Name (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceIds() {
        return resourceIds != null && !(resourceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of resource identifiers to retrieve flow associations.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Amazon Web Services End User Messaging SMS phone number ARN when using <code>SMS_PHONE_NUMBER</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Web Services End User Messaging Social phone number ARN when using
     * <code>WHATSAPP_MESSAGING_PHONE_NUMBER</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceIds} method.
     * </p>
     * 
     * @return A list of resource identifiers to retrieve flow associations.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Amazon Web Services End User Messaging SMS phone number ARN when using <code>SMS_PHONE_NUMBER</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services End User Messaging Social phone number ARN when using
     *         <code>WHATSAPP_MESSAGING_PHONE_NUMBER</code>
     *         </p>
     *         </li>
     */
    public final List<String> resourceIds() {
        return resourceIds;
    }

    /**
     * <p>
     * The type of resource association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ListFlowAssociationResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource association.
     * @see ListFlowAssociationResourceType
     */
    public final ListFlowAssociationResourceType resourceType() {
        return ListFlowAssociationResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of resource association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ListFlowAssociationResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource association.
     * @see ListFlowAssociationResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceIds() ? resourceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetFlowAssociationRequest)) {
            return false;
        }
        BatchGetFlowAssociationRequest other = (BatchGetFlowAssociationRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && hasResourceIds() == other.hasResourceIds()
                && Objects.equals(resourceIds(), other.resourceIds())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetFlowAssociationRequest").add("InstanceId", instanceId())
                .add("ResourceIds", hasResourceIds() ? resourceIds() : null).add("ResourceType", resourceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "ResourceIds":
            return Optional.ofNullable(clazz.cast(resourceIds()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("ResourceIds", RESOURCE_IDS_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetFlowAssociationRequest, T> g) {
        return obj -> g.apply((BatchGetFlowAssociationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetFlowAssociationRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a>
         * in the Amazon Resource Name (ARN) of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
         *        ID</a> in the Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * A list of resource identifiers to retrieve flow associations.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Amazon Web Services End User Messaging SMS phone number ARN when using <code>SMS_PHONE_NUMBER</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Web Services End User Messaging Social phone number ARN when using
         * <code>WHATSAPP_MESSAGING_PHONE_NUMBER</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceIds
         *        A list of resource identifiers to retrieve flow associations.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Amazon Web Services End User Messaging SMS phone number ARN when using <code>SMS_PHONE_NUMBER</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Web Services End User Messaging Social phone number ARN when using
         *        <code>WHATSAPP_MESSAGING_PHONE_NUMBER</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIds(Collection<String> resourceIds);

        /**
         * <p>
         * A list of resource identifiers to retrieve flow associations.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Amazon Web Services End User Messaging SMS phone number ARN when using <code>SMS_PHONE_NUMBER</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Web Services End User Messaging Social phone number ARN when using
         * <code>WHATSAPP_MESSAGING_PHONE_NUMBER</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceIds
         *        A list of resource identifiers to retrieve flow associations.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Amazon Web Services End User Messaging SMS phone number ARN when using <code>SMS_PHONE_NUMBER</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Web Services End User Messaging Social phone number ARN when using
         *        <code>WHATSAPP_MESSAGING_PHONE_NUMBER</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIds(String... resourceIds);

        /**
         * <p>
         * The type of resource association.
         * </p>
         * 
         * @param resourceType
         *        The type of resource association.
         * @see ListFlowAssociationResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListFlowAssociationResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of resource association.
         * </p>
         * 
         * @param resourceType
         *        The type of resource association.
         * @see ListFlowAssociationResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListFlowAssociationResourceType
         */
        Builder resourceType(ListFlowAssociationResourceType resourceType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private List<String> resourceIds = DefaultSdkAutoConstructList.getInstance();

        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetFlowAssociationRequest model) {
            super(model);
            instanceId(model.instanceId);
            resourceIds(model.resourceIds);
            resourceType(model.resourceType);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final Collection<String> getResourceIds() {
            if (resourceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceIds;
        }

        public final void setResourceIds(Collection<String> resourceIds) {
            this.resourceIds = _resourceArnListMaxLimit100Copier.copy(resourceIds);
        }

        @Override
        public final Builder resourceIds(Collection<String> resourceIds) {
            this.resourceIds = _resourceArnListMaxLimit100Copier.copy(resourceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIds(String... resourceIds) {
            resourceIds(Arrays.asList(resourceIds));
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ListFlowAssociationResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetFlowAssociationRequest build() {
            return new BatchGetFlowAssociationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
