/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Chat integration event containing payload to perform different chat actions such as:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Sending a chat message
 * </p>
 * </li>
 * <li>
 * <p>
 * Sending a chat event, such as typing
 * </p>
 * </li>
 * <li>
 * <p>
 * Disconnecting from a chat
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChatEvent implements SdkPojo, Serializable, ToCopyableBuilder<ChatEvent.Builder, ChatEvent> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ChatEvent::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentType").getter(getter(ChatEvent::contentType)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentType").build()).build();

    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Content")
            .getter(getter(ChatEvent::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            CONTENT_TYPE_FIELD, CONTENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String contentType;

    private final String content;

    private ChatEvent(BuilderImpl builder) {
        this.type = builder.type;
        this.contentType = builder.contentType;
        this.content = builder.content;
    }

    /**
     * <p>
     * Type of chat integration event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ChatEventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Type of chat integration event.
     * @see ChatEventType
     */
    public final ChatEventType type() {
        return ChatEventType.fromValue(type);
    }

    /**
     * <p>
     * Type of chat integration event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ChatEventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Type of chat integration event.
     * @see ChatEventType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Type of content. This is required when <code>Type</code> is <code>MESSAGE</code> or <code>EVENT</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For allowed message content types, see the <code>ContentType</code> parameter in the <a
     * href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_SendMessage.html">SendMessage</a>
     * topic in the <i>Amazon Connect Participant Service API Reference</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For allowed event content types, see the <code>ContentType</code> parameter in the <a
     * href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_SendEvent.html">SendEvent</a> topic
     * in the <i>Amazon Connect Participant Service API Reference</i>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Type of content. This is required when <code>Type</code> is <code>MESSAGE</code> or <code>EVENT</code>.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For allowed message content types, see the <code>ContentType</code> parameter in the <a
     *         href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_SendMessage.html"
     *         >SendMessage</a> topic in the <i>Amazon Connect Participant Service API Reference</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For allowed event content types, see the <code>ContentType</code> parameter in the <a
     *         href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_SendEvent.html"
     *         >SendEvent</a> topic in the <i>Amazon Connect Participant Service API Reference</i>.
     *         </p>
     *         </li>
     */
    public final String contentType() {
        return contentType;
    }

    /**
     * <p>
     * Content of the message or event. This is required when <code>Type</code> is <code>MESSAGE</code> and for certain
     * <code>ContentTypes</code> when <code>Type</code> is <code>EVENT</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For allowed message content, see the <code>Content</code> parameter in the <a
     * href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_SendMessage.html">SendMessage</a>
     * topic in the <i>Amazon Connect Participant Service API Reference</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For allowed event content, see the <code>Content</code> parameter in the <a
     * href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_SendEvent.html">SendEvent</a> topic
     * in the <i>Amazon Connect Participant Service API Reference</i>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Content of the message or event. This is required when <code>Type</code> is <code>MESSAGE</code> and for
     *         certain <code>ContentTypes</code> when <code>Type</code> is <code>EVENT</code>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For allowed message content, see the <code>Content</code> parameter in the <a
     *         href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_SendMessage.html"
     *         >SendMessage</a> topic in the <i>Amazon Connect Participant Service API Reference</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For allowed event content, see the <code>Content</code> parameter in the <a
     *         href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_SendEvent.html"
     *         >SendEvent</a> topic in the <i>Amazon Connect Participant Service API Reference</i>.
     *         </p>
     *         </li>
     */
    public final String content() {
        return content;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChatEvent)) {
            return false;
        }
        ChatEvent other = (ChatEvent) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(contentType(), other.contentType())
                && Objects.equals(content(), other.content());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChatEvent").add("Type", typeAsString()).add("ContentType", contentType())
                .add("Content", content()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "ContentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Type", TYPE_FIELD);
        map.put("ContentType", CONTENT_TYPE_FIELD);
        map.put("Content", CONTENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChatEvent, T> g) {
        return obj -> g.apply((ChatEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChatEvent> {
        /**
         * <p>
         * Type of chat integration event.
         * </p>
         * 
         * @param type
         *        Type of chat integration event.
         * @see ChatEventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChatEventType
         */
        Builder type(String type);

        /**
         * <p>
         * Type of chat integration event.
         * </p>
         * 
         * @param type
         *        Type of chat integration event.
         * @see ChatEventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChatEventType
         */
        Builder type(ChatEventType type);

        /**
         * <p>
         * Type of content. This is required when <code>Type</code> is <code>MESSAGE</code> or <code>EVENT</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For allowed message content types, see the <code>ContentType</code> parameter in the <a
         * href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_SendMessage.html"
         * >SendMessage</a> topic in the <i>Amazon Connect Participant Service API Reference</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For allowed event content types, see the <code>ContentType</code> parameter in the <a
         * href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_SendEvent.html">SendEvent</a>
         * topic in the <i>Amazon Connect Participant Service API Reference</i>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param contentType
         *        Type of content. This is required when <code>Type</code> is <code>MESSAGE</code> or <code>EVENT</code>
         *        . </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For allowed message content types, see the <code>ContentType</code> parameter in the <a
         *        href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_SendMessage.html"
         *        >SendMessage</a> topic in the <i>Amazon Connect Participant Service API Reference</i>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For allowed event content types, see the <code>ContentType</code> parameter in the <a
         *        href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_SendEvent.html"
         *        >SendEvent</a> topic in the <i>Amazon Connect Participant Service API Reference</i>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * Content of the message or event. This is required when <code>Type</code> is <code>MESSAGE</code> and for
         * certain <code>ContentTypes</code> when <code>Type</code> is <code>EVENT</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For allowed message content, see the <code>Content</code> parameter in the <a
         * href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_SendMessage.html"
         * >SendMessage</a> topic in the <i>Amazon Connect Participant Service API Reference</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * For allowed event content, see the <code>Content</code> parameter in the <a
         * href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_SendEvent.html">SendEvent</a>
         * topic in the <i>Amazon Connect Participant Service API Reference</i>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param content
         *        Content of the message or event. This is required when <code>Type</code> is <code>MESSAGE</code> and
         *        for certain <code>ContentTypes</code> when <code>Type</code> is <code>EVENT</code>.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For allowed message content, see the <code>Content</code> parameter in the <a
         *        href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_SendMessage.html"
         *        >SendMessage</a> topic in the <i>Amazon Connect Participant Service API Reference</i>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For allowed event content, see the <code>Content</code> parameter in the <a
         *        href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_SendEvent.html"
         *        >SendEvent</a> topic in the <i>Amazon Connect Participant Service API Reference</i>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String contentType;

        private String content;

        private BuilderImpl() {
        }

        private BuilderImpl(ChatEvent model) {
            type(model.type);
            contentType(model.contentType);
            content(model.content);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ChatEventType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final String getContent() {
            return content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        @Override
        public ChatEvent build() {
            return new ChatEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
