/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A leaf node condition which can be used to specify a ProficiencyName, ProficiencyValue and ProficiencyLimit.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Condition implements SdkPojo, Serializable, ToCopyableBuilder<Condition.Builder, Condition> {
    private static final SdkField<StringCondition> STRING_CONDITION_FIELD = SdkField
            .<StringCondition> builder(MarshallingType.SDK_POJO).memberName("StringCondition")
            .getter(getter(Condition::stringCondition)).setter(setter(Builder::stringCondition))
            .constructor(StringCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringCondition").build()).build();

    private static final SdkField<NumberCondition> NUMBER_CONDITION_FIELD = SdkField
            .<NumberCondition> builder(MarshallingType.SDK_POJO).memberName("NumberCondition")
            .getter(getter(Condition::numberCondition)).setter(setter(Builder::numberCondition))
            .constructor(NumberCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberCondition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRING_CONDITION_FIELD,
            NUMBER_CONDITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final StringCondition stringCondition;

    private final NumberCondition numberCondition;

    private Condition(BuilderImpl builder) {
        this.stringCondition = builder.stringCondition;
        this.numberCondition = builder.numberCondition;
    }

    /**
     * <p>
     * A leaf node condition which can be used to specify a string condition.
     * </p>
     * <note>
     * <p>
     * The currently supported values for <code>FieldName</code> are <code>name</code> and&#x2028; <code>value</code>.
     * </p>
     * </note>
     * 
     * @return A leaf node condition which can be used to specify a string condition.</p> <note>
     *         <p>
     *         The currently supported values for <code>FieldName</code> are <code>name</code> and&#x2028;
     *         <code>value</code>.
     *         </p>
     */
    public final StringCondition stringCondition() {
        return stringCondition;
    }

    /**
     * <p>
     * A leaf node condition which can be used to specify a numeric condition.
     * </p>
     * 
     * @return A leaf node condition which can be used to specify a numeric condition.
     */
    public final NumberCondition numberCondition() {
        return numberCondition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stringCondition());
        hashCode = 31 * hashCode + Objects.hashCode(numberCondition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Condition)) {
            return false;
        }
        Condition other = (Condition) obj;
        return Objects.equals(stringCondition(), other.stringCondition())
                && Objects.equals(numberCondition(), other.numberCondition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Condition").add("StringCondition", stringCondition()).add("NumberCondition", numberCondition())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StringCondition":
            return Optional.ofNullable(clazz.cast(stringCondition()));
        case "NumberCondition":
            return Optional.ofNullable(clazz.cast(numberCondition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StringCondition", STRING_CONDITION_FIELD);
        map.put("NumberCondition", NUMBER_CONDITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Condition, T> g) {
        return obj -> g.apply((Condition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Condition> {
        /**
         * <p>
         * A leaf node condition which can be used to specify a string condition.
         * </p>
         * <note>
         * <p>
         * The currently supported values for <code>FieldName</code> are <code>name</code> and&#x2028;
         * <code>value</code>.
         * </p>
         * </note>
         * 
         * @param stringCondition
         *        A leaf node condition which can be used to specify a string condition.</p> <note>
         *        <p>
         *        The currently supported values for <code>FieldName</code> are <code>name</code> and&#x2028;
         *        <code>value</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringCondition(StringCondition stringCondition);

        /**
         * <p>
         * A leaf node condition which can be used to specify a string condition.
         * </p>
         * <note>
         * <p>
         * The currently supported values for <code>FieldName</code> are <code>name</code> and&#x2028;
         * <code>value</code>.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link StringCondition.Builder} avoiding
         * the need to create one manually via {@link StringCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StringCondition.Builder#build()} is called immediately and its
         * result is passed to {@link #stringCondition(StringCondition)}.
         * 
         * @param stringCondition
         *        a consumer that will call methods on {@link StringCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stringCondition(StringCondition)
         */
        default Builder stringCondition(Consumer<StringCondition.Builder> stringCondition) {
            return stringCondition(StringCondition.builder().applyMutation(stringCondition).build());
        }

        /**
         * <p>
         * A leaf node condition which can be used to specify a numeric condition.
         * </p>
         * 
         * @param numberCondition
         *        A leaf node condition which can be used to specify a numeric condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberCondition(NumberCondition numberCondition);

        /**
         * <p>
         * A leaf node condition which can be used to specify a numeric condition.
         * </p>
         * This is a convenience method that creates an instance of the {@link NumberCondition.Builder} avoiding the
         * need to create one manually via {@link NumberCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NumberCondition.Builder#build()} is called immediately and its
         * result is passed to {@link #numberCondition(NumberCondition)}.
         * 
         * @param numberCondition
         *        a consumer that will call methods on {@link NumberCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #numberCondition(NumberCondition)
         */
        default Builder numberCondition(Consumer<NumberCondition.Builder> numberCondition) {
            return numberCondition(NumberCondition.builder().applyMutation(numberCondition).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private StringCondition stringCondition;

        private NumberCondition numberCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(Condition model) {
            stringCondition(model.stringCondition);
            numberCondition(model.numberCondition);
        }

        public final StringCondition.Builder getStringCondition() {
            return stringCondition != null ? stringCondition.toBuilder() : null;
        }

        public final void setStringCondition(StringCondition.BuilderImpl stringCondition) {
            this.stringCondition = stringCondition != null ? stringCondition.build() : null;
        }

        @Override
        public final Builder stringCondition(StringCondition stringCondition) {
            this.stringCondition = stringCondition;
            return this;
        }

        public final NumberCondition.Builder getNumberCondition() {
            return numberCondition != null ? numberCondition.toBuilder() : null;
        }

        public final void setNumberCondition(NumberCondition.BuilderImpl numberCondition) {
            this.numberCondition = numberCondition != null ? numberCondition.build() : null;
        }

        @Override
        public final Builder numberCondition(NumberCondition numberCondition) {
            this.numberCondition = numberCondition;
            return this;
        }

        @Override
        public Condition build() {
            return new Condition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
