/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that defines search criteria for contacts using analysis outputs from Amazon Connect Contact Lens.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContactAnalysis implements SdkPojo, Serializable, ToCopyableBuilder<ContactAnalysis.Builder, ContactAnalysis> {
    private static final SdkField<Transcript> TRANSCRIPT_FIELD = SdkField.<Transcript> builder(MarshallingType.SDK_POJO)
            .memberName("Transcript").getter(getter(ContactAnalysis::transcript)).setter(setter(Builder::transcript))
            .constructor(Transcript::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Transcript").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSCRIPT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Transcript transcript;

    private ContactAnalysis(BuilderImpl builder) {
        this.transcript = builder.transcript;
    }

    /**
     * <p>
     * Search criteria based on transcript analyzed by Amazon Connect Contact Lens.
     * </p>
     * 
     * @return Search criteria based on transcript analyzed by Amazon Connect Contact Lens.
     */
    public final Transcript transcript() {
        return transcript;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transcript());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactAnalysis)) {
            return false;
        }
        ContactAnalysis other = (ContactAnalysis) obj;
        return Objects.equals(transcript(), other.transcript());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContactAnalysis").add("Transcript", transcript()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Transcript":
            return Optional.ofNullable(clazz.cast(transcript()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Transcript", TRANSCRIPT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContactAnalysis, T> g) {
        return obj -> g.apply((ContactAnalysis) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContactAnalysis> {
        /**
         * <p>
         * Search criteria based on transcript analyzed by Amazon Connect Contact Lens.
         * </p>
         * 
         * @param transcript
         *        Search criteria based on transcript analyzed by Amazon Connect Contact Lens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transcript(Transcript transcript);

        /**
         * <p>
         * Search criteria based on transcript analyzed by Amazon Connect Contact Lens.
         * </p>
         * This is a convenience method that creates an instance of the {@link Transcript.Builder} avoiding the need to
         * create one manually via {@link Transcript#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Transcript.Builder#build()} is called immediately and its result
         * is passed to {@link #transcript(Transcript)}.
         * 
         * @param transcript
         *        a consumer that will call methods on {@link Transcript.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transcript(Transcript)
         */
        default Builder transcript(Consumer<Transcript.Builder> transcript) {
            return transcript(Transcript.builder().applyMutation(transcript).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Transcript transcript;

        private BuilderImpl() {
        }

        private BuilderImpl(ContactAnalysis model) {
            transcript(model.transcript);
        }

        public final Transcript.Builder getTranscript() {
            return transcript != null ? transcript.toBuilder() : null;
        }

        public final void setTranscript(Transcript.BuilderImpl transcript) {
            this.transcript = transcript != null ? transcript.build() : null;
        }

        @Override
        public final Builder transcript(Transcript transcript) {
            this.transcript = transcript;
            return this;
        }

        @Override
        public ContactAnalysis build() {
            return new ContactAnalysis(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
